<!-- received="Fri Jul 21 11:04:19 2000 EET DST" -->
<!-- sent="Fri, 21 Jul 2000 16:54:43 +0900" -->
<!-- name="Go Taniguchi" -->
<!-- email="taniguchi@turbolinux.co.jp" -->
<!-- subject="isofs readdir boundarie and move sector error" -->
<!-- id="200007210758.QAA15520@mail.turbolinux.co.jp" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: isofs readdir boundarie and move sector error</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>isofs readdir boundarie and move sector error</h1>
<b>Go Taniguchi</b> (<a href="mailto:taniguchi@turbolinux.co.jp"><i>taniguchi@turbolinux.co.jp</i></a>)<br>
<i>Fri, 21 Jul 2000 16:54:43 +0900</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#716">[ date ]</a><a href="index.html#716">[ thread ]</a><a href="subject.html#716">[ subject ]</a><a href="author.html#716">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0717.html">Brion Vibber: "DVD reading beyond end of device"</a>
<li> <b>Previous message:</b> <a href="0715.html">Andre Hedrick: "Re: disk-destroyer.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This is a multi-part message in MIME format.<br>
<p>
--Multipart_Fri__21_Jul_2000_16:54:43_+0900_081c7348<br>
Content-Type: text/plain; charset=US-ASCII<br>
<p>
We have found a problem with readdir() for isofs.  When there are a lot of files in a single directory, and when you copy that directory, some of the files can disappear.  For example, we found this with the Windows 2000 CD-ROM.<br>
<p>
After looking into it, it seems that there is a boundary error in linux/fs/isofs/dir.c.  When the sector size is 2048 and the directory entry offset is also 2048, there is a problem.<br>
<p>
When de_len, the sum of the buffer start address plus the offset becomes 2048 and *de_len is zero, then it skips one sector and you there fore skip some files.<br>
<p>
Please look at the patch I have included for details.<br>
<p>
--- linux/fs/isofs/dir.c.orig   Sat Apr 24 13:20:38 1999<br>
+++ linux/fs/isofs/dir.c        Fri Jul 21 02:37:16 2000<br>
@@ -160,9 +163,11 @@<br>
                de = (struct iso_directory_record *) (bh-&gt;b_data + offset);<br>
                if(first_de) inode_number = (block &lt;&lt; bufbits) + (offset &amp; (bufs<br>
ize - 1));<br>
 <br>
-               de_len = *(unsigned char *) de;<br>
+               /* Check boundaries and get length. by GO! */<br>
+               if (offset &lt; bufsize) de_len = *(unsigned char *) de;<br>
 #ifdef DEBUG<br>
-               printk("de_len = %ld\n", de_len);<br>
+               if (offset &lt; bufsize) printk("de_len = %ld\n", de_len);<br>
+               else printk("Move to next sector\n");<br>
 #endif<br>
            <br>
 <br>
@@ -170,15 +175,15 @@<br>
                   CDROM sector.  If we are at the end of the directory, we<br>
                   kick out of the while loop. */<br>
 <br>
-               if ((de_len == 0) || (offset &gt;= bufsize) ) {<br>
+               if ((offset &gt;= bufsize) || (de_len == 0) ) {<br>
                        brelse(bh);<br>
-                       if (de_len == 0) {<br>
+                       if (offset &gt;= bufsize) {        /*Check first. by GO!*/<br>
+                               offset -= bufsize;<br>
+                               filp-&gt;f_pos += offset;<br>
+                       } else {<br>
                                filp-&gt;f_pos = ((filp-&gt;f_pos &amp; ~(ISOFS_BLOCK_SIZE<br>
 - 1))<br>
                                               + ISOFS_BLOCK_SIZE);<br>
                                offset = 0;<br>
-                       } else {<br>
-                               offset -= bufsize;<br>
-                               filp-&gt;f_pos += offset;<br>
                        }<br>
 <br>
                        if (filp-&gt;f_pos &gt;= inode-&gt;i_size)<br>
<p>
--Multipart_Fri__21_Jul_2000_16:54:43_+0900_081c7348<br>
Content-Type: application/octet-stream; name="linux-2.2.16-isofs-dir-sector.patch"<br>
Content-Disposition: attachment; filename="linux-2.2.16-isofs-dir-sector.patch"<br>
Content-Transfer-Encoding: base64<br>
<p>
LS0tIGxpbnV4L2ZzL2lzb2ZzL2Rpci5jLm9yaWcJU2F0IEFwciAyNCAxMzoyMDozOCAxOTk5Cisr<br>
KyBsaW51eC9mcy9pc29mcy9kaXIuYwlGcmkgSnVsIDIxIDAyOjM3OjE2IDIwMDAKQEAgLTcsNiAr<br>
Nyw5IEBACiAgKgogICogIFN0ZXZlIEJleW5vbgkJICAgICAgIDogTWlzc2luZyBsYXN0IGRpcmVj<br>
dG9yeSBlbnRyaWVzIGZpeGVkCiAgKiAgKHN0ZXBoZW5AYXNrb25lLmRlbW9uLmNvLnVrKSAgICAg<br>
IDogMjFzdCBKdW5lIDE5OTYKKyAqCisgKiAgR28gVGFuaWd1Y2hpCQkJOiBNb3ZlIHNlY3RvciBh<br>
bmQgYm91bmRhcmllIGVycm9yIGZpeGVkCisgKiAgKGdvQHR1cmJvbGludXguY28uanApCQk6IEp1<br>
bCAyMSAyMDAwCiAgKiAKICAqICBpc29mcyBkaXJlY3RvcnkgaGFuZGxpbmcgZnVuY3Rpb25zCiAg<br>
Ki8KQEAgLTE2MCw5ICsxNjMsMTEgQEAKIAkJZGUgPSAoc3RydWN0IGlzb19kaXJlY3RvcnlfcmVj<br>
b3JkICopIChiaC0+Yl9kYXRhICsgb2Zmc2V0KTsKIAkJaWYoZmlyc3RfZGUpIGlub2RlX251bWJl<br>
ciA9IChibG9jayA8PCBidWZiaXRzKSArIChvZmZzZXQgJiAoYnVmc2l6ZSAtIDEpKTsKIAotCQlk<br>
ZV9sZW4gPSAqKHVuc2lnbmVkIGNoYXIgKikgZGU7CisJCS8qIENoZWNrIGJvdW5kYXJpZXMgYW5k<br>
IGdldCBsZW5ndGguIGJ5IEdPISAqLworCQlpZiAob2Zmc2V0IDwgYnVmc2l6ZSkgZGVfbGVuID0g<br>
Kih1bnNpZ25lZCBjaGFyICopIGRlOwogI2lmZGVmIERFQlVHCi0JCXByaW50aygiZGVfbGVuID0g<br>
JWxkXG4iLCBkZV9sZW4pOworCQlpZiAob2Zmc2V0IDwgYnVmc2l6ZSkgcHJpbnRrKCJkZV9sZW4g<br>
PSAlbGRcbiIsIGRlX2xlbik7CisJCWVsc2UgcHJpbnRrKCJNb3ZlIHRvIG5leHQgc2VjdG9yXG4i<br>
KTsKICNlbmRpZgogCSAgICAKIApAQCAtMTcwLDE1ICsxNzUsMTUgQEAKIAkJICAgQ0RST00gc2Vj<br>
dG9yLiAgSWYgd2UgYXJlIGF0IHRoZSBlbmQgb2YgdGhlIGRpcmVjdG9yeSwgd2UKIAkJICAga2lj<br>
ayBvdXQgb2YgdGhlIHdoaWxlIGxvb3AuICovCiAKLQkJaWYgKChkZV9sZW4gPT0gMCkgfHwgKG9m<br>
ZnNldCA+PSBidWZzaXplKSApIHsKKwkJaWYgKChvZmZzZXQgPj0gYnVmc2l6ZSkgfHwgKGRlX2xl<br>
biA9PSAwKSApIHsKIAkJCWJyZWxzZShiaCk7Ci0JCQlpZiAoZGVfbGVuID09IDApIHsKKwkJCWlm<br>
IChvZmZzZXQgPj0gYnVmc2l6ZSkgewkvKkNoZWNrIGZpcnN0LiBieSBHTyEqLworCQkJCW9mZnNl<br>
dCAtPSBidWZzaXplOworCQkJCWZpbHAtPmZfcG9zICs9IG9mZnNldDsKKwkJCX0gZWxzZSB7CiAJ<br>
CQkJZmlscC0+Zl9wb3MgPSAoKGZpbHAtPmZfcG9zICYgfihJU09GU19CTE9DS19TSVpFIC0gMSkp<br>
CiAJCQkJCSAgICAgICArIElTT0ZTX0JMT0NLX1NJWkUpOwogCQkJCW9mZnNldCA9IDA7Ci0JCQl9<br>
IGVsc2UgewotCQkJCW9mZnNldCAtPSBidWZzaXplOwotCQkJCWZpbHAtPmZfcG9zICs9IG9mZnNl<br>
dDsKIAkJCX0KIAogCQkJaWYgKGZpbHAtPmZfcG9zID49IGlub2RlLT5pX3NpemUpCg==<br>
<p>
--Multipart_Fri__21_Jul_2000_16:54:43_+0900_081c7348--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0717.html">Brion Vibber: "DVD reading beyond end of device"</a>
<li> <b>Previous message:</b> <a href="0715.html">Andre Hedrick: "Re: disk-destroyer.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
