<!-- received="Thu Jul 20 22:42:16 2000 EET DST" -->
<!-- sent="Thu, 20 Jul 2000 21:26:47 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] bug in scripts/Configure:dep_tristate" -->
<!-- id="200007201926.VAA02056@harpo.it.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] bug in scripts/Configure:dep_tristate</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] bug in scripts/Configure:dep_tristate</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Thu, 20 Jul 2000 21:26:47 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#617">[ date ]</a><a href="index.html#617">[ thread ]</a><a href="subject.html#617">[ subject ]</a><a href="author.html#617">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0618.html">Michael Bacarella: "Re: [PATCH] allow emu10k1 as non-module in 2.2.17pre"</a>
<li> <b>Previous message:</b> <a href="0616.html">Mikael Pettersson: "[PATCH] buglet in drivers/scsi/scsi.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
drivers/ide/Config.in triggers a problem with dep_tristate<br>
as implemented by scripts/Configure.<br>
<p>
The problem occurs when a dependency is a forward reference.<br>
For instance, arch/i386/config.in does IDE before SCSI, so<br>
the dependency from CONFIG_BLK_DEV_IDESCSI to CONFIG_SCSI<br>
is a forward reference.<br>
<p>
Consider a stable .config with CONFIG_BLK_DEV_IDESCSI and<br>
CONFIG_SCSI as modules. Now `make config' but set CONFIG_MODULES=n.<br>
When processing CONFIG_BLK_DEV_IDESCSI, dep_tristate will<br>
see CONFIG_SCSI=m from the previous .config, and incorrectly<br>
limit the result to m or n. Since CONFIG_MODULES=n, dep_tristate<br>
will silently turn off CONFIG_BLK_DEV_IDESCSI (actually, it<br>
drops its altogether). Seriously uncool.<br>
<p>
This problem occurs because the script doesn't take into account<br>
the fact that the CONFIG_SCSI=m dependency will be changed by the<br>
script itself to CONFIG_SCSI=y later on (since modules are off).<br>
Therefore, limiting the result to m or n is incorrect in this case.<br>
<p>
The patch below (against 2.4.0-test4) fixes this problem. Please apply.<br>
<p>
/Mikael<br>
<p>
--- linux-2.4.0-test4/scripts/Configure.~1~	Sat Jul  1 00:14:11 2000<br>
+++ linux-2.4.0-test4/scripts/Configure	Thu Jul 20 19:47:23 2000<br>
@@ -254,7 +254,13 @@<br>
 	      return<br>
 	      ;;<br>
 	    m)<br>
-	      need_module=1<br>
+	      # Note: "m" means "module" only when CONFIG_MODULES=y,<br>
+	      # otherwise it really means "y". This matters when<br>
+	      # a dep_tristate dependency is a forward reference<br>
+	      # which we haven't yet "corrected" from "m" to "y".<br>
+	      if [ "$CONFIG_MODULES" = "y" ]; then<br>
+		need_module=1<br>
+	      fi<br>
 	      ;;<br>
 	  esac<br>
 	  shift<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0618.html">Michael Bacarella: "Re: [PATCH] allow emu10k1 as non-module in 2.2.17pre"</a>
<li> <b>Previous message:</b> <a href="0616.html">Mikael Pettersson: "[PATCH] buglet in drivers/scsi/scsi.c"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
