<!-- received="Thu Jul 20 22:35:31 2000 EET DST" -->
<!-- sent="Thu, 20 Jul 2000 21:28:42 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] buglet in drivers/scsi/scsi.c" -->
<!-- id="200007201928.VAA02073@harpo.it.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] buglet in drivers/scsi/scsi.c</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] buglet in drivers/scsi/scsi.c</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Thu, 20 Jul 2000 21:28:42 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#616">[ date ]</a><a href="index.html#616">[ thread ]</a><a href="subject.html#616">[ subject ]</a><a href="author.html#616">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0617.html">Mikael Pettersson: "[PATCH] bug in scripts/Configure:dep_tristate"</a>
<li> <b>Previous message:</b> <a href="0615.html">Mikael Pettersson: "[PATCH] allow emu10k1 as non-module in 2.2.17pre"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Compiling 2.4.0-test4 with<br>
	# CONFIG_MODULES is not set<br>
	CONFIG_BLK_DEV_IDESCSI=y<br>
	CONFIG_SCSI=y<br>
results in:<br>
<p>
scsi.c: In function `scsi_register_host':<br>
scsi.c:1956: warning: implicit declaration of function `scsi_unregister_host'<br>
scsi.c: At top level:<br>
scsi.c:2085: warning: `scsi_unregister_host' was declared implicitly `extern' and later `static'<br>
scsi.c:2068: warning: previous declaration of `scsi_unregister_host'<br>
scsi.c:2085: warning: type mismatch with previous implicit declaration<br>
scsi.c:2068: warning: previous implicit declaration of `scsi_unregister_host'<br>
scsi.c:2085: warning: `scsi_unregister_host' was previously implicitly declared to return `int'<br>
<p>
The problem is that scsi.c has a forward declaration of scsi_register_host<br>
and scsi_unregister_host inside an #if/#endif, but the condition used in<br>
the forward declaration isn't the same as that in the actual definition,<br>
which leads to the type mismatches seen above.<br>
<p>
Trivial patch below (against 2.4.0-test4) fixes this. Please apply.<br>
<p>
/Mikael<br>
<p>
--- linux-2.4.0-test4/drivers/scsi/scsi.c.~1~	Tue Jul 11 19:35:12 2000<br>
+++ linux-2.4.0-test4/drivers/scsi/scsi.c	Thu Jul 20 19:11:16 2000<br>
@@ -1361,7 +1361,7 @@<br>
 	SCpnt-&gt;done(SCpnt);<br>
 }<br>
 <br>
-#ifdef CONFIG_MODULES<br>
+#if defined(CONFIG_MODULES) || defined(CONFIG_BLK_DEV_IDESCSI) || defined(CONFIG_USB_STORAGE)<br>
 static int scsi_register_host(Scsi_Host_Template *);<br>
 static void scsi_unregister_host(Scsi_Host_Template *);<br>
 #endif<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0617.html">Mikael Pettersson: "[PATCH] bug in scripts/Configure:dep_tristate"</a>
<li> <b>Previous message:</b> <a href="0615.html">Mikael Pettersson: "[PATCH] allow emu10k1 as non-module in 2.2.17pre"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
