<!-- received="Thu Jul 20 11:26:36 2000 EET DST" -->
<!-- sent="Thu, 20 Jul 2000 10:23:49 +0200 (MET DST)" -->
<!-- name="Mathias Froehlich" -->
<!-- email="frohlich@na.uni-tuebingen.de" -->
<!-- subject="[PATCH] specify ramfs root inode permissions at mount time" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] specify ramfs root inode permissions at mount time</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] specify ramfs root inode permissions at mount time</h1>
<b>Mathias Froehlich</b> (<a href="mailto:frohlich@na.uni-tuebingen.de"><i>frohlich@na.uni-tuebingen.de</i></a>)<br>
<i>Thu, 20 Jul 2000 10:23:49 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#550">[ date ]</a><a href="index.html#550">[ thread ]</a><a href="subject.html#550">[ subject ]</a><a href="author.html#550">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0551.html">Ville Herva: "E2compr"</a>
<li> <b>Previous message:</b> <a href="0549.html">Heusden, Folkert van: "adding physical memory-pages to Linux' pool-of-pages"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
Since ramfs is very fast I tried to use ramfs for /tmp. This would<br>
have the important side effect, that all those open files in /tmp will<br>
no longer corrupt my root fs in case of a crash.<br>
<p>
I tried to use ramfs for /tmp which failed because the default<br>
permissions of the root inode of ramfs is set to 0755. So I thought,<br>
that having this permission as a mount option will solve this problem.<br>
<p>
Here is a small patch which implements the mount option rootperm=1777.<br>
Maybe this is usefull for others too.<br>
<p>
    Thanks<br>
<p>
      Mathias<br>
<p>
--- linux-2.4.0-test5-pre3/fs/ramfs/inode.c.orig	Thu Jul 20 08:48:21 2000<br>
+++ linux-2.4.0-test5-pre3/fs/ramfs/inode.c	Thu Jul 20 09:09:14 2000<br>
@@ -309,6 +309,37 @@<br>
 	put_inode:	force_delete,<br>
 };<br>
 <br>
+static int get_root_mode(char * options)<br>
+{<br>
+        const int defaultmode = 0755;<br>
+        int mode = defaultmode;<br>
+        char * this_char;<br>
+<br>
+        if (!options)<br>
+                return defaultmode;<br>
+        for (this_char = strtok (options, ",");<br>
+              this_char != NULL;<br>
+              this_char = strtok (NULL, ",")) {<br>
+                char * value;<br>
+                if ((value = strchr (this_char, '=')) != NULL)<br>
+                        *value++ = 0;<br>
+                if (!strcmp (this_char, "rootperm")) {<br>
+                        if (!value || !*value) {<br>
+			        printk("RAMFS: no value given to the rootperm option\n");<br>
+				break;<br>
+			}<br>
+                        mode = simple_strtoul(value,&amp;value,8) &amp; 07777;<br>
+                        if (*value) {<br>
+			        printk("RAMFS: invalid value given to the rootperm option\n");<br>
+				mode = defaultmode;<br>
+				break;<br>
+			}<br>
+		}<br>
+	}<br>
+<br>
+	return mode;<br>
+}<br>
+<br>
 static struct super_block *ramfs_read_super(struct super_block * sb, void * data, int silent)<br>
 {<br>
 	struct inode * inode;<br>
@@ -318,7 +349,7 @@<br>
 	sb-&gt;s_blocksize_bits = PAGE_CACHE_SHIFT;<br>
 	sb-&gt;s_magic = RAMFS_MAGIC;<br>
 	sb-&gt;s_op = &amp;ramfs_ops;<br>
-	inode = ramfs_get_inode(sb, S_IFDIR | 0755, 0);<br>
+	inode = ramfs_get_inode(sb, S_IFDIR | get_root_mode((char*)data), 0);<br>
 	if (!inode)<br>
 		return NULL;<br>
 <br>
<p>
<p>
<pre>
-- 
Mathias Fr"ohlich              e-mail: <a href="mailto:frohlich@na.uni-tuebingen.de">frohlich@na.uni-tuebingen.de</a>
Institut f"ur Mathematik, Universit"at T"ubingen, D-72076 T"ubingen
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0551.html">Ville Herva: "E2compr"</a>
<li> <b>Previous message:</b> <a href="0549.html">Heusden, Folkert van: "adding physical memory-pages to Linux' pool-of-pages"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
