<!-- received="Thu Jul 20 03:59:15 2000 EET DST" -->
<!-- sent="Thu, 20 Jul 2000 10:55:00 +1000 (EST)" -->
<!-- name="Mark Goodwin" -->
<!-- email="markgw@sgi.com" -->
<!-- subject="[PATCH] system call acct" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] system call acct</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] system call acct</h1>
<b>Mark Goodwin</b> (<a href="mailto:markgw@sgi.com"><i>markgw@sgi.com</i></a>)<br>
<i>Thu, 20 Jul 2000 10:55:00 +1000 (EST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#516">[ date ]</a><a href="index.html#516">[ thread ]</a><a href="subject.html#516">[ subject ]</a><a href="author.html#516">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0517.html">Linus Torvalds: "Re: [BUG] PCMCIA CardBus problems"</a>
<li> <b>Previous message:</b> <a href="0515.html">Attila Kesmarki: "tdfx framebuffer driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch against 2.4.0-test5-pre3 provides per-cpu system call counters<br>
(for arch/i386 only so far), and exports them in /proc/interrupts. I'm<br>
interested if anyone thinks this is useful or plain stupid, and/or if<br>
anyone familiar with assembler for other archs wants to make similar<br>
changes  [note: this patch follow's Keith's recently posted patch which<br>
also changed include/asm-i386/hardirq.h].<br>
<p>
Lots of due care to avoid any performance degradation like syscall overhead,<br>
SMP cacheline pingpong, etc. The changes use one of the spare fields<br>
in irq_stat (which is cacheline aligned), and require a single additional<br>
instruction to the ret_from_sys_call code path. Testing reveals no<br>
statistically significant degradation in performance, i.e. on our<br>
dual-cpu-PIII/550 system :<br>
<p>
=== 2.2.4-test5 WITHOUT syscall acct ===<br>
    one process spinning in getpid<br>
        1816913 calls/second<br>
<p>
    two processes spinning in getpid:<br>
        1780061 calls/second<br>
        1778278 calls/second<br>
<p>
    clean kernel compile<br>
    210.310u 13.820s 3:43.81 100.1% 0+0k 0+0io 302915pf+0w<br>
    210.470u 14.090s 3:43.48 100.4% 0+0k 0+0io 302915pf+0w<br>
<p>
=== 2.2.4-test5 WITH syscall acct ===<br>
    one process spinning in getpid<br>
        1815879 calls/second<br>
<p>
    two processes spinning in getpid:<br>
        1768717 calls/second<br>
        1763654 calls/second<br>
<p>
    clean kernel compile<br>
    207.460u 14.160s 3:40.83 100.3% 0+0k 0+0io 302915pf+0w<br>
    207.800u 14.300s 3:37.38 102.1% 0+0k 0+0io 302915pf+0w<br>
<p>
The new /proc/interrupts looks like this:<br>
<p>
icy 53% cat /proc/interrupts<br>
           CPU0       CPU1       <br>
  0:      89722      99730    IO-APIC-edge  timer<br>
  1:          2          0    IO-APIC-edge  keyboard<br>
  2:          0          0          XT-PIC  cascade<br>
  4:        168        162    IO-APIC-edge  serial<br>
 13:          1          0          XT-PIC  fpu<br>
 15:          1          3    IO-APIC-edge  ide1<br>
 19:      27408      27300   IO-APIC-level  aic7xxx, aic7xxx<br>
 21:      13432      13948   IO-APIC-level  eth0<br>
NMI:     189327     189327 <br>
LOC:     189299     189289 <br>
ERR:          0<br>
SYS:  130768636   69891376    system calls<br>
<p>
thanks<br>
-- Mark Goodwin<br>
SGI Engineering<br>
---------------<br>
<p>
--- linux/include/asm-i386/hardirq.h.orig	Thu Jul 20 09:38:50 2000<br>
+++ linux/include/asm-i386/hardirq.h	Thu Jul 20 09:35:26 2000<br>
@@ -9,7 +9,8 @@<br>
 	unsigned int __local_irq_count;<br>
 	unsigned int __local_bh_count;<br>
 	unsigned int __nmi_counter;<br>
-	unsigned int __pad[5];<br>
+	unsigned int __syscall_counter; /* this is updated in entry.S */<br>
+	unsigned int __pad[4];<br>
 } ____cacheline_aligned irq_cpustat_t;<br>
 <br>
 extern irq_cpustat_t irq_stat [NR_CPUS];<br>
--- linux/arch/i386/kernel/entry.S.orig	Thu Jul 20 09:39:21 2000<br>
+++ linux/arch/i386/kernel/entry.S	Thu Jul 20 09:34:44 2000<br>
@@ -206,9 +206,11 @@<br>
 #ifdef CONFIG_SMP<br>
 	movl processor(%ebx),%eax<br>
 	shll $5,%eax<br>
+	incl SYMBOL_NAME(irq_stat)+12(,%eax) # irq_stat.__syscall_counter<br>
 	movl SYMBOL_NAME(softirq_state)(,%eax),%ecx<br>
 	testl SYMBOL_NAME(softirq_state)+4(,%eax),%ecx<br>
 #else<br>
+	incl SYMBOL_NAME(irq_stat)+12	# irq_stat.__syscall_counter<br>
 	movl SYMBOL_NAME(softirq_state),%ecx<br>
 	testl SYMBOL_NAME(softirq_state)+4,%ecx<br>
 #endif<br>
--- linux/arch/i386/kernel/irq.c.orig	Thu Jul 20 09:39:41 2000<br>
+++ linux/arch/i386/kernel/irq.c	Thu Jul 20 09:34:44 2000<br>
@@ -170,6 +170,13 @@<br>
 	p += sprintf(p, "\n");<br>
 #endif<br>
 	p += sprintf(p, "ERR: %10lu\n", irq_err_count);<br>
+<br>
+	p += sprintf(p, "SYS: ");<br>
+	for (j = 0; j &lt; smp_num_cpus; j++)<br>
+		p += sprintf(p, "%10u ",<br>
+			irq_stat[cpu_logical_map(j)].__syscall_counter);<br>
+	p += sprintf(p, " %14s\n", "system calls");<br>
+<br>
 	return p - buf;<br>
 }<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0517.html">Linus Torvalds: "Re: [BUG] PCMCIA CardBus problems"</a>
<li> <b>Previous message:</b> <a href="0515.html">Attila Kesmarki: "tdfx framebuffer driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
