<!-- received="Wed Jul 19 22:38:55 2000 EET DST" -->
<!-- sent="Wed, 19 Jul 2000 21:33:27 +0200" -->
<!-- name="Alain Knaff" -->
<!-- email="Alain.Knaff@ltnb.lu" -->
<!-- subject="[PATCH] Support for floppies whose sectors are numbered from zero" -->
<!-- id="200007191933.VAA01472@hitchhiker.org.lu" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Support for floppies whose sectors are numbered from zero</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Support for floppies whose sectors are numbered from zero</h1>
<b>Alain Knaff</b> (<a href="mailto:Alain.Knaff@ltnb.lu"><i>Alain.Knaff@ltnb.lu</i></a>)<br>
<i>Wed, 19 Jul 2000 21:33:27 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#472">[ date ]</a><a href="index.html#472">[ thread ]</a><a href="subject.html#472">[ subject ]</a><a href="author.html#472">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0473.html">David Mansfield: "Re: An important fact about real time computing"</a>
<li> <b>Previous message:</b> <a href="0471.html">P.Basker: "compile fails (for embedded mips)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
[Well, I admit it might be a little bit late for a "feature" patch,<br>
codefreeze and all but this patch is rather small and thus low<br>
risk...]<br>
<p>
This patch adds support for floppy disks whose sectors are numbered<br>
starting at 0 rather than 1 as usual disks would be.  This format is<br>
used for some CP/M disks, and also for certain music synthesizers<br>
(Ensoniq sampler).<br>
<p>
In order to use, you need to apply the fdutils-20000716 patch at<br>
<a href="http://fdutils.linux.lu">http://fdutils.linux.lu</a> as well, and do<br>
 setfdrpm /dev/fd0 dd zerobased sect=10<br>
or<br>
 setfdprm /dev/fd0 hd zerobased sect=20.<br>
 <br>
Regards,<br>
<p>
Alain<br>
<p>
diff -ur test5-pre3/linux/drivers/block/floppy.c linux/drivers/block/floppy.c<br>
--- test5-pre3/linux/drivers/block/floppy.c	Wed Jul 19 20:47:20 2000<br>
+++ linux/drivers/block/floppy.c	Wed Jul 19 21:15:24 2000<br>
@@ -2229,6 +2229,10 @@<br>
 			}<br>
 		}<br>
 	}<br>
+	if(_floppy-&gt;stretch &amp; FD_ZEROBASED) {<br>
+	    for(count = 0; count &lt; F_SECT_PER_TRACK; count++)<br>
+		here[count].sect--;<br>
+	}<br>
 }<br>
 <br>
 static void redo_format(void)<br>
@@ -2645,7 +2649,8 @@<br>
 	}<br>
 	HEAD = sector_t / _floppy-&gt;sect;<br>
 <br>
-	if (((_floppy-&gt;stretch &amp; FD_SWAPSIDES) || TESTF(FD_NEED_TWADDLE)) &amp;&amp;<br>
+	if (( (_floppy-&gt;stretch &amp; (FD_SWAPSIDES | FD_ZEROBASED)) || <br>
+	      TESTF(FD_NEED_TWADDLE)) &amp;&amp;<br>
 	    sector_t &lt; _floppy-&gt;sect)<br>
 		max_sector = _floppy-&gt;sect;<br>
 <br>
@@ -2675,7 +2680,8 @@<br>
 	GAP = _floppy-&gt;gap;<br>
 	CODE2SIZE;<br>
 	SECT_PER_TRACK = _floppy-&gt;sect &lt;&lt; 2 &gt;&gt; SIZECODE;<br>
-	SECTOR = ((sector_t % _floppy-&gt;sect) &lt;&lt; 2 &gt;&gt; SIZECODE) + 1;<br>
+	SECTOR = ((sector_t % _floppy-&gt;sect) &lt;&lt; 2 &gt;&gt; SIZECODE) + <br>
+	    ((_floppy-&gt;stretch &amp; FD_ZEROBASED) ? 0 : 1);<br>
 <br>
 	/* tracksize describes the size which can be filled up with sectors<br>
 	 * of size ssize.<br>
@@ -3312,7 +3318,7 @@<br>
 	    g-&gt;track &lt;= 0 ||<br>
 	    g-&gt;track &gt; UDP-&gt;tracks&gt;&gt;STRETCH(g) ||<br>
 	    /* check if reserved bits are set */<br>
-	    (g-&gt;stretch&amp;~(FD_STRETCH|FD_SWAPSIDES)) != 0)<br>
+	    (g-&gt;stretch&amp;~(FD_STRETCH|FD_SWAPSIDES|FD_ZEROBASED)) != 0)<br>
 		return -EINVAL;<br>
 	if (type){<br>
 		if (!capable(CAP_SYS_ADMIN))<br>
@@ -3337,11 +3343,13 @@<br>
 					      drive_state[cnt].fd_device));<br>
 		}<br>
 	} else {<br>
+		int oldStretch;<br>
 		LOCK_FDC(drive,1);<br>
 		if (cmd != FDDEFPRM)<br>
 			/* notice a disk change immediately, else<br>
 			 * we lose our settings immediately*/<br>
 			CALL(poll_drive(1, FD_RAW_NEED_DISK));<br>
+		oldStretch = g-&gt;stretch;<br>
 		user_params[drive] = *g;<br>
 		if (buffer_drive == drive)<br>
 			SUPBOUND(buffer_max, user_params[drive].sect);<br>
@@ -3356,7 +3364,10 @@<br>
 		 * whose number will change. This is useful, because<br>
 		 * mtools often changes the geometry of the disk after<br>
 		 * looking at the boot block */<br>
-		if (DRS-&gt;maxblock &gt; user_params[drive].sect || DRS-&gt;maxtrack)<br>
+		if (DRS-&gt;maxblock &gt; user_params[drive].sect || <br>
+		    DRS-&gt;maxtrack ||<br>
+		    ((user_params[drive].sect ^ oldStretch) &amp;<br>
+		     FD_SWAPSIDES | FD_ZEROBASED))<br>
 			invalidate_drive(device);<br>
 		else<br>
 			process_fd_request();<br>
<p>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0473.html">David Mansfield: "Re: An important fact about real time computing"</a>
<li> <b>Previous message:</b> <a href="0471.html">P.Basker: "compile fails (for embedded mips)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
