<!-- received="Wed Jul 19 19:06:10 2000 EET DST" -->
<!-- sent="Wed, 19 Jul 2000 11:58:16 -0400" -->
<!-- name="Paul Barton-Davis" -->
<!-- email="pbd@op.net" -->
<!-- subject="[PATCH] CRITICAL bug(s?) in parport driver" -->
<!-- id="200007191558.e6JFwGc00845@op.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] CRITICAL bug(s?) in parport driver</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] CRITICAL bug(s?) in parport driver</h1>
<b>Paul Barton-Davis</b> (<a href="mailto:pbd@op.net"><i>pbd@op.net</i></a>)<br>
<i>Wed, 19 Jul 2000 11:58:16 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#449">[ date ]</a><a href="index.html#449">[ thread ]</a><a href="subject.html#449">[ subject ]</a><a href="author.html#449">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0450.html">Sebastian Willing: "syba tech multi-I/O pci-card"</a>
<li> <b>Previous message:</b> <a href="0448.html">Richard B. Johnson: "Re: D-Link DFE-570TX: driver issues w/ tulip and de4x5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0452.html">Tim Waugh: "Re: [PATCH] CRITICAL bug(s?) in parport driver"</a>
<li> <b>Reply:</b> <a href="0452.html">Tim Waugh: "Re: [PATCH] CRITICAL bug(s?) in parport driver"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
There is a critical bug in the parport driver that prevents it from <br>
ever attaching any device driver to any ports under some (all?)<br>
circumstances. Patch enclosed.<br>
<p>
HOWEVER: from a casual inspection of the code, there are several other<br>
locations where the use of loop increment variables seems odd. I have<br>
not chosen to dabble with these, but here is the most obvious example,<br>
from attach_driver_chain():<br>
<p>
------------------------------------------------------------------------------<br>
	spin_lock (&amp;driverlist_lock);<br>
	for (i = 0, drv = driver_chain; drv &amp;&amp; i &lt; count; drv = drv-&gt;next)<br>
		attach[i] = drv-&gt;attach;<br>
	spin_unlock (&amp;driverlist_lock);<br>
<p>
   ..... So whats the value of `i' now, and what does it mean ???? ....<br>
<p>
	for (count = 0; count &lt; i; count++)<br>
		(*attach[i]) (port);<br>
------------------------------------------------------------------------------<br>
<p>
Anyway, here is the patch that was stopping my printer (and as far as<br>
I can tell, *any* parport driver) from working, at least when compiled<br>
into the kernel.<br>
<p>
--p<br>
<p>
--- linux/drivers/parport/share.c.orig  Wed Jul 12 19:24:34 2000<br>
+++ linux/drivers/parport/share.c       Wed Jul 19 11:52:14 2000<br>
@@ -200,7 +200,7 @@<br>
        else {<br>
                spin_lock (&amp;parportlist_lock);<br>
                for (i = 0, port = portlist; port &amp;&amp; i &lt; count;<br>
-                    port = port-&gt;next)<br>
+                    port = port-&gt;next, i++)<br>
                        ports[i] = port;<br>
                spin_unlock (&amp;parportlist_lock);<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0450.html">Sebastian Willing: "syba tech multi-I/O pci-card"</a>
<li> <b>Previous message:</b> <a href="0448.html">Richard B. Johnson: "Re: D-Link DFE-570TX: driver issues w/ tulip and de4x5"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0452.html">Tim Waugh: "Re: [PATCH] CRITICAL bug(s?) in parport driver"</a>
<li> <b>Reply:</b> <a href="0452.html">Tim Waugh: "Re: [PATCH] CRITICAL bug(s?) in parport driver"</a>
<!-- reply="end" -->
</ul>
</font></body>
