<!-- received="Wed Jul 19 16:59:55 2000 EET DST" -->
<!-- sent="Wed, 19 Jul 2000 15:56:04 +0200" -->
<!-- name="Christoph Hellwig" -->
<!-- email="hch@ns.lst.de" -->
<!-- subject="[PATCH] Stackable filesystem fixes for 2.4.0test5 (-pre3)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Stackable filesystem fixes for 2.4.0test5 (-pre3)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Stackable filesystem fixes for 2.4.0test5 (-pre3)</h1>
<b>Christoph Hellwig</b> (<a href="mailto:hch@ns.lst.de"><i>hch@ns.lst.de</i></a>)<br>
<i>Wed, 19 Jul 2000 15:56:04 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#441">[ date ]</a><a href="index.html#441">[ thread ]</a><a href="subject.html#441">[ subject ]</a><a href="author.html#441">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0442.html">David Balazic: "An important fact about real time computing"</a>
<li> <b>Previous message:</b> <a href="0440.html">Robert Cohen: "Elvtune and kernel 2.4.0-test4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch provides better support for stackable filesystem based on<br>
fist (<a href="http://www.cs.columbia.edu/~ezk/research/fist/">http://www.cs.columbia.edu/~ezk/research/fist/</a>, patch for<br>
fist 0.0.3 to support Linux 2.4 at ftp.openlinux.org:/pub/people/hch).<br>
All work was done by Erez Zadok, I've only ported it to Linux 2.4.<br>
<p>
Please apply, this patch is completly passive and couldn"t impact kernel<br>
stability.<br>
<p>
	Christoph<br>
<p>
<p>
diff -uNr --exclude-from=exclude linux.orig/fs/exec.c linux/fs/exec.c<br>
--- linux.orig/fs/exec.c	Wed Jul 19 14:39:40 2000<br>
+++ linux/fs/exec.c	Wed Jul 19 15:16:52 2000<br>
@@ -117,7 +117,7 @@<br>
 	if (error)<br>
 		goto exit;<br>
 <br>
-	file = dentry_open(nd.dentry, nd.mnt, O_RDONLY);<br>
+	file = dentry_open(nd.dentry, nd.mnt, FMODE_READ, O_RDONLY);<br>
 	error = PTR_ERR(file);<br>
 	if (IS_ERR(file))<br>
 		goto out;<br>
@@ -348,7 +348,7 @@<br>
 			int err = permission(inode, MAY_EXEC);<br>
 			file = ERR_PTR(err);<br>
 			if (!err) {<br>
-				file = dentry_open(nd.dentry, nd.mnt, O_RDONLY);<br>
+				file = dentry_open(nd.dentry, nd.mnt, FMODE_READ, O_RDONLY);<br>
 				if (!IS_ERR(file)) {<br>
 					err = deny_write_access(file);<br>
 					if (err) {<br>
diff -uNr --exclude-from=exclude linux.orig/fs/open.c linux/fs/open.c<br>
--- linux.orig/fs/open.c	Wed Jul 19 14:39:40 2000<br>
+++ linux/fs/open.c	Wed Jul 19 15:16:52 2000<br>
@@ -587,12 +587,12 @@<br>
 }<br>
 <br>
 /*<br>
- * Note that while the flag value (low two bits) for sys_open means:<br>
+ * Note that while the flags value (low two bits) for sys_open means:<br>
  *	00 - read-only<br>
  *	01 - write-only<br>
  *	10 - read-write<br>
  *	11 - special<br>
- * it is changed into<br>
+ * when it is copied into open_flags, it is changed into<br>
  *	00 - no permissions needed<br>
  *	01 - read-permission<br>
  *	10 - write-permission<br>
@@ -602,23 +602,24 @@<br>
  */<br>
 struct file *filp_open(const char * filename, int flags, int mode)<br>
 {<br>
-	int namei_flags, error;<br>
+	int namei_flags, open_flags, error;<br>
 	struct nameidata nd;<br>
 <br>
 	namei_flags = flags;<br>
-	if ((namei_flags+1) &amp; O_ACCMODE)<br>
+	open_flags = ((namei_flags+1) &amp; O_ACCMODE);<br>
+	if (open_flags)<br>
 		namei_flags++;<br>
 	if (namei_flags &amp; O_TRUNC)<br>
 		namei_flags |= 2;<br>
 <br>
 	error = open_namei(filename, namei_flags, mode, &amp;nd);<br>
 	if (!error)<br>
-		return dentry_open(nd.dentry, nd.mnt, flags);<br>
+		return dentry_open(nd.dentry, nd.mnt, open_flags, flags);<br>
 <br>
 	return ERR_PTR(error);<br>
 }<br>
 <br>
-struct file *dentry_open(struct dentry *dentry, struct vfsmount *mnt, int flags)<br>
+struct file *dentry_open(struct dentry *dentry, struct vfsmount *mnt, int mode, int flags)<br>
 {<br>
 	struct file * f;<br>
 	struct inode *inode;<br>
@@ -629,7 +630,7 @@<br>
 	if (!f)<br>
 		goto cleanup_dentry;<br>
 	f-&gt;f_flags = flags;<br>
-	f-&gt;f_mode = (flags+1) &amp; O_ACCMODE;<br>
+	f-&gt;f_mode = mode;<br>
 	inode = dentry-&gt;d_inode;<br>
 	if (f-&gt;f_mode &amp; FMODE_WRITE) {<br>
 		error = get_write_access(inode);<br>
diff -uNr --exclude-from=exclude linux.orig/include/linux/fs.h linux/include/linux/fs.h<br>
--- linux.orig/include/linux/fs.h	Wed Jul 19 14:56:28 2000<br>
+++ linux/include/linux/fs.h	Wed Jul 19 15:16:53 2000<br>
@@ -879,7 +879,7 @@<br>
 extern int do_truncate(struct dentry *, loff_t start);<br>
 <br>
 extern struct file *filp_open(const char *, int, int);<br>
-extern struct file * dentry_open(struct dentry *, struct vfsmount *, int);<br>
+extern struct file * dentry_open(struct dentry *, struct vfsmount *, int, int);<br>
 extern int filp_close(struct file *, fl_owner_t id);<br>
 extern char * getname(const char *);<br>
 <br>
diff -uNr --exclude-from=exclude linux.orig/include/linux/fs.h~ linux/include/linux/fs.h~<br>
--- linux.orig/include/linux/fs.h~	Wed Jul 19 14:33:58 2000<br>
+++ linux/include/linux/fs.h~	Wed Jul 19 14:56:28 2000<br>
@@ -879,7 +879,7 @@<br>
 extern int do_truncate(struct dentry *, loff_t start);<br>
 <br>
 extern struct file *filp_open(const char *, int, int);<br>
-extern struct file * dentry_open(struct dentry *, struct vfsmount *, int, int);<br>
+extern struct file * dentry_open(struct dentry *, struct vfsmount *, int);<br>
 extern int filp_close(struct file *, fl_owner_t id);<br>
 extern char * getname(const char *);<br>
 <br>
diff -uNr --exclude-from=exclude linux.orig/include/linux/mm.h linux/include/linux/mm.h<br>
--- linux.orig/include/linux/mm.h	Wed Jul 19 14:56:28 2000<br>
+++ linux/include/linux/mm.h	Wed Jul 19 15:16:53 2000<br>
@@ -544,6 +544,21 @@<br>
 #define vmlist_modify_lock(mm)		vmlist_access_lock(mm)<br>
 #define vmlist_modify_unlock(mm)	vmlist_access_unlock(mm)<br>
 <br>
+/*<br>
+ * Common MM functions for inclusion in the VFS<br>
+ * or in other stackable file systems.  Some of these<br>
+ * functions were in linux/mm/ C files.<br>
+ *<br>
+ */<br>
+static inline int sync_page(struct page *page)<br>
+{<br>
+	struct address_space *mapping = page-&gt;mapping;<br>
+<br>
+	if (mapping &amp;&amp; mapping-&gt;a_ops &amp;&amp; mapping-&gt;a_ops-&gt;sync_page)<br>
+		return mapping-&gt;a_ops-&gt;sync_page(page);<br>
+	return 0;<br>
+}<br>
+<br>
 #endif /* __KERNEL__ */<br>
 <br>
 #endif<br>
diff -uNr --exclude-from=exclude linux.orig/include/linux/mm.h~ linux/include/linux/mm.h~<br>
--- linux.orig/include/linux/mm.h~	Wed Jul 19 14:33:58 2000<br>
+++ linux/include/linux/mm.h~	Wed Jul 19 14:56:28 2000<br>
@@ -544,21 +544,6 @@<br>
 #define vmlist_modify_lock(mm)		vmlist_access_lock(mm)<br>
 #define vmlist_modify_unlock(mm)	vmlist_access_unlock(mm)<br>
 <br>
-/*<br>
- * Common MM functions for inclusion in the VFS<br>
- * or in other stackable file systems.  Some of these<br>
- * functions were in linux/mm/ C files.<br>
- *<br>
- */<br>
-static inline int sync_page(struct page *page)<br>
-{<br>
-	struct address_space *mapping = page-&gt;mapping;<br>
-<br>
-	if (mapping &amp;&amp; mapping-&gt;a_ops &amp;&amp; mapping-&gt;a_ops-&gt;sync_page)<br>
-		return mapping-&gt;a_ops-&gt;sync_page(page);<br>
-	return 0;<br>
-}<br>
-<br>
 #endif /* __KERNEL__ */<br>
 <br>
 #endif<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0442.html">David Balazic: "An important fact about real time computing"</a>
<li> <b>Previous message:</b> <a href="0440.html">Robert Cohen: "Elvtune and kernel 2.4.0-test4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
