<!-- received="Wed Jul 19 11:16:15 2000 EET DST" -->
<!-- sent="Wed, 19 Jul 2000 10:12:40 +0200" -->
<!-- name="Christian Ehrhardt" -->
<!-- email="ehrhardt@mathematik.uni-ulm.de" -->
<!-- subject="[PATCH] Infinite loop in fs/fcntl.c" -->
<!-- id="20000719101240.A4536@mathematik.uni-ulm.de" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Infinite loop in fs/fcntl.c</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Infinite loop in fs/fcntl.c</h1>
<b>Christian Ehrhardt</b> (<a href="mailto:ehrhardt@mathematik.uni-ulm.de"><i>ehrhardt@mathematik.uni-ulm.de</i></a>)<br>
<i>Wed, 19 Jul 2000 10:12:40 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#417">[ date ]</a><a href="index.html#417">[ thread ]</a><a href="subject.html#417">[ subject ]</a><a href="author.html#417">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0418.html">Heusden, Folkert van: "framebuffer"</a>
<li> <b>Previous message:</b> <a href="0416.html">Willy Tarreau: "[PATCH] typo in 2.2.1[67] + 486 emulation"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
there is a Bug in fs/fcntl.c#locate_fd that can hang your system<br>
completly within seconds. Just run this little program with a<br>
ulimit &gt; 1024 for the number of open files.<br>
<p>
<p>
#include &lt;unistd.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
<p>
int main () {<br>
	int fd;<br>
	while (1) {<br>
		fd = dup (0);<br>
		if (fd &lt; 0)<br>
			break;<br>
		if (close (fd-1) &lt; 0)<br>
			break;<br>
		fd = dup (0);<br>
		if (fd &lt; 0)<br>
			break;<br>
		if (fd %100 == 0) {<br>
			write (0, "ok\n", 3);<br>
		}<br>
	}<br>
	perror ("duptest");<br>
	return 0;<br>
}<br>
<p>
The reason is an infinite loop in locate_fd. Here's the patch. It also<br>
fixes another mostly harmless race that might cause unnecessary expansion<br>
of the number of file descriptors. The patch is against 2.3.99-pre9 but<br>
it applies cleanly against 2.4.0-test4.<br>
<p>
<p>
--- linux-2.3.99/fs/fcntl.c.vanilla	Wed Jul 19 00:34:07 2000<br>
+++ linux-2.3.99/fs/fcntl.c	Wed Jul 19 01:00:45 2000<br>
@@ -21,19 +21,21 @@<br>
  */<br>
 <br>
 static inline int locate_fd(struct files_struct *files, <br>
-			    struct file *file, int start)<br>
+			    struct file *file, int orig_start)<br>
 {<br>
 	unsigned int newfd;<br>
 	int error;<br>
+	int start;<br>
 <br>
 	write_lock(&amp;files-&gt;file_lock);<br>
 	<br>
 repeat:<br>
 	error = -EMFILE;<br>
+	start = orig_start;	/* Someone might have closed fd's in the range<br>
+				 * orig_start..files-&gt;next_fd */<br>
 	if (start &lt; files-&gt;next_fd)<br>
 		start = files-&gt;next_fd;<br>
 	if (start &gt;= files-&gt;max_fdset) {<br>
-	expand:<br>
 		error = expand_files(files, start);<br>
 		if (error &lt; 0)<br>
 			goto out;<br>
@@ -46,8 +48,6 @@<br>
 	error = -EMFILE;<br>
 	if (newfd &gt;= current-&gt;rlim[RLIMIT_NOFILE].rlim_cur)<br>
 		goto out;<br>
-	if (newfd &gt;= files-&gt;max_fdset) <br>
-		goto expand;<br>
 <br>
 	error = expand_files(files, newfd);<br>
 	if (error &lt; 0)<br>
<p>
<p>
     regards  Christian<br>
<p>
<pre>
-- 
THAT'S ALL FOLKS!
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0418.html">Heusden, Folkert van: "framebuffer"</a>
<li> <b>Previous message:</b> <a href="0416.html">Willy Tarreau: "[PATCH] typo in 2.2.1[67] + 486 emulation"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
