<!-- received="Wed Jul 19 00:48:06 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 23:46:54 +0200" -->
<!-- name="Jakub Jelinek" -->
<!-- email="jakub@redhat.com" -->
<!-- subject="[PATCH] 2.4.0-test5-pre2 preprocessing related fixes" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] 2.4.0-test5-pre2 preprocessing related fixes</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.4.0-test5-pre2 preprocessing related fixes</h1>
<b>Jakub Jelinek</b> (<a href="mailto:jakub@redhat.com"><i>jakub@redhat.com</i></a>)<br>
<i>Tue, 18 Jul 2000 23:46:54 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#372">[ date ]</a><a href="index.html#372">[ thread ]</a><a href="subject.html#372">[ subject ]</a><a href="author.html#372">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0373.html">Sid Boyce: "2.4.0-test4 and bttv"</a>
<li> <b>Previous message:</b> <a href="0371.html">Ross Patterson: "Patch for s390 kernel bug in arch/s390/kernel/signal.c: rt_sigreturn()"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0382.html">Brian Gerst: "Re: [PATCH] 2.4.0-test5-pre2 preprocessing related fixes"</a>
<li> <b>Reply:</b> <a href="0382.html">Brian Gerst: "Re: [PATCH] 2.4.0-test5-pre2 preprocessing related fixes"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
cpp in gcc 2.96 (and in the upcoming gcc3) is much more picky about bugs in<br>
the code or relying on undefined behaviour, as it tries to comply to<br>
standards. So, e.g. using a ## operator without left-hand or right-hand side<br>
is not good (and its removal in fact does not change anything with older<br>
cpp's).<br>
Also, there is an asm() fix, I really think the zatm author meant "=a" when<br>
writing "=eax" and not one of the 3 alternatives.<br>
The i386 boot/ code contains several asm comments which start with<br>
							# if something<br>
or<br>
							# else something<br>
This is again not very good, because it was really meant as comments and not<br>
preprocessor directives.<br>
And last, gcc3 -traditional preprocessor does not handle GNU varargs<br>
extensions, that's why it is traditional, pure K&amp;R. So, .S files either have<br>
to be written to work with pure K&amp;R cpp or be preprocessed without<br>
-traditional.<br>
<p>
--- linux-2.4.0/drivers/char/ftape/lowlevel/ftape_syms.c.jj	Wed May 20 21:54:37 1998<br>
+++ linux-2.4.0/drivers/char/ftape/lowlevel/ftape_syms.c	Tue Jul 18 19:09:38 2000<br>
@@ -43,9 +43,9 @@<br>
 #include "../lowlevel/ftape-format.h"<br>
 <br>
 #if LINUX_VERSION_CODE &gt;= KERNEL_VER(2,1,18)<br>
-# define FT_KSYM(sym) EXPORT_SYMBOL(##sym);<br>
+# define FT_KSYM(sym) EXPORT_SYMBOL(sym);<br>
 #else<br>
-# define FT_KSYM(sym) X(##sym),<br>
+# define FT_KSYM(sym) X(sym),<br>
 #endif<br>
 <br>
 #if LINUX_VERSION_CODE &lt; KERNEL_VER(2,1,18)<br>
--- linux-2.4.0/drivers/char/ftape/lowlevel/ftape-tracing.h.jj	Fri Jan 23 20:38:04 1998<br>
+++ linux-2.4.0/drivers/char/ftape/lowlevel/ftape-tracing.h	Tue Jul 18 20:36:38 2000<br>
@@ -149,7 +149,7 @@ extern void ftape_trace_log (const char <br>
  */<br>
 #define TRACE_ABORT(res, i...)			\<br>
 {						\<br>
- 	TRACE(##i);				\<br>
+ 	TRACE(i);				\<br>
 	TRACE_EXIT res;				\<br>
 }<br>
 <br>
--- linux-2.4.0/drivers/char/ftape/zftape/zftape_syms.c.jj	Wed May 20 21:54:37 1998<br>
+++ linux-2.4.0/drivers/char/ftape/zftape/zftape_syms.c	Tue Jul 18 20:48:10 2000<br>
@@ -35,9 +35,9 @@<br>
 #include "../zftape/zftape-ctl.h"<br>
 <br>
 #if LINUX_VERSION_CODE &gt;= KERNEL_VER(2,1,18)<br>
-# define FT_KSYM(sym) EXPORT_SYMBOL(##sym);<br>
+# define FT_KSYM(sym) EXPORT_SYMBOL(sym);<br>
 #else<br>
-# define FT_KSYM(sym) X(##sym),<br>
+# define FT_KSYM(sym) X(sym),<br>
 #endif<br>
 <br>
 #if LINUX_VERSION_CODE &lt; KERNEL_VER(2,1,18)<br>
--- linux-2.4.0/drivers/usb/microtek.c.jj	Wed Jun 28 22:49:00 2000<br>
+++ linux-2.4.0/drivers/usb/microtek.c	Tue Jul 18 21:03:43 2000<br>
@@ -151,18 +151,18 @@ static struct usb_driver mts_usb_driver <br>
 #define MTS_NAME	"microtek usb (rev " MTS_VERSION "): "<br>
 <br>
 #define MTS_WARNING(x...) \<br>
-	printk( KERN_WARNING MTS_NAME ## x )<br>
+	printk( KERN_WARNING MTS_NAME x )<br>
 #define MTS_ERROR(x...) \<br>
-	printk( KERN_ERR MTS_NAME ## x )<br>
+	printk( KERN_ERR MTS_NAME x )<br>
 #define MTS_INT_ERROR(x...) \<br>
-	MTS_ERROR( ## x )<br>
+	MTS_ERROR(x)<br>
 #define MTS_MESSAGE(x...) \<br>
-	printk( KERN_INFO MTS_NAME ## x )<br>
+	printk( KERN_INFO MTS_NAME x )<br>
 <br>
 #if defined MTS_DO_DEBUG<br>
 <br>
 #define MTS_DEBUG(x...) \<br>
-	printk( KERN_DEBUG MTS_NAME ## x )<br>
+	printk( KERN_DEBUG MTS_NAME x )<br>
 <br>
 #define MTS_DEBUG_GOT_HERE() \<br>
 	MTS_DEBUG("got to %s:%d (%s)\n", __FILE__, (int)__LINE__, __PRETTY_FUNCTION__ )<br>
--- linux-2.4.0/drivers/atm/zatm.c.jj	Tue Jun 20 16:58:42 2000<br>
+++ linux-2.4.0/drivers/atm/zatm.c	Tue Jul 18 22:03:42 2000<br>
@@ -441,8 +441,8 @@ static void zatm_clock_sync(unsigned lon<br>
 			    "shldl $" SX(TIMER_SHIFT) ",%1,%%edx\n\t"<br>
 			    "shl $" SX(TIMER_SHIFT) ",%1\n\t"<br>
 			    "divl %%ebx\n\t"<br>
-			    : "=eax" (zatm_dev-&gt;factor)<br>
-			    : "eax" (interval-diff),"g" (ticks),<br>
+			    : "=a" (zatm_dev-&gt;factor)<br>
+			    : "a" (interval-diff),"g" (ticks),<br>
 			      "g" (zatm_dev-&gt;last_clk)<br>
 			    : "ebx","edx","cc");<br>
 #undef S<br>
--- linux-2.4.0/arch/i386/lib/Makefile.jj	Fri Jul  7 20:55:39 2000<br>
+++ linux-2.4.0/arch/i386/lib/Makefile	Tue Jul 18 18:56:39 2000<br>
@@ -3,7 +3,7 @@<br>
 #<br>
 <br>
 .S.o:<br>
-	$(CC) $(AFLAGS) -traditional -c $&lt; -o $*.o<br>
+	$(CC) $(AFLAGS) -c $&lt; -o $*.o<br>
 <br>
 L_TARGET = lib.a<br>
 L_OBJS  = checksum.o old-checksum.o delay.o \<br>
--- linux-2.4.0/arch/i386/kernel/i8259.c.jj	Wed Jul  5 16:24:10 2000<br>
+++ linux-2.4.0/arch/i386/kernel/i8259.c	Tue Jul 18 18:47:39 2000<br>
@@ -36,7 +36,7 @@<br>
 BUILD_COMMON_IRQ()<br>
 <br>
 #define BI(x,y) \<br>
-	BUILD_IRQ(##x##y)<br>
+	BUILD_IRQ(x##y)<br>
 <br>
 #define BUILD_16_IRQS(x) \<br>
 	BI(x,0) BI(x,1) BI(x,2) BI(x,3) \<br>
--- linux-2.4.0/arch/i386/boot/setup.S.jj	Wed Jul  5 15:03:12 2000<br>
+++ linux-2.4.0/arch/i386/boot/setup.S	Tue Jul 18 23:10:23 2000<br>
@@ -81,7 +81,7 @@ start_sys_seg:	.word	SYSSEG<br>
 <br>
 type_of_loader:	.byte	0		# = 0, old one (LILO, Loadlin,<br>
 					#      Bootlin, SYSLX, bootsect...)<br>
-					# else it is set by the loader:<br>
+					# Else it is set by the loader:<br>
 					# 0xTV: T=0 for LILO<br>
 					#	T=1 for Loadlin<br>
 					#	T=2 for bootsect-loader<br>
@@ -91,8 +91,8 @@ type_of_loader:	.byte	0		# = 0, old one <br>
 <br>
 # flags, unused bits must be zero (RFU) bit within loadflags<br>
 loadflags:<br>
-LOADED_HIGH	= 1			# if set, the kernel is loaded high<br>
-CAN_USE_HEAP	= 0x80			# if set, the loader also has set<br>
+LOADED_HIGH	= 1			# If set, the kernel is loaded high<br>
+CAN_USE_HEAP	= 0x80			# If set, the loader also has set<br>
 					# heap_end_ptr to tell how much<br>
 					# space behind setup.S can be used for<br>
 					# heap purposes.<br>
--- linux-2.4.0/arch/i386/boot/bootsect.S.jj	Sun Feb 13 13:16:36 2000<br>
+++ linux-2.4.0/arch/i386/boot/bootsect.S	Tue Jul 18 23:20:14 2000<br>
@@ -151,7 +151,7 @@ probe_loop:<br>
 	cbtw				# extend to word<br>
 	movw	%ax, sectors<br>
 	cmpw	$disksizes+4, %si<br>
-	jae	got_sectors		# if all else fails, try 9<br>
+	jae	got_sectors		# If all else fails, try 9<br>
 	<br>
 	xchgw	%cx, %ax		# cx = track and sector<br>
 	xorw	%dx, %dx		# drive 0, head 0<br>
<p>
	Jakub<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0373.html">Sid Boyce: "2.4.0-test4 and bttv"</a>
<li> <b>Previous message:</b> <a href="0371.html">Ross Patterson: "Patch for s390 kernel bug in arch/s390/kernel/signal.c: rt_sigreturn()"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0382.html">Brian Gerst: "Re: [PATCH] 2.4.0-test5-pre2 preprocessing related fixes"</a>
<li> <b>Reply:</b> <a href="0382.html">Brian Gerst: "Re: [PATCH] 2.4.0-test5-pre2 preprocessing related fixes"</a>
<!-- reply="end" -->
</ul>
</font></body>
