<!-- received="Tue Jul 18 23:53:01 2000 EET DST" -->
<!-- sent="Tue, 18 Jul 2000 13:50:40 -0700" -->
<!-- name="George Anzinger" -->
<!-- email="george@pioneer.net" -->
<!-- subject="C issues with spinlocks and preemption" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: C issues with spinlocks and preemption</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>C issues with spinlocks and preemption</h1>
<b>George Anzinger</b> (<a href="mailto:george@pioneer.net"><i>george@pioneer.net</i></a>)<br>
<i>Tue, 18 Jul 2000 13:50:40 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#362">[ date ]</a><a href="index.html#362">[ thread ]</a><a href="subject.html#362">[ subject ]</a><a href="author.html#362">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0363.html">Richard Gooch: "Re: devfs question"</a>
<li> <b>Previous message:</b> <a href="0361.html">Mario Vanoni: "Linux SMP performance vs. UP: not a laurel"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0365.html">ludovic fernandez: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0365.html">ludovic fernandez: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0370.html">George Anzinger: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0398.html">Tom Leete: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0403.html">George Anzinger: "Re: C issues with spinlocks and preemption"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
In the persuit of trying to use spinlocks macros for UP preemption I<br>
have come up with an interesting C problem and the way header files are<br>
being coded in the kernel.  In particular:<br>
<p>
#include &lt;linux/sched.h&gt;<br>
#include &lt;asm/current.h&gt;<br>
<p>
static inline int foo(void)<br>
{<br>
	int bar;<br>
<p>
	bar = current-&gt;need_resched;<br>
	return bar;<br>
}<br>
<p>
Works fine as a .c file, but if it is in a header file that is included<br>
by sched.h (such as tty.h) or indirectly included by sched.h (such as<br>
tqueue.h) cc complains about an incomplete type on the "current"<br>
reference.<br>
<p>
The problem is that sched.h, in such a case, actually has its body<br>
included after the above code and thus all cc has is a promise (i.e.<br>
struct task_struct;) and not the real task_struct.  It appears that cc<br>
is compiling the "inline" function when it sees it, not when it is<br>
referenced.<br>
<p>
This is proving to be a tough nut to crack.  Any thoughts?<br>
<p>
George<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0363.html">Richard Gooch: "Re: devfs question"</a>
<li> <b>Previous message:</b> <a href="0361.html">Mario Vanoni: "Linux SMP performance vs. UP: not a laurel"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0365.html">ludovic fernandez: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0365.html">ludovic fernandez: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0370.html">George Anzinger: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0398.html">Tom Leete: "Re: C issues with spinlocks and preemption"</a>
<li> <b>Reply:</b> <a href="0403.html">George Anzinger: "Re: C issues with spinlocks and preemption"</a>
<!-- reply="end" -->
</ul>
</font></body>
