<!-- received="Mon Jul 17 10:46:15 2000 EET DST" -->
<!-- sent="Mon, 17 Jul 2000 09:42:43 +0200" -->
<!-- name="Vojtech Pavlik" -->
<!-- email="vojtech@suse.cz" -->
<!-- subject="VIA IDE driver, v1.5 (final)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-29,: VIA IDE driver, v1.5 (final)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>VIA IDE driver, v1.5 (final)</h1>
<b>Vojtech Pavlik</b> (<a href="mailto:vojtech@suse.cz"><i>vojtech@suse.cz</i></a>)<br>
<i>Mon, 17 Jul 2000 09:42:43 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#109">[ date ]</a><a href="index.html#109">[ thread ]</a><a href="subject.html#109">[ subject ]</a><a href="author.html#109">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0110.html">Ralston, Steve: "NT [SCSI] class/filter driver equiv. for linux?"</a>
<li> <b>Previous message:</b> <a href="0108.html">Manfred Spraul: "Re: [OT] Re: [Announce] BKL shifting into drivers and filesystems-"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0133.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0133.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0191.html">Anthony Barbachan: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0205.html">Brian Gerst: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0208.html">Brian Gerst: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0264.html">Anthony Barbachan: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0278.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0316.html">David Lombard: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0413.html">Chris Kloiber: "Re: VIA IDE driver, v1.5 (final)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--u3/rZRmxL6MmkK24<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi!<br>
<p>
I think I have a well working and tested (by a bunch of people) version<br>
of the via IDE tuning driver. I'd suggest integrating it into the<br>
current kernel. For use w/ UDMA66, it's needed to specify ide0=ata66 or<br>
ide1=ata66 on the kernel command line.<br>
<p>
See it attached.<br>
<p>
<pre>
-- 
Vojtech Pavlik
SuSE Labs
<p>
--u3/rZRmxL6MmkK24
Content-Type: text/plain
Content-Disposition: attachment; filename="via82cxxx.c"
<p>
/*
 * $Id: via82cxxx.c,v 1.5 2000/07/14 12:20:34 vojtech Exp $
 *
 *  Copyright (c) 2000 Vojtech Pavlik
 *
 *  Based on the work of:
 *	Michel Aubry
 *	Jeff Garzik
 *	Andre Hedrick
 *
 *  Sponsored by SuSE
 */
<p>
/*
 * VIA vt82c586 IDE driver for Linux. Supports
 *
 *   vt82c586, vt82c586a, vt82c586b, vt82c596a, vt82c596b, vt82c686a, vt8231
 *
 * southbridges, which can be found in
 *
 *  VIA Apollo VP, VPX, VPX/97, VP2, VP2/97, VP3, MVP3, MVP4
 *  VIA Apollo Pro, Pro Plus, Pro 133, Pro 133A, ProMedia 601, ProSavage 605
 *  VIA Apollo KX133, KT133
 *  AMD-640, AMD-750 IronGate
 *
 * chipsets. Supports PIO 0-4, MWDMA 0-2 and UDMA 0-4 (includes UDMA33 and 66) modes.
 *
 * UDMA66 modes are NOT autodetected, to do this, use 'ide0=ata66' or 'ide1=ata66'
 * on the kernel command line.
 */
<p>
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Should you need to contact me, the author, you can do so either by
 * e-mail - mail your message to &lt;vojtech@suse.cz&gt;, or by paper mail:
 * Vojtech Pavlik, Ucitelska 1576, Prague 8, 182 00 Czech Republic
 */
<p>
#include &lt;linux/config.h&gt;
#include &lt;linux/types.h&gt;
#include &lt;linux/kernel.h&gt;
#include &lt;linux/timer.h&gt;
#include &lt;linux/mm.h&gt;
#include &lt;linux/ioport.h&gt;
#include &lt;linux/interrupt.h&gt;
#include &lt;linux/blkdev.h&gt;
#include &lt;linux/hdreg.h&gt;
#include &lt;linux/pci.h&gt;
#include &lt;linux/init.h&gt;
#include &lt;linux/delay.h&gt;
#include &lt;linux/ide.h&gt;
#include &lt;asm/io.h&gt;
<p>
#include "ide_modes.h"
<p>
#define VIA_BM_BASE		0x20
#define VIA_IDE_ENABLE		0x40
#define VIA_IDE_CONFIG		0x41
#define VIA_FIFO_CONFIG		0x43
#define VIA_MISC_1		0x44
#define VIA_MISC_2		0x45
#define VIA_MISC_3		0x46
#define VIA_DRIVE_TIMING	0x48
#define VIA_ADDRESS_SETUP	0x4c
#define VIA_UDMA_TIMING		0x50
#define VIA_PRI_SECTOR_SIZE	0x60
#define VIA_SEC_SECTOR_SIZE	0x68
<p>
/*
 * VIA SouthBridge chips.
 */
<p>
static const struct {
	char *name;
	unsigned short id;
	unsigned char speed;
} via_isa_bridges[] = {
	{ "vt8231",	PCI_DEVICE_ID_VIA_8231,     XFER_UDMA_4 },
	{ "vt82c686a",	PCI_DEVICE_ID_VIA_82C686,   XFER_UDMA_4 },
	{ "vt82c596b",	PCI_DEVICE_ID_VIA_82C596,   XFER_UDMA_4 },
	{ "vt82c596a",	PCI_DEVICE_ID_VIA_82C596,   XFER_UDMA_2 },
	{ "vt82c586b",	PCI_DEVICE_ID_VIA_82C586_0, XFER_UDMA_2 },
	{ "vt82c586a",	PCI_DEVICE_ID_VIA_82C586_0, XFER_UDMA_2 },
	{ "vt82c586",	PCI_DEVICE_ID_VIA_82C586_0, XFER_MW_DMA_2 },
	{ "Unknown SouthBridge",	0,	    XFER_UDMA_4 },
	{ "Unknown SouthBridge",	0,	    XFER_UDMA_2 },
};
<p>
static unsigned char via_config;
static unsigned char via_enabled;
unsigned char fifoconfig;
<p>
/*
 * PIO 0-5, MWDMA 0-2 and UDMA 0-5 timings (in nanoseconds).
 * FIXME: Check against real ATA specification.
 */
<p>
static const struct {
	int mode;
	char *name;
	short setup;
	short active;
	short recover;
	short udma;
} via_timing[] = {
	{ XFER_UDMA_4,    "UDMA4", 25,  70,  25,  30 },
	{ XFER_UDMA_3,    "UDMA3", 25,  70,  25,  45 },
	{ XFER_UDMA_2,    "UDMA2", 25,  70,  25,  60 },
	{ XFER_UDMA_1,    "UDMA1", 25,  70,  25,  90 },
	{ XFER_UDMA_0,    "UDMA0", 25,  70,  25, 120 },
	{ XFER_MW_DMA_2,  "MDMA2", 25,  70,  25,   0 },
	{ XFER_MW_DMA_1,  "MDMA1", 30,  90,  30,   0 },
	{ XFER_MW_DMA_0,  "MDMA0", 55, 130, 300,   0 },
	{ XFER_PIO_4,     "PIO4",  25,  70,  25,   0 },
	{ XFER_PIO_3,     "PIO3",  30,  80,  70,   0 },
	{ XFER_PIO_2,     "PIO2",  30, 100, 110,   0 },
	{ XFER_PIO_1,     "PIO1",  50, 125, 208,   0 },
	{ XFER_PIO_0,     "PIO0",  70, 165, 365,   0 },
	{ XFER_PIO_SLOW,  "SLOW", 120, 260, 580,   0 },
	{ 0 }
};
<p>
/*
 * VIA /proc entry.
 */
<p>
static struct pci_dev *bmide_dev;
<p>
#ifdef CONFIG_PROC_FS
<p>
#include &lt;linux/stat.h&gt;
#include &lt;linux/proc_fs.h&gt;
<p>
int via_proc = 0;
extern int (*via_display_info)(char *, char **, off_t, int); /* ide-proc.c */
<p>
static char *via_fifo[] = { " 1 ", "3/4", "1/2", "1/4" };
static char *via_control3[] = { "No limit", "64", "128", "192" };
<p>
#define via_print(format, arg...) p += sprintf(p, format "\n" , ## arg)
#define via_print_drive(name, format, arg...)\
	p += sprintf(p, name); for (i = 0; i &lt; 4; i++) p += sprintf(p, format, ## arg); p += sprintf(p, "\n");
<p>
static int via_get_info(char *buffer, char **addr, off_t offset, int count)
{
	short pci_clock, speed[4], setup[4], active[4], recover[4], umul[4], uen[4], udma[4];
	struct pci_dev *dev = bmide_dev;
	unsigned int v, u, i, base;
	unsigned short c, size0, size1;
	unsigned char t, c0, c1;
	char *p = buffer;
<p>
	via_print("----------VIA BusMastering IDE Configuration----------------");
<p>
	via_print("South Bridge:                       VIA %s", via_isa_bridges[via_config].name);
<p>
	pci_read_config_word(dev, PCI_COMMAND, &amp;c);
	via_print("Command register:                   %#x", c);
<p>
	pci_read_config_byte(dev, PCI_LATENCY_TIMER, &amp;t);
	via_print("Latency timer:                      %d", t);
<p>
	pci_read_config_byte(dev, VIA_MISC_1, &amp;t);
	via_print("Master Read  Cycle IRDY:            %dws", (t &amp; 64) &gt;&gt;6 );
	via_print("Master Write Cycle IRDY:            %dws", (t &amp; 32) &gt;&gt; 5 );
	via_print("FIFO Output Data 1/2 Clock Advance: %s", (t &amp; 16) ? "on" : "off" );
	via_print("BM IDE Status Register Read Retry:  %s", (t &amp; 8) ? "on" : "off" );
<p>
	pci_read_config_byte(dev, VIA_MISC_2, &amp;t);
	sprintf(p, "Interrupt Steering Swap:           %s", (t &amp; 64) ? "on" : "off");
<p>
	pci_read_config_byte(dev, VIA_MISC_3, &amp;t);
	via_print("Max DRDY Pulse Width:               %s%s", via_control3[(t &amp; 0x03)], (t &amp; 0x03) ? "PCI clocks" : "");
<p>
	via_print("-----------------------Primary IDE-------Secondary IDE------");
	via_print("Read DMA FIFO flush:   %10s%20s", (t &amp; 0x80) ? "on" : "off", (t &amp; 0x40) ? "on" : "off" );
	via_print("End Sect. FIFO flush:  %10s%20s", (t &amp; 0x20) ? "on" : "off", (t &amp; 0x10) ? "on" : "off" );
<p>
	pci_read_config_byte(dev, VIA_IDE_CONFIG, &amp;t);
	via_print("Prefetch Buffer:       %10s%20s", (t &amp; 0x80) ? "on" : "off", (t &amp; 0x20) ? "on" : "off" );
	via_print("Post Write Buffer:     %10s%20s", (t &amp; 0x40) ? "on" : "off", (t &amp; 0x10) ? "on" : "off" );
<p>
	pci_read_config_byte(dev, VIA_FIFO_CONFIG, &amp;t);
	via_print("FIFO size:             %10d%20d", 16 -((t &gt;&gt; 5) + (t &gt;&gt; 6)) * 8, ((t &gt;&gt; 5) + (t &gt;&gt; 6)) * 8);
	via_print("Threshold Prim.:       %10s%20s", via_fifo[(t &gt;&gt; 2) &amp; 3], via_fifo[t &amp; 3]);
<p>
	pci_read_config_word(dev, VIA_PRI_SECTOR_SIZE, &amp;size0);
	pci_read_config_word(dev, VIA_SEC_SECTOR_SIZE, &amp;size1);
	via_print("Bytes Per Sector:      %10d%20d", size0 &amp; 0xfff, size1 &amp; 0xfff);
<p>
	pci_read_config_dword(dev, VIA_BM_BASE, &amp;base);
	base = (base &amp; 0xfff0) ;
<p>
	c0 = inb((unsigned short)base + 0x02);
	c1 = inb((unsigned short)base + 0x0a);
<p>
	via_print("Both channels togth:   %10s%20s", (c0 &amp; 0x80) ? "no" : "yes", (c1 &amp; 0x80) ? "no" : "yes" );
<p>
	via_print("-------------------drive0----drive1----drive2----drive3-----");
<p>
	via_print("BMDMA enabled: %10s%10s%10s%10s", (c0&amp;0x20) ? "yes" : "no", (c0&amp;0x40) ? "yes" : "no",
						     (c1&amp;0x20) ? "yes" : "no", (c1&amp;0x40) ? "yes" : "no" );
	pci_clock = system_bus_clock();
<p>
	pci_read_config_byte(dev, VIA_ADDRESS_SETUP, &amp;t);
	pci_read_config_dword(dev, VIA_DRIVE_TIMING, &amp;v);
	pci_read_config_dword(dev, VIA_UDMA_TIMING, &amp;u);
<p>
	for (i = 0; i &lt; 4; i++) {
		setup[i]   = ((t &gt;&gt;  ((3 - i) &lt;&lt; 1)     ) &amp; 0x3) + 1;
		active[i]  = ((v &gt;&gt; (((3 - i) &lt;&lt; 3) + 4)) &amp; 0xf) + 1;
		recover[i] = ((v &gt;&gt;  ((3 - i) &lt;&lt; 3)     ) &amp; 0xf) + 1;
		udma[i]    = ((u &gt;&gt;  ((3 - i) &lt;&lt; 3)     ) &amp; 0x7) + 2;
		umul[i]    = ((u &gt;&gt; (((3 - i) &amp; 2) &lt;&lt; 3)) &amp; 0x8) ? 2 : 1;
		uen[i]     = ((u &gt;&gt; ((3 - i) &lt;&lt; 3)) &amp; 0x20) ? 1 : 0;
		speed[i] = uen[i] ? (20 * pci_clock * umul[i]) /  udma[i] :
				    (20 * pci_clock          ) / (setup[i] + active[i] + recover[i]);
	}
<p>
	via_print_drive("Transfer Mode: ", "%10s",  uen[i] ? "UDMA" : "DMA/PIO");
	via_print_drive("Cycle (T):     ", "%8dns", 1000 / pci_clock / (uen[i] ? umul[i] : 1));
	via_print_drive("Address Setup: ", uen[i] ? "       ---" : "%9dT", setup[i]);
	via_print_drive("Active Pulse:  ", uen[i] ? "       ---" : "%9dT", active[i]);
	via_print_drive("Recovery Time: ", uen[i] ? "       ---" : "%9dT", recover[i]);
	via_print_drive("Cycle Time:    ", "%9dT", uen[i] ? udma[i] : setup[i] + active[i] + recover[i]);
	via_print_drive("Transfer Rate: ", "%4d.%dMB/s", speed[i] / 10, speed[i] % 10);
<p>
	return p - buffer;	/* hoping it is less than 4K... */
}
<p>
#endif
<p>
#define FIT(v,min,max) (((v)&gt;(max)?(max):(v))&lt;(min)?(min):(v))
#define ENOUGH(v,un) (((v)-1)/(un)+1)
<p>
static int via_set_speed(ide_drive_t *drive, byte speed)
{
	ide_hwif_t *hwif = HWIF(drive);
	struct pci_dev *dev = hwif-&gt;pci_dev;
	unsigned char t;
	int i, cycle, err = 0;
<p>
	if (drive-&gt;dn &gt; 3) return -1;
<p>
	cycle = 1000 / system_bus_clock();
<p>
	if (speed &gt; via_isa_bridges[via_config].speed)	/* Is this OK? */
		speed = via_isa_bridges[via_config].speed;
<p>
	for (i = 0; via_timing[i].mode &amp;&amp; via_timing[i].mode != speed; i++);
<p>
	printk(KERN_INFO "%s: Setting drive %d to %s\n", hwif-&gt;name, drive-&gt;dn, via_timing[i].name);
<p>
/*
 * PIO address setup
 */
<p>
	pci_read_config_byte(dev, VIA_ADDRESS_SETUP, &amp;t);
	t = (t &amp; ~(3 &lt;&lt; ((3 - drive-&gt;dn) &lt;&lt; 1))) | (FIT(ENOUGH(via_timing[i].setup, cycle) - 1, 0, 3) &lt;&lt; ((3 - drive-&gt;dn) &lt;&lt; 1));
	pci_write_config_byte(dev, VIA_ADDRESS_SETUP, t);
<p>
/*
 * PIO active &amp; recover
 */
<p>
	t = FIT(ENOUGH(via_timing[i].active, cycle) - 1, 0, 0xf) &lt;&lt; 4;
	t |= FIT(ENOUGH(via_timing[i].recover, cycle) - 1, 0, 0xf);
	pci_write_config_byte(dev, VIA_DRIVE_TIMING + (3 - drive-&gt;dn), t);
<p>
/*
 * UDMA cycle
 */
<p>
	if (via_timing[i].udma) {
		t = 0xe8;
		if (via_isa_bridges[via_config].speed &gt;= XFER_UDMA_4)
			t |= FIT(ENOUGH(via_timing[i].udma, cycle &gt;&gt; 1) - 2, 0, 7);
		else
			t |= FIT(ENOUGH(via_timing[i].udma, cycle     ) - 2, 0, 3);
	} else t = 0x0b;
<p>
	pci_write_config_byte(dev, VIA_UDMA_TIMING + (3 - drive-&gt;dn), t);
<p>
/*
 * Drive init
 */
<p>
	if (!drive-&gt;init_speed) drive-&gt;init_speed = speed;
	if ((err = ide_config_drive_speed(drive, speed)))
		return err;
	drive-&gt;current_speed = speed;
<p>
	return 0;
}
<p>
static void config_chipset_for_pio(ide_drive_t *drive)
{
	short eide_pio_timing[] = {600, 383, 240, 180, 120};
	signed char pio, ide_pio;
<p>
	if (drive-&gt;id-&gt;eide_pio_iordy &gt; 0) {	/* Has timing table */
		for (pio = 4; pio &gt;= 0; pio--)
			if (drive-&gt;id-&gt;eide_pio_iordy &lt;= eide_pio_timing[pio])
				break;
	} else {				/* No timing table -&gt; use mode capabilities */
		pio = (drive-&gt;id-&gt;eide_pio_modes &amp; 4) ? 5 :
		      (drive-&gt;id-&gt;eide_pio_modes &amp; 2) ? 4 :
		      (drive-&gt;id-&gt;eide_pio_modes &amp; 1) ? 3 :
		      (drive-&gt;id-&gt;tPIO == 2) ? 2 :
		      (drive-&gt;id-&gt;tPIO == 1) ? 1 : 0;
	}
<p>
	ide_pio = ide_get_best_pio_mode(drive, 255, 4, NULL);
	pio = (pio &gt;= ide_pio) ? pio : ide_pio;	/* Phew. What about the blacklist? */
<p>
	if (!pio) pio = (!drive-&gt;id-&gt;tPIO) ? XFER_PIO_0 : XFER_PIO_SLOW;
		else pio += XFER_PIO_0;
<p>
	via_set_speed(drive, pio);
}
<p>
static void via82cxxx_tune_drive(ide_drive_t *drive, byte pio)
{
	if (pio == 255) {
		config_chipset_for_pio(drive);
		return;
	}
	
	if (pio &gt; 4) pio = 4;
<p>
	via_set_speed(drive, XFER_PIO_0 + pio);
}
<p>
#ifdef CONFIG_BLK_DEV_IDEDMA
<p>
static int config_chipset_for_dma (ide_drive_t *drive)
{
	struct hd_driveid *id = drive-&gt;id;
	unsigned char ultra66 = eighty_ninty_three(drive);
	unsigned char speed =
<p>
		((id-&gt;dma_ultra &amp; 0x0010) &amp;&amp; ultra66) ? XFER_UDMA_4 :
		((id-&gt;dma_ultra &amp; 0x0008) &amp;&amp; ultra66) ? XFER_UDMA_3 :
		(id-&gt;dma_ultra &amp; 0x0004) ? XFER_UDMA_2 :
		(id-&gt;dma_ultra &amp; 0x0002) ? XFER_UDMA_1 :
		(id-&gt;dma_ultra &amp; 0x0001) ? XFER_UDMA_0 :
		(id-&gt;dma_mword &amp; 0x0004) ? XFER_MW_DMA_2 :
		(id-&gt;dma_mword &amp; 0x0002) ? XFER_MW_DMA_1 :
		(id-&gt;dma_mword &amp; 0x0001) ? XFER_MW_DMA_0 : 0;
		
	if (!speed) return (int) ide_dma_off_quietly;
<p>
	via_set_speed(drive, speed);
<p>
	return (int) ide_dma_on;
}
<p>
/*
 * Almost a library function.
 */
<p>
static int config_drive_xfer_rate (ide_drive_t *drive)
{
	struct hd_driveid *id = drive-&gt;id;
	ide_dma_action_t dma_func = ide_dma_on;
<p>
	if (id &amp;&amp; (id-&gt;capability &amp; 1) &amp;&amp; HWIF(drive)-&gt;autodma) {
		/* Consult the list of known "bad" drives */
		if (ide_dmaproc(ide_dma_bad_drive, drive)) {
			dma_func = ide_dma_off;
			goto fast_ata_pio;
		}
		dma_func = ide_dma_off_quietly;
		if (id-&gt;field_valid &amp; 4) {
			if (id-&gt;dma_ultra &amp; 0x002F) {
				/* Force if Capable UltraDMA */
				dma_func = config_chipset_for_dma(drive);
				if ((id-&gt;field_valid &amp; 2) &amp;&amp;
				    (dma_func != ide_dma_on))
					goto try_dma_modes;
			}
		} else if (id-&gt;field_valid &amp; 2) {
try_dma_modes:
			if (id-&gt;dma_mword &amp; 0x0007) {
				/* Force if Capable regular DMA modes */
				dma_func = config_chipset_for_dma(drive);
				if (dma_func != ide_dma_on)
					goto no_dma_set;
			}
		} else if (ide_dmaproc(ide_dma_good_drive, drive)) {
			if (id-&gt;eide_dma_time &gt; 150) {
				goto no_dma_set;
			}
			/* Consult the list of known "good" drives */
			dma_func = config_chipset_for_dma(drive);
			if (dma_func != ide_dma_on)
				goto no_dma_set;
		} else {
			goto fast_ata_pio;
		}
	} else if ((id-&gt;capability &amp; 8) || (id-&gt;field_valid &amp; 2)) {
fast_ata_pio:
		dma_func = ide_dma_off_quietly;
no_dma_set:
		config_chipset_for_pio(drive);
	}
	return HWIF(drive)-&gt;dmaproc(dma_func, drive);
}
<p>
<p>
int via82cxxx_dmaproc(ide_dma_action_t func, ide_drive_t *drive)
{
	if (func == ide_dma_check)
			return config_drive_xfer_rate(drive);
	return ide_dmaproc(func, drive);
}
#endif /* CONFIG_BLK_DEV_IDEDMA */
<p>
unsigned int __init pci_init_via82cxxx(struct pci_dev *dev, const char *name)
{
	struct pci_dev *isa = NULL;
	unsigned char f, t, m;
	unsigned int u;
<p>
/*
 * Find ISA bridge to see how good the IDE is.
 */
<p>
	for (via_config = 0; via_isa_bridges[via_config].id; via_config++)
		if ((isa = pci_find_device(PCI_VENDOR_ID_VIA, via_isa_bridges[via_config].id, NULL)))	
			break;
/*
 * Read revision.
 */
<p>
	if (via_isa_bridges[via_config].id == PCI_DEVICE_ID_VIA_82C586_0) {
		pci_read_config_byte(isa, PCI_REVISION_ID, &amp;t);
		if (t &lt; 0x30) via_config++;			/* vt82c586a */
		if (t &lt; 0x20) via_config++;			/* vt82c586 */
	}
<p>
/*
 * Set UDMA66 double clock bits.
 */
<p>
	pci_read_config_dword(dev, VIA_UDMA_TIMING, &amp;u);
	pci_write_config_dword(dev, VIA_UDMA_TIMING, u | 0x80008);
	pci_read_config_dword(dev, VIA_UDMA_TIMING, &amp;u);
<p>
	if ((via_isa_bridges[via_config].id == PCI_DEVICE_ID_VIA_82C596 || !isa)
		&amp;&amp; (u &amp; 0x80008) != 0x80008)
			via_config++;				/* vt82c596a / Unknown UDMA33 */
<p>
/*
 * Set up FIFO, flush, prefetch and post-writes.
 */
<p>
	pci_read_config_dword(dev, VIA_IDE_ENABLE, &amp;u);
<p>
	pci_read_config_byte(dev, VIA_FIFO_CONFIG, &amp;f);
	pci_read_config_byte(dev, VIA_IDE_CONFIG, &amp;t);
	pci_read_config_byte(dev, VIA_MISC_3, &amp;m);
<p>
	f &amp;= 0x90; t &amp;= 0x0f; m &amp;= 0x0f;
<p>
	switch (u &amp; 3) {
		case 2: via_enabled = 1; f |= 0x06; t |= 0xc0; m |= 0xa0; break;	/* primary only, 3/4 */
		case 1: via_enabled = 2; f |= 0x69; t |= 0x30; m |= 0x50; break;	/* secondary only, 3/4 */
		case 3: via_enabled = 3;
		default:                 f |= 0x2a; t |= 0xf0; m |= 0xf0; break;	/* fifo evenly distributed */
	}
<p>
	pci_write_config_byte(dev, VIA_FIFO_CONFIG, f);
	pci_write_config_byte(dev, VIA_IDE_CONFIG, t);
	pci_write_config_byte(dev, VIA_MISC_3, m);
<p>
/*
 * Print the boot message.
 */
<p>
	printk(KERN_INFO "VP_IDE: VIA %s IDE %s controller on pci%d:%d.%d\n",
			via_isa_bridges[via_config].name,
			via_isa_bridges[via_config].speed &gt;= XFER_UDMA_4 ? "UDMA66" :
			via_isa_bridges[via_config].speed &gt;= XFER_UDMA_2 ? "UDMA33" : "MWDMA16",
			dev-&gt;bus-&gt;number, PCI_SLOT(dev-&gt;devfn), PCI_FUNC(dev-&gt;devfn));
/*
 * Register /proc/ide/via entry
 */
<p>
#if defined(CONFIG_PROC_FS)
	if (!via_proc) {
		via_proc = 1;
		bmide_dev = dev;
		via_display_info = &amp;via_get_info;
	}
#endif
<p>
	return 0;
}
<p>
/*
 * Since we don't have a way to detect the 80-wire ribbon cable
 * we rely on the user to specify ide[0|1]=ata66 on the command line
 * if she has the cable installed.
 */
<p>
unsigned int __init ata66_via82cxxx(ide_hwif_t *hwif)
{
	return 0;
}
<p>
void __init ide_init_via82cxxx(ide_hwif_t *hwif)
{
	hwif-&gt;tuneproc = &amp;via82cxxx_tune_drive;
	hwif-&gt;speedproc = &amp;via_set_speed;
	hwif-&gt;drives[0].autotune = 1;
	hwif-&gt;drives[1].autotune = 1;
	hwif-&gt;autodma = 0;
<p>
#ifdef CONFIG_BLK_DEV_IDEDMA
	if (hwif-&gt;dma_base) {
		hwif-&gt;dmaproc = &amp;via82cxxx_dmaproc;
		hwif-&gt;autodma = 1;
	}
#endif /* CONFIG_BLK_DEV_IDEDMA */
}
<p>
/*
 * We allow the BM-DMA driver only work on enabled interfaces.
 */
<p>
void ide_dmacapable_via82cxxx(ide_hwif_t *hwif, unsigned long dmabase)
{
	if (via_enabled &amp; (1 &lt;&lt; hwif-&gt;channel))
		ide_setup_dma(hwif, dmabase, 8);
}
<p>
--u3/rZRmxL6MmkK24--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0110.html">Ralston, Steve: "NT [SCSI] class/filter driver equiv. for linux?"</a>
<li> <b>Previous message:</b> <a href="0108.html">Manfred Spraul: "Re: [OT] Re: [Announce] BKL shifting into drivers and filesystems-"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0133.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0133.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0191.html">Anthony Barbachan: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0205.html">Brian Gerst: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0208.html">Brian Gerst: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0264.html">Anthony Barbachan: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0278.html">David Ford: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0316.html">David Lombard: "Re: VIA IDE driver, v1.5 (final)"</a>
<li> <b>Reply:</b> <a href="0413.html">Chris Kloiber: "Re: VIA IDE driver, v1.5 (final)"</a>
<!-- reply="end" -->
</ul>
</font></body>
