<!-- received="Sun Jul 16 01:17:44 2000 EET DST" -->
<!-- sent="Sun, 16 Jul 2000 00:14:43 +0200" -->
<!-- name="Christian Ehrhardt" -->
<!-- email="ehrhardt@mathematik.uni-ulm.de" -->
<!-- subject="[PATCH] Race in pipe code" -->
<!-- id="20000716001443.A11284@mathematik.uni-ulm.de" -->
<!-- inreplyto="20000712234632.A20546@mathematik.uni-ulm.de" -->
<title>Linux-kernel mailing list archive 2000-29,: [PATCH] Race in pipe code</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Race in pipe code</h1>
<b>Christian Ehrhardt</b> (<a href="mailto:ehrhardt@mathematik.uni-ulm.de"><i>ehrhardt@mathematik.uni-ulm.de</i></a>)<br>
<i>Sun, 16 Jul 2000 00:14:43 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#2">[ date ]</a><a href="index.html#2">[ thread ]</a><a href="subject.html#2">[ subject ]</a><a href="author.html#2">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0003.html">Andre Hedrick: "Re: IDE read problem with ht6560a fixed in ide- patches only"</a>
<li> <b>Previous message:</b> <a href="0001.html">Petr Soucek: "Re: IDE read problem with ht6560a fixed in ide- patches only"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0024.html">Manfred Spraul: "Re: [PATCH] Race in pipe code"</a>
<li> <b>Reply:</b> <a href="0024.html">Manfred Spraul: "Re: [PATCH] Race in pipe code"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--0F1p//8PRICkK4MW<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
<p>
Hi,<br>
<p>
I can prove the race now (sample code attached) and I have a patch that fixes<br>
it for me. If noone sees problems with the patch I'll send it to Linus.<br>
The patch was developped for 2.3.99-pre9 but it applies cleanly against<br>
2.4.0-test4.<br>
<p>
The nice(20) in the test program isn't needed, it just helps to trigger the<br>
race. About 50% of the time the program prints BBBBBBBBBB on stderr and<br>
4000(!) A's on stdout which is clearly wrong. The patch basically makes<br>
sure that the same reader continues to read from the pipe after it went<br>
to sleep.<br>
<p>
    regards    Christian<br>
<p>
<pre>
-- 
THAT'S ALL FOLKS!
<p>
--0F1p//8PRICkK4MW
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="ptest.c"
<p>
#include &lt;unistd.h&gt;
#include &lt;sys/types.h&gt;
#include &lt;sys/wait.h&gt;
<p>
<p>
int main () {
	int ret, pid, i;
	int fd[2];
	char buf[5000];
<p>
	pipe (fd);
	pid = fork ();
	if (!pid) {
		close (fd[0]);
		for (i=0; i&lt;3000; i++)
			buf[i] = 'A';
		write (fd[1], buf, 3000);
		for (i=0; i&lt;10; i++)
			buf[i] = 'B';
		write (fd[1], buf, 3000);
		wait (NULL);
		wait (NULL);
	} else {
		close (fd[1]);
		pid = fork ();
		if (!pid) {
			nice (20);
			ret = read (fd[0], buf, 4000);
			buf[ret] = '\n';
			write (1, buf, ret+1);
		} else {
			ret = read (fd[0], buf, 10);
			buf[ret] = '\n';
			write (2, buf, ret+1);
		}
	} 
	return 0;
}
<p>
--0F1p//8PRICkK4MW
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="2.3.99-pre9-pipe"
<p>
--- linux/include/linux/pipe_fs_i.h.vanilla	Fri Jul 14 10:39:06 2000
+++ linux/include/linux/pipe_fs_i.h	Sat Jul 15 21:15:50 2000
@@ -1,9 +1,12 @@
 #ifndef _LINUX_PIPE_FS_I_H
 #define _LINUX_PIPE_FS_I_H
 
+#include &lt;asm/semaphore.h&gt;
+
 #define PIPEFS_MAGIC 0x50495045
 struct pipe_inode_info {
 	wait_queue_head_t wait;
+	struct semaphore read_sem;
 	char *base;
 	unsigned int start;
 	unsigned int readers;
@@ -20,6 +23,7 @@
 
 #define PIPE_SEM(inode)		(&amp;(inode).i_sem)
 #define PIPE_WAIT(inode)	(&amp;(inode).i_pipe-&gt;wait)
+#define PIPE_READ_SEM(inode)	(&amp;(inode).i_pipe-&gt;read_sem)
 #define PIPE_BASE(inode)	((inode).i_pipe-&gt;base)
 #define PIPE_START(inode)	((inode).i_pipe-&gt;start)
 #define PIPE_LEN(inode)		((inode).i_size)
--- linux/fs/pipe.c.vanilla	Sat Jul 15 21:14:00 2000
+++ linux/fs/pipe.c	Sat Jul 15 22:01:55 2000
@@ -21,6 +21,11 @@
  * 
  * Reads with count = 0 should always return 0.
  * -- Julian Bradfield 1999-06-07.
+ *
+ * A single read should always return continuous bytes.
+ * Added PIPE_READ_SEM to fix a race where this wasn't true.
+ * -- Christian Ehrhardt 2000-07-15
+ * 
  */
 
 /* Drop the inode semaphore and wait for a pipe event, atomically */
@@ -53,10 +58,12 @@
 	if (count == 0)
 		goto out_nolock;
 
-	/* Get the pipe semaphore */
+	/* Get the pipe semaphores */
 	ret = -ERESTARTSYS;
-	if (down_interruptible(PIPE_SEM(*inode)))
+	if (down_interruptible(PIPE_READ_SEM(*inode)))
 		goto out_nolock;
+	if (down_interruptible(PIPE_SEM(*inode)))
+		goto out_readlock;
 
 	if (PIPE_EMPTY(*inode)) {
 do_more_read:
@@ -126,6 +133,8 @@
 	ret = read;
 out:
 	up(PIPE_SEM(*inode));
+out_readlock:
+	up(PIPE_READ_SEM(*inode));
 out_nolock:
 	if (read)
 		ret = read;
@@ -453,6 +462,7 @@
 		goto fail_page;
 
 	init_waitqueue_head(PIPE_WAIT(*inode));
+	sema_init (PIPE_READ_SEM(*inode), 1);
 	PIPE_BASE(*inode) = (char*) page;
 	PIPE_START(*inode) = PIPE_LEN(*inode) = 0;
 	PIPE_READERS(*inode) = PIPE_WRITERS(*inode) = 0;
<p>
--0F1p//8PRICkK4MW--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0003.html">Andre Hedrick: "Re: IDE read problem with ht6560a fixed in ide- patches only"</a>
<li> <b>Previous message:</b> <a href="0001.html">Petr Soucek: "Re: IDE read problem with ht6560a fixed in ide- patches only"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0024.html">Manfred Spraul: "Re: [PATCH] Race in pipe code"</a>
<li> <b>Reply:</b> <a href="0024.html">Manfred Spraul: "Re: [PATCH] Race in pipe code"</a>
<!-- reply="end" -->
</ul>
</font></body>
