<!-- received="Sat Apr 29 18:10:03 2000 EET DST" -->
<!-- sent="Sat, 29 Apr 2000 17:03:31 +0200" -->
<!-- name="Martin Mares" -->
<!-- email="mj@suse.cz" -->
<!-- subject="PCI patch for 2.3.99pre7-pre1" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: PCI patch for 2.3.99pre7-pre1</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>PCI patch for 2.3.99pre7-pre1</h1>
<b>Martin Mares</b> (<a href="mailto:mj@suse.cz"><i>mj@suse.cz</i></a>)<br>
<i>Sat, 29 Apr 2000 17:03:31 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#976">[ date ]</a><a href="index.html#976">[ thread ]</a><a href="subject.html#976">[ subject ]</a><a href="author.html#976">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0977.html">Tom Goodman: "BUG IN 2.3.99-pre6"</a>
<li> <b>Previous message:</b> <a href="0975.html">Alan Cox: "Re: "movb" for spin-unlock"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus!<br>
<p>
   This is a PCI patch for 2.3.99pre7-pre1. I haven't looked at the power management<br>
stuff yet (hopefully I'll do so tomorrow), but there is a small bunch of useful fixes:<br>
<p>
	o  /proc/pci now works even if read in small chunks.<br>
	o  On ALI IRQ routers, we are also able to read current routing.<br>
	o  Don't crash when the BIOS reports a non-existent IRQ router.<br>
	o  Split IRQ fixup to pcibios_irq_init and pcibios_fixup_irqs. The former<br>
	   needs to be called before peer bridge detection, the latter afterwards.<br>
	o  request_region() PCI configuration ports.<br>
	o  On SI5597/5598 chipsets, don't allow latency higher than 32<br>
	   (reported by Alan to lock up the system).<br>
<p>
								Martin<br>
<p>
--- include/linux/pci_ids.h.mj	Sat Apr 29 15:00:36 2000<br>
+++ include/linux/pci_ids.h	Sat Apr 29 15:00:36 2000<br>
@@ -332,6 +332,7 @@<br>
 #define PCI_DEVICE_ID_SI_5571		0x5571<br>
 #define PCI_DEVICE_ID_SI_5591		0x5591<br>
 #define PCI_DEVICE_ID_SI_5597		0x5597<br>
+#define PCI_DEVICE_ID_SI_5598		0x5598<br>
 #define PCI_DEVICE_ID_SI_5600		0x5600<br>
 #define PCI_DEVICE_ID_SI_6306		0x6306<br>
 #define PCI_DEVICE_ID_SI_6326		0x6326<br>
--- drivers/pci/proc.c.mj	Sat Apr 29 14:48:42 2000<br>
+++ drivers/pci/proc.c	Sat Apr 29 14:48:42 2000<br>
@@ -389,7 +389,7 @@<br>
 <br>
 	*eof = 1;<br>
 	pci_for_each_dev(dev) {<br>
-		nprinted = sprint_dev_config(dev, buf + len, count - len);<br>
+		nprinted = sprint_dev_config(dev, buf + len, PAGE_SIZE - len);<br>
 		if (nprinted &lt; 0) {<br>
 			*eof = 0;<br>
 			break;<br>
--- arch/i386/kernel/pci-irq.c.mj	Fri Apr 28 01:05:42 2000<br>
+++ arch/i386/kernel/pci-irq.c	Sat Apr 29 15:09:02 2000<br>
@@ -125,11 +125,22 @@<br>
 	}<br>
 }<br>
 <br>
+static int pirq_ali_get(struct pci_dev *router, struct pci_dev *dev, int pirq)<br>
+{<br>
+	static unsigned char irqmap[16] = { 0, 9, 3, 10, 4, 5, 7, 6, 1, 11, 0, 12, 0, 14, 0, 15 };<br>
+	pirq--;<br>
+	if (pirq &lt; 8) {<br>
+		u8 x;<br>
+		unsigned reg = 0x48 + (pirq &gt;&gt; 1);<br>
+		pci_read_config_byte(router, reg, &amp;x);<br>
+		return irqmap[(pirq &amp; 1) ? (x &gt;&gt; 4) : (x &amp; 0x0f)];<br>
+	}<br>
+	return 0;<br>
+}<br>
+<br>
 static int pirq_ali_set(struct pci_dev *router, struct pci_dev *dev, int pirq, int irq)<br>
 {<br>
-	static unsigned char irqmap[16] = {<br>
-		0, 8, 0, 2, 4, 5, 7, 6, 0, 1, 3, 9, 11, 0, 13, 15<br>
-	};<br>
+	static unsigned char irqmap[16] = { 0, 8, 0, 2, 4, 5, 7, 6, 0, 1, 3, 9, 11, 0, 13, 15 };<br>
 	unsigned int val = irqmap[irq];<br>
 	pirq--;<br>
 	if (val &amp;&amp; pirq &lt; 8) {<br>
@@ -211,7 +222,7 @@<br>
 	{ "PIIX", PCI_VENDOR_ID_INTEL, PCI_DEVICE_ID_INTEL_82371FB_0, pirq_piix_get, pirq_piix_set },<br>
 	{ "PIIX", PCI_VENDOR_ID_INTEL, PCI_DEVICE_ID_INTEL_82371SB_0, pirq_piix_get, pirq_piix_set },<br>
 	{ "PIIX", PCI_VENDOR_ID_INTEL, PCI_DEVICE_ID_INTEL_82371AB_0, pirq_piix_get, pirq_piix_set },<br>
-	{ "ALI", PCI_VENDOR_ID_AL, PCI_DEVICE_ID_AL_M1533, NULL, pirq_ali_set },<br>
+	{ "ALI", PCI_VENDOR_ID_AL, PCI_DEVICE_ID_AL_M1533, pirq_ali_get, pirq_ali_set },<br>
 	{ "VIA", PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_82C586_0, pirq_via_get, pirq_via_set },<br>
 	{ "VIA", PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_82C596, pirq_via_get, pirq_via_set },<br>
 	{ "VIA", PCI_VENDOR_ID_VIA, PCI_DEVICE_ID_VIA_82C686, pirq_via_get, pirq_via_set },<br>
@@ -236,7 +247,9 @@<br>
 	}<br>
 #endif<br>
 	if (!(pirq_router_dev = pci_find_slot(rt-&gt;rtr_bus, rt-&gt;rtr_devfn))) {<br>
-		DBG("PCI: Interrupt router not found\n");<br>
+		DBG("PCI: Interrupt router not found at %02x:%02x\n", rt-&gt;rtr_bus, rt-&gt;rtr_devfn);<br>
+		/* fall back to default router */<br>
+		pirq_router = pirq_routers + sizeof(pirq_routers) / sizeof(pirq_routers[0]) - 1;<br>
 		return;<br>
 	}<br>
 	if (rt-&gt;rtr_vendor) {<br>
@@ -354,12 +367,9 @@<br>
 	return 1;<br>
 }<br>
 <br>
-void __init pcibios_fixup_irqs(void)<br>
+void __init pcibios_irq_init(void)<br>
 {<br>
-	struct pci_dev *dev;<br>
-	u8 pin;<br>
-<br>
-	DBG("PCI: IRQ fixup\n");<br>
+	DBG("PCI: IRQ init\n");<br>
 	pirq_table = pirq_find_routing_table();<br>
 #ifdef CONFIG_PCI_BIOS<br>
 	if (!pirq_table &amp;&amp; (pci_probe &amp; PCI_BIOS_IRQ_SCAN))<br>
@@ -369,7 +379,14 @@<br>
 		pirq_peer_trick();<br>
 		pirq_find_router();<br>
 	}<br>
+}<br>
+<br>
+void __init pcibios_fixup_irqs(void)<br>
+{<br>
+	struct pci_dev *dev;<br>
+	u8 pin;<br>
 <br>
+	DBG("PCI: IRQ fixup\n");<br>
 	pci_for_each_dev(dev) {<br>
 		/*<br>
 		 * If the BIOS has set an out of range IRQ number, just ignore it.<br>
--- arch/i386/kernel/pci-pc.c.mj	Sat Apr 29 14:52:43 2000<br>
+++ arch/i386/kernel/pci-pc.c	Sat Apr 29 15:02:56 2000<br>
@@ -10,6 +10,7 @@<br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/pci.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
+#include &lt;linux/ioport.h&gt;<br>
 <br>
 #include &lt;asm/segment.h&gt;<br>
 #include &lt;asm/io.h&gt;<br>
@@ -208,6 +209,7 @@<br>
 			outl (tmp, 0xCF8);<br>
 			__restore_flags(flags);<br>
 			printk("PCI: Using configuration type 1\n");<br>
+			request_region(0xCF8, 8, "PCI conf1");<br>
 			return &amp;pci_direct_conf1;<br>
 		}<br>
 		outl (tmp, 0xCF8);<br>
@@ -224,6 +226,7 @@<br>
 		    pci_sanity_check(&amp;pci_direct_conf2)) {<br>
 			__restore_flags(flags);<br>
 			printk("PCI: Using configuration type 2\n");<br>
+			request_region(0xCF8, 4, "PCI conf2");<br>
 			return &amp;pci_direct_conf2;<br>
 		}<br>
 	}<br>
@@ -912,6 +915,16 @@<br>
 		d-&gt;resource[i].start = d-&gt;resource[i].end = d-&gt;resource[i].flags = 0;<br>
 }<br>
 <br>
+static void __init pci_fixup_latency(struct pci_dev *d)<br>
+{<br>
+	/*<br>
+	 *  SiS 5597 and 5598 chipsets require latency timer set to<br>
+	 *  at most 32 to avoid lockups.<br>
+	 */<br>
+	DBG("PCI: Setting max latency to 32\n");<br>
+	pcibios_max_latency = 32;<br>
+}<br>
+<br>
 struct pci_fixup pcibios_fixups[] = {<br>
 	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_INTEL_82451NX,	pci_fixup_i450nx },<br>
 	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_INTEL,	PCI_DEVICE_ID_INTEL_82454GX,	pci_fixup_i450gx },<br>
@@ -921,6 +934,8 @@<br>
 	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_UMC,	PCI_DEVICE_ID_UMC_UM8886BF,	pci_fixup_umc_ide },<br>
 	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_SI,	PCI_DEVICE_ID_SI_5513,		pci_fixup_ide_trash },<br>
 	{ PCI_FIXUP_HEADER,	PCI_ANY_ID,		PCI_ANY_ID,			pci_fixup_ide_bases },<br>
+	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_SI,	PCI_DEVICE_ID_SI_5597,		pci_fixup_latency },<br>
+	{ PCI_FIXUP_HEADER,	PCI_VENDOR_ID_SI,	PCI_DEVICE_ID_SI_5598,		pci_fixup_latency },<br>
 	{ 0 }<br>
 };<br>
 <br>
@@ -969,8 +984,9 @@<br>
 	printk("PCI: Probing PCI hardware\n");<br>
 	pci_root_bus = pci_scan_bus(0, pci_root_ops, NULL);<br>
 <br>
-	pcibios_fixup_irqs();<br>
+	pcibios_irq_init();<br>
 	pcibios_fixup_peer_bridges();<br>
+	pcibios_fixup_irqs();<br>
 	pcibios_resource_survey();<br>
 <br>
 #ifdef CONFIG_PCI_BIOS<br>
--- arch/i386/kernel/pci-i386.h.mj	Sat Apr 29 14:53:42 2000<br>
+++ arch/i386/kernel/pci-i386.h	Sat Apr 29 15:03:14 2000<br>
@@ -25,6 +25,8 @@<br>
 <br>
 /* pci-i386.c */<br>
 <br>
+extern unsigned int pcibios_max_latency;<br>
+<br>
 void pcibios_resource_survey(void);<br>
 int pcibios_enable_resources(struct pci_dev *);<br>
 <br>
@@ -64,5 +66,6 @@<br>
 <br>
 extern unsigned int pcibios_irq_mask;<br>
 <br>
+void pcibios_irq_init(void);<br>
 void pcibios_fixup_irqs(void);<br>
 int pcibios_lookup_irq(struct pci_dev *dev, int assign);<br>
--- arch/i386/kernel/pci-i386.c.mj	Sat Apr 29 14:57:06 2000<br>
+++ arch/i386/kernel/pci-i386.c	Sat Apr 29 14:57:06 2000<br>
@@ -330,12 +330,18 @@<br>
  *  If we set up a device for bus mastering, we need to check the latency<br>
  *  timer as certain crappy BIOSes forget to set it properly.<br>
  */<br>
+unsigned int pcibios_max_latency = 255;<br>
+<br>
 void pcibios_set_master(struct pci_dev *dev)<br>
 {<br>
 	u8 lat;<br>
 	pci_read_config_byte(dev, PCI_LATENCY_TIMER, &amp;lat);<br>
-	if (lat &lt; 16) {<br>
-		printk("PCI: Increasing latency timer of device %s to 64\n", dev-&gt;slot_name);<br>
-		pci_write_config_byte(dev, PCI_LATENCY_TIMER, 64);<br>
-	}<br>
+	if (lat &lt; 16)<br>
+		lat = (64 &lt;= pcibios_max_latency) ? 64 : pcibios_max_latency;<br>
+	else if (lat &gt; pcibios_max_latency)<br>
+		lat = pcibios_max_latency;<br>
+	else<br>
+		return;<br>
+	printk("PCI: Setting latency timer of device %s to %d\n", dev-&gt;slot_name, lat);<br>
+	pci_write_config_byte(dev, PCI_LATENCY_TIMER, lat);<br>
 }<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0977.html">Tom Goodman: "BUG IN 2.3.99-pre6"</a>
<li> <b>Previous message:</b> <a href="0975.html">Alan Cox: "Re: "movb" for spin-unlock"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
