<!-- received="Sat Apr 29 09:32:26 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 23:22:19 -0700" -->
<!-- name="David S. Miller" -->
<!-- email="davem@redhat.com" -->
<!-- subject="[PATCH] Swap cache leak..." -->
<!-- id="200004290622.XAA12485@pizda.ninka.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] Swap cache leak...</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Swap cache leak...</h1>
<b>David S. Miller</b> (<a href="mailto:davem@redhat.com"><i>davem@redhat.com</i></a>)<br>
<i>Fri, 28 Apr 2000 23:22:19 -0700</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#941">[ date ]</a><a href="index.html#941">[ thread ]</a><a href="subject.html#941">[ subject ]</a><a href="author.html#941">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0942.html">chris_good@webtop.com: "IBM boxes [was Re: HIGH MEMORY access]"</a>
<li> <b>Previous message:</b> <a href="0940.html">Jeff V. Merkey: "Re: quake3 slowdown in 2.2.15pre19 and 2.2.16pre1"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1001.html">Shane Shrybman: "Re: [PATCH] Swap cache leak..."</a>
<li> <b>Reply:</b> <a href="1001.html">Shane Shrybman: "Re: [PATCH] Swap cache leak..."</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Can people test out this patch?  Especially people who see<br>
the kernel go deeply into swap and never come fully out of it.<br>
<p>
The problem is that there is a piece of code during swapin<br>
readahead which backs out of the rest of the read-ahead operation if<br>
it will hit the async paging limit and block.  In this case it loops<br>
releasing the swapcache entires it grabbed to do the I/O, but due to<br>
a off-by-one error it forgets to free up one of those entries.<br>
<p>
Here is the fix.  One good way to test this, and see the bad behavior,<br>
is to run something which purposely exercises swapping, and after the<br>
test runs, try to turn off all of your swap partitions.  When the bug<br>
is present, the swapoff syscall will fail (with -ENOMEM) due to this<br>
leak.<br>
<p>
Thanks, the patch is against 2.3.99-pre6.<br>
<p>
--- mm/memory.c.~1~	Mon Apr 24 19:16:59 2000<br>
+++ mm/memory.c	Fri Apr 28 20:49:40 2000<br>
@@ -1016,8 +1016,11 @@<br>
 	for (i = 0; i &lt; num; offset++, i++) {<br>
 		/* Don't block on I/O for read-ahead */<br>
 		if (atomic_read(&amp;nr_async_pages) &gt;= pager_daemon.swap_cluster) {<br>
-			while (i++ &lt; num)<br>
-				swap_free(SWP_ENTRY(SWP_TYPE(entry), offset++));<br>
+			while (i &lt; num) {<br>
+				swap_free(SWP_ENTRY(SWP_TYPE(entry), offset));<br>
+				offset++;<br>
+				i++;<br>
+			}<br>
 			break;<br>
 		}<br>
 		/* Ok, do the async read-ahead now */<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0942.html">chris_good@webtop.com: "IBM boxes [was Re: HIGH MEMORY access]"</a>
<li> <b>Previous message:</b> <a href="0940.html">Jeff V. Merkey: "Re: quake3 slowdown in 2.2.15pre19 and 2.2.16pre1"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1001.html">Shane Shrybman: "Re: [PATCH] Swap cache leak..."</a>
<li> <b>Reply:</b> <a href="1001.html">Shane Shrybman: "Re: [PATCH] Swap cache leak..."</a>
<!-- reply="end" -->
</ul>
</font></body>
