<!-- received="Sat Apr 29 02:42:48 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 20:21:04 -0300 (BRST)" -->
<!-- name="Rik van Riel" -->
<!-- email="riel@conectiva.com.br" -->
<!-- subject="[PATCH] 2.3.99-pre6 vm fix" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] 2.3.99-pre6 vm fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.99-pre6 vm fix</h1>
<b>Rik van Riel</b> (<a href="mailto:riel@conectiva.com.br"><i>riel@conectiva.com.br</i></a>)<br>
<i>Fri, 28 Apr 2000 20:21:04 -0300 (BRST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#922">[ date ]</a><a href="index.html#922">[ thread ]</a><a href="subject.html#922">[ subject ]</a><a href="author.html#922">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0923.html">Ivan Passos: "Re: Compiling multiplatform code"</a>
<li> <b>Previous message:</b> <a href="0921.html">Alexander Viro: "Re: [RFC] automount based devfs replacement"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0948.html">Roel van der Goot: "Re: [PATCH] 2.3.99-pre6 vm fix"</a>
<li> <b>Reply:</b> <a href="0948.html">Roel van der Goot: "Re: [PATCH] 2.3.99-pre6 vm fix"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
here's a patch against 2.3.99-pre6 that fixes the stability problem<br>
(apparently it was possible for a process to "slip through" the<br>
tests in swap_out() and end up with a swap_cnt of 0 which would mean<br>
an infinite loop in the leftshifting loop).<br>
<p>
It also fixes a correctness issue in kswapd. Kswapd would exit<br>
after one call to do_try_to_free_pages(), even if there was still<br>
a lot of work to do. Now kswapd will play again if there are still<br>
a lot of pages to free.<br>
<p>
The performance problem isn't 100% fixed yet, but the other two<br>
things are important enough that I thought I'd send the patch<br>
now instead of after the (extra long) weekend.<br>
<p>
regards,<br>
<p>
Rik<br>
<pre>
--
The Internet is not a network of computers. It is a network
of people. That is its real strength.
<p>
Wanna talk about the kernel?  irc.openprojects.net / #kernelnewbies
<a href="http://www.conectiva.com/">http://www.conectiva.com/</a>		http://www.surriel.com/
<p>
<p>
<p>
--- linux-2.3.99-pre6/mm/filemap.c.orig	Thu Apr 27 12:49:05 2000
+++ linux-2.3.99-pre6/mm/filemap.c	Fri Apr 28 19:49:01 2000
@@ -238,14 +238,13 @@
 
 int shrink_mmap(int priority, int gfp_mask, zone_t *zone)
 {
-	int ret = 0, loop = 0, count;
+	int ret = 0, count;
 	LIST_HEAD(young);
 	LIST_HEAD(old);
 	LIST_HEAD(forget);
 	struct list_head * page_lru, * dispose;
 	struct page * page = NULL;
 	struct zone_struct * p_zone;
-	int maxloop = 256 &gt;&gt; priority;
 	
 	if (!zone)
 		BUG();
@@ -262,30 +261,26 @@
 		list_del(page_lru);
 		p_zone = page-&gt;zone;
 
-		/*
-		 * These two tests are there to make sure we don't free too
-		 * many pages from the "wrong" zone. We free some anyway,
-		 * they are the least recently used pages in the system.
-		 * When we don't free them, leave them in &amp;old.
-		 */
-		dispose = &amp;old;
-		if (p_zone != zone &amp;&amp; (loop &gt; (maxloop / 4) ||
-				p_zone-&gt;free_pages &gt; p_zone-&gt;pages_high))
-			goto dispose_continue;
+		/* This LRU list only contains a few pages from the system,
+		 * so we must fail and let swap_out() refill the list if
+		 * there aren't enough freeable pages on the list */
 
 		/* The page is in use, or was used very recently, put it in
 		 * &amp;young to make sure that we won't try to free it the next
 		 * time */
 		dispose = &amp;young;
-
 		if (test_and_clear_bit(PG_referenced, &amp;page-&gt;flags))
 			goto dispose_continue;
 
-		count--;
+		if (p_zone-&gt;free_pages &gt; p_zone-&gt;pages_high)
+			goto dispose_continue;
+
 		if (!page-&gt;buffers &amp;&amp; page_count(page) &gt; 1)
 			goto dispose_continue;
 
-		/* Page not used -&gt; free it; if that fails -&gt; &amp;old */
+		count--;
+		/* Page not used -&gt; free it or put it on the old list
+		 * so it gets freed first the next time */
 		dispose = &amp;old;
 		if (TryLockPage(page))
 			goto dispose_continue;
@@ -375,9 +370,8 @@
 	/* nr_lru_pages needs the spinlock */
 	nr_lru_pages--;
 
-	loop++;
 	/* wrong zone?  not looped too often?    roll again... */
-	if (page-&gt;zone != zone &amp;&amp; loop &lt; maxloop)
+	if (page-&gt;zone != zone &amp;&amp; count)
 		goto again;
 
 out:
--- linux-2.3.99-pre6/mm/page_alloc.c.orig	Thu Apr 27 12:57:20 2000
+++ linux-2.3.99-pre6/mm/page_alloc.c	Fri Apr 28 12:29:08 2000
@@ -285,9 +285,11 @@
 		goto allocate_ok;
 
 	/* If we're a memory hog, unmap some pages */
-	if (current-&gt;hog &amp;&amp; low_on_memory &amp;&amp;
-			(gfp_mask &amp; __GFP_WAIT))
-		swap_out(4, gfp_mask);
+	if (current-&gt;hog &amp;&amp; low_on_memory &amp;&amp; (gfp_mask &amp; __GFP_WAIT)) {
+	//	swap_out(6, gfp_mask);
+	//	shm_swap(6, gfp_mask, (zone_t *)(zone));
+		try_to_free_pages(gfp_mask, (zone_t *)(zone));
+	}
 
 	/*
 	 * (If anyone calls gfp from interrupts nonatomically then it
--- linux-2.3.99-pre6/mm/vmscan.c.orig	Thu Apr 27 12:57:58 2000
+++ linux-2.3.99-pre6/mm/vmscan.c	Fri Apr 28 19:43:37 2000
@@ -387,8 +387,8 @@
 				if (!p-&gt;swappable || !mm || mm-&gt;rss &lt;= 0)
 					continue;
 				/* small processes are swapped out less */
-				while ((mm-&gt;swap_cnt &lt;&lt; 2 * (i + 1) &lt; max_cnt))
-					i++;
+				while ((mm-&gt;swap_cnt &lt;&lt; 2 * (i + 1) &lt; max_cnt)
+						&amp;&amp; i++ &lt; 10)
 				mm-&gt;swap_cnt &gt;&gt;= i;
 				mm-&gt;swap_cnt += i; /* if swap_cnt reaches 0 */
 				/* we're big -&gt; hog treatment */
@@ -437,14 +437,13 @@
 {
 	int priority;
 	int count = SWAP_CLUSTER_MAX;
-	int ret;
 
 	/* Always trim SLAB caches when memory gets low. */
 	kmem_cache_reap(gfp_mask);
 
 	priority = 6;
 	do {
-		while ((ret = shrink_mmap(priority, gfp_mask, zone))) {
+		while (shrink_mmap(priority, gfp_mask, zone)) {
 			if (!--count)
 				goto done;
 		}
@@ -467,9 +466,7 @@
 			}
 		}
 
-		/* Then, try to page stuff out..
-		 * We use swapcount here because this doesn't actually
-		 * free pages */
+		/* Then, try to page stuff out.. */
 		while (swap_out(priority, gfp_mask)) {
 			if (!--count)
 				goto done;
@@ -530,12 +527,16 @@
 		pgdat = pgdat_list;
 		while (pgdat) {
 			for (i = 0; i &lt; MAX_NR_ZONES; i++) {
-				zone = pgdat-&gt;node_zones + i;
+			    int count = SWAP_CLUSTER_MAX;
+			    zone = pgdat-&gt;node_zones + i;
+			    do {
 				if (tsk-&gt;need_resched)
 					schedule();
 				if ((!zone-&gt;size) || (!zone-&gt;zone_wake_kswapd))
 					continue;
 				do_try_to_free_pages(GFP_KSWAPD, zone);
+			   } while (zone-&gt;free_pages &lt; zone-&gt;pages_low &amp;&amp;
+					   --count);
 			}
 			pgdat = pgdat-&gt;node_next;
 		}
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0923.html">Ivan Passos: "Re: Compiling multiplatform code"</a>
<li> <b>Previous message:</b> <a href="0921.html">Alexander Viro: "Re: [RFC] automount based devfs replacement"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0948.html">Roel van der Goot: "Re: [PATCH] 2.3.99-pre6 vm fix"</a>
<li> <b>Reply:</b> <a href="0948.html">Roel van der Goot: "Re: [PATCH] 2.3.99-pre6 vm fix"</a>
<!-- reply="end" -->
</ul>
</font></body>
