<!-- received="Fri Apr 28 17:02:01 2000 EET DST" -->
<!-- sent="Fri, 28 Apr 2000 15:51:26 +0200" -->
<!-- name="Andreas Schuldei" -->
<!-- email="schuldei@andrive.de" -->
<!-- subject="hanging socket when smbfs (and others?) loaded on stable kernel" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: hanging socket when smbfs (and others?) loaded on stable kernel</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>hanging socket when smbfs (and others?) loaded on stable kernel</h1>
<b>Andreas Schuldei</b> (<a href="mailto:schuldei@andrive.de"><i>schuldei@andrive.de</i></a>)<br>
<i>Fri, 28 Apr 2000 15:51:26 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#830">[ date ]</a><a href="index.html#830">[ thread ]</a><a href="subject.html#830">[ subject ]</a><a href="author.html#830">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0831.html">Christian Klippel: "oops-report"</a>
<li> <b>Previous message:</b> <a href="0829.html">Linux Kernel: "Re: BUG: 2.2.15pre19 with screen"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--nFreZHaLTZJo0R7j<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
please find enclosed the test-programs which produce the error on stock<br>
linux 2.2.14 and earlier.<br>
<p>
client and server work like a charm when smbfs is not loaded.<br>
<p>
Whenever I load smbfs (when I mount a samba-share) after some random<br>
(but long) time my testprogram hangs.<br>
<p>
it looks like the server waits for some more data from client. But I can<br>
not explain why: the transmitted data is by far less then the mtu. It<br>
does not matter if I go over lo or eth or if I use TCP_NODELAY or not.<br>
<p>
Please give it a spin and tell me what is wrong!<br>
<p>
<p>
--nFreZHaLTZJo0R7j<br>
Content-Type: text/x-csrc<br>
Content-Disposition: attachment; filename="testing.c"<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;pthread.h&gt;<br>
#include &lt;signal.h&gt;<br>
#include &lt;sys/types.h&gt; <br>
#include &lt;netinet/in.h&gt; <br>
#include &lt;sys/socket.h&gt; <br>
#include &lt;errno.h&gt;<br>
<p>
#define MAX_THREADS     10<br>
#define GOODBYE         0<br>
<p>
#ifndef TCP_NODELAY<br>
  #define TCP_NODELAY 1<br>
#endif<br>
<p>
<p>
typedef struct s_theadInfo   //for thread<br>
{<br>
  pthread_t      *threads;<br>
  int            idx;<br>
  int            sockfd;<br>
} threadInfo;<br>
<p>
/* prototypes */<br>
void * serve(void *arg);              // Thread-Funktion<br>
void sig_break(int signo);            // Signal-Handler<br>
<p>
/* globals */<br>
int      nThreads;<br>
char     dbgstatus[MAX_THREADS];<br>
int      sockfd;<br>
int      DM_ANZ;<br>
<p>
<p>
/* MAIN */<br>
int main( int argc, char *argv[] )<br>
{<br>
struct sockaddr_in server;<br>
struct sockaddr_in their_addr;<br>
int                sin_size;<br>
int                length;<br>
int                msgsock;<br>
int                rval;<br>
pthread_t          threadid;<br>
pthread_t          threads[MAX_THREADS];<br>
threadInfo        *ti;<br>
int                idx;<br>
int                sockoption;<br>
<p>
    if ( argc &lt; 2 ) {<br>
        printf("Aufruf -&gt;  dmserver Port\n");<br>
        exit (-1);<br>
    } <br>
#ifdef TEST_FEHLER<br>
	printf("Serverversion mit Fehler \n");<br>
#else<br>
	printf("Serverversion ohne Fehler \n");<br>
#endif<br>
    dbgstatus[MAX_THREADS] = 0;<br>
<p>
    nThreads = 0;<br>
    bzero(threads, sizeof(threads));<br>
    sockfd = socket(AF_INET, SOCK_STREAM, 0);<br>
    if (sockfd &lt; 0) {<br>
        printf("Unable to open stream socket\n");<br>
        exit(-1);<br>
    }     <br>
<p>
    /* CTRL-C Handler einhaengen */<br>
    signal(SIGINT, sig_break);<br>
    // signal(SIGPIPE, sig_pipe);<br>
<p>
    // Name socket using wildcards<br>
    server.sin_family      = AF_INET;         // TCP/IP<br>
    server.sin_addr.s_addr = INADDR_ANY;<br>
    server.sin_port        = htons(atoi(argv[1]));<br>
<p>
<p>
    sockoption = 1;<br>
    if (setsockopt (sockfd, IPPROTO_TCP, TCP_NODELAY, (char *) &amp;sockoption, sizeof(sockoption)) != 0) {<br>
        printf("Failed to set socket option TCP_NODELAY\n");<br>
        exit (1);<br>
    }    <br>
<p>
    // Dem Socket wird eine Port-Nummer zugewiesen<br>
    if (bind(sockfd, (struct sockaddr *)&amp;server, sizeof(server))) {<br>
        printf("Unable to bind stream socket\n");<br>
        exit(-1);<br>
    } <br>
    // name<br>
    length = sizeof(server);<br>
    if (getsockname(sockfd, (struct sockaddr *)&amp;server, &amp;length)) {<br>
        printf("Unable to get socket name\n");<br>
        exit(-1);<br>
    }<br>
<p>
    printf("Socket has port #%d\n", ntohs(server.sin_port));<br>
<p>
    // Start accepting connections<br>
    listen(sockfd, 1);<br>
<p>
    for (;;) {<br>
        sin_size = sizeof(struct sockaddr_in);<br>
        msgsock = accept(sockfd, (struct sockaddr *)&amp;their_addr, &amp;sin_size );<br>
<p>
        /* anyone connected */<br>
        if (msgsock &lt; 0)<br>
            printf("Unable to accept message\n");<br>
        else {<br>
            printf("server: connection from %s\n", inet_ntoa(their_addr.sin_addr));<br>
            if (nThreads &gt;= MAX_THREADS) {<br>
                printf("MaxThreads reached\n"); continue;<br>
            }   <br>
<p>
            // Durch ti werden dem Thread alle Infos uebergeben<br>
            ti = (threadInfo *)malloc(sizeof(threadInfo));<br>
            if (!ti) {<br>
                printf ("Memory\n");<br>
                exit(-1);<br>
            } <br>
<p>
            // Freie Stelle in der Tabelle suchen:<br>
            idx = 0;<br>
            while (threads[idx] &amp;&amp; idx &lt; MAX_THREADS)<br>
                ++idx;<br>
<p>
            // Folgendes braucht unser Thread:<br>
            ti-&gt;threads = threads;           // Tabelle mit allen Thread-IDs<br>
            ti-&gt;idx     = idx;               // Seine stelle in dieser Tabelle<br>
            ti-&gt;sockfd  = msgsock;           // Socket-Handle fuer seine Connection<br>
<p>
            if (pthread_create(&amp;threadid, NULL, &amp;serve, (void *)ti)) {<br>
                free(ti);<br>
                printf("Thread could not be started\n");<br>
                continue;<br>
            }<br>
<p>
            threads[idx] = threadid;         // Thread-ID in die Tabelle einfuegen<br>
            ++nThreads;<br>
        } /* end else Connected */<br>
    } /* end for ever */<br>
} <br>
<p>
/* Thread for serving clients */<br>
void * serve(void *arg)          // wird pro Connection aufgerufen<br>
{<br>
int          rval = 0;               // Return-Wert<br>
char         buf[128];<br>
char         sbuf[128];<br>
char        *sbufzgr = sbuf;<br>
threadInfo  *ti = (threadInfo *)arg; // Zeiger auf ThreadInfo von main-Thread<br>
int         len, nbytes, len2read;   // Diverse Zaehler<br>
int         templen;<br>
<p>
    pthread_detach(pthread_self());    // Thread wird mit der Funktion beendet<br>
<p>
    dbgstatus[ti-&gt;idx] = '0';<br>
    while (1) {<br>
        int     nleft,nread;<br>
        char    *ptr ;<br>
        dbgstatus[ti-&gt;idx] = '1';<br>
        /* 1.  command recv <br>
             a)length of command at first<br>
             b)command<br>
           2.  send answer<br>
             a)lenght of answer<br>
             b)answer<br>
        */<br>
        /* receive the command */<br>
        /* 1a receive length */<br>
<p>
#ifdef TEST_FEHLER<br>
        nbytes = spbsRecvn(ti-&gt;sockfd, (char *)&amp;len, sizeof(int));<br>
        dbgstatus[ti-&gt;idx] = '-';<br>
        if ( nbytes &lt; 0 ) {<br>
            printf("Laenge fehlerhaft empfangen\n");<br>
            exit(1);<br>
        }<br>
        if (nbytes != sizeof(int)) {<br>
            printf("Laenge nicht vollstaendig empfangen\n");<br>
            exit(1);<br>
        }<br>
        dbgstatus[ti-&gt;idx] = '2';<br>
        // Daten = len Bytes aus dem Stream einlesen<br>
        nbytes = spbsRecvn(ti-&gt;sockfd, buf, len);<br>
        dbgstatus[ti-&gt;idx] = '+';<br>
        if ( nbytes &lt; 0 ) {<br>
            printf("Daten fehlerhaft empfangen\n");<br>
            break;<br>
        }<br>
        if ( nbytes != len ) {<br>
            printf("Daten nicht vollstaendig empfangen\n");<br>
            break;<br>
        }<br>
<p>
#else<br>
        nleft = sizeof(int);<br>
        ptr = (char *) &amp;len;<br>
        while (nleft &gt; 0) {<br>
            if ( (nread = recv(ti-&gt;sockfd, ptr, nleft, 0)) &lt; 0) {<br>
                printf("ERROR recv\n"); exit (2);<br>
            } /* end if return &lt; 0 */<br>
            else if (nread == 0)<br>
                break;<br>
            nleft -= nread;<br>
            ptr   += nread;<br>
        } /* end while length to receive */<br>
<p>
        dbgstatus[ti-&gt;idx] = '-';<br>
        if ( nleft ) {<br>
            printf("Laenge fehlerhaft empfangen\n");<br>
            break;<br>
        }<br>
        if (len &lt; 0 || len &gt; 128 ) {<br>
            printf("Laenge ist falsch\n");<br>
            break;<br>
        }<br>
        dbgstatus[ti-&gt;idx] = '2';<br>
        // read data as in Length defined <br>
        nleft = len;<br>
        ptr = buf;<br>
        while (nleft &gt; 0) {<br>
            if ( (nread = recv(ti-&gt;sockfd, ptr, nleft, 0)) &lt; 0) {<br>
                printf("ERROR recv\n"); exit (2);<br>
            } /* end if return &lt; 0 */<br>
            else if (nread == 0)<br>
                break;<br>
            nleft -= nread;<br>
            ptr   += nread;<br>
        } /* end while length to receive */<br>
        dbgstatus[ti-&gt;idx] = '+';<br>
        if ( nleft ) {<br>
            printf("Daten fehlerhaft empfangen\n");<br>
            break;<br>
        }<br>
#endif<br>
<p>
<p>
/*<br>
   all received<br>
   if work .. do here and build the answer<br>
*/<br>
<p>
        dbgstatus[ti-&gt;idx] = '3';<br>
        strcpy(buf,"OK");<br>
        len = strlen(buf); /* for OK */<br>
        rval = send(ti-&gt;sockfd, (char *)&amp;len, sizeof(int), 0);<br>
        if (rval &lt; 0 || rval != 4) {<br>
            printf("send Antwortlaenge fehlerhaft\n");<br>
            break;<br>
        }     <br>
        rval = send(ti-&gt;sockfd, buf, len, 0);<br>
        if (rval &lt; 0 || rval != len) {<br>
            printf("send Antwort fehlerhaft\n");<br>
            break;<br>
        }     <br>
        dbgstatus[ti-&gt;idx] = '4';<br>
        printf("%d-&gt;%s\r", DM_ANZ++,dbgstatus); fflush(stdout);<br>
    } /* end while */<br>
    <br>
    // Aufraeumen:<br>
    printf("\nEnde Thread-&gt; %d\n", ti-&gt;idx);<br>
    close(ti-&gt;sockfd);<br>
    dbgstatus[ti-&gt;idx] = 'E';<br>
    ti-&gt;threads[ti-&gt;idx] = GOODBYE;<br>
    --nThreads;<br>
    free(ti);<br>
    return NULL;<br>
} <br>
<p>
<p>
void sig_break(int signo)<br>
{<br>
pid_t pid;<br>
int   stat;<br>
<p>
    close(sockfd);<br>
    printf("*** terminated\n");<br>
    fflush(stdout);<br>
    exit(0);<br>
    return;<br>
}<br>
<p>
#ifdef TEST_FEHLER<br>
/* recv defined number of bytes */<br>
int spbsRecvn(int fd, void *aptr, int nbytes)<br>
{<br>
int           nleft, nread;<br>
char          *ptr = aptr;<br>
<p>
    nleft = nbytes;<br>
    while (nleft &gt; 0) {<br>
        if ( (nread = recv(fd, ptr, nleft, 0)) &lt; 0) {<br>
            printf("ERROR spbsRecvn\n");<br>
            return -1;<br>
        } /* end if return &lt; 0 */<br>
        else if (nread == 0)<br>
            break;<br>
        nleft -= nread;<br>
        ptr   += nread;<br>
    } /* end while all to receive */<br>
<p>
    return (nbytes - nleft);      // return &gt;= 0<br>
} <br>
#endif<br>
--nFreZHaLTZJo0R7j<br>
Content-Type: text/x-csrc<br>
Content-Disposition: attachment; filename="testingc.c"<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;stdlib.h&gt;<br>
#include &lt;string.h&gt;<br>
<p>
#include &lt;signal.h&gt;<br>
#include &lt;netdb.h&gt; <br>
#include &lt;sys/types.h&gt; <br>
#include &lt;netinet/in.h&gt; <br>
#include &lt;sys/socket.h&gt; <br>
#include &lt;errno.h&gt;<br>
<p>
<p>
#define sFALSE                  0<br>
#define sTRUE                   1<br>
<p>
#ifndef TCP_NODELAY<br>
  #define TCP_NODELAY 1<br>
#endif<br>
<p>
volatile int STOP = sFALSE;<br>
<p>
<p>
/***************************************************************************<br>
* signal handler. <br>
* CTRL-C Handler fuer sauberes beenden <br>
***************************************************************************/<br>
void signal_handler_CTRL (int status)<br>
{<br>
    STOP=sTRUE;<br>
    printf("\n\n SIGNAL \n\n");<br>
} /* end funktion signal_handler_CTRL */<br>
<p>
<p>
<p>
<p>
int main(int argc, char *argv[])<br>
{<br>
int                     i=0;<br>
char                    buf[128];<br>
char                    sbuf[] = "123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";<br>
struct sockaddr_in      server;  // Socket-Adresse<br>
struct hostent          *hp;      // Host-Info<br>
int                     sockfd, sockoption;<br>
int						ret;<br>
<p>
<p>
    if ( argc &lt; 3 ) {<br>
        printf("Aufruf -&gt;  dmtest ServerIP Port\n");<br>
        exit (-1);<br>
    }   <br>
    /* CTRL-C Handler einhaengen */<br>
    signal(SIGINT, signal_handler_CTRL);<br>
<p>
    // Socket erzeugen<br>
    sockfd = socket(AF_INET, SOCK_STREAM, 0);<br>
    if  (sockfd &lt; 0) {<br>
        printf ("Unable to open stream socket\n");<br>
        exit(1); <br>
    } <br>
    <br>
    sockoption = 1;<br>
    if (setsockopt (sockfd, IPPROTO_TCP, TCP_NODELAY, (char *) &amp;sockoption, sizeof(sockoption)) != 0) {<br>
        printf("Failed to set socket option TCP_NODELAY\n");<br>
        exit (1);<br>
    }    <br>
<p>
    // Hostnamen aufloesen<br>
    server.sin_family = AF_INET;<br>
    hp = gethostbyname(argv[1]);<br>
    if (hp == 0) {<br>
        printf("%s: unknown host\n", argv[1]);<br>
        exit(1);<br>
    }<br>
<p>
    bcopy(hp-&gt;h_addr_list[0], &amp;server.sin_addr, hp-&gt;h_length);<br>
    server.sin_port = htons(atoi(argv[2]));<br>
<p>
    // Verbindung herstellen:<br>
    if (connect(sockfd, (struct sockaddr *)&amp;server, sizeof(server)) &lt; 0) {<br>
        printf("Unable to connect stream socket\n");<br>
        exit(1);<br>
    } <br>
<p>
    while (STOP==sFALSE) {<br>
        int     len, nleft, nread, rval;<br>
        char    *ptr;<br>
        /* 1.  command send <br>
             a)length of command at first<br>
             b)command<br>
           2.  receive answer<br>
             a)lenght of answer<br>
             b)answer<br>
        */<br>
        /* send the command */<br>
printf("s"); fflush(stdout);<br>
<p>
        /* 1a send length */<br>
        len = strlen(sbuf); <br>
        rval = send(sockfd, (char *)&amp;len, sizeof(int), 0);<br>
        if (rval &lt; 0 || rval != sizeof(int)) {<br>
            printf("send Anfragelaenge fehlerhaft\n");<br>
            break;<br>
        }     <br>
printf("S"); fflush(stdout);<br>
        /* 1b send command */<br>
        rval = send(sockfd, sbuf, len, 0);<br>
        if (rval &lt; 0 || rval != len) {<br>
            printf("send Anfrage fehlerhaft\n");<br>
            break;<br>
        }     <br>
<p>
printf("r"); fflush(stdout);<br>
        /* wait for the OK-answer from Server */<br>
        /* 2a read lenght of answer */<br>
        nleft = sizeof(int);<br>
        ptr = (char *) &amp;len;<br>
        while (nleft &gt; 0) {<br>
            if ( (nread = recv(sockfd, ptr, nleft, 0)) &lt; 0) {<br>
                printf("ERROR recv\n"); exit (2);<br>
            } /* end if return &lt; 0 */<br>
            else if (nread == 0)<br>
                break;<br>
            nleft -= nread;<br>
            ptr   += nread;<br>
        } /* end while length to receive */<br>
        if ( nleft ) {<br>
            printf("Laenge fehlerhaft empfangen\n");<br>
            break;<br>
        }<br>
        if (len &lt; 0 || len &gt; 128 ) {<br>
            printf("Laenge ist falsch\n");<br>
            break;<br>
		}	<br>
printf("R%d",len); fflush(stdout);<br>
        /* 2b read answer */<br>
        nleft = len;<br>
        ptr = (char *) buf;<br>
        while (nleft &gt; 0) {<br>
            if ( (nread = recv(sockfd, ptr, nleft, 0)) &lt; 0) {<br>
                printf("ERROR recv\n"); exit (2);<br>
            } /* end if return &lt; 0 */<br>
            else if (nread == 0)<br>
                break;<br>
            nleft -= nread;<br>
            ptr   += nread;<br>
        } /* end while length to receive */<br>
        if ( nleft ) {<br>
            printf("Laenge fehlerhaft empfangen\n");<br>
            break;<br>
        }<br>
		<br>
		buf[len] = 0;<br>
        printf("-&gt;%d-&gt;%s\n", i++,buf); fflush(stdout);<br>
		<br>
		<br>
    } /* end while */<br>
<p>
    ret = close ( sockfd );<br>
    printf("\nENDE DMTEST\n");<br>
    exit(1);<br>
}<br>
<p>
<p>
--nFreZHaLTZJo0R7j<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename=makefile<br>
<p>
all :		server client dmserver dmtest<br>
test :		testing testingc<br>
<p>
DEBUG_FLAGS = -g<br>
CFLAGS= $(DEBUG_FLAGS) $(MYINCLUDE)<br>
COFLAGS = -c $(CFLAGS)<br>
<p>
server : server.c<br>
	gcc $(CFLAGS) -o server server.c <br>
<p>
client : client.c<br>
	gcc $(CFLAGS) -o client client.c <br>
<p>
<p>
dmserver : dmserver.c <br>
	gcc ${CFLAGS} -o dmserver -lpthread dmserver.c<br>
<p>
dmtest : dmtest.c<br>
	gcc $(CFLAGS) -o dmtest dmtest.c <br>
<p>
testing : testing.c<br>
	gcc $(CFLAGS) -o testing -lpthread testing.c <br>
<p>
testingc : testingc.c<br>
	gcc $(CFLAGS) -o testingc testingc.c <br>
<p>
<p>
clean :<br>
	rm *.o <br>
	rm server<br>
	rm client<br>
	rm testing<br>
	rm testingc<br>
	<br>
<p>
<p>
--nFreZHaLTZJo0R7j--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0831.html">Christian Klippel: "oops-report"</a>
<li> <b>Previous message:</b> <a href="0829.html">Linux Kernel: "Re: BUG: 2.2.15pre19 with screen"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
