<!-- received="Thu Apr 27 18:38:21 2000 EET DST" -->
<!-- sent="27 Apr 2000 17:23:03 +0200" -->
<!-- name="Trond Myklebust" -->
<!-- email="trond.myklebust@fys.uio.no" -->
<!-- subject="Re: Generic API for asynchronous filesystems (w/ Patch)" -->
<!-- id="" -->
<!-- inreplyto="27 Apr 2000 12:06:53 +0200"" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: Generic API for asynchronous filesystems (w/ Patch)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Generic API for asynchronous filesystems (w/ Patch)</h1>
<b>Trond Myklebust</b> (<a href="mailto:trond.myklebust@fys.uio.no"><i>trond.myklebust@fys.uio.no</i></a>)<br>
<i>27 Apr 2000 17:23:03 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#657">[ date ]</a><a href="index.html#657">[ thread ]</a><a href="subject.html#657">[ subject ]</a><a href="author.html#657">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0658.html">Shane Shrybman: "Re: IO scheduling problem in 2.3.99-pre6"</a>
<li> <b>Previous message:</b> <a href="0656.html">Alexander Viro: "Re: [PATCH] C++ breaks on linux/ioport.h"</a>
<li> <b>In reply to:</b> <a href="0618.html">Trond Myklebust: "Generic API for asynchronous filesystems (was Re: 2.3.99-pre6-pre7 sync_page in remove_inode_page)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The following patch for 2.3.99-pre6 exhibits one way in which we could<br>
split up the new task of syncing in readaheads and flushing out<br>
writebacks.<br>
<p>
Comments?<br>
<p>
Cheers,<br>
  Trond<br>
<p>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/adfs/inode.c linux-2.3.99-pre6-devel/fs/adfs/inode.c<br>
--- linux-2.3.99-pre6/fs/adfs/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/adfs/inode.c	Thu Apr 27 15:26:28 2000<br>
@@ -74,6 +74,7 @@<br>
 	readpage:	adfs_readpage,<br>
 	writepage:	adfs_writepage,<br>
 	sync_page:	block_sync_page,<br>
+	flush_page:	block_flushpage,<br>
 	prepare_write:	adfs_prepare_write,<br>
 	commit_write:	generic_commit_write,<br>
 	bmap:		_adfs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/affs/file.c linux-2.3.99-pre6-devel/fs/affs/file.c<br>
--- linux-2.3.99-pre6/fs/affs/file.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/affs/file.c	Thu Apr 27 15:27:04 2000<br>
@@ -359,6 +359,7 @@<br>
 	readpage: affs_readpage,<br>
 	writepage: affs_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: affs_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: _affs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/bfs/file.c linux-2.3.99-pre6-devel/fs/bfs/file.c<br>
--- linux-2.3.99-pre6/fs/bfs/file.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/bfs/file.c	Thu Apr 27 15:27:44 2000<br>
@@ -151,6 +151,7 @@<br>
 	readpage:	bfs_readpage,<br>
 	writepage:	bfs_writepage,<br>
 	sync_page:	block_sync_page,<br>
+	flush_page:	block_flushpage,<br>
 	prepare_write:	bfs_prepare_write,<br>
 	commit_write:	generic_commit_write,<br>
 	bmap:		bfs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/buffer.c linux-2.3.99-pre6-devel/fs/buffer.c<br>
--- linux-2.3.99-pre6/fs/buffer.c	Wed Apr 26 02:28:55 2000<br>
+++ linux-2.3.99-pre6-devel/fs/buffer.c	Thu Apr 27 15:24:41 2000<br>
@@ -1288,7 +1288,7 @@<br>
  * we have truncated the file and are going to free the<br>
  * blocks on-disk..<br>
  */<br>
-int block_flushpage(struct page *page, unsigned long offset)<br>
+int block_flushpage(struct page *page, unsigned int offset)<br>
 {<br>
 	struct buffer_head *head, *bh, *next;<br>
 	unsigned int curr_off = 0;<br>
@@ -2417,7 +2417,8 @@<br>
 <br>
 int block_sync_page(struct page *page)<br>
 {<br>
-	run_task_queue(&amp;tq_disk);<br>
+	if (!Page_Uptodate(page))<br>
+		run_task_queue(&amp;tq_disk);<br>
 	return 0;<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/ext2/inode.c linux-2.3.99-pre6-devel/fs/ext2/inode.c<br>
--- linux-2.3.99-pre6/fs/ext2/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/ext2/inode.c	Thu Apr 27 15:28:26 2000<br>
@@ -640,6 +640,7 @@<br>
 	readpage: ext2_readpage,<br>
 	writepage: ext2_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: ext2_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: ext2_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/fat/inode.c linux-2.3.99-pre6-devel/fs/fat/inode.c<br>
--- linux-2.3.99-pre6/fs/fat/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/fat/inode.c	Thu Apr 27 15:28:43 2000<br>
@@ -750,6 +750,7 @@<br>
 	readpage: fat_readpage,<br>
 	writepage: fat_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: fat_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: _fat_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/hfs/inode.c linux-2.3.99-pre6-devel/fs/hfs/inode.c<br>
--- linux-2.3.99-pre6/fs/hfs/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/hfs/inode.c	Thu Apr 27 15:29:07 2000<br>
@@ -238,6 +238,7 @@<br>
 	readpage: hfs_readpage,<br>
 	writepage: hfs_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: hfs_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: hfs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/hpfs/file.c linux-2.3.99-pre6-devel/fs/hpfs/file.c<br>
--- linux-2.3.99-pre6/fs/hpfs/file.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/hpfs/file.c	Thu Apr 27 15:29:35 2000<br>
@@ -107,6 +107,7 @@<br>
 	readpage: hpfs_readpage,<br>
 	writepage: hpfs_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: hpfs_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: _hpfs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/minix/inode.c linux-2.3.99-pre6-devel/fs/minix/inode.c<br>
--- linux-2.3.99-pre6/fs/minix/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/minix/inode.c	Thu Apr 27 15:30:00 2000<br>
@@ -1026,6 +1026,7 @@<br>
 	readpage: minix_readpage,<br>
 	writepage: minix_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: minix_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: minix_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/nfs/file.c linux-2.3.99-pre6-devel/fs/nfs/file.c<br>
--- linux-2.3.99-pre6/fs/nfs/file.c	Wed Apr 26 02:28:55 2000<br>
+++ linux-2.3.99-pre6-devel/fs/nfs/file.c	Thu Apr 27 16:17:54 2000<br>
@@ -179,28 +179,47 @@<br>
 {<br>
 	struct inode	*inode = (struct inode *)page-&gt;mapping-&gt;host;<br>
 	unsigned long	index = page_index(page);<br>
-	unsigned int	rpages, wpages;<br>
+	unsigned int	rpages;<br>
 	int		result;<br>
 <br>
 	if (!inode)<br>
-		return 0;<br>
+		return 1;<br>
 <br>
 	rpages = NFS_SERVER(inode)-&gt;rpages;<br>
 	result = nfs_pagein_inode(inode, index, rpages);<br>
 	if (result &lt; 0)<br>
 		goto out_bad;<br>
-	wpages = NFS_SERVER(inode)-&gt;wpages;<br>
-	result = nfs_sync_file(inode, NULL, index, wpages, FLUSH_STABLE);<br>
-	if (result &lt; 0)<br>
-		goto out_bad;<br>
-	return 0;<br>
+	return 1;<br>
  out_bad:<br>
 	return result;<br>
 }<br>
 <br>
+/*<br>
+ * The following tries to flush out any pending writes on a given page<br>
+ * Note: in NFS we don't want it to wait on the flush request, since we<br>
+ *	 often end up calling invalidate_inode_pages() from rpciod()<br>
+ */<br>
+static int nfs_flushpage(struct page *page, unsigned partial)<br>
+{<br>
+	struct inode	*inode = (struct inode *)page-&gt;mapping-&gt;host;<br>
+	unsigned long	index = page_index(page);<br>
+	unsigned int	wpages;<br>
+<br>
+	if (!PageLocked(page))<br>
+		BUG();<br>
+	if (!inode)<br>
+		goto out;<br>
+<br>
+	wpages = NFS_SERVER(inode)-&gt;wpages;<br>
+	nfs_sync_file(inode, NULL, index, wpages, FLUSH_STABLE);<br>
+ out:<br>
+	return 1;<br>
+}<br>
+<br>
 struct address_space_operations nfs_file_aops = {<br>
 	readpage: nfs_readpage,<br>
 	sync_page: nfs_sync_page,<br>
+	flush_page: nfs_flushpage,<br>
 	writepage: nfs_writepage,<br>
 	prepare_write: nfs_prepare_write,<br>
 	commit_write: nfs_commit_write<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/ntfs/fs.c linux-2.3.99-pre6-devel/fs/ntfs/fs.c<br>
--- linux-2.3.99-pre6/fs/ntfs/fs.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/ntfs/fs.c	Thu Apr 27 16:18:28 2000<br>
@@ -608,6 +608,7 @@<br>
 	readpage: ntfs_readpage,<br>
 	writepage: ntfs_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: ntfs_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: _ntfs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/qnx4/inode.c linux-2.3.99-pre6-devel/fs/qnx4/inode.c<br>
--- linux-2.3.99-pre6/fs/qnx4/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/qnx4/inode.c	Thu Apr 27 16:18:50 2000<br>
@@ -431,6 +431,7 @@<br>
 	readpage: qnx4_readpage,<br>
 	writepage: qnx4_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: qnx4_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: qnx4_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/sysv/inode.c linux-2.3.99-pre6-devel/fs/sysv/inode.c<br>
--- linux-2.3.99-pre6/fs/sysv/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/sysv/inode.c	Thu Apr 27 16:19:08 2000<br>
@@ -959,6 +959,7 @@<br>
 	readpage: sysv_readpage,<br>
 	writepage: sysv_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: sysv_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: sysv_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/udf/file.c linux-2.3.99-pre6-devel/fs/udf/file.c<br>
--- linux-2.3.99-pre6/fs/udf/file.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/udf/file.c	Thu Apr 27 16:19:31 2000<br>
@@ -119,6 +119,7 @@<br>
 	readpage:			udf_adinicb_readpage,<br>
 	writepage:			udf_adinicb_writepage,<br>
 	sync_page:		block_sync_page,<br>
+	flush_page:		block_flushpage,<br>
 	prepare_write:		udf_adinicb_prepare_write,<br>
 	commit_write:		udf_adinicb_commit_write,<br>
 };<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/udf/inode.c linux-2.3.99-pre6-devel/fs/udf/inode.c<br>
--- linux-2.3.99-pre6/fs/udf/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/udf/inode.c	Thu Apr 27 16:19:53 2000<br>
@@ -149,6 +149,7 @@<br>
 	readpage:			udf_readpage,<br>
 	writepage:			udf_writepage,<br>
 	sync_page:		block_sync_page,<br>
+	flush_page:		block_flushpage,<br>
 	prepare_write:		udf_prepare_write,<br>
 	commit_write:		generic_commit_write,<br>
 	bmap:				udf_bmap,<br>
diff -u --recursive --new-file linux-2.3.99-pre6/fs/ufs/inode.c linux-2.3.99-pre6-devel/fs/ufs/inode.c<br>
--- linux-2.3.99-pre6/fs/ufs/inode.c	Wed Apr 26 02:28:56 2000<br>
+++ linux-2.3.99-pre6-devel/fs/ufs/inode.c	Thu Apr 27 16:20:14 2000<br>
@@ -560,6 +560,7 @@<br>
 	readpage: ufs_readpage,<br>
 	writepage: ufs_writepage,<br>
 	sync_page: block_sync_page,<br>
+	flush_page: block_flushpage,<br>
 	prepare_write: ufs_prepare_write,<br>
 	commit_write: generic_commit_write,<br>
 	bmap: ufs_bmap<br>
diff -u --recursive --new-file linux-2.3.99-pre6/include/linux/fs.h linux-2.3.99-pre6-devel/include/linux/fs.h<br>
--- linux-2.3.99-pre6/include/linux/fs.h	Thu Apr 27 13:44:35 2000<br>
+++ linux-2.3.99-pre6-devel/include/linux/fs.h	Thu Apr 27 16:26:50 2000<br>
@@ -341,6 +341,7 @@<br>
 	int (*writepage)(struct file *, struct dentry *, struct page *);<br>
 	int (*readpage)(struct dentry *, struct page *);<br>
 	int (*sync_page)(struct page *);<br>
+	int (*flush_page)(struct page *, unsigned);<br>
 	int (*prepare_write)(struct file *, struct page *, unsigned, unsigned);<br>
 	int (*commit_write)(struct file *, struct page *, unsigned, unsigned);<br>
 	/* Unfortunately this kludge is needed for FIBMAP. Don't use it */<br>
@@ -1087,7 +1088,7 @@<br>
 typedef int (get_block_t)(struct inode*,long,struct buffer_head*,int);<br>
 <br>
 /* Generic buffer handling for block filesystems.. */<br>
-extern int block_flushpage(struct page *, unsigned long);<br>
+extern int block_flushpage(struct page *, unsigned);<br>
 extern int block_fsync(struct file *filp, struct dentry *dentry);<br>
 extern int block_symlink(struct inode *, const char *, int);<br>
 extern int block_write_full_page(struct page*, get_block_t*);<br>
diff -u --recursive --new-file linux-2.3.99-pre6/mm/filemap.c linux-2.3.99-pre6-devel/mm/filemap.c<br>
--- linux-2.3.99-pre6/mm/filemap.c	Thu Apr 27 00:06:25 2000<br>
+++ linux-2.3.99-pre6-devel/mm/filemap.c	Thu Apr 27 15:23:36 2000<br>
@@ -87,6 +87,15 @@<br>
 	return 0;<br>
 }<br>
 <br>
+static inline int flush_page(struct page *page, unsigned int partial)<br>
+{<br>
+	struct address_space *mapping = page-&gt;mapping;<br>
+<br>
+	if (mapping &amp;&amp; mapping-&gt;a_ops &amp;&amp; mapping-&gt;a_ops-&gt;flush_page)<br>
+		return mapping-&gt;a_ops-&gt;flush_page(page, partial);<br>
+	return 1;<br>
+}<br>
+<br>
 /*<br>
  * Remove a page from the page cache and free it. Caller has to make<br>
  * sure the page is locked and that nobody else uses it - or that usage<br>
@@ -97,8 +106,6 @@<br>
 	if (!PageLocked(page))<br>
 		PAGE_BUG(page);<br>
 <br>
-	/* Initiate completion of any async operations */<br>
-	sync_page(page);<br>
 <br>
 	spin_lock(&amp;pagecache_lock);<br>
 	remove_page_from_inode_queue(page);<br>
@@ -126,7 +133,9 @@<br>
 			continue;<br>
 		spin_unlock(&amp;pagecache_lock);<br>
 <br>
-		lru_cache_del(page);<br>
+		/* Initiate completion of any async operations */<br>
+		if (flush_page(page, 0))<br>
+			lru_cache_del(page);<br>
 		remove_inode_page(page);<br>
 		UnlockPage(page);<br>
 		page_cache_release(page);<br>
@@ -172,9 +181,8 @@<br>
 			get_page(page);<br>
 			spin_unlock(&amp;pagecache_lock);<br>
 <br>
-			if (!page-&gt;buffers || block_flushpage(page, 0))<br>
+			if (flush_page(page, 0))<br>
 				lru_cache_del(page);<br>
-<br>
 			/*<br>
 			 * We remove the page from the page cache<br>
 			 * _after_ we have destroyed all buffer-cache<br>
@@ -217,8 +225,7 @@<br>
 		spin_unlock(&amp;pagecache_lock);<br>
 <br>
 		memclear_highpage_flush(page, partial, PAGE_CACHE_SIZE-partial);<br>
-		if (page-&gt;buffers)<br>
-			block_flushpage(page, partial);<br>
+		flush_page(page, partial);<br>
 <br>
 		partial = 0;<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0658.html">Shane Shrybman: "Re: IO scheduling problem in 2.3.99-pre6"</a>
<li> <b>Previous message:</b> <a href="0656.html">Alexander Viro: "Re: [PATCH] C++ breaks on linux/ioport.h"</a>
<li> <b>In reply to:</b> <a href="0618.html">Trond Myklebust: "Generic API for asynchronous filesystems (was Re: 2.3.99-pre6-pre7 sync_page in remove_inode_page)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
