<!-- received="Thu Apr 27 15:25:07 2000 EET DST" -->
<!-- sent="27 Apr 2000 14:18:11 +0200" -->
<!-- name="Trond Myklebust" -->
<!-- email="trond.myklebust@fys.uio.no" -->
<!-- subject="Re: IO scheduling problem in 2.3.99-pre6" -->
<!-- id="" -->
<!-- inreplyto="Thu, 27 Apr 2000 03:17:24 -0700"" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: IO scheduling problem in 2.3.99-pre6</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: IO scheduling problem in 2.3.99-pre6</h1>
<b>Trond Myklebust</b> (<a href="mailto:trond.myklebust@fys.uio.no"><i>trond.myklebust@fys.uio.no</i></a>)<br>
<i>27 Apr 2000 14:18:11 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#632">[ date ]</a><a href="index.html#632">[ thread ]</a><a href="subject.html#632">[ subject ]</a><a href="author.html#632">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0633.html">Tigran Aivazian: "chroot_fs_refs() question"</a>
<li> <b>Previous message:</b> <a href="0631.html">Maciej W. Rozycki: "Re: Reading the BSD partition table from Linux/Intel"</a>
<li> <b>In reply to:</b> <a href="0622.html">Adam J. Richter: "IO scheduling problem in 2.3.99-pre6"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0647.html">Joerg Stroettchen: "Re: IO scheduling problem in 2.3.99-pre6"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
<i>&gt;&gt;&gt;&gt;&gt; " " == Adam J Richter &lt;<a href="mailto:adam@yggdrasil.com">adam@yggdrasil.com</a>&gt; writes:</i><br>
<p>
<i>     &gt; 	When I do anything that causes a lot of I/O to the IDE</i><br>
<i>     &gt; hard disk on a computer running 2.3.99-pre6, the system becomes</i><br>
<i>     &gt; very unresponsive.  I often have to wait a couple of seconds</i><br>
<i>     &gt; for characters to echo on xterm windows, for example.</i><br>
<i>     &gt; 2.3.99pre6-5 did not have this problem.  I did not try</i><br>
<i>     &gt; 2.3.99pre6-6 or 2.3.99pre6-7, so the problem could have been</i><br>
<i>     &gt; introduced at that point too.</i><br>
<p>
<i>     &gt; 	I have verified that the problem is triggered by IO rather</i><br>
<i>     &gt; than CPU utilization.</i><br>
<p>
Does the following cure it?<br>
<p>
Cheers,<br>
  Trond<br>
<p>
--- linux-2.3.99-pre6/fs/buffer.c	Wed Apr 26 02:28:55 2000<br>
+++ linux-2.3.99-pre6-devel/fs/buffer.c	Thu Apr 27 13:27:52 2000<br>
@@ -2417,7 +2417,8 @@<br>
 <br>
 int block_sync_page(struct page *page)<br>
 {<br>
-	run_task_queue(&amp;tq_disk);<br>
+	if (!Page_Uptodate(page))<br>
+		run_task_queue(&amp;tq_disk);<br>
 	return 0;<br>
 }<br>
 <br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0633.html">Tigran Aivazian: "chroot_fs_refs() question"</a>
<li> <b>Previous message:</b> <a href="0631.html">Maciej W. Rozycki: "Re: Reading the BSD partition table from Linux/Intel"</a>
<li> <b>In reply to:</b> <a href="0622.html">Adam J. Richter: "IO scheduling problem in 2.3.99-pre6"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0647.html">Joerg Stroettchen: "Re: IO scheduling problem in 2.3.99-pre6"</a>
<!-- reply="end" -->
</ul>
</font></body>
