<!-- received="Thu Apr 27 09:03:53 2000 EET DST" -->
<!-- sent="Thu, 27 Apr 2000 08:00:19 +0200 (CEST)" -->
<!-- name="Mike Galbraith" -->
<!-- email="mikeg@weiden.de" -->
<!-- subject="[patch][diag][rfc] Bugasaurus REX" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [patch][diag][rfc] Bugasaurus REX</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch][diag][rfc] Bugasaurus REX</h1>
<b>Mike Galbraith</b> (<a href="mailto:mikeg@weiden.de"><i>mikeg@weiden.de</i></a>)<br>
<i>Thu, 27 Apr 2000 08:00:19 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#595">[ date ]</a><a href="index.html#595">[ thread ]</a><a href="subject.html#595">[ subject ]</a><a href="author.html#595">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0596.html">Mani Manoharan Balaraman: "Kernel Debugging"</a>
<li> <b>Previous message:</b> <a href="0594.html">Niels Kristian Bech Jensen: "Can't eject CDROM in 2.3.99-pre6-7 and 2.3.99-pre6."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Greetings,<br>
<p>
'scuse me a sec..<br>
[Dear God, _please_ don't let that first chunk be an IKD bug.]<br>
<p>
Try this patch if you want to see the critter.  I'm not going to<br>
provide any details.. I start babbling when I try ;-) I will say<br>
that protecting sem_exit() with task_lock() helps a lot.  (If you<br>
run full IKD, you see more symptoms than you can shake a stick at)<br>
<p>
If anyone does try this, be warned that fsck becomes quite irate over<br>
disconnected inodes.  It's no big deal.. only /var/run pids&amp;socs and<br>
sometimes /etc/ld.so.cache.  Nothing serious has happened here in<br>
many many many fsck runs, but YMMV applies.<br>
<p>
I have made no progress to date.. but have done many things which<br>
move symptoms around.  (trust me, you don't want to hear it)<br>
<p>
	-Mike<br>
<p>
--- linux-2.3.99-pre6-7.virgin/mm/slab.c.org	Thu Apr 27 07:17:39 2000<br>
+++ linux-2.3.99-pre6-7.virgin/mm/slab.c	Thu Apr 27 07:23:15 2000<br>
@@ -682,6 +682,9 @@<br>
 	size_t		left_over;<br>
 	size_t		align;<br>
 <br>
+#if SLAB_DEBUG_SUPPORT<br>
+	flags |= SLAB_POISON;<br>
+#endif<br>
 	/* Sanity checks... */<br>
 #if	SLAB_MGMT_CHECKS<br>
 	if (!name) {<br>
--- linux-2.3.99-pre6-7.virgin/arch/i386/kernel/semaphore.c.org	Thu Apr 27 08:01:04 2000<br>
+++ linux-2.3.99-pre6-7.virgin/arch/i386/kernel/semaphore.c	Thu Apr 27 08:07:13 2000<br>
@@ -55,13 +55,23 @@<br>
 <br>
 static spinlock_t semaphore_lock = SPIN_LOCK_UNLOCKED;<br>
 <br>
+static void generate_oops (struct semaphore *sem)<br>
+{<br>
+	atomic_set (&amp;sem-&gt;count, 9876);<br>
+	wake_up (&amp;sem-&gt;wait);<br>
+}<br>
+<br>
 void __down(struct semaphore * sem)<br>
 {<br>
+	struct timer_list timer;<br>
 	struct task_struct *tsk = current;<br>
 	DECLARE_WAITQUEUE(wait, tsk);<br>
 	tsk-&gt;state = TASK_UNINTERRUPTIBLE|TASK_EXCLUSIVE;<br>
 	add_wait_queue_exclusive(&amp;sem-&gt;wait, &amp;wait);<br>
 <br>
+	init_timer (&amp;timer);<br>
+	timer.data = (unsigned long) sem;<br>
+	timer.function = (void (*)(unsigned long)) generate_oops;<br>
 	spin_lock_irq(&amp;semaphore_lock);<br>
 	sem-&gt;sleepers++;<br>
 	for (;;) {<br>
@@ -78,7 +88,12 @@<br>
 		sem-&gt;sleepers = 1;	/* us - see -1 above */<br>
 		spin_unlock_irq(&amp;semaphore_lock);<br>
 <br>
+		timer.expires = jiffies + HZ*20;<br>
+		add_timer (&amp;timer);<br>
 		schedule();<br>
+		if (atomic_read (&amp;sem-&gt;count) == 9876)<br>
+			BUG();<br>
+		del_timer (&amp;timer);<br>
 		tsk-&gt;state = TASK_UNINTERRUPTIBLE|TASK_EXCLUSIVE;<br>
 		spin_lock_irq(&amp;semaphore_lock);<br>
 	}<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0596.html">Mani Manoharan Balaraman: "Kernel Debugging"</a>
<li> <b>Previous message:</b> <a href="0594.html">Niels Kristian Bech Jensen: "Can't eject CDROM in 2.3.99-pre6-7 and 2.3.99-pre6."</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
