<!-- received="Thu Apr 27 02:54:13 2000 EET DST" -->
<!-- sent="Thu, 27 Apr 2000 01:50:57 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] preliminary Cyrix III detection code" -->
<!-- id="200004262350.BAA17076@harpo.it.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] preliminary Cyrix III detection code</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] preliminary Cyrix III detection code</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Thu, 27 Apr 2000 01:50:57 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#563">[ date ]</a><a href="index.html#563">[ thread ]</a><a href="subject.html#563">[ subject ]</a><a href="author.html#563">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0564.html">iehrenwald@earthlink.net: "ramfs questions"</a>
<li> <b>Previous message:</b> <a href="0562.html">khromy: "3c590"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch, against 2.3.99-pre6-7, adds VIA Cyrix III detection<br>
code to arch/i386/kernel/setup.c. Code written from published<br>
specs, but untested as I don't have a Cyrix III myself.<br>
<p>
Anyone with a Cyrix III care to test it?<br>
<p>
/Mikael<br>
<p>
--- linux-2.3.99-pre6p7/arch/i386/kernel/setup.c.~1~	Wed Apr 26 21:45:33 2000<br>
+++ linux-2.3.99-pre6p7/arch/i386/kernel/setup.c	Thu Apr 27 01:11:44 2000<br>
@@ -1070,6 +1070,40 @@<br>
 		c-&gt;x86_capability |= X86_FEATURE_MTRR;<br>
 		break;<br>
 <br>
+	case 8:	/* Cyrix III */<br>
+		/* Integrated 256KB L2 cache. */<br>
+		c-&gt;x86_cache_size = 256;<br>
+		/* Use extended CPUID levels to get extended feature<br>
+		   flags and CPU marketing name. */<br>
+		get_model_name(c);<br>
+		/* Emulate MTRRs using Cyrix' ARRs. */<br>
+		c-&gt;x86_capability |= X86_FEATURE_MTRR;<br>
+		/*<br>
+		 * Construct the multiplier string:<br>
+		 *<br>
+		 *	dir0_lsn	multiplier<br>
+		 *	0100		2.5<br>
+		 *	0001		3.0<br>
+		 *	0101		3.5<br>
+		 *	0010		4.0<br>
+		 *	0110		4.5<br>
+		 *	0011		5.0<br>
+		 *	0111		5.5<br>
+		 *	1000		6.0<br>
+		 *	1010		6.5<br>
+		 *	1001		7.0<br>
+		 *	1011		7.5<br>
+		 */<br>
+		if (dir0_lsn &amp; 8) {<br>
+			p = Cx86_cb + ((dir0_lsn &amp; 2) ? 0 : 2);<br>
+			p[0] = '6' + (dir0_lsn &amp; 1);<br>
+		} else {<br>
+			p = Cx86_cb + ((dir0_lsn &amp; 4) ? 0 : 2);<br>
+			p[0] = '2' + (dir0_lsn &amp; 3);<br>
+		}<br>
+		strcat(buf, p);<br>
+		return;<br>
+<br>
 	case 0xf:  /* Cyrix 486 without DEVID registers */<br>
 		switch (dir0_lsn) {<br>
 		case 0xd:  /* either a 486SLC or DLC w/o DEVID */<br>
@@ -1471,6 +1505,8 @@<br>
 <br>
 		    case X86_VENDOR_CYRIX:<br>
 			x86_cap_flags[24] = "cxmmx";<br>
+			if (Cx86_dir0_msb &gt;= 8) /* Cyrix III and above */<br>
+				x86_cap_flags[31] = "3dnow";<br>
 			break;<br>
 <br>
 		    case X86_VENDOR_AMD:<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0564.html">iehrenwald@earthlink.net: "ramfs questions"</a>
<li> <b>Previous message:</b> <a href="0562.html">khromy: "3c590"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
