<!-- received="Wed Apr 26 03:05:37 2000 EET DST" -->
<!-- sent="Wed, 26 Apr 2000 01:55:51 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="[PATCH] minor cleanup in arch/i386/kernel/" -->
<!-- id="200004252355.BAA11517@harpo.it.uu.se" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] minor cleanup in arch/i386/kernel/</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] minor cleanup in arch/i386/kernel/</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Wed, 26 Apr 2000 01:55:51 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#428">[ date ]</a><a href="index.html#428">[ thread ]</a><a href="subject.html#428">[ subject ]</a><a href="author.html#428">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0429.html">Graham Stoney: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Previous message:</b> <a href="0427.html">Mikael Pettersson: "[PATCH] dep_mbool is broken in scripts/Configure"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
arch/i386/kernel/setup.c increments a counter cpus_initialized<br>
for each new cpu which is initialized. However, this variable<br>
is never actually _used_ for anything.<br>
<p>
setup.c also maintains a bitmask of all initialized cpus in<br>
cpu_initialized. This variable should be declared static and<br>
__initdata since it's only referenced from cpu_init(), which<br>
is declared __init.<br>
<p>
The patch below (against 2.3.99-pre5) cleans up these little uglies.<br>
<p>
/Mikael<br>
<p>
--- linux-2.3.99-pre5/arch/i386/kernel/process.c.~1~	Sat Mar 11 16:01:20 2000<br>
+++ linux-2.3.99-pre5/arch/i386/kernel/process.c	Sat Apr 15 13:46:20 2000<br>
@@ -589,7 +589,6 @@<br>
  * More important, however, is the fact that this allows us much<br>
  * more flexibility.<br>
  */<br>
-extern int cpus_initialized;<br>
 void __switch_to(struct task_struct *prev_p, struct task_struct *next_p)<br>
 {<br>
 	struct thread_struct *prev = &amp;prev_p-&gt;thread,<br>
--- linux-2.3.99-pre5/arch/i386/kernel/setup.c.~1~	Wed Apr 12 22:00:57 2000<br>
+++ linux-2.3.99-pre5/arch/i386/kernel/setup.c	Sat Apr 15 13:46:20 2000<br>
@@ -1531,8 +1531,7 @@<br>
 	return p - buffer;<br>
 }<br>
 <br>
-int cpus_initialized = 0;<br>
-unsigned long cpu_initialized = 0;<br>
+static unsigned long cpu_initialized __initdata = 0;<br>
 <br>
 /*<br>
  * cpu_init() initializes state that is per-CPU. Some data is already<br>
@@ -1549,7 +1548,6 @@<br>
 		printk("CPU#%d already initialized!\n", nr);<br>
 		for (;;) __sti();<br>
 	}<br>
-	cpus_initialized++;<br>
 	printk("Initializing CPU#%d\n", nr);<br>
 <br>
 	if (cpu_has_vme || cpu_has_tsc || cpu_has_de)<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0429.html">Graham Stoney: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Previous message:</b> <a href="0427.html">Mikael Pettersson: "[PATCH] dep_mbool is broken in scripts/Configure"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
