<!-- received="Wed Apr 26 02:04:18 2000 EET DST" -->
<!-- sent="Wed, 26 Apr 2000 00:03:12 +0000" -->
<!-- name="=?iso-8859-1?Q?Fran=E7ois_romieu?=" -->
<!-- email="romieu@ensta.fr" -->
<!-- subject="[PATCH] 2.3.99pre6-6 cosmetic replacement for init_timer...add_timer" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] 2.3.99pre6-6 cosmetic replacement for init_timer...add_timer</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] 2.3.99pre6-6 cosmetic replacement for init_timer...add_timer</h1>
<b>=?iso-8859-1?Q?Fran=E7ois_romieu?=</b> (<a href="mailto:romieu@ensta.fr"><i>romieu@ensta.fr</i></a>)<br>
<i>Wed, 26 Apr 2000 00:03:12 +0000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#421">[ date ]</a><a href="index.html#421">[ thread ]</a><a href="subject.html#421">[ subject ]</a><a href="author.html#421">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0422.html">Erik van Asselt: "Packet loss with kernel 2.3.99.pre6-3?"</a>
<li> <b>Previous message:</b> <a href="0420.html">Dimitris Michailidis: "Re: SCHED_RR is broken + patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Many drivers use the same init_timer, timer.expires = , timer.data =,<br>
timer.function = , add_timer sequence. Here the common factor becomes a <br>
function added to kernel/timer.c.<br>
<p>
Question : <br>
Doing this, I noticed everybody uses his own method to specify the expires<br>
value (simple number, HZ, etc...). Is there a preferred (or really avoidable)<br>
way to do it ?<br>
<p>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/arch/sparc64/kernel/central.c linux-2.3.99pre6-6/arch/sparc64/kernel/central.c<br>
--- linux-2.3.99pre6-6.orig/arch/sparc64/kernel/central.c	Sat Mar 18 06:59:42 2000<br>
+++ linux-2.3.99pre6-6/arch/sparc64/kernel/central.c	Wed Apr 26 00:08:01 2000<br>
@@ -455,9 +455,5 @@<br>
 	upa_writeb(ctrl, central-&gt;clkregs + CLOCK_CTRL);<br>
 <br>
 	led_state = 0;<br>
-	init_timer(&amp;sftimer);<br>
-	sftimer.data = 0;<br>
-	sftimer.function = &amp;sunfire_timer;<br>
-	sftimer.expires = jiffies + (HZ &gt;&gt; 1);<br>
-	add_timer(&amp;sftimer);<br>
+	add_simple_timer( &amp;sftimer, HZ&gt;&gt;1, 0, &amp;sunfire_timer );<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/atm/nicstar.c linux-2.3.99pre6-6/drivers/atm/nicstar.c<br>
--- linux-2.3.99pre6-6.orig/drivers/atm/nicstar.c	Tue Apr 25 21:33:48 2000<br>
+++ linux-2.3.99pre6-6/drivers/atm/nicstar.c	Tue Apr 25 22:52:20 2000<br>
@@ -251,11 +251,7 @@<br>
 #endif /* PHY_LOOPBACK */<br>
    XPRINTK("nicstar: init_module() returned.\n");<br>
 <br>
-   init_timer(&amp;ns_timer);<br>
-   ns_timer.expires = jiffies + NS_POLL_PERIOD;<br>
-   ns_timer.data = 0UL;<br>
-   ns_timer.function = ns_poll;<br>
-   add_timer(&amp;ns_timer);<br>
+   add_simple_timer( &amp;ns_timer, NS_POLL_PERIOD, 0UL, ns_poll );<br>
    return 0;<br>
 }<br>
 <br>
@@ -387,11 +383,7 @@<br>
 #endif /* PHY_LOOPBACK */<br>
    XPRINTK("nicstar: init_module() returned.\n");<br>
 <br>
-   init_timer(&amp;ns_timer);<br>
-   ns_timer.expires = jiffies + NS_POLL_PERIOD;<br>
-   ns_timer.data = 0UL;<br>
-   ns_timer.function = ns_poll;<br>
-   add_timer(&amp;ns_timer);<br>
+   add_simple_timer( &amp;ns_timer, jiffies + NS_POLL_PERIOD, 0UL, ns_poll );<br>
    return i;<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/block/cpqarray.c linux-2.3.99pre6-6/drivers/block/cpqarray.c<br>
--- linux-2.3.99pre6-6.orig/drivers/block/cpqarray.c	Sat Mar 18 07:09:31 2000<br>
+++ linux-2.3.99pre6-6/drivers/block/cpqarray.c	Tue Apr 25 22:52:01 2000<br>
@@ -472,11 +472,8 @@<br>
 		ida_gendisk[i].next = gendisk_head;<br>
 		gendisk_head = &amp;ida_gendisk[i];<br>
 <br>
-		init_timer(&amp;hba[i]-&gt;timer);<br>
-		hba[i]-&gt;timer.expires = jiffies + IDA_TIMER;<br>
-		hba[i]-&gt;timer.data = (unsigned long)hba[i];<br>
-		hba[i]-&gt;timer.function = ida_timer;<br>
-		add_timer(&amp;hba[i]-&gt;timer);<br>
+		add_simple_timer( &amp;hba[i]-&gt;timer, IDA_TIMER,<br>
+				  (unsigned long)hba[i], ida_timer );<br>
 <br>
 		ida_geninit(i);<br>
 		for(j=0; j&lt;NWD; j++)	<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/char/radio-cadet.c linux-2.3.99pre6-6/drivers/char/radio-cadet.c<br>
--- linux-2.3.99pre6-6.orig/drivers/char/radio-cadet.c	Sat Mar 18 07:03:12 2000<br>
+++ linux-2.3.99pre6-6/drivers/char/radio-cadet.c	Tue Apr 25 22:52:04 2000<br>
@@ -335,11 +335,8 @@<br>
 	/* <br>
 	 * Clean up and exit<br>
 	 */<br>
-	init_timer(&amp;readtimer);<br>
-	readtimer.function=cadet_handler;<br>
-	readtimer.data=(unsigned long)0;<br>
-	readtimer.expires=jiffies+(HZ/20);<br>
-	add_timer(&amp;readtimer);<br>
+	add_simple_timer( &amp;readtimer, HZ/20, (unsigned long)0,<br>
+			  cadet_handler );<br>
 }<br>
 <br>
 <br>
@@ -355,11 +352,7 @@<br>
 	        rdsstat=1;<br>
 		outb(0x80,io);        /* Select RDS fifo */<br>
 		cadet_lock--;<br>
-		init_timer(&amp;readtimer);<br>
-		readtimer.function=cadet_handler;<br>
-		readtimer.data=(unsigned long)0;<br>
-		readtimer.expires=jiffies+(HZ/20);<br>
-		add_timer(&amp;readtimer);<br>
+		add_simple_timer( &amp;readtimer, HZ/20, (unsigned long)0, cadet_handler );<br>
 	}<br>
 	if(rdsin==rdsout) {<br>
   	        if(nonblock) {<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/char/specialix.c linux-2.3.99pre6-6/drivers/char/specialix.c<br>
--- linux-2.3.99pre6-6.orig/drivers/char/specialix.c	Sat Mar 18 07:13:51 2000<br>
+++ linux-2.3.99pre6-6/drivers/char/specialix.c	Tue Apr 25 22:52:03 2000<br>
@@ -581,11 +581,8 @@<br>
 #endif<br>
 <br>
 #ifdef SPECIALIX_TIMER<br>
-	init_timer (&amp;missed_irq_timer);<br>
-	missed_irq_timer.function = missed_irq;<br>
-	missed_irq_timer.data = (unsigned long) bp;<br>
-	missed_irq_timer.expires = jiffies + HZ;<br>
-	add_timer (&amp;missed_irq_timer);<br>
+	add_simple_timer( &amp;missed_irq_timer, HZ, (unsigned long) bp,<br>
+			  missed_irq );<br>
 #endif<br>
 <br>
 	printk(KERN_INFO"sx%d: specialix IO8+ board detected at 0x%03x, IRQ %d, CD%d Rev. %c.\n",<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/icn/icn.c linux-2.3.99pre6-6/drivers/isdn/icn/icn.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/icn/icn.c	Sat Mar 18 06:55:09 2000<br>
+++ linux-2.3.99pre6-6/drivers/isdn/icn/icn.c	Tue Apr 25 22:52:11 2000<br>
@@ -1205,18 +1205,13 @@<br>
 #endif<br>
 				save_flags(flags);<br>
 				cli();<br>
-				init_timer(&amp;card-&gt;st_timer);<br>
-				card-&gt;st_timer.expires = jiffies + ICN_TIMER_DCREAD;<br>
-				card-&gt;st_timer.function = icn_polldchan;<br>
-				card-&gt;st_timer.data = (unsigned long) card;<br>
-				add_timer(&amp;card-&gt;st_timer);<br>
+				add_simple_timer( &amp;card-&gt;st_timer,<br>
+						  ICN_TIMER_DCREAD,<br>
+						  (unsigned long) card,<br>
+						  icn_polldchan );<br>
 				card-&gt;flags |= ICN_FLAGS_RUNNING;<br>
 				if (card-&gt;doubleS0) {<br>
-					init_timer(&amp;card-&gt;other-&gt;st_timer);<br>
-					card-&gt;other-&gt;st_timer.expires = jiffies + ICN_TIMER_DCREAD;<br>
-					card-&gt;other-&gt;st_timer.function = icn_polldchan;<br>
-					card-&gt;other-&gt;st_timer.data = (unsigned long) card-&gt;other;<br>
-					add_timer(&amp;card-&gt;other-&gt;st_timer);<br>
+					add_simple_timer( &amp;card-&gt;other-&gt;st_timer, ICN_TIMER_DCREAD, (unsigned long) card-&gt;other, icn_polldchan );<br>
 					card-&gt;other-&gt;flags |= ICN_FLAGS_RUNNING;<br>
 				}<br>
 				restore_flags(flags);<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/isdnloop/isdnloop.c linux-2.3.99pre6-6/drivers/isdn/isdnloop/isdnloop.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/isdnloop/isdnloop.c	Sat Mar 18 06:55:09 2000<br>
+++ linux-2.3.99pre6-6/drivers/isdn/isdnloop/isdnloop.c	Tue Apr 25 22:52:13 2000<br>
@@ -1152,11 +1152,8 @@<br>
 			       sdef.ptype);<br>
 			return -EINVAL;<br>
 	}<br>
-	init_timer(&amp;card-&gt;st_timer);<br>
-	card-&gt;st_timer.expires = jiffies + ISDNLOOP_TIMER_DCREAD;<br>
-	card-&gt;st_timer.function = isdnloop_polldchan;<br>
-	card-&gt;st_timer.data = (unsigned long) card;<br>
-	add_timer(&amp;card-&gt;st_timer);<br>
+	add_simple_timer( &amp;card-&gt;st_timer, ISDNLOOP_TIMER_DCREAD,<br>
+			  (unsigned long) card, isdnloop_polldchan );<br>
 	card-&gt;flags |= ISDNLOOP_FLAGS_RUNNING;<br>
 	restore_flags(flags);<br>
 	return 0;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/drv.c linux-2.3.99pre6-6/drivers/isdn/pcbit/drv.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/drv.c	Sat Mar 18 06:56:31 2000<br>
+++ linux-2.3.99pre6-6/drivers/isdn/pcbit/drv.c	Tue Apr 25 22:52:12 2000<br>
@@ -389,11 +389,8 @@<br>
 		 */<br>
 #ifdef BLOCK_TIMER<br>
 		if (chan-&gt;block_timer.function == NULL) {<br>
-			init_timer(&amp;chan-&gt;block_timer);<br>
-			chan-&gt;block_timer.function =  &amp;pcbit_block_timer;<br>
-			chan-&gt;block_timer.data = (long) chan;<br>
-			chan-&gt;block_timer.expires = jiffies + 1 * HZ;<br>
-			add_timer(&amp;chan-&gt;block_timer);<br>
+			add_simple_timer( &amp;chan-&gt;block_timer, HZ, (long) chan,<br>
+					  &amp;pcbit_block_timer );<br>
 		}<br>
 #endif		<br>
 		return 0;	                 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/edss1.c linux-2.3.99pre6-6/drivers/isdn/pcbit/edss1.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/edss1.c	Sat Aug 31 13:01:58 1996<br>
+++ linux-2.3.99pre6-6/drivers/isdn/pcbit/edss1.c	Tue Apr 25 22:52:12 2000<br>
@@ -315,11 +315,8 @@<br>
                         break;<br>
 <br>
         if (tentry-&gt;init != 0xff) {<br>
-                init_timer(&amp;chan-&gt;fsm_timer);<br>
-                chan-&gt;fsm_timer.function = &amp;pcbit_fsm_timer;<br>
-                chan-&gt;fsm_timer.data = (ulong) chan;<br>
-                chan-&gt;fsm_timer.expires = jiffies + tentry-&gt;timeout * HZ;<br>
-                add_timer(&amp;chan-&gt;fsm_timer);<br>
+                add_simple_timer( &amp;chan-&gt;fsm_timer, tentry-&gt;timeout*HZ,<br>
+				  (ulong) chan, &amp;pcbit_fsm_timer );<br>
         }<br>
 <br>
 	restore_flags(flags);<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/layer2.c linux-2.3.99pre6-6/drivers/isdn/pcbit/layer2.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/pcbit/layer2.c	Sat Mar 18 06:55:09 2000<br>
+++ linux-2.3.99pre6-6/drivers/isdn/pcbit/layer2.c	Tue Apr 25 22:52:12 2000<br>
@@ -684,11 +684,8 @@<br>
 <br>
 		dev-&gt;l2_state = L2_DOWN;<br>
 <br>
-		init_timer(&amp;dev-&gt;error_recover_timer);<br>
-		dev-&gt;error_recover_timer.function = &amp;pcbit_l2_err_recover;<br>
-		dev-&gt;error_recover_timer.data = (ulong) dev;<br>
-		dev-&gt;error_recover_timer.expires = jiffies + ERRTIME;<br>
-		add_timer(&amp;dev-&gt;error_recover_timer);<br>
+		add_simple_timer( &amp;dev-&gt;error_recover_timer, ERRTIME,<br>
+				  (ulong) dev, &amp;pcbit_l2_err_recover );<br>
 	}<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/sc/command.c linux-2.3.99pre6-6/drivers/isdn/sc/command.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/sc/command.c	Fri May 30 00:53:06 1997<br>
+++ linux-2.3.99pre6-6/drivers/isdn/sc/command.c	Tue Apr 25 22:52:13 2000<br>
@@ -543,11 +543,8 @@<br>
 <br>
 	save_flags(flags);<br>
 	cli();<br>
-	init_timer(&amp;adapter[card]-&gt;reset_timer);<br>
-	adapter[card]-&gt;reset_timer.function = check_reset;<br>
-	adapter[card]-&gt;reset_timer.data = card;<br>
-	adapter[card]-&gt;reset_timer.expires = jiffies + CHECKRESET_TIME;<br>
-	add_timer(&amp;adapter[card]-&gt;reset_timer);<br>
+	add_simple_timer( &amp;adapter[card]-&gt;reset_timer, CHECKRESET_TIME,<br>
+			  card, check_reset );<br>
 	restore_flags(flags);<br>
 <br>
 	outb(0x1,adapter[card]-&gt;ioport[SFT_RESET]); <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/isdn/sc/interrupt.c linux-2.3.99pre6-6/drivers/isdn/sc/interrupt.c<br>
--- linux-2.3.99pre6-6.orig/drivers/isdn/sc/interrupt.c	Wed Apr  1 19:21:04 1998<br>
+++ linux-2.3.99pre6-6/drivers/isdn/sc/interrupt.c	Tue Apr 25 22:52:13 2000<br>
@@ -180,11 +180,8 @@<br>
 			adapter[card]-&gt;EngineUp = 1;<br>
 			sendmessage(card, CEPID,ceReqTypeCall,ceReqClass0,ceReqCallGetMyNumber,1,0,NULL);<br>
 			sendmessage(card, CEPID,ceReqTypeCall,ceReqClass0,ceReqCallGetMyNumber,2,0,NULL);<br>
-			init_timer(&amp;adapter[card]-&gt;stat_timer);<br>
-			adapter[card]-&gt;stat_timer.function = check_phystat;<br>
-			adapter[card]-&gt;stat_timer.data = card;<br>
-			adapter[card]-&gt;stat_timer.expires = jiffies + CHECKSTAT_TIME;<br>
-			add_timer(&amp;adapter[card]-&gt;stat_timer);<br>
+			add_simple_timer( &amp;adapter[card]-&gt;stat_timer,<br>
+					  CHECKSTAT_TIME, card, check_phystat );<br>
 			continue;<br>
 		}<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/3c515.c linux-2.3.99pre6-6/drivers/net/3c515.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/3c515.c	Tue Apr 25 21:33:51 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/3c515.c	Tue Apr 25 22:51:59 2000<br>
@@ -742,11 +742,8 @@<br>
 			printk("%s: Initial media type %s.\n",<br>
 			       dev-&gt;name, media_tbl[dev-&gt;if_port].name);<br>
 <br>
-		init_timer(&amp;vp-&gt;timer);<br>
-		vp-&gt;timer.expires = RUN_AT(media_tbl[dev-&gt;if_port].wait);<br>
-		vp-&gt;timer.data = (unsigned long) dev;<br>
-		vp-&gt;timer.function = &amp;corkscrew_timer;	/* timer handler */<br>
-		add_timer(&amp;vp-&gt;timer);<br>
+		add_simple_timer( &amp;vp-&gt;timer, media_tbl[dev-&gt;if_port].wait,<br>
+				  (unsigned long) dev, &amp;corkscrew_timer );<br>
 	} else<br>
 		dev-&gt;if_port = vp-&gt;default_media;<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/3c59x.c linux-2.3.99pre6-6/drivers/net/3c59x.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/3c59x.c	Tue Apr 25 21:36:33 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/3c59x.c	Tue Apr 25 22:51:55 2000<br>
@@ -1072,11 +1072,8 @@<br>
 				dev-&gt;name, media_tbl[dev-&gt;if_port].name);<br>
 	}<br>
 <br>
-	init_timer(&amp;vp-&gt;timer);<br>
-	vp-&gt;timer.expires = RUN_AT(media_tbl[dev-&gt;if_port].wait);<br>
-	vp-&gt;timer.data = (unsigned long)dev;<br>
-	vp-&gt;timer.function = &amp;vortex_timer;		/* timer handler */<br>
-	add_timer(&amp;vp-&gt;timer);<br>
+	add_simple_timer( &amp;vp-&gt;timer,media_tbl[dev-&gt;if_port].wait,<br>
+			  (unsigned long)dev, &amp;vortex_timer );<br>
 <br>
 	if (vortex_debug &gt; 1)<br>
 		printk(KERN_DEBUG "%s: Initial media type %s.\n",<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/8139too.c linux-2.3.99pre6-6/drivers/net/8139too.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/8139too.c	Tue Apr 25 21:36:33 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/8139too.c	Tue Apr 25 22:51:59 2000<br>
@@ -945,11 +945,8 @@<br>
 <br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer (&amp;tp-&gt;timer);<br>
-	tp-&gt;timer.expires = jiffies + 3 * HZ;<br>
-	tp-&gt;timer.data = (unsigned long) dev;<br>
-	tp-&gt;timer.function = &amp;rtl8139_timer;<br>
-	add_timer (&amp;tp-&gt;timer);<br>
+	add_simple_timer( &amp;tp-&gt;timer, 3*HZ, (unsigned long) dev,<br>
+			  &amp;rtl8139_timer );<br>
 <br>
 	DPRINTK ("EXIT, returning 0\n");<br>
 	return 0;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/appletalk/cops.c linux-2.3.99pre6-6/drivers/net/appletalk/cops.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/appletalk/cops.c	Sat Mar 18 07:14:48 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/appletalk/cops.c	Tue Apr 25 22:51:59 2000<br>
@@ -411,11 +411,8 @@<br>
 		 */<br>
 		if(lp-&gt;board==TANGENT)	/* Poll 20 times per second */<br>
 		{<br>
-		    init_timer(&amp;cops_timer);<br>
-		    cops_timer.function = cops_poll;<br>
-		    cops_timer.data 	= (unsigned long)dev;<br>
-		    cops_timer.expires 	= jiffies + 5;<br>
-		    add_timer(&amp;cops_timer);<br>
+		    add_simple_timer( &amp;cops_timer, 5, (unsigned long)dev,<br>
+		    		      cops_poll );<br>
 		} <br>
 		else <br>
 		{<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/dmfe.c linux-2.3.99pre6-6/drivers/net/dmfe.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/dmfe.c	Tue Apr 25 21:33:17 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/dmfe.c	Tue Apr 25 22:52:00 2000<br>
@@ -499,11 +499,8 @@<br>
 	MOD_INC_USE_COUNT;<br>
 <br>
 	/* set and active a timer process */<br>
-	init_timer(&amp;db-&gt;timer);<br>
-	db-&gt;timer.expires = DMFE_TIMER_WUT;<br>
-	db-&gt;timer.data = (unsigned long) dev;<br>
-	db-&gt;timer.function = &amp;dmfe_timer;<br>
-	add_timer(&amp;db-&gt;timer);<br>
+	add_simple_timer( &amp;db-&gt;timer, DMFE_TIMER_WUT, (unsigned long) dev,<br>
+			  &amp;dmfe_timer );<br>
 	<br>
 	netif_wake_queue(dev);<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/eepro100.c linux-2.3.99pre6-6/drivers/net/eepro100.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/eepro100.c	Tue Apr 25 21:36:33 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/eepro100.c	Tue Apr 25 22:51:57 2000<br>
@@ -1021,11 +1021,8 @@<br>
 	   to an alternate media type<br>
 	   2) to monitor Rx activity, and restart the Rx process if the receiver<br>
 	   hangs. */<br>
-	init_timer(&amp;sp-&gt;timer);<br>
-	sp-&gt;timer.expires = RUN_AT((24*HZ)/10); 			/* 2.4 sec. */<br>
-	sp-&gt;timer.data = (unsigned long)dev;<br>
-	sp-&gt;timer.function = &amp;speedo_timer;					/* timer handler */<br>
-	add_timer(&amp;sp-&gt;timer);<br>
+	add_simple_timer( &amp;sp-&gt;timer, (24*HZ)/10, (unsigned long)dev,<br>
+			  &amp;speedo_timer );<br>
 <br>
 	/* No need to wait for the command unit to accept here. */<br>
 	if ((sp-&gt;phy[0] &amp; 0x8000) == 0)<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/epic100.c linux-2.3.99pre6-6/drivers/net/epic100.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/epic100.c	Tue Apr 25 21:33:51 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/epic100.c	Tue Apr 25 22:51:58 2000<br>
@@ -455,11 +455,7 @@<br>
 <br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;ep-&gt;timer);<br>
-	ep-&gt;timer.expires = RUN_AT(3*HZ);			/* 3 sec. */<br>
-	ep-&gt;timer.data = (unsigned long)dev;<br>
-	ep-&gt;timer.function = &amp;epic_timer;				/* timer handler */<br>
-	add_timer(&amp;ep-&gt;timer);<br>
+	add_simple_timer( &amp;ep-&gt;timer, 3*HZ, (unsigned long)dev, &amp;epic_timer );<br>
 <br>
 	return 0;<br>
 }<br>
Binary files linux-2.3.99pre6-6.orig/drivers/net/pcmcia/.ibmtr.o and linux-2.3.99pre6-6/drivers/net/pcmcia/.ibmtr.o differ<br>
Binary files linux-2.3.99pre6-6.orig/drivers/net/pcmcia/.ibmtr_cs.o and linux-2.3.99pre6-6/drivers/net/pcmcia/.ibmtr_cs.o differ<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/pcmcia/xircom_tulip_cb.c linux-2.3.99pre6-6/drivers/net/pcmcia/xircom_tulip_cb.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/pcmcia/xircom_tulip_cb.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/pcmcia/xircom_tulip_cb.c	Tue Apr 25 22:52:00 2000<br>
@@ -1465,11 +1465,8 @@<br>
 	}<br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;tp-&gt;timer);<br>
-	tp-&gt;timer.expires = RUN_AT(5*HZ);<br>
-	tp-&gt;timer.data = (unsigned long)dev;<br>
-	tp-&gt;timer.function = tulip_tbl[tp-&gt;chip_id].media_timer;<br>
-	add_timer(&amp;tp-&gt;timer);<br>
+	add_simple_timer( &amp;tp-&gt;timer, 5*HZ, (unsigned long)dev,<br>
+			  tulip_tbl[tp-&gt;chip_id].media_timer );<br>
 }<br>
 <br>
 static int<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/rcpci45.c linux-2.3.99pre6-6/drivers/net/rcpci45.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/rcpci45.c	Tue Apr 25 21:33:39 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/rcpci45.c	Tue Apr 25 22:51:59 2000<br>
@@ -580,11 +580,8 @@<br>
         RCDisableI2OInterrupts(pDpa-&gt;id);<br>
         RCShutdownLANCard(pDpa-&gt;id,0,0,0);<br>
         printk("rc: scheduling timer...\n");<br>
-        init_timer(&amp;pDpa-&gt;timer);<br>
-        pDpa-&gt;timer.expires = RUN_AT((40*HZ)/10); /* 4 sec. */<br>
-        pDpa-&gt;timer.data = (unsigned long)dev;<br>
-        pDpa-&gt;timer.function = &amp;rc_timer;    /* timer handler */<br>
-        add_timer(&amp;pDpa-&gt;timer);<br>
+        add_simple_timer( &amp;pDpa-&gt;timer, (40*HZ)/10, (unsigned long)dev,<br>
+			  &amp;rc_timer );<br>
     }<br>
 <br>
 <br>
@@ -883,11 +880,7 @@<br>
         else<br>
         {<br>
             printk("rc: rescheduling timer...\n");<br>
-            init_timer(&amp;pDpa-&gt;timer);<br>
-            pDpa-&gt;timer.expires = RUN_AT((40*HZ)/10); /* 3 sec. */<br>
-            pDpa-&gt;timer.data = (unsigned long)dev;<br>
-            pDpa-&gt;timer.function = &amp;rc_timer;    /* timer handler */<br>
-            add_timer(&amp;pDpa-&gt;timer);<br>
+            add_simple_timer( &amp;pDpa-&gt;timer, (40*HZ)/10, (unsigned long)dev, &amp;rc_timer );<br>
         }<br>
     }<br>
     else<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/rrunner.c linux-2.3.99pre6-6/drivers/net/rrunner.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/rrunner.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/rrunner.c	Tue Apr 25 22:51:59 2000<br>
@@ -1171,11 +1171,7 @@<br>
 <br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;rrpriv-&gt;timer);<br>
-	rrpriv-&gt;timer.expires = RUN_AT(5*HZ);           /* 5 sec. watchdog */<br>
-	rrpriv-&gt;timer.data = (unsigned long)dev;<br>
-	rrpriv-&gt;timer.function = &amp;rr_timer;               /* timer handler */<br>
-	add_timer(&amp;rrpriv-&gt;timer);<br>
+	add_simple_timer( &amp;rrpriv-&gt;timer, 5*HZ, (unsigned long)dev, &amp;rr_timer );<br>
 <br>
 	netif_start_queue(dev);<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/rtl8129.c linux-2.3.99pre6-6/drivers/net/rtl8129.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/rtl8129.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/rtl8129.c	Tue Apr 25 22:51:59 2000<br>
@@ -749,11 +749,8 @@<br>
 <br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;tp-&gt;timer);<br>
-	tp-&gt;timer.expires = RUN_AT((24*HZ)/10);			/* 2.4 sec. */<br>
-	tp-&gt;timer.data = (unsigned long)dev;<br>
-	tp-&gt;timer.function = &amp;rtl8129_timer;<br>
-	add_timer(&amp;tp-&gt;timer);<br>
+	add_simple_timer( &amp;tp-&gt;timer, (24*HZ)/10, (unsigned long)dev,<br>
+			  &amp;rtl8129_timer );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/sis900.c linux-2.3.99pre6-6/drivers/net/sis900.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/sis900.c	Tue Apr 25 21:33:39 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/sis900.c	Tue Apr 25 22:52:00 2000<br>
@@ -497,11 +497,8 @@<br>
 <br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;sis_priv-&gt;timer);<br>
-	sis_priv-&gt;timer.expires = jiffies + HZ;<br>
-	sis_priv-&gt;timer.data = (unsigned long)net_dev;<br>
-	sis_priv-&gt;timer.function = &amp;sis900_timer;<br>
-	add_timer(&amp;sis_priv-&gt;timer);<br>
+	add_simple_timer( &amp;sis_priv-&gt;timer, HZ, (unsigned long)net_dev,<br>
+			  &amp;sis900_timer );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/starfire.c linux-2.3.99pre6-6/drivers/net/starfire.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/starfire.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/starfire.c	Tue Apr 25 22:52:00 2000<br>
@@ -656,11 +656,8 @@<br>
 			   dev-&gt;name);<br>
 <br>
 	/* Set the timer to check for link beat. */<br>
-	init_timer(&amp;np-&gt;timer);<br>
-	np-&gt;timer.expires = RUN_AT(3*HZ);<br>
-	np-&gt;timer.data = (unsigned long)dev;<br>
-	np-&gt;timer.function = &amp;netdev_timer;				/* timer handler */<br>
-	add_timer(&amp;np-&gt;timer);<br>
+	add_simple_timer( &amp;np-&gt;timer, 3*HZ, (unsigned long)dev,<br>
+			  &amp;netdev_timer );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/tulip/tulip_core.c linux-2.3.99pre6-6/drivers/net/tulip/tulip_core.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/tulip/tulip_core.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/tulip/tulip_core.c	Tue Apr 25 22:51:58 2000<br>
@@ -387,11 +387,8 @@<br>
 	}<br>
 	/* Set the timer to switch to check for link beat and perhaps switch<br>
 	   to an alternate media type. */<br>
-	init_timer(&amp;tp-&gt;timer);<br>
-	tp-&gt;timer.expires = RUN_AT(next_tick);<br>
-	tp-&gt;timer.data = (unsigned long)dev;<br>
-	tp-&gt;timer.function = tulip_tbl[tp-&gt;chip_id].media_timer;<br>
-	add_timer(&amp;tp-&gt;timer);<br>
+	add_simple_timer( &amp;tp-&gt;timer, next_tick, (unsigned long)dev,<br>
+			  tulip_tbl[tp-&gt;chip_id].media_timer );<br>
 }<br>
 <br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/via-rhine.c linux-2.3.99pre6-6/drivers/net/via-rhine.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/via-rhine.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/via-rhine.c	Tue Apr 25 22:51:59 2000<br>
@@ -696,11 +696,7 @@<br>
 			   mdio_read(dev, np-&gt;phys[0], 1));<br>
 <br>
 	/* Set the timer to check for link beat. */<br>
-	init_timer(&amp;np-&gt;timer);<br>
-	np-&gt;timer.expires = RUN_AT(1);<br>
-	np-&gt;timer.data = (unsigned long)dev;<br>
-	np-&gt;timer.function = &amp;via_rhine_timer;				/* timer handler */<br>
-	add_timer(&amp;np-&gt;timer);<br>
+	add_simple_timer( &amp;np-&gt;timer, 1, (unsigned long)dev, &amp;via_rhine_timer );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/wan/comx-hw-locomx.c linux-2.3.99pre6-6/drivers/net/wan/comx-hw-locomx.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/wan/comx-hw-locomx.c	Tue Apr 25 21:33:18 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/wan/comx-hw-locomx.c	Tue Apr 25 22:51:54 2000<br>
@@ -224,11 +224,8 @@<br>
 <br>
 	comx_status(dev, ch-&gt;line_status);<br>
 <br>
-	init_timer(&amp;hw-&gt;status_timer);<br>
-	hw-&gt;status_timer.function=locomx_status_timerfun;<br>
-	hw-&gt;status_timer.data=(unsigned long)dev;<br>
-	hw-&gt;status_timer.expires=jiffies + ch-&gt;lineup_delay * HZ;<br>
-	add_timer(&amp;hw-&gt;status_timer);<br>
+	add_simple_timer( &amp;hw-&gt;status_timer, ch-&gt;lineup_delay*HZ,<br>
+			  (unsigned long)dev, locomx_status_timerfun );<br>
 <br>
 	for (; procfile ; procfile = procfile-&gt;next) {<br>
 		if (strcmp(procfile-&gt;name, FILENAME_IO) == 0 ||<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/wan/comx-proto-ppp.c linux-2.3.99pre6-6/drivers/net/wan/comx-proto-ppp.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/wan/comx-proto-ppp.c	Tue Apr 25 21:33:18 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/wan/comx-proto-ppp.c	Tue Apr 25 22:51:54 2000<br>
@@ -112,11 +112,8 @@<br>
 		sppp_open(dev);<br>
 	}<br>
 <br>
-	init_timer(&amp;spch-&gt;status_timer);<br>
-	spch-&gt;status_timer.function=syncppp_status_timerfun;<br>
-	spch-&gt;status_timer.data=(unsigned long)dev;<br>
-	spch-&gt;status_timer.expires=jiffies + HZ*3;<br>
-	add_timer(&amp;spch-&gt;status_timer);<br>
+	add_simple_timer( &amp;spch-&gt;status_timer, 3*HZ, (unsigned long)dev,<br>
+			  syncppp_status_timerfun );<br>
 	<br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/wan/lmc/lmc_main.c linux-2.3.99pre6-6/drivers/net/wan/lmc/lmc_main.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/wan/lmc/lmc_main.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/wan/lmc/lmc_main.c	Tue Apr 25 22:51:54 2000<br>
@@ -1299,11 +1299,7 @@<br>
      * Setup a timer for the watchdog on probe, and start it running.<br>
      * Since lmc_ok == 0, it will be a NOP for now.<br>
      */<br>
-    init_timer (&amp;sc-&gt;timer);<br>
-    sc-&gt;timer.expires = jiffies + HZ;<br>
-    sc-&gt;timer.data = (unsigned long) dev;<br>
-    sc-&gt;timer.function = &amp;lmc_watchdog;<br>
-    add_timer (&amp;sc-&gt;timer);<br>
+    add_simple_timer( &amp;sc-&gt;timer, HZ, (unsigned long) dev, &amp;lmc_watchdog );<br>
 <br>
     lmc_trace(dev, "lmc_open out");<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/net/yellowfin.c linux-2.3.99pre6-6/drivers/net/yellowfin.c<br>
--- linux-2.3.99pre6-6.orig/drivers/net/yellowfin.c	Tue Apr 25 21:36:34 2000<br>
+++ linux-2.3.99pre6-6/drivers/net/yellowfin.c	Tue Apr 25 22:51:58 2000<br>
@@ -483,11 +483,8 @@<br>
 			   dev-&gt;name);<br>
 	}<br>
 	/* Set the timer to check for link beat. */<br>
-	init_timer(&amp;yp-&gt;timer);<br>
-	yp-&gt;timer.expires = jiffies + 3*HZ;<br>
-	yp-&gt;timer.data = (unsigned long)dev;<br>
-	yp-&gt;timer.function = &amp;yellowfin_timer;				/* timer handler */<br>
-	add_timer(&amp;yp-&gt;timer);<br>
+	add_simple_timer( &amp;yp-&gt;timer, 3*HZ, (unsigned long)dev,<br>
+			  &amp;yellowfin_timer );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/scsi/aha152x.c linux-2.3.99pre6-6/drivers/scsi/aha152x.c<br>
--- linux-2.3.99pre6-6.orig/drivers/scsi/aha152x.c	Sat Mar 18 07:10:03 2000<br>
+++ linux-2.3.99pre6-6/drivers/scsi/aha152x.c	Tue Apr 25 22:52:05 2000<br>
@@ -1586,11 +1586,8 @@<br>
 	cmnd.request_buffer  = 0;<br>
 	cmnd.request_bufflen = 0;<br>
 <br>
-	init_timer(&amp;timer);<br>
-	timer.data     = (unsigned long) &amp;sem;<br>
-	timer.expires  = jiffies + 10000;   /* 10s */<br>
-	timer.function = (void (*)(unsigned long)) timer_expired;<br>
-	add_timer(&amp;timer);<br>
+	add_simple_timer( &amp;timer, 10000, (unsigned long) &amp;sem,<br>
+			  (void (*)(unsigned long)) timer_expired );<br>
 <br>
 	aha152x_internal_queue(&amp;cmnd, &amp;sem, resetting, 0, internal_done);<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/scsi/gdth.c linux-2.3.99pre6-6/drivers/scsi/gdth.c<br>
--- linux-2.3.99pre6-6.orig/drivers/scsi/gdth.c	Sat Mar 18 07:04:32 2000<br>
+++ linux-2.3.99pre6-6/drivers/scsi/gdth.c	Tue Apr 25 22:52:05 2000<br>
@@ -3329,11 +3329,7 @@<br>
     if (gdth_ctr_count &gt; 0) {<br>
 #ifdef GDTH_STATISTICS<br>
         TRACE2(("gdth_detect(): Initializing timer !\n"));<br>
-        init_timer(&amp;gdth_timer);<br>
-        gdth_timer.expires = jiffies + HZ;<br>
-        gdth_timer.data = 0L;<br>
-        gdth_timer.function = gdth_timeout;<br>
-        add_timer(&amp;gdth_timer);<br>
+        add_simple_timer( &amp;gdth_timer, HZ, 0L, gdth_timeout );<br>
 #endif<br>
         register_reboot_notifier(&amp;gdth_notifier);<br>
     }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/sound/cmpci.c linux-2.3.99pre6-6/drivers/sound/cmpci.c<br>
--- linux-2.3.99pre6-6.orig/drivers/sound/cmpci.c	Tue Apr 25 21:36:36 2000<br>
+++ linux-2.3.99pre6-6/drivers/sound/cmpci.c	Tue Apr 25 22:52:10 2000<br>
@@ -1997,11 +1997,8 @@<br>
 		if (!(inb(s-&gt;iomidi+1) &amp; 0x80))<br>
 			inb(s-&gt;iomidi);<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
-		init_timer(&amp;s-&gt;midi.timer);<br>
-		s-&gt;midi.timer.expires = jiffies+1;<br>
-		s-&gt;midi.timer.data = (unsigned long)s;<br>
-		s-&gt;midi.timer.function = cm_midi_timer;<br>
-		add_timer(&amp;s-&gt;midi.timer);<br>
+		add_simple_timer( &amp;s-&gt;midi.timer, 1, (unsigned long)s,<br>
+				  cm_midi_timer );<br>
 	}<br>
 	if (file-&gt;f_mode &amp; FMODE_READ) {<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/sound/esssolo1.c linux-2.3.99pre6-6/drivers/sound/esssolo1.c<br>
--- linux-2.3.99pre6-6.orig/drivers/sound/esssolo1.c	Tue Apr 25 21:36:37 2000<br>
+++ linux-2.3.99pre6-6/drivers/sound/esssolo1.c	Tue Apr 25 22:52:10 2000<br>
@@ -1853,11 +1853,8 @@<br>
 			inb(s-&gt;mpubase);<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
 		outb(0xb0, s-&gt;iobase + 7); /* enable A1, A2, MPU irq's */<br>
-		init_timer(&amp;s-&gt;midi.timer);<br>
-		s-&gt;midi.timer.expires = jiffies+1;<br>
-		s-&gt;midi.timer.data = (unsigned long)s;<br>
-		s-&gt;midi.timer.function = solo1_midi_timer;<br>
-		add_timer(&amp;s-&gt;midi.timer);<br>
+		add_simple_timer( &amp;s-&gt;midi.timer, 1, (unsigned long)s,<br>
+				  solo1_midi_timer );<br>
 	}<br>
 	if (file-&gt;f_mode &amp; FMODE_READ) {<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/sound/sonicvibes.c linux-2.3.99pre6-6/drivers/sound/sonicvibes.c<br>
--- linux-2.3.99pre6-6.orig/drivers/sound/sonicvibes.c	Tue Apr 25 21:36:37 2000<br>
+++ linux-2.3.99pre6-6/drivers/sound/sonicvibes.c	Tue Apr 25 22:52:10 2000<br>
@@ -2142,11 +2142,8 @@<br>
 		if (!(inb(s-&gt;iomidi+1) &amp; 0x80))<br>
 			inb(s-&gt;iomidi);<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
-		init_timer(&amp;s-&gt;midi.timer);<br>
-		s-&gt;midi.timer.expires = jiffies+1;<br>
-		s-&gt;midi.timer.data = (unsigned long)s;<br>
-		s-&gt;midi.timer.function = sv_midi_timer;<br>
-		add_timer(&amp;s-&gt;midi.timer);<br>
+		add_simple_timer( &amp;s-&gt;midi.timer, 1, (unsigned long)s, <br>
+				  sv_midi_timer );<br>
 	}<br>
 	if (file-&gt;f_mode &amp; FMODE_READ) {<br>
 		s-&gt;midi.ird = s-&gt;midi.iwr = s-&gt;midi.icnt = 0;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/sound/waveartist.c linux-2.3.99pre6-6/drivers/sound/waveartist.c<br>
--- linux-2.3.99pre6-6.orig/drivers/sound/waveartist.c	Tue Apr 25 21:33:20 2000<br>
+++ linux-2.3.99pre6-6/drivers/sound/waveartist.c	Tue Apr 25 22:52:10 2000<br>
@@ -1344,11 +1344,7 @@<br>
 	else {<br>
 #ifdef CONFIG_ARCH_NETWINDER<br>
 		if (machine_is_netwinder()) {<br>
-			init_timer(&amp;vnc_timer);<br>
-			vnc_timer.function = vnc_slider_tick;<br>
-			vnc_timer.expires  = jiffies;<br>
-			vnc_timer.data     = nr_waveartist_devs;<br>
-			add_timer(&amp;vnc_timer);<br>
+			add_simple_timer( &amp;vnc_timer, 0, nr_waveartist_devs, vnc_slider_tick );<br>
 <br>
 			vnc_configure_mixer(devc);<br>
 		}<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/usb/uhci.c linux-2.3.99pre6-6/drivers/usb/uhci.c<br>
--- linux-2.3.99pre6-6.orig/drivers/usb/uhci.c	Tue Apr 25 21:36:38 2000<br>
+++ linux-2.3.99pre6-6/drivers/usb/uhci.c	Tue Apr 25 22:52:18 2000<br>
@@ -1715,11 +1715,11 @@<br>
 	struct uhci *uhci = (struct uhci *)urb-&gt;dev-&gt;bus-&gt;hcpriv;<br>
 <br>
 	uhci-&gt;rh.interval = urb-&gt;interval;<br>
-	init_timer(&amp;uhci-&gt;rh.rh_int_timer);<br>
-	uhci-&gt;rh.rh_int_timer.function = rh_int_timer_do;<br>
-	uhci-&gt;rh.rh_int_timer.data = (unsigned long)urb;<br>
-	uhci-&gt;rh.rh_int_timer.expires = jiffies + (HZ * (urb-&gt;interval &lt; 30 ? 30 : urb-&gt;interval)) / 1000;<br>
-	add_timer(&amp;uhci-&gt;rh.rh_int_timer);<br>
+	add_simple_timer( &amp;uhci-&gt;rh.rh_int_timer,<br>
+			  (HZ * (urb-&gt;interval &lt; 30 ? <br>
+			   30 : <br>
+			   urb-&gt;interval)) / 1000,<br>
+			  (unsigned long)urb, rh_int_timer_do );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/usb/usb-uhci.c linux-2.3.99pre6-6/drivers/usb/usb-uhci.c<br>
--- linux-2.3.99pre6-6.orig/drivers/usb/usb-uhci.c	Tue Apr 25 21:34:13 2000<br>
+++ linux-2.3.99pre6-6/drivers/usb/usb-uhci.c	Tue Apr 25 22:52:18 2000<br>
@@ -1784,11 +1784,8 @@<br>
 	uhci_t *uhci = urb-&gt;dev-&gt;bus-&gt;hcpriv;<br>
 <br>
 	uhci-&gt;rh.interval = urb-&gt;interval;<br>
-	init_timer (&amp;uhci-&gt;rh.rh_int_timer);<br>
-	uhci-&gt;rh.rh_int_timer.function = rh_int_timer_do;<br>
-	uhci-&gt;rh.rh_int_timer.data = (unsigned long) urb;<br>
-	uhci-&gt;rh.rh_int_timer.expires = jiffies + (HZ * 20) / 1000;<br>
-	add_timer (&amp;uhci-&gt;rh.rh_int_timer);<br>
+	add_simple_timer( &amp;uhci-&gt;rh.rh_int_timer, (HZ*20)/1000,<br>
+			  (unsigned long) urb, rh_int_timer_do );<br>
 <br>
 	return 0;<br>
 }<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/video/imsttfb.c linux-2.3.99pre6-6/drivers/video/imsttfb.c<br>
--- linux-2.3.99pre6-6.orig/drivers/video/imsttfb.c	Sat Mar 18 07:01:15 2000<br>
+++ linux-2.3.99pre6-6/drivers/video/imsttfb.c	Tue Apr 25 22:52:15 2000<br>
@@ -983,11 +983,8 @@<br>
 <br>
 	if (curblink) {<br>
 		c-&gt;blink_rate = CURSOR_BLINK_RATE;<br>
-		init_timer(&amp;c-&gt;timer);<br>
-		c-&gt;timer.expires = jiffies + (HZ / 50);<br>
-		c-&gt;timer.data = (unsigned long)p;<br>
-		c-&gt;timer.function = imstt_cursor_timer_handler;<br>
-		add_timer(&amp;c-&gt;timer);<br>
+		add_simple_timer( &amp;c-&gt;timer, (HZ/50), (unsigned long)p,<br>
+				  imstt_cursor_timer_handler );<br>
 	}<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/video/sbusfb.c linux-2.3.99pre6-6/drivers/video/sbusfb.c<br>
--- linux-2.3.99pre6-6.orig/drivers/video/sbusfb.c	Sat Mar 18 07:00:06 2000<br>
+++ linux-2.3.99pre6-6/drivers/video/sbusfb.c	Tue Apr 25 22:52:15 2000<br>
@@ -1110,11 +1110,10 @@<br>
 		fb-&gt;dispsw.cursor = sbusfb_cursor;<br>
 		if (curblink) {<br>
 			fb-&gt;cursor.blink_rate = DEFAULT_CURSOR_BLINK_RATE;<br>
-			init_timer(&amp;fb-&gt;cursor.timer);<br>
-			fb-&gt;cursor.timer.expires = jiffies + fb-&gt;cursor.blink_rate;<br>
-			fb-&gt;cursor.timer.data = (unsigned long)fb;<br>
-			fb-&gt;cursor.timer.function = sbusfb_cursor_timer_handler;<br>
-			add_timer(&amp;fb-&gt;cursor.timer);<br>
+			add_simple_timer( &amp;fb-&gt;cursor.timer,<br>
+					  fb-&gt;cursor.blink_rate,<br>
+					  (unsigned long)fb,<br>
+					  sbusfb_cursor_timer_handler );<br>
 		}<br>
 	}<br>
 	fb-&gt;cursor.mode = CURSOR_SHAPE;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/drivers/video/sun3fb.c linux-2.3.99pre6-6/drivers/video/sun3fb.c<br>
--- linux-2.3.99pre6-6.orig/drivers/video/sun3fb.c	Sat Mar 18 07:09:07 2000<br>
+++ linux-2.3.99pre6-6/drivers/video/sun3fb.c	Tue Apr 25 22:52:16 2000<br>
@@ -654,11 +654,10 @@<br>
 		fb-&gt;dispsw.cursor = sun3fb_cursor;<br>
 		if (curblink) {<br>
 			fb-&gt;cursor.blink_rate = DEFAULT_CURSOR_BLINK_RATE;<br>
-			init_timer(&amp;fb-&gt;cursor.timer);<br>
-			fb-&gt;cursor.timer.expires = jiffies + fb-&gt;cursor.blink_rate;<br>
-			fb-&gt;cursor.timer.data = (unsigned long)fb;<br>
-			fb-&gt;cursor.timer.function = sun3fb_cursor_timer_handler;<br>
-			add_timer(&amp;fb-&gt;cursor.timer);<br>
+			add_simple_timer( &amp;fb-&gt;cursor.timer,<br>
+					  fb-&gt;cursor.blink_rate,<br>
+					  (unsigned long)fb,<br>
+					  sun3fb_cursor_timer_handler );<br>
 		}<br>
 	}<br>
 	fb-&gt;cursor.mode = CURSOR_SHAPE;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/include/linux/timer.h linux-2.3.99pre6-6/include/linux/timer.h<br>
--- linux-2.3.99pre6-6.orig/include/linux/timer.h	Tue Apr 25 21:36:42 2000<br>
+++ linux-2.3.99pre6-6/include/linux/timer.h	Tue Apr 25 22:57:58 2000<br>
@@ -61,7 +61,7 @@<br>
  * active timer (if the timer is inactive it will be activated)<br>
  * mod_timer(a,b) is equivalent to del_timer(a); a-&gt;expires = b; add_timer(a)<br>
  */<br>
-int mod_timer(struct timer_list *timer, unsigned long expires);<br>
+extern int mod_timer(struct timer_list *timer, unsigned long expires);<br>
 <br>
 extern void it_real_fn(unsigned long);<br>
 <br>
@@ -111,3 +111,14 @@<br>
 #define time_before_eq(a,b)	time_after_eq(b,a)<br>
 <br>
 #endif<br>
+<br>
+/**<br>
+ * add_simple_timer - performs a simple init_timer/add_timer cycle <br>
+ * @timer : allocated timer to add<br>
+ * @expires : timeout<br>
+ * @data : data field of the timer<br>
+ * @fn : timeout handler<br>
+ */<br>
+extern void add_simple_timer(struct timer_list *timer, unsigned long expires,<br>
+			     unsigned long data, void (* fn) );<br>
+<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/kernel/timer.c linux-2.3.99pre6-6/kernel/timer.c<br>
--- linux-2.3.99pre6-6.orig/kernel/timer.c	Tue Apr 25 21:36:43 2000<br>
+++ linux-2.3.99pre6-6/kernel/timer.c	Tue Apr 25 23:03:06 2000<br>
@@ -830,3 +830,14 @@<br>
 	return 0;<br>
 }<br>
 <br>
+void add_simple_timer(struct timer_list *timer, unsigned long expires,<br>
+                      unsigned long data, void (* fn) )<br>
+{<br>
+	init_timer(timer);<br>
+	timer-&gt;expires = jiffies + expires;<br>
+	timer-&gt;function = fn;<br>
+	timer-&gt;data = data;<br>
+	add_timer(timer);<br>
+}<br>
+<br>
+<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/appletalk/aarp.c linux-2.3.99pre6-6/net/appletalk/aarp.c<br>
--- linux-2.3.99pre6-6.orig/net/appletalk/aarp.c	Sat Mar 18 07:15:56 2000<br>
+++ linux-2.3.99pre6-6/net/appletalk/aarp.c	Tue Apr 25 22:51:48 2000<br>
@@ -1056,11 +1056,8 @@<br>
 {<br>
 	if ((aarp_dl = register_snap_client(aarp_snap_id, aarp_rcv)) == NULL)<br>
 		printk(KERN_CRIT "Unable to register AARP with SNAP.\n");<br>
-	init_timer(&amp;aarp_timer);<br>
-	aarp_timer.function = aarp_expire_timeout;<br>
-	aarp_timer.data = 0;<br>
-	aarp_timer.expires = jiffies + sysctl_aarp_expiry_time;<br>
-	add_timer(&amp;aarp_timer);<br>
+	add_simple_timer( &amp;aarp_timer, sysctl_aarp_expiry_time, 0, <br>
+			  aarp_expire_timeout );<br>
 	register_netdevice_notifier(&amp;aarp_notifier);<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/appletalk/ddp.c linux-2.3.99pre6-6/net/appletalk/ddp.c<br>
--- linux-2.3.99pre6-6.orig/net/appletalk/ddp.c	Tue Apr 25 21:36:43 2000<br>
+++ linux-2.3.99pre6-6/net/appletalk/ddp.c	Tue Apr 25 22:51:48 2000<br>
@@ -241,11 +241,8 @@<br>
 		sock_put(sk);<br>
 		MOD_DEC_USE_COUNT;<br>
 	} else {<br>
-		init_timer(&amp;sk-&gt;timer);<br>
-		sk-&gt;timer.expires = jiffies + SOCK_DESTROY_TIME;<br>
-		sk-&gt;timer.function = atalk_destroy_timer;<br>
-		sk-&gt;timer.data = (unsigned long) sk;<br>
-		add_timer(&amp;sk-&gt;timer);<br>
+		add_simple_timer( &amp;sk-&gt;timer, SOCK_DESTROY_TIME, <br>
+				  (unsigned long) sk, atalk_destroy_timer );<br>
 	}<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/atm/lec.c linux-2.3.99pre6-6/net/atm/lec.c<br>
--- linux-2.3.99pre6-6.orig/net/atm/lec.c	Tue Apr 25 21:36:43 2000<br>
+++ linux-2.3.99pre6-6/net/atm/lec.c	Tue Apr 25 22:51:53 2000<br>
@@ -1050,11 +1050,8 @@<br>
         for (i=0;i&lt;LEC_ARP_TABLE_SIZE;i++) {<br>
                 priv-&gt;lec_arp_tables[i] = NULL;<br>
         }        <br>
-        init_timer(&amp;priv-&gt;lec_arp_timer);<br>
-        priv-&gt;lec_arp_timer.expires = jiffies+LEC_ARP_REFRESH_INTERVAL;<br>
-        priv-&gt;lec_arp_timer.data = (unsigned long)priv;<br>
-        priv-&gt;lec_arp_timer.function = lec_arp_check_expire;<br>
-        add_timer(&amp;priv-&gt;lec_arp_timer);<br>
+        add_simple_timer( &amp;priv-&gt;lec_arp_timer, LEC_ARP_REFRESH_INTERVAL,<br>
+			  (unsigned long)priv, lec_arp_check_expire );<br>
 }<br>
 <br>
 void<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/ax25/af_ax25.c linux-2.3.99pre6-6/net/ax25/af_ax25.c<br>
--- linux-2.3.99pre6-6.orig/net/ax25/af_ax25.c	Tue Apr 25 21:36:43 2000<br>
+++ linux-2.3.99pre6-6/net/ax25/af_ax25.c	Tue Apr 25 22:51:48 2000<br>
@@ -433,11 +433,9 @@<br>
 		if (atomic_read(&amp;ax25-&gt;sk-&gt;wmem_alloc) != 0 ||<br>
 		    atomic_read(&amp;ax25-&gt;sk-&gt;rmem_alloc) != 0) {<br>
 			/* Defer: outstanding buffers */<br>
-			init_timer(&amp;ax25-&gt;timer);<br>
-			ax25-&gt;timer.expires  = jiffies + 10 * HZ;<br>
-			ax25-&gt;timer.function = ax25_destroy_timer;<br>
-			ax25-&gt;timer.data     = (unsigned long)ax25;<br>
-			add_timer(&amp;ax25-&gt;timer);<br>
+			add_simple_timer( &amp;ax25-&gt;timer, 10*HZ,<br>
+			                  (unsigned long)ax25, <br>
+					  ax25_destroy_timer );<br>
 		} else {<br>
 			sk_free(ax25-&gt;sk);<br>
 		}<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/core/sock.c linux-2.3.99pre6-6/net/core/sock.c<br>
--- linux-2.3.99pre6-6.orig/net/core/sock.c	Tue Apr 25 21:36:43 2000<br>
+++ linux-2.3.99pre6-6/net/core/sock.c	Tue Apr 25 22:51:49 2000<br>
@@ -955,11 +955,8 @@<br>
 		/*<br>
 		 *	Someone is using our buffers still.. defer<br>
 		 */<br>
-		init_timer(&amp;sk-&gt;timer);<br>
-		sk-&gt;timer.expires=jiffies+SOCK_DESTROY_TIME;<br>
-		sk-&gt;timer.function=sklist_destroy_timer;<br>
-		sk-&gt;timer.data = (unsigned long)sk;<br>
-		add_timer(&amp;sk-&gt;timer);<br>
+		add_simple_timer( &amp;sk-&gt;timer, SOCK_DESTROY_TIME,<br>
+				  (unsigned long)sk, sklist_destroy_timer );<br>
 	}<br>
 }<br>
 <br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/netrom/af_netrom.c linux-2.3.99pre6-6/net/netrom/af_netrom.c<br>
--- linux-2.3.99pre6-6.orig/net/netrom/af_netrom.c	Tue Apr 25 21:36:44 2000<br>
+++ linux-2.3.99pre6-6/net/netrom/af_netrom.c	Tue Apr 25 22:51:50 2000<br>
@@ -326,11 +326,8 @@<br>
 <br>
 	if (atomic_read(&amp;sk-&gt;wmem_alloc) != 0 || atomic_read(&amp;sk-&gt;rmem_alloc) != 0) {<br>
 		/* Defer: outstanding buffers */<br>
-		init_timer(&amp;sk-&gt;timer);<br>
-		sk-&gt;timer.expires  = jiffies + 10 * HZ;<br>
-		sk-&gt;timer.function = nr_destroy_timer;<br>
-		sk-&gt;timer.data     = (unsigned long)sk;<br>
-		add_timer(&amp;sk-&gt;timer);<br>
+		add_simple_timer( &amp;sk-&gt;timer, 10*HZ, <br>
+				  (unsigned long)sk, nr_destroy_timer );<br>
 	} else {<br>
 		nr_free_sock(sk);<br>
 	}<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/rose/af_rose.c linux-2.3.99pre6-6/net/rose/af_rose.c<br>
--- linux-2.3.99pre6-6.orig/net/rose/af_rose.c	Tue Apr 25 21:36:44 2000<br>
+++ linux-2.3.99pre6-6/net/rose/af_rose.c	Tue Apr 25 22:51:51 2000<br>
@@ -383,11 +383,8 @@<br>
 <br>
 	if (atomic_read(&amp;sk-&gt;wmem_alloc) != 0 || atomic_read(&amp;sk-&gt;rmem_alloc) != 0) {<br>
 		/* Defer: outstanding buffers */<br>
-		init_timer(&amp;sk-&gt;timer);<br>
-		sk-&gt;timer.expires  = jiffies + 10 * HZ;<br>
-		sk-&gt;timer.function = rose_destroy_timer;<br>
-		sk-&gt;timer.data     = (unsigned long)sk;<br>
-		add_timer(&amp;sk-&gt;timer);<br>
+		add_simple_timer( &amp;sk-&gt;timer, 10*HZ, (unsigned long)sk,<br>
+				  rose_destroy_timer );<br>
 	} else {<br>
 		rose_free_sock(sk);<br>
 	}<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/sched/estimator.c linux-2.3.99pre6-6/net/sched/estimator.c<br>
--- linux-2.3.99pre6-6.orig/net/sched/estimator.c	Sat Mar 18 06:42:39 2000<br>
+++ linux-2.3.99pre6-6/net/sched/estimator.c	Tue Apr 25 22:51:52 2000<br>
@@ -157,11 +157,9 @@<br>
 <br>
 	est-&gt;next = elist[est-&gt;interval].list;<br>
 	if (est-&gt;next == NULL) {<br>
-		init_timer(&amp;elist[est-&gt;interval].timer);<br>
-		elist[est-&gt;interval].timer.data = est-&gt;interval;<br>
-		elist[est-&gt;interval].timer.expires = jiffies + ((HZ/4)&lt;&lt;est-&gt;interval);<br>
-		elist[est-&gt;interval].timer.function = est_timer;<br>
-		add_timer(&amp;elist[est-&gt;interval].timer);<br>
+		add_simple_timer( &amp;elist[est-&gt;interval].timer,<br>
+				  (HZ/4)&lt;&lt;est-&gt;interval, est-&gt;interval,<br>
+				  est_timer );<br>
 	}<br>
 	write_lock_bh(&amp;est_lock);<br>
 	elist[est-&gt;interval].list = est;<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/sunrpc/sched.c linux-2.3.99pre6-6/net/sunrpc/sched.c<br>
--- linux-2.3.99pre6-6.orig/net/sunrpc/sched.c	Tue Apr 25 21:36:44 2000<br>
+++ linux-2.3.99pre6-6/net/sunrpc/sched.c	Tue Apr 25 22:51:52 2000<br>
@@ -114,11 +114,9 @@<br>
 	}<br>
 	if (!timer)<br>
 		timer = __rpc_default_timer;<br>
-	init_timer(&amp;task-&gt;tk_timer);<br>
-	task-&gt;tk_timer.expires  = jiffies + task-&gt;tk_timeout;<br>
-	task-&gt;tk_timer.data     = (unsigned long) task;<br>
-	task-&gt;tk_timer.function = (void (*)(unsigned long)) timer;<br>
-	add_timer(&amp;task-&gt;tk_timer);<br>
+	add_simple_timer( &amp;task-&gt;tk_timer, task-&gt;tk_timeout,<br>
+			  (unsigned long)task,<br>
+			  (void (*)(unsigned long)) timer );<br>
 }<br>
 <br>
 /*<br>
diff -u --recursive --new-file linux-2.3.99pre6-6.orig/net/x25/af_x25.c linux-2.3.99pre6-6/net/x25/af_x25.c<br>
--- linux-2.3.99pre6-6.orig/net/x25/af_x25.c	Tue Apr 25 21:36:44 2000<br>
+++ linux-2.3.99pre6-6/net/x25/af_x25.c	Tue Apr 25 22:51:51 2000<br>
@@ -332,11 +332,8 @@<br>
 <br>
 	if (atomic_read(&amp;sk-&gt;wmem_alloc) != 0 || atomic_read(&amp;sk-&gt;rmem_alloc) != 0) {<br>
 		/* Defer: outstanding buffers */<br>
-		init_timer(&amp;sk-&gt;timer);<br>
-		sk-&gt;timer.expires  = jiffies + 10 * HZ;<br>
-		sk-&gt;timer.function = x25_destroy_timer;<br>
-		sk-&gt;timer.data     = (unsigned long)sk;<br>
-		add_timer(&amp;sk-&gt;timer);<br>
+		add_simple_timer( &amp;sk-&gt;timer, 10*HZ, (unsigned long)sk,<br>
+				  x25_destroy_timer );<br>
 	} else {<br>
 		sk_free(sk);<br>
 		MOD_DEC_USE_COUNT;<br>
<p>
<pre>
-- 
Ueimor
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0422.html">Erik van Asselt: "Packet loss with kernel 2.3.99.pre6-3?"</a>
<li> <b>Previous message:</b> <a href="0420.html">Dimitris Michailidis: "Re: SCHED_RR is broken + patch"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
