<!-- received="Tue Apr 25 20:28:45 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 17:42:17 +0100" -->
<!-- name="Stephen C. Tweedie" -->
<!-- email="sct@redhat.com" -->
<!-- subject="[PATCH 2.3.99-pre6.5] Re: reading a raw device starting from end" -->
<!-- id="" -->
<!-- inreplyto="00042418214600.28901@fermat.vxindia.veritas.com" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH 2.3.99-pre6.5] Re: reading a raw device starting from end</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH 2.3.99-pre6.5] Re: reading a raw device starting from end</h1>
<b>Stephen C. Tweedie</b> (<a href="mailto:sct@redhat.com"><i>sct@redhat.com</i></a>)<br>
<i>Tue, 25 Apr 2000 17:42:17 +0100</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#366">[ date ]</a><a href="index.html#366">[ thread ]</a><a href="subject.html#366">[ subject ]</a><a href="author.html#366">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0367.html">Mike Porter: "Re: IDE/PIIX: Trouble with DMA - OOPS without"</a>
<li> <b>Previous message:</b> <a href="0365.html">Mr.Aphirak Jansang: "SO_SNDTIMEO,SO_RCVTIMEO is Linux Kernel Support?"</a>
<li> <b>In reply to:</b> <a href="0153.html">Amit S. Kale: "Re: reading a raw device starting from end"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--ikeVEW9yuYc//A+q<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
Hi,<br>
<p>
On Mon, Apr 24, 2000 at 06:16:03PM +0530, Amit S. Kale wrote:<br>
<i>&gt; </i><br>
<i>&gt; I later suggested ENXIO because that's the value solaris raw devices return</i><br>
<i>&gt; when trying to write beyond end. Solaris raw devices as well as block devices</i><br>
<i>&gt; return ENXIO.</i><br>
<p>
Right.  The patch below makes raw devices return -ENXIO on access at<br>
or beyond the EOF.  Linus, please apply.  There is precedent for<br>
ENXIO in this case, and it makes as much sense as any other error we<br>
might return.<br>
<p>
--Stephen<br>
<p>
--ikeVEW9yuYc//A+q<br>
Content-Type: text/plain; charset=us-ascii<br>
Content-Disposition: attachment; filename="raw-enxio.diff"<br>
<p>
--- drivers/char/raw.c.~1~	Wed Mar 29 22:35:19 2000<br>
+++ drivers/char/raw.c	Tue Apr 25 15:37:35 2000<br>
@@ -274,8 +274,12 @@<br>
 	<br>
 	if ((*offp &amp; sector_mask) || (size &amp; sector_mask))<br>
 		return -EINVAL;<br>
-	if ((*offp &gt;&gt; sector_bits) &gt; limit)<br>
+	if ((*offp &gt;&gt; sector_bits) &gt;= limit) {<br>
+		if (size) {<br>
+			return -ENXIO;<br>
+		}<br>
 		return 0;<br>
+	}<br>
 <br>
 	/* <br>
 	 * We'll just use one kiobuf<br>
<p>
--ikeVEW9yuYc//A+q--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0367.html">Mike Porter: "Re: IDE/PIIX: Trouble with DMA - OOPS without"</a>
<li> <b>Previous message:</b> <a href="0365.html">Mr.Aphirak Jansang: "SO_SNDTIMEO,SO_RCVTIMEO is Linux Kernel Support?"</a>
<li> <b>In reply to:</b> <a href="0153.html">Amit S. Kale: "Re: reading a raw device starting from end"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
