<!-- received="Tue Apr 25 16:05:52 2000 EET DST" -->
<!-- sent="Tue, 25 Apr 2000 14:00:40 +0100 (BST)" -->
<!-- name="Tigran Aivazian" -->
<!-- email="tigran@veritas.com" -->
<!-- subject="[patch-2.3.99-pre6-6] SMP-threaded vmalloc() and friends." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 2000-17,: [patch-2.3.99-pre6-6] SMP-threaded vmalloc() and friends.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch-2.3.99-pre6-6] SMP-threaded vmalloc() and friends.</h1>
<b>Tigran Aivazian</b> (<a href="mailto:tigran@veritas.com"><i>tigran@veritas.com</i></a>)<br>
<i>Tue, 25 Apr 2000 14:00:40 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#320">[ date ]</a><a href="index.html#320">[ thread ]</a><a href="subject.html#320">[ subject ]</a><a href="author.html#320">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0321.html">Andrew Morton: "Re: [patch] drivers/net/3c59x.c"</a>
<li> <b>Previous message:</b> <a href="0319.html">Martin Mares: "Re: [PATCH] Generic dead function optimisation"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi Linus,<br>
<p>
This patch does:<br>
<p>
1) protects vmlist by a rw spinlock, thereby making vmalloc/vfree/ioremap<br>
   re-entrant.<br>
<p>
2) illustrates the benefit of doing 1) by removing lock/unlock_kernel from<br>
   ipc_alloc/free in ipc/util.c and fixing a bug in<br>
   fs/proc/kcore.c:read_kcore() which I introduced (and commented!) there<br>
   ages ago (because it needed to walk through vmlist so I tried to<br>
   "soften" it somewhat by using atomic kmalloc allocation but on SMP that<br>
   was obviously not good enough).<br>
<p>
Please consider it - against 2.3.99-pre6-6. A copy is on:<br>
<p>
<a href="http://www.ocston.org/~tigran/patches/vmalloc-2.3.99-pre6-6.patch">http://www.ocston.org/~tigran/patches/vmalloc-2.3.99-pre6-6.patch</a><br>
<p>
regards,<br>
Tigran<br>
<p>
diff -urN -X dontdiff linux/drivers/char/mem.c vmalloc/drivers/char/mem.c<br>
--- linux/drivers/char/mem.c	Wed Apr 12 09:09:20 2000<br>
+++ vmalloc/drivers/char/mem.c	Tue Apr 25 13:50:50 2000<br>
@@ -231,7 +231,8 @@<br>
 {<br>
 	unsigned long p = *ppos;<br>
 	ssize_t read = 0;<br>
-	ssize_t virtr;<br>
+	ssize_t virtr = 0;<br>
+	char * kbuf; /* k-addr because vread() takes vmlist_lock rwlock */<br>
 		<br>
 	if (p &lt; (unsigned long) high_memory) { <br>
 		read = count;<br>
@@ -258,11 +259,27 @@<br>
 		count -= read;<br>
 	}<br>
 <br>
-	virtr = vread(buf, (char *)p, count);<br>
-	if (virtr &lt; 0)<br>
-		return virtr;<br>
-	*ppos += p + virtr;<br>
-	return virtr + read;<br>
+	kbuf = (char *)get_free_page(GFP_KERNEL);<br>
+	if (!kbuf)<br>
+		return -ENOMEM;<br>
+	while (count &gt; 0) {<br>
+		int len = count;<br>
+<br>
+		if (len &gt; PAGE_SIZE)<br>
+			len = PAGE_SIZE;<br>
+		len = vread(kbuf, (char *)p, len); /* always &gt;= 0 */<br>
+		if (len &amp;&amp; copy_to_user(buf, kbuf, len)) {<br>
+			free_page((unsigned long)kbuf);<br>
+			return -EFAULT;<br>
+		}<br>
+		count -= len;<br>
+		buf += len;<br>
+		virtr += len;<br>
+		p += len;<br>
+	}<br>
+	free_page((unsigned long)kbuf);<br>
+ 	*ppos += p + virtr;<br>
+ 	return virtr + read;<br>
 }<br>
 <br>
 /*<br>
diff -urN -X dontdiff linux/fs/proc/kcore.c vmalloc/fs/proc/kcore.c<br>
--- linux/fs/proc/kcore.c	Sun Feb 27 04:33:07 2000<br>
+++ vmalloc/fs/proc/kcore.c	Tue Apr 25 11:39:30 2000<br>
@@ -315,13 +315,12 @@<br>
 	size_t elf_buflen;<br>
 	int num_vma;<br>
 <br>
-	/* XXX we need to somehow lock vmlist between here<br>
-	 * and after elf_kcore_store_hdr() returns.<br>
-	 * For now assume that num_vma does not change (TA)<br>
-	 */<br>
+	read_lock(&amp;vmlist_lock);<br>
 	proc_root_kcore-&gt;size = size = get_kcore_size(&amp;num_vma, &amp;elf_buflen);<br>
-	if (buflen == 0 || *fpos &gt;= size)<br>
+	if (buflen == 0 || *fpos &gt;= size) {<br>
+		read_unlock(&amp;vmlist_lock);<br>
 		return 0;<br>
+	}<br>
 <br>
 	/* trim buflen to not go beyond EOF */<br>
 	if (buflen &gt; size - *fpos)<br>
@@ -335,10 +334,13 @@<br>
 		if (buflen &lt; tsz)<br>
 			tsz = buflen;<br>
 		elf_buf = kmalloc(elf_buflen, GFP_ATOMIC);<br>
-		if (!elf_buf)<br>
+		if (!elf_buf) {<br>
+			read_unlock(&amp;vmlist_lock);<br>
 			return -ENOMEM;<br>
+		}<br>
 		memset(elf_buf, 0, elf_buflen);<br>
 		elf_kcore_store_hdr(elf_buf, num_vma, elf_buflen);<br>
+		read_unlock(&amp;vmlist_lock);<br>
 		if (copy_to_user(buffer, elf_buf + *fpos, tsz)) {<br>
 			kfree(elf_buf);<br>
 			return -EFAULT;<br>
@@ -352,7 +354,8 @@<br>
 		/* leave now if filled buffer already */<br>
 		if (buflen == 0)<br>
 			return acc;<br>
-	}<br>
+	} else<br>
+		read_unlock(&amp;vmlist_lock);<br>
 <br>
 	/* where page 0 not mapped, write zeros into buffer */<br>
 #if defined (__i386__) || defined (__mc68000__)<br>
diff -urN -X dontdiff linux/include/linux/vmalloc.h vmalloc/include/linux/vmalloc.h<br>
--- linux/include/linux/vmalloc.h	Sat Mar 18 20:11:01 2000<br>
+++ vmalloc/include/linux/vmalloc.h	Tue Apr 25 11:17:57 2000<br>
@@ -3,6 +3,7 @@<br>
 <br>
 #include &lt;linux/sched.h&gt;<br>
 #include &lt;linux/mm.h&gt;<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
 #include &lt;asm/pgtable.h&gt;<br>
 <br>
@@ -24,6 +25,11 @@<br>
 void vmfree_area_pages(unsigned long address, unsigned long size);<br>
 int vmalloc_area_pages(unsigned long address, unsigned long size);<br>
 <br>
+/* vmlist_lock is a read-write spinlock that protects vmlist <br>
+ * Used in mm/vmalloc.c and fs/proc/kcore.c.<br>
+ */<br>
+extern rwlock_t vmlist_lock;<br>
+ <br>
 extern struct vm_struct * vmlist;<br>
 #endif<br>
 <br>
diff -urN -X dontdiff linux/ipc/util.c vmalloc/ipc/util.c<br>
--- linux/ipc/util.c	Wed Mar  8 17:16:24 2000<br>
+++ vmalloc/ipc/util.c	Tue Apr 25 11:18:45 2000<br>
@@ -159,25 +159,19 @@<br>
 void* ipc_alloc(int size)<br>
 {<br>
 	void* out;<br>
-	if(size &gt; PAGE_SIZE) {<br>
-		lock_kernel();<br>
+	if(size &gt; PAGE_SIZE)<br>
 		out = vmalloc(size);<br>
-		unlock_kernel();<br>
-	} else {<br>
+	else<br>
 		out = kmalloc(size, GFP_KERNEL);<br>
-	}<br>
 	return out;<br>
 }<br>
 <br>
 void ipc_free(void* ptr, int size)<br>
 {<br>
-	if(size &gt; PAGE_SIZE) {<br>
-		lock_kernel();<br>
+	if(size &gt; PAGE_SIZE)<br>
 		vfree(ptr);<br>
-		unlock_kernel();<br>
-	} else {<br>
+	else<br>
 		kfree(ptr);<br>
-	}<br>
 }<br>
 <br>
 /* <br>
diff -urN -X dontdiff linux/mm/vmalloc.c vmalloc/mm/vmalloc.c<br>
--- linux/mm/vmalloc.c	Fri Mar 24 11:01:34 2000<br>
+++ vmalloc/mm/vmalloc.c	Tue Apr 25 11:23:15 2000<br>
@@ -3,14 +3,17 @@<br>
  *<br>
  *  Copyright (C) 1993  Linus Torvalds<br>
  *  Support of BIGMEM added by Gerhard Wichert, Siemens AG, July 1999<br>
+ *  SMP-threaded vmalloc/vfree/ioremap, Tigran Aivazian &lt;<a href="mailto:tigran@veritas.com">tigran@veritas.com</a>&gt;, Apr 2000<br>
  */<br>
 <br>
 #include &lt;linux/malloc.h&gt;<br>
 #include &lt;linux/vmalloc.h&gt;<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/pgalloc.h&gt;<br>
 <br>
+rwlock_t vmlist_lock = RW_LOCK_UNLOCKED;<br>
 struct vm_struct * vmlist = NULL;<br>
 <br>
 static inline void free_area_pte(pmd_t * pmd, unsigned long address, unsigned long size)<br>
@@ -163,11 +166,13 @@<br>
 	if (!area)<br>
 		return NULL;<br>
 	addr = VMALLOC_START;<br>
+	write_lock(&amp;vmlist_lock);<br>
 	for (p = &amp;vmlist; (tmp = *p) ; p = &amp;tmp-&gt;next) {<br>
 		if (size + addr &lt; (unsigned long) tmp-&gt;addr)<br>
 			break;<br>
 		addr = tmp-&gt;size + (unsigned long) tmp-&gt;addr;<br>
 		if (addr &gt; VMALLOC_END-size) {<br>
+			write_unlock(&amp;vmlist_lock);<br>
 			kfree(area);<br>
 			return NULL;<br>
 		}<br>
@@ -177,6 +182,7 @@<br>
 	area-&gt;size = size + PAGE_SIZE;<br>
 	area-&gt;next = *p;<br>
 	*p = area;<br>
+	write_unlock(&amp;vmlist_lock);<br>
 	return area;<br>
 }<br>
 <br>
@@ -190,14 +196,17 @@<br>
 		printk(KERN_ERR "Trying to vfree() bad address (%p)\n", addr);<br>
 		return;<br>
 	}<br>
+	write_lock(&amp;vmlist_lock);<br>
 	for (p = &amp;vmlist ; (tmp = *p) ; p = &amp;tmp-&gt;next) {<br>
 		if (tmp-&gt;addr == addr) {<br>
 			*p = tmp-&gt;next;<br>
 			vmfree_area_pages(VMALLOC_VMADDR(tmp-&gt;addr), tmp-&gt;size);<br>
 			kfree(tmp);<br>
+			write_unlock(&amp;vmlist_lock);<br>
 			return;<br>
 		}<br>
 	}<br>
+	write_unlock(&amp;vmlist_lock);<br>
 	printk(KERN_ERR "Trying to vfree() nonexistent vm area (%p)\n", addr);<br>
 }<br>
 <br>
@@ -235,6 +244,7 @@<br>
 	if ((unsigned long) addr + count &lt; count)<br>
 		count = -(unsigned long) addr;<br>
 <br>
+	read_lock(&amp;vmlist_lock);<br>
 	for (tmp = vmlist; tmp; tmp = tmp-&gt;next) {<br>
 		vaddr = (char *) tmp-&gt;addr;<br>
 		if (addr &gt;= vaddr + tmp-&gt;size - PAGE_SIZE)<br>
@@ -242,7 +252,7 @@<br>
 		while (addr &lt; vaddr) {<br>
 			if (count == 0)<br>
 				goto finished;<br>
-			put_user('\0', buf);<br>
+			*buf = '\0';<br>
 			buf++;<br>
 			addr++;<br>
 			count--;<br>
@@ -251,12 +261,13 @@<br>
 		do {<br>
 			if (count == 0)<br>
 				goto finished;<br>
-			put_user(*addr, buf);<br>
+			*buf = *addr;<br>
 			buf++;<br>
 			addr++;<br>
 			count--;<br>
 		} while (--n &gt; 0);<br>
 	}<br>
 finished:<br>
+	read_unlock(&amp;vmlist_lock);<br>
 	return buf - buf_start;<br>
 }<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0321.html">Andrew Morton: "Re: [patch] drivers/net/3c59x.c"</a>
<li> <b>Previous message:</b> <a href="0319.html">Martin Mares: "Re: [PATCH] Generic dead function optimisation"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
