<!-- received="Mon Apr 24 18:42:09 2000 EET DST" -->
<!-- sent="Mon, 24 Apr 2000 16:38:40 +0100 (BST)" -->
<!-- name="Tigran Aivazian" -->
<!-- email="tigran@veritas.com" -->
<!-- subject="(updated) Re: [patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd()" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.10.10004231803020.1372-100000@penguin.transmeta.com" -->
<title>Linux-kernel mailing list archive 2000-17,: (updated) Re: [patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd()</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>(updated) Re: [patch-2.3.99-pre6-5] __put_unused_fd()/put_unused_fd()</h1>
<b>Tigran Aivazian</b> (<a href="mailto:tigran@veritas.com"><i>tigran@veritas.com</i></a>)<br>
<i>Mon, 24 Apr 2000 16:38:40 +0100 (BST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#174">[ date ]</a><a href="index.html#174">[ thread ]</a><a href="subject.html#174">[ subject ]</a><a href="author.html#174">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0175.html">Michael Ivanov: "IDE problems in 2.2.14"</a>
<li> <b>Previous message:</b> <a href="0173.html">scott.ashcroft@talk21.com: "Major packet loss with eepro10 in 2.3.99-pre5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, 23 Apr 2000, Linus Torvalds wrote:<br>
<i>&gt; This is insane.</i><br>
<i>&gt; </i><br>
<i>&gt; It makes no sense to pass in "tsk". If you want to mess with somebodys</i><br>
<i>&gt; files, you pass in "struct files_struct", not "struct task_struct". Which</i><br>
<i>&gt; would clean up the code more, anyway.</i><br>
<i>&gt; </i><br>
<i>&gt; 		Linus</i><br>
<p>
yes, you are right - struct task_struct is one extra level of abstraction<br>
away so passing 'struct files_struct' doesn't restrict being as generic as<br>
possible.<br>
<p>
Patch remade, tested and attached. Also, I removed declarations of<br>
connecting_fifo_ops and floppy_is_wp() from &lt;linux/fs.h&gt; as they are not<br>
needed (any more).<br>
<p>
Regards,<br>
Tigran<br>
<p>
<p>
diff -urN -X dontdiff linux/fs/open.c doclose/fs/open.c<br>
--- linux/fs/open.c	Sat Apr 22 10:30:24 2000<br>
+++ doclose/fs/open.c	Mon Apr 24 16:17:40 2000<br>
@@ -756,13 +756,20 @@<br>
 	return error;<br>
 }<br>
 <br>
+inline void __put_unused_fd(struct files_struct *files, unsigned int fd)<br>
+{<br>
+	FD_CLR(fd, files-&gt;open_fds);<br>
+	if (fd &lt; files-&gt;next_fd)<br>
+		files-&gt;next_fd = fd;<br>
+}<br>
+<br>
 inline void put_unused_fd(unsigned int fd)<br>
 {<br>
-	write_lock(&amp;current-&gt;files-&gt;file_lock);<br>
-	FD_CLR(fd, current-&gt;files-&gt;open_fds);<br>
-	if (fd &lt; current-&gt;files-&gt;next_fd)<br>
-		current-&gt;files-&gt;next_fd = fd;<br>
-	write_unlock(&amp;current-&gt;files-&gt;file_lock);<br>
+	struct files_struct *files = current-&gt;files;<br>
+<br>
+	write_lock(&amp;files-&gt;file_lock);<br>
+	__put_unused_fd(files, fd);<br>
+	write_unlock(&amp;files-&gt;file_lock);<br>
 }<br>
 <br>
 asmlinkage long sys_open(const char * filename, int flags, int mode)<br>
@@ -852,9 +859,9 @@<br>
 	if (!filp)<br>
 		goto out_unlock;<br>
 	FD_CLR(fd, files-&gt;close_on_exec);<br>
-	write_unlock(&amp;files-&gt;file_lock);<br>
 	if (release)<br>
-		put_unused_fd(fd);<br>
+		__put_unused_fd(files, fd);<br>
+	write_unlock(&amp;files-&gt;file_lock);<br>
 	lock_kernel();<br>
 	error = filp_close(filp, files);<br>
 	unlock_kernel();<br>
diff -urN -X dontdiff linux/include/linux/fs.h doclose/include/linux/fs.h<br>
--- linux/include/linux/fs.h	Sat Apr 22 10:30:25 2000<br>
+++ doclose/include/linux/fs.h	Mon Apr 24 16:29:33 2000<br>
@@ -848,7 +848,8 @@<br>
 extern int do_close(unsigned int, int);		/* yes, it's really unsigned */<br>
 extern int do_truncate(struct dentry *, loff_t start);<br>
 extern int get_unused_fd(void);<br>
-extern void put_unused_fd(unsigned int);<br>
+extern void __put_unused_fd(struct files_struct *, unsigned int); /* locked outside */<br>
+extern void put_unused_fd(unsigned int);                          /* locked inside */<br>
 <br>
 extern struct file *filp_open(const char *, int, int);<br>
 extern struct file * dentry_open(struct dentry *, struct vfsmount *, int);<br>
@@ -886,7 +887,6 @@<br>
 extern void make_bad_inode(struct inode *);<br>
 extern int is_bad_inode(struct inode *);<br>
 <br>
-extern struct file_operations connecting_fifo_fops;<br>
 extern struct file_operations read_fifo_fops;<br>
 extern struct file_operations write_fifo_fops;<br>
 extern struct file_operations rdwr_fifo_fops;<br>
@@ -955,7 +955,6 @@<br>
 #define invalidate_buffers(dev)	__invalidate_buffers((dev), 0)<br>
 #define destroy_buffers(dev)	__invalidate_buffers((dev), 1)<br>
 extern void __invalidate_buffers(kdev_t dev, int);<br>
-extern int floppy_is_wp(int);<br>
 extern void sync_inodes(kdev_t);<br>
 extern void write_inode_now(struct inode *);<br>
 extern void sync_dev(kdev_t);<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0175.html">Michael Ivanov: "IDE problems in 2.2.14"</a>
<li> <b>Previous message:</b> <a href="0173.html">scott.ashcroft@talk21.com: "Major packet loss with eepro10 in 2.3.99-pre5"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
