<!-- received="Mon Apr 24 15:20:31 2000 EET DST" -->
<!-- sent="Mon, 24 Apr 2000 17:48:12 +0530" -->
<!-- name="Amit S. Kale" -->
<!-- email="akale@veritas.com" -->
<!-- subject="Re: reading a raw device starting from end" -->
<!-- id="00042417492700.28619@fermat.vxindia.veritas.com" -->
<!-- inreplyto="00042117302500.18537@fermat.vxindia.veritas.com" -->
<title>Linux-kernel mailing list archive 2000-17,: Re: reading a raw device starting from end</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: reading a raw device starting from end</h1>
<b>Amit S. Kale</b> (<a href="mailto:akale@veritas.com"><i>akale@veritas.com</i></a>)<br>
<i>Mon, 24 Apr 2000 17:48:12 +0530</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#144">[ date ]</a><a href="index.html#144">[ thread ]</a><a href="subject.html#144">[ subject ]</a><a href="author.html#144">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0145.html">Jamie Lokier: "Re: patch: signed char issues"</a>
<li> <b>Previous message:</b> <a href="0143.html">Benno Senoner: "Re: IDE drives and unmaskirq"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0148.html">Jamie Lokier: "Re: reading a raw device starting from end"</a>
<li> <b>Reply:</b> <a href="0148.html">Jamie Lokier: "Re: reading a raw device starting from end"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I suggest following patch to raw.c<br>
<p>
--- drivers/char/raw.c  Tue Mar 28 11:56:08 2000<br>
+++ raw.c       Mon Apr 24 17:44:38 2000<br>
@@ -274,8 +274,12 @@<br>
<p>
        if ((*offp &amp; sector_mask) || (size &amp; sector_mask))<br>
                return -EINVAL;<br>
-       if ((*offp &gt;&gt; sector_bits) &gt; limit)<br>
+       if ((*offp &gt;&gt; sector_bits) &gt;limit) {<br>
+               if (size) {<br>
+                       return -ENXIO;<br>
+               }<br>
                return 0;<br>
+       }<br>
<p>
        /*<br>
         * We'll just use one kiobuf <br>
<p>
<p>
Thanks.<br>
On Fri, 21 Apr 2000, Amit S. Kale wrote:<br>
<i>&gt; On Fri, 21 Apr 2000, Stephen C. Tweedie wrote:</i><br>
<i>&gt; &gt; Hi,</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; On Fri, Apr 21, 2000 at 04:30:28PM +0530, Amit S. Kale wrote:</i><br>
<i>&gt; &gt; &gt; </i><br>
<i>&gt; &gt; &gt; Reading a raw device starting from end returns 0. </i><br>
<i>&gt; &gt; &gt; If you do a 'dd' to a raw device without specifying count of blocks, it writes</i><br>
<i>&gt; &gt; &gt; to the end. After this write returns 0 which causes dd to retry the write ( Not</i><br>
<i>&gt; &gt; &gt; sure why dd retries write ) Thus dd falls into an infinite loop.</i><br>
<i>&gt; &gt; &gt; </i><br>
<i>&gt; &gt; &gt; This does not happen on a block device as writing starting from end returns</i><br>
<i>&gt; &gt; &gt; ENOSPC</i><br>
<i>&gt; &gt; &gt; </i><br>
<i>&gt; &gt; &gt; Should this be considered as a bug in dd or incorrect behavior of raw device</i><br>
<i>&gt; &gt; &gt; driver?</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; I don't know.  POSIX certainly doesn't specify exactly what to do in</i><br>
<i>&gt; &gt; this case.  I never use "dd" on raw devices, as (at least on Linux) it</i><br>
<i>&gt; &gt; does not align its buffers correctly,</i><br>
<i>&gt; </i><br>
<i>&gt; Other unixes use bounce buffers so alignment is not required.</i><br>
<i>&gt; dd in RH6.2 apparently uses page aligned buffers.</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; but "lmdd" does not have the </i><br>
<i>&gt; &gt; problem you describe: it terminates correctly after a short write.</i><br>
<i>&gt; &gt;</i><br>
<i>&gt; &gt; Do you know what other Unixen return in this case?   </i><br>
<i>&gt; </i><br>
<i>&gt; I checked behaviors on solaris. Both dd and raw devices behave differently</i><br>
<i>&gt; there.</i><br>
<i>&gt; </i><br>
<i>&gt; 1. dd on solaris terminates if number of bytes written are less then</i><br>
<i>&gt; request. The shown by dd is is error 'unexpected short write'  </i><br>
<i>&gt; This happens when a write starts before end of a device and extends beyond it.</i><br>
<i>&gt; dd on linux is certainly buggy.</i><br>
<i>&gt; </i><br>
<i>&gt; 2. raw device returns ENXIO when writing  to a raw device starting from end of</i><br>
<i>&gt; the device.</i><br>
<i>&gt; </i><br>
<i>&gt; -- </i><br>
<i>&gt; Amit Kale</i><br>
<i>&gt; Veritas Software ( <a href="http://www.veritas.com">http://www.veritas.com</a> )</i><br>
<pre>
-- 
Amit Kale
Veritas Software ( <a href="http://www.veritas.com">http://www.veritas.com</a> )
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0145.html">Jamie Lokier: "Re: patch: signed char issues"</a>
<li> <b>Previous message:</b> <a href="0143.html">Benno Senoner: "Re: IDE drives and unmaskirq"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0148.html">Jamie Lokier: "Re: reading a raw device starting from end"</a>
<li> <b>Reply:</b> <a href="0148.html">Jamie Lokier: "Re: reading a raw device starting from end"</a>
<!-- reply="end" -->
</ul>
</font></body>
