<!-- received="Mon Apr 24 04:28:10 2000 EET DST" -->
<!-- sent="Sun, 23 Apr 2000 20:17:06 -0500" -->
<!-- name="Oliver Xymoron" -->
<!-- email="oxymoron@waste.org" -->
<!-- subject="Testers wanted! (was Re: "movb" for spin-unlock)" -->
<!-- id="" -->
<!-- inreplyto="20000424002732.P4758@ostenfeld.dk" -->
<title>Linux-kernel mailing list archive 2000-17,: Testers wanted! (was Re: "movb" for spin-unlock)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Testers wanted! (was Re: "movb" for spin-unlock)</h1>
<b>Oliver Xymoron</b> (<a href="mailto:oxymoron@waste.org"><i>oxymoron@waste.org</i></a>)<br>
<i>Sun, 23 Apr 2000 20:17:06 -0500</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#104">[ date ]</a><a href="index.html#104">[ thread ]</a><a href="subject.html#104">[ subject ]</a><a href="author.html#104">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0105.html">Andrew Morton: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Previous message:</b> <a href="0103.html">Guest section DW: "Re: Possible bug in the floppy driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, 23 Apr 2000, [iso-8859-1] Jakob stergaard wrote:<br>
<p>
<i>&gt; On Sun, 23 Apr 2000, Oliver Xymoron wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; Below is Manfred's lock test code if people with Pentium Pros want to</i><br>
<i>&gt; &gt; bang on it. If it locks up, we have a problem. Set USE_MB to one to use</i><br>
<i>&gt; &gt; the mov-based unlock. My dual PPro is a later stepping 9 and seems to work</i><br>
<i>&gt; &gt; just fine. If you have an SMP system with steppings 1-8 (only 1, 2, 6, and</i><br>
<i>&gt; &gt; 7 should be out there) and can confirm this works for you, that'd be</i><br>
<i>&gt; &gt; great.</i><br>
<i>&gt; </i><br>
<i>&gt; From what I can see in the code, USE_MB should be set to zero for the program</i><br>
<i>&gt; to use the mov based unlock:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; #if USE_MB == 0</i><br>
<i>&gt; &gt;                 "movl $1,%1\n\t" /* set current_state = 1 */</i><br>
<i>&gt; &gt; #else</i><br>
<i>&gt; &gt;                 "lock;bts $0,%1\n\t"</i><br>
<i>&gt; &gt; #endif</i><br>
<p>
Yep. I only took a quick glance at it before sending it on. Turns out it<br>
doesn't work as I remembered at all. When I said it worked on my machine,<br>
that was also from memory (too lazy to login to the machine in question).<br>
<p>
<i>&gt; Dual PPro stepping 1 here.  I was just finishing my ``success report'' as the</i><br>
<i>&gt; program locked up    :(      </i><br>
<p>
Not a problem - turns out Manfred's program was testing something<br>
different, but it started the discussion about the simpler unlock.<br>
<p>
I've hacked it into a new variant that tests what we're trying to test,<br>
and is a fair amount simpler to read (after you get past all of the kernel<br>
cut and paste!). See racefunc(). The idea is see if we can ever acquire a<br>
lock while changes made to data in the previous critical section are still<br>
not visible.<br>
<p>
<p>
TESTERS:<br>
<p>
Anyone with a dual x86, please give this a quick run. I want to hear about<br>
any failures (it'll abort with "state was 1!") and if you have a PPro with<br>
a stepping of less than 9 (which have been rumored to have a problem with<br>
this), tell me about your successes as well. Send me a copy of your<br>
/proc/cpuinfo too. If we can get a solid set of success reports for early<br>
P6s and no failures elsewhere, perhaps we can get this faster locking<br>
method into the kernel.<br>
<p>
/* <br>
<p>
movb.c<br>
<p>
Compile with:<br>
<p>
cc -O2 -o movb movb.c -lpthread<br>
<p>
undefine MOVB below to test the old spin_unlock variant<br>
<p>
*/<br>
<p>
#include &lt;stdio.h&gt;<br>
#include &lt;pthread.h&gt;<br>
#include &lt;assert.h&gt;<br>
<p>
#define MOVB<br>
<p>
#define mb() 	__asm__ __volatile__ ("lock; addl $0,0(%%esp)": : :"memory")<br>
<p>
typedef struct { unsigned long a[100]; } __dummy_lock_t;<br>
#define __dummy_lock(lock) (*(__dummy_lock_t *)(lock))<br>
<p>
typedef struct {<br>
	volatile unsigned int lock;<br>
#if SPINLOCK_DEBUG<br>
	unsigned magic;<br>
#endif<br>
} spinlock_t;<br>
<p>
#if SPINLOCK_DEBUG<br>
#define SPINLOCK_MAGIC_INIT	, SPINLOCK_MAGIC<br>
#else<br>
#define SPINLOCK_MAGIC_INIT	/* */<br>
#endif<br>
<p>
#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 SPINLOCK_MAGIC_INIT }<br>
<p>
#define spin_lock_init(x)	do { *(x) = SPIN_LOCK_UNLOCKED; } while(0)<br>
<p>
#define spin_lock_string \<br>
	"\n1:\t" \<br>
	"lock ; btsl $0,%0\n\t" \<br>
	"jc 2f\n" \<br>
	".section .text.lock,\"ax\"\n" \<br>
	"2:\t" \<br>
	"testb $1,%0\n\t" \<br>
	"rep;nop\n\t" \<br>
	"jne 2b\n\t" \<br>
	"jmp 1b\n" \<br>
	".previous"<br>
<p>
#ifdef MOVB<br>
#define spin_unlock_string \<br>
	"movb $0,%0"<br>
#else<br>
#define spin_unlock_string \<br>
	"lock ; btrl $0,%0"<br>
#endif<br>
<p>
extern inline void spin_lock(spinlock_t *lock)<br>
{<br>
#if SPINLOCK_DEBUG<br>
	__label__ here;<br>
here:<br>
	if (lock-&gt;magic != SPINLOCK_MAGIC) {<br>
printk("eip: %p\n", &amp;&amp;here);<br>
		BUG();<br>
	}<br>
#endif<br>
	__asm__ __volatile__(<br>
		spin_lock_string<br>
		:"=m" (__dummy_lock(lock)));<br>
}<br>
<p>
extern inline void spin_unlock(spinlock_t *lock)<br>
{<br>
#if SPINLOCK_DEBUG<br>
	if (lock-&gt;magic != SPINLOCK_MAGIC)<br>
		BUG();<br>
	if (!lock-&gt;lock)<br>
		BUG();<br>
#endif<br>
	__asm__ __volatile__(<br>
		spin_unlock_string<br>
		:"=m" (__dummy_lock(lock)));<br>
}<br>
<p>
typedef void *threadfunc(void *);<br>
<p>
void start_thread(threadfunc *f)<br>
{<br>
        pthread_t thread;<br>
        int res;<br>
<p>
        res = pthread_create(&amp;thread,NULL,f,NULL);<br>
<p>
        if(res != 0) <br>
                assert(0);<br>
}<br>
<p>
static spinlock_t testlock = SPIN_LOCK_UNLOCKED;<br>
volatile int state=0;<br>
<p>
void racefunc()<br>
{<br>
	int i, j;<br>
	volatile int delay=50;<br>
<p>
	spin_lock(&amp;testlock);<br>
	<br>
	i=state;<br>
	if(i) {<br>
		printf("state was %d!\n", i);<br>
		exit(-1);<br>
	}<br>
	<br>
	/* force change of state on bus */<br>
	state=1;<br>
	mb(); <br>
	for(j=0;j&lt;delay;j++)<br>
		;<br>
<p>
	/* swap next two lines to demonstrate race */<br>
	state=0;<br>
	spin_unlock(&amp;testlock);<br>
}<br>
<p>
void * cpu1(void *param)<br>
{<br>
	int i, j;<br>
	volatile int delay=1;<br>
	<br>
        for(i=0; i&lt;5000000; i++) {<br>
<p>
                for(j=0;j&lt;delay;j++)<br>
                        ;<br>
<p>
		racefunc();<br>
<p>
                if((i%5000)==0) {<br>
			printf("delay %d: ok\n",delay);<br>
			delay++;<br>
		}<br>
	}<br>
<p>
        printf("thread %d finished.\n",(int)param);<br>
        exit(0);<br>
}<br>
<p>
void* cpu2(void* param)<br>
{<br>
	volatile int delay2 = 300;<br>
        int i=0,j;<br>
<p>
        for(;;) {<br>
                for(j=0;j&lt;delay2;j++)<br>
                        ;<br>
		<br>
		racefunc();<br>
        }<br>
}<br>
<p>
int main()<br>
{<br>
        printf("movb:\n");<br>
        printf(" starting, please wait.\n");<br>
        start_thread(cpu2);<br>
        cpu1(0);<br>
}<br>
<p>
<p>
<pre>
--
 "Love the dolphins," she advised him. "Write by W.A.S.T.E.." 
<p>
<p>
<p>
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0105.html">Andrew Morton: "Re: [PATCH] Generic dead function optimisation"</a>
<li> <b>Previous message:</b> <a href="0103.html">Guest section DW: "Re: Possible bug in the floppy driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
