<!-- received="Sun Apr 23 17:06:32 2000 EET DST" -->
<!-- sent="Sun, 23 Apr 2000 11:01:32 -0300" -->
<!-- name="Cesar Eduardo Barros" -->
<!-- email="cesarb@web4u.com.br" -->
<!-- subject="[PATCH] Fix for rtc.c non-atomic mess (try 4)" -->
<!-- id="" -->
<!-- inreplyto="20000423011751.A6051@cesarb.uucp.openprojects.net" -->
<title>Linux-kernel mailing list archive 2000-17,: [PATCH] Fix for rtc.c non-atomic mess (try 4)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] Fix for rtc.c non-atomic mess (try 4)</h1>
<b>Cesar Eduardo Barros</b> (<a href="mailto:cesarb@web4u.com.br"><i>cesarb@web4u.com.br</i></a>)<br>
<i>Sun, 23 Apr 2000 11:01:32 -0300</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#48">[ date ]</a><a href="index.html#48">[ thread ]</a><a href="subject.html#48">[ subject ]</a><a href="author.html#48">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0049.html">Benno Senoner: "Re: IDE/ATAPI"</a>
<li> <b>Previous message:</b> <a href="0047.html">Benno Senoner: "hdrbench on FreeBSD MUCH better filesystem latencies than on Linux :-("</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Now I think it's almost ready. Spraul: found the implicit sti() in<br>
run_timer_list just before calling the timer function.<br>
<p>
This patch fixes the atomicity problems in rtc.c, where:<br>
a) the dropped irq timer interrupt could be disabled after rtc_interrupt had<br>
   read that it was enabled in rtc_status, making it reenable the timer<br>
b) access to rtc_irq_data in rtc_read was not atomic wrt it being changed in<br>
   rtc_interrupt<br>
<p>
Also removed unneeded saving of interrupt status in places where the interrupt<br>
state is known (disabled for rtc_interrupt, enabled for everywhere else in the<br>
module).<br>
<p>
As a bonus, Manfred Spraul confirmed rtc_poll was safe without the kernel lock.<br>
<p>
The patch has not been tested (but it compiles without a warning, at least<br>
here). Some brave soul with SMP is needed to test it.<br>
<p>
Made by Cesar Eduardo Barros and Manfred Spraul. Cesar made the first ugly<br>
patches, Manfred made it much simpler, and Cesar made the final polish.<br>
<p>
<p>
--- linux-2.3.99-pre5/drivers/char/rtc.c	Fri Apr 14 14:31:08 2000<br>
+++ linux-rtcfix4/drivers/char/rtc.c	Sun Apr 23 10:24:41 2000<br>
@@ -124,8 +124,18 @@<br>
 #define RTC_IS_OPEN		0x01	/* means /dev/rtc is in use	*/<br>
 #define RTC_TIMER_ON		0x02	/* missed irq timer active	*/<br>
 <br>
-static atomic_t rtc_status = ATOMIC_INIT(0); /* bitmapped status byte.	*/<br>
+/*<br>
+ * rtc_status is never changed by rtc_interrupt, and ioctl/open/close is<br>
+ * protected by the big kernel lock. However, ioctl can still disable the timer<br>
+ * in rtc_status and then with del_timer after the interrupt has read<br>
+ * rtc_status but before mod_timer is called, which would then reenable the<br>
+ * timer (but you would need to have an awful timing before you'd trip on it)<br>
+ */<br>
+static unsigned long rtc_status = 0;	/* bitmapped status byte.	*/<br>
 static unsigned long rtc_freq = 0;	/* Current periodic IRQ rate	*/<br>
+/* Making this two variables instead of one might make the interrupt a bit<br>
+ * faster (and exchange a spinlock (2 locked mem accesses) by two variable<br>
+ * atomic updates (2 locked mem accesses)). Or maybe slower. Ideas? */<br>
 static unsigned long rtc_irq_data = 0;	/* our output to the world	*/<br>
 <br>
 /*<br>
@@ -162,15 +172,17 @@<br>
 	rtc_irq_data += 0x100;<br>
 	rtc_irq_data &amp;= ~0xff;<br>
 	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);<br>
+<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+<br>
 	spin_unlock (&amp;rtc_lock);<br>
 <br>
+	/* Now do the rest of the actions */<br>
 	wake_up_interruptible(&amp;rtc_wait);	<br>
 <br>
 	if (rtc_async_queue)<br>
 		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
-<br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
-		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 }<br>
 #endif<br>
 <br>
@@ -200,7 +212,18 @@<br>
 <br>
 	current-&gt;state = TASK_INTERRUPTIBLE;<br>
 		<br>
-	while ((data = xchg(&amp;rtc_irq_data, 0)) == 0) {<br>
+	do {<br>
+		/* First make it right. Then make it fast. Putting this whole<br>
+		 * block within the parentheses of a while would be too<br>
+		 * confusing. And no, xchg() is not the answer. */<br>
+		spin_lock_irq (&amp;rtc_lock);<br>
+		data = rtc_irq_data;<br>
+		rtc_irq_data = 0;<br>
+		spin_unlock_irq (&amp;rtc_lock);<br>
+<br>
+		if (data != 0)<br>
+			break;<br>
+<br>
 		if (file-&gt;f_flags &amp; O_NONBLOCK) {<br>
 			retval = -EAGAIN;<br>
 			goto out;<br>
@@ -210,7 +233,7 @@<br>
 			goto out;<br>
 		}<br>
 		schedule();<br>
-	}<br>
+	} while (1);<br>
 <br>
 	retval = put_user(data, (unsigned long *)buf); <br>
 	if (!retval)<br>
@@ -226,8 +249,6 @@<br>
 static int rtc_ioctl(struct inode *inode, struct file *file, unsigned int cmd,<br>
 		     unsigned long arg)<br>
 {<br>
-<br>
-	unsigned long flags;<br>
 	struct rtc_time wtime; <br>
 <br>
 	switch (cmd) {<br>
@@ -245,10 +266,11 @@<br>
 	case RTC_PIE_OFF:	/* Mask periodic int. enab. bit	*/<br>
 	{<br>
 		mask_rtc_irq_bit(RTC_PIE);<br>
-		if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
+		if (rtc_status &amp; RTC_TIMER_ON) {<br>
+			spin_lock_irq (&amp;rtc_lock);<br>
+			rtc_status &amp;= ~RTC_TIMER_ON;<br>
 			del_timer(&amp;rtc_irq_timer);<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
+			spin_unlock_irq (&amp;rtc_lock);<br>
 		}<br>
 		return 0;<br>
 	}<br>
@@ -262,11 +284,12 @@<br>
 		if ((rtc_freq &gt; 64) &amp;&amp; (!capable(CAP_SYS_RESOURCE)))<br>
 			return -EACCES;<br>
 <br>
-		if (!(atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)) {<br>
-			atomic_set(&amp;rtc_status,<br>
-				   atomic_read(&amp;rtc_status) | RTC_TIMER_ON);<br>
+		if (!(rtc_status &amp; RTC_TIMER_ON)) {<br>
+			spin_lock_irq (&amp;rtc_lock);<br>
 			rtc_irq_timer.expires = jiffies + HZ/rtc_freq + 2*HZ/100;<br>
 			add_timer(&amp;rtc_irq_timer);<br>
+			rtc_status |= RTC_TIMER_ON;<br>
+			spin_unlock_irq (&amp;rtc_lock);<br>
 		}<br>
 		set_rtc_irq_bit(RTC_PIE);<br>
 		return 0;<br>
@@ -320,7 +343,7 @@<br>
 		if (sec &gt;= 60)<br>
 			sec = 0xff;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY) ||<br>
 		    RTC_ALWAYS_BCD)<br>
 		{<br>
@@ -331,7 +354,7 @@<br>
 		CMOS_WRITE(hrs, RTC_HOURS_ALARM);<br>
 		CMOS_WRITE(min, RTC_MINUTES_ALARM);<br>
 		CMOS_WRITE(sec, RTC_SECONDS_ALARM);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 		return 0;<br>
 	}<br>
@@ -346,8 +369,7 @@<br>
 		unsigned char mon, day, hrs, min, sec, leap_yr;<br>
 		unsigned char save_control, save_freq_select;<br>
 		unsigned int yrs;<br>
-		unsigned long flags;<br>
-			<br>
+<br>
 		if (!capable(CAP_SYS_TIME))<br>
 			return -EACCES;<br>
 <br>
@@ -379,11 +401,11 @@<br>
 		if ((yrs -= epoch) &gt; 255)    /* They are unsigned */<br>
 			return -EINVAL;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		if (!(CMOS_READ(RTC_CONTROL) &amp; RTC_DM_BINARY)<br>
<i> 		    || RTC_ALWAYS_BCD) {</i><br>
 			if (yrs &gt; 169) {<br>
-				spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+				spin_unlock_irq(&amp;rtc_lock);<br>
 				return -EINVAL;<br>
 			}<br>
 			if (yrs &gt;= 100)<br>
@@ -412,7 +434,7 @@<br>
 		CMOS_WRITE(save_control, RTC_CONTROL);<br>
 		CMOS_WRITE(save_freq_select, RTC_FREQ_SELECT);<br>
 <br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #ifndef __alpha__<br>
@@ -448,11 +470,11 @@<br>
 <br>
 		rtc_freq = arg;<br>
 <br>
-		spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+		spin_lock_irq(&amp;rtc_lock);<br>
 		val = CMOS_READ(RTC_FREQ_SELECT) &amp; 0xf0;<br>
 		val |= (16 - tmp);<br>
 		CMOS_WRITE(val, RTC_FREQ_SELECT);<br>
-		spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+		spin_unlock_irq(&amp;rtc_lock);<br>
 		return 0;<br>
 	}<br>
 #else<br>
@@ -489,18 +511,18 @@<br>
 <br>
 static int rtc_open(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
-<br>
-	if(atomic_read(&amp;rtc_status) &amp; RTC_IS_OPEN)<br>
+	/* If someday somebody decides to remove the kernel_lock on open and<br>
+	 * close and ioctl this is gonna get open to races */<br>
+	if(rtc_status &amp; RTC_IS_OPEN)<br>
 		return -EBUSY;<br>
 <br>
 	MOD_INC_USE_COUNT;<br>
 <br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) | RTC_IS_OPEN);<br>
+	rtc_status |= RTC_IS_OPEN;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -512,7 +534,6 @@<br>
 <br>
 static int rtc_release(struct inode *inode, struct file *file)<br>
 {<br>
-	unsigned long flags;<br>
 #ifndef __alpha__<br>
 	/*<br>
 	 * Turn off all interrupts once the device is no longer<br>
@@ -521,19 +542,19 @@<br>
 <br>
 	unsigned char tmp;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	tmp = CMOS_READ(RTC_CONTROL);<br>
 	tmp &amp;=  ~RTC_PIE;<br>
 	tmp &amp;=  ~RTC_AIE;<br>
 	tmp &amp;=  ~RTC_UIE;<br>
 	CMOS_WRITE(tmp, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON) {<br>
-		atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_TIMER_ON);<br>
+	if (rtc_status &amp; RTC_TIMER_ON) {<br>
+		rtc_status &amp;= ~RTC_TIMER_ON;<br>
 		del_timer(&amp;rtc_irq_timer);<br>
 	}<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (file-&gt;f_flags &amp; FASYNC) {<br>
 		rtc_fasync (-1, file, 0);<br>
@@ -542,23 +563,24 @@<br>
 #endif<br>
 	MOD_DEC_USE_COUNT;<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
-	atomic_set(&amp;rtc_status, atomic_read(&amp;rtc_status) &amp; ~RTC_IS_OPEN);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
+	rtc_status = rtc_status &amp; ~RTC_IS_OPEN;<br>
 	return 0;<br>
 }<br>
 <br>
 #ifndef __alpha__<br>
+/* Called without the kernel lock - fine */<br>
 static unsigned int rtc_poll(struct file *file, poll_table *wait)<br>
 {<br>
-	unsigned long l, flags;<br>
+	unsigned long l;<br>
 <br>
 	poll_wait(file, &amp;rtc_wait, wait);<br>
 <br>
-	spin_lock_irqsave (&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
 	l = rtc_irq_data;<br>
-	spin_unlock_irqrestore (&amp;rtc_lock, flags);<br>
+	spin_unlock_irq (&amp;rtc_lock);<br>
 <br>
 	if (l != 0)<br>
 		return POLLIN | POLLRDNORM;<br>
@@ -591,7 +613,6 @@<br>
 <br>
 static int __init rtc_init(void)<br>
 {<br>
-	unsigned long flags;<br>
 #ifdef __alpha__<br>
 	unsigned int year, ctrl;<br>
 	unsigned long uip_watchdog;<br>
@@ -662,10 +683,10 @@<br>
 		while (jiffies - uip_watchdog &lt; 2*HZ/100)<br>
 			barrier();<br>
 	<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	<br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 		BCD_TO_BIN(year);       /* This should never happen... */<br>
@@ -683,10 +704,10 @@<br>
 #ifndef __alpha__<br>
 	init_timer(&amp;rtc_irq_timer);<br>
 	rtc_irq_timer.function = rtc_dropped_irq;<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	/* Initialize periodic freq. to CMOS reset default, which is 1024Hz */<br>
 	CMOS_WRITE(((CMOS_READ(RTC_FREQ_SELECT) &amp; 0xF0) | 0x06), RTC_FREQ_SELECT);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 #endif<br>
 	rtc_freq = 1024;<br>
 <br>
@@ -698,9 +719,16 @@<br>
 static void __exit rtc_exit (void)<br>
 {<br>
 	/* interrupts and maybe timer disabled at this point by rtc_release */<br>
+	/* FIXME: Maybe??? */<br>
 <br>
-	if (atomic_read(&amp;rtc_status) &amp; RTC_TIMER_ON)<br>
+	if (rtc_status &amp; RTC_TIMER_ON) {<br>
+		spin_lock_irq (&amp;rtc_lock);<br>
+		rtc_status &amp;= ~RTC_TIMER_ON;<br>
 		del_timer(&amp;rtc_irq_timer);<br>
+		spin_unlock_irq (&amp;rtc_lock);<br>
+<br>
+		printk(KERN_WARNING "rtc_exit(), and timer still running.\n");<br>
+	}<br>
 <br>
 	remove_proc_entry ("driver/rtc", NULL);<br>
 	misc_deregister(&amp;rtc_dev);<br>
@@ -734,16 +762,24 @@<br>
 <br>
 static void rtc_dropped_irq(unsigned long data)<br>
 {<br>
-	unsigned long flags;<br>
-<br>
 	printk(KERN_INFO "rtc: lost some interrupts at %ldHz.\n", rtc_freq);<br>
-	mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq (&amp;rtc_lock);<br>
+<br>
+	/* Just in case someone disabled the timer from behind our back... */<br>
+	if (rtc_status &amp; RTC_TIMER_ON)<br>
+		mod_timer(&amp;rtc_irq_timer, jiffies + HZ/rtc_freq + 2*HZ/100);<br>
+<br>
 	rtc_irq_data += ((rtc_freq/HZ)&lt;&lt;8);<br>
 	rtc_irq_data &amp;= ~0xff;<br>
 	rtc_irq_data |= (CMOS_READ(RTC_INTR_FLAGS) &amp; 0xF0);	/* restart */<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
+<br>
+	/* Now we have new data */<br>
+	wake_up_interruptible(&amp;rtc_wait);<br>
+<br>
+	if (rtc_async_queue)<br>
+		kill_fasync (rtc_async_queue, SIGIO, POLL_IN);<br>
 }<br>
 #endif<br>
 <br>
@@ -758,12 +794,11 @@<br>
 	char *p;<br>
 	struct rtc_time tm;<br>
 	unsigned char batt, ctrl;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	batt = CMOS_READ(RTC_VALID) &amp; RTC_VRT;<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	p = buf;<br>
 <br>
@@ -843,21 +878,20 @@<br>
 /*<br>
  * Returns true if a clock update is in progress<br>
  */<br>
+/* FIXME shouldn't this be above rtc_init to inline it? */<br>
 static inline unsigned char rtc_is_updating(void)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char uip;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	uip = (CMOS_READ(RTC_FREQ_SELECT) &amp; RTC_UIP);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 	return uip;<br>
 }<br>
 <br>
 static void get_rtc_time(struct rtc_time *rtc_tm)<br>
 {<br>
-<br>
-	unsigned long flags, uip_watchdog = jiffies;<br>
+	unsigned long uip_watchdog = jiffies;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
@@ -880,7 +914,7 @@<br>
 	 * RTC has RTC_DAY_OF_WEEK, we ignore it, as it is only updated<br>
 	 * by the RTC when initially set to a non-zero value.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	rtc_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS);<br>
 	rtc_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES);<br>
 	rtc_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS);<br>
@@ -888,7 +922,7 @@<br>
 	rtc_tm-&gt;tm_mon = CMOS_READ(RTC_MONTH);<br>
 	rtc_tm-&gt;tm_year = CMOS_READ(RTC_YEAR);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -912,19 +946,18 @@<br>
 <br>
 static void get_rtc_alm_time(struct rtc_time *alm_tm)<br>
 {<br>
-	unsigned long flags;<br>
 	unsigned char ctrl;<br>
 <br>
 	/*<br>
 	 * Only the values that we read from the RTC are set. That<br>
 	 * means only tm_hour, tm_min, and tm_sec.<br>
 	 */<br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	alm_tm-&gt;tm_sec = CMOS_READ(RTC_SECONDS_ALARM);<br>
 	alm_tm-&gt;tm_min = CMOS_READ(RTC_MINUTES_ALARM);<br>
 	alm_tm-&gt;tm_hour = CMOS_READ(RTC_HOURS_ALARM);<br>
 	ctrl = CMOS_READ(RTC_CONTROL);<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 <br>
 	if (!(ctrl &amp; RTC_DM_BINARY) || RTC_ALWAYS_BCD)<br>
 	{<br>
@@ -948,28 +981,28 @@<br>
 static void mask_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val &amp;=  ~bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 }<br>
 <br>
 static void set_rtc_irq_bit(unsigned char bit)<br>
 {<br>
 	unsigned char val;<br>
-	unsigned long flags;<br>
 <br>
-	spin_lock_irqsave(&amp;rtc_lock, flags);<br>
+	spin_lock_irq(&amp;rtc_lock);<br>
 	val = CMOS_READ(RTC_CONTROL);<br>
 	val |= bit;<br>
 	CMOS_WRITE(val, RTC_CONTROL);<br>
 	CMOS_READ(RTC_INTR_FLAGS);<br>
+<br>
 	rtc_irq_data = 0;<br>
-	spin_unlock_irqrestore(&amp;rtc_lock, flags);<br>
+	spin_unlock_irq(&amp;rtc_lock);<br>
 }<br>
 #endif<br>
<p>
<pre>
-- 
Cesar Eduardo Barros
<a href="mailto:cesarb@web4u.com.br">cesarb@web4u.com.br</a>
<a href="mailto:cesarb@dcc.ufrj.br">cesarb@dcc.ufrj.br</a>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0049.html">Benno Senoner: "Re: IDE/ATAPI"</a>
<li> <b>Previous message:</b> <a href="0047.html">Benno Senoner: "hdrbench on FreeBSD MUCH better filesystem latencies than on Linux :-("</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
