<!-- received="Sat Sep 18 22:18:54 1999 EET DST" -->
<!-- sent="Sat, 18 Sep 1999 21:15:04 +0200 (CEST)" -->
<!-- name="Daniel Kobras" -->
<!-- email="daniel.kobras@student.uni-tuebingen.de" -->
<!-- subject="Hangs with new Realtek driver in ac5." -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: Hangs with new Realtek driver in ac5.</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Hangs with new Realtek driver in ac5.</h1>
<b>Daniel Kobras</b> (<a href="mailto:daniel.kobras@student.uni-tuebingen.de"><i>daniel.kobras@student.uni-tuebingen.de</i></a>)<br>
<i>Sat, 18 Sep 1999 21:15:04 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1229">[ date ]</a><a href="index.html#1229">[ thread ]</a><a href="subject.html#1229">[ subject ]</a><a href="author.html#1229">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1230.html">Mr. James W. Laferriere: "Re: Probable bug in handling disabled network interfaces (2.2.12)"</a>
<li> <b>Previous message:</b> <a href="1228.html">Mr. James W. Laferriere: "Re: Linux Device Drivers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
Using the updated rtl8139 in 2.3.18ac5 turned out to be not really a<br>
pleasure. Actually, the card reliably hangs in rtl8129_open(). And it<br>
hangs the whole machine, "hang" meaning I can't even use the ATX power<br>
switch to turn it off. Don't even think about magic syskeys and the like.<br>
<p>
The cause seems to be that with the switch to using PCI mem rather than<br>
i/o ports, the driver runs into a load of nasty timing issues. I was<br>
finally able to cure the hangs by forcing each write transaction to<br>
complete before the next one is issued. This probably kills the whole<br>
point of using PCI mem in the first place, so the forced flushes should be<br>
much finer grained but, hey, it's a quick fix and it's a whole lot better<br>
than hanging the machine. (The other obvious fix of course being to switch<br>
back to i/o ports which works fine as well.)<br>
<p>
Anyway, here's the patch that was necessary to cure my machine and I'll<br>
try to come up with an improved version with less readb()s.<br>
<p>
--[snip]--<br>
<p>
--- drivers/net/rtl8139.c.orig	Fri Sep 17 23:43:06 1999<br>
+++ drivers/net/rtl8139.c	Sat Sep 18 20:51:53 1999<br>
@@ -178,9 +178,9 @@<br>
 #define inb readb<br>
 #define inw readw<br>
 #define inl readl<br>
-#define outb writeb<br>
-#define outw writew<br>
-#define outl writel<br>
+#define outb(val,port) do { writeb((val),(port));readb(port); } while(0)<br>
+#define outw(val,port) do { writew((val),(port));readb(port); } while(0)<br>
+#define outl(val,port) do { writel((val),(port));readb(port); } while(0)<br>
 #endif<br>
 <br>
 /* The rest of these values should never change. */<br>
<p>
--[snap]--<br>
<p>
And while I'm at it, may I suggest the following change to<br>
drivers/pci/scan.c, providing a little more useful information in a<br>
debugging output:<br>
<p>
--[snip]--<br>
<p>
--- drivers/pci/scan.c~	Thu Sep 16 22:41:31 1999<br>
+++ drivers/pci/scan.c	Sat Sep 18 14:52:03 1999<br>
@@ -117,8 +117,11 @@<br>
 		pciaddr = res-&gt;start;<br>
 		<br>
 		if (debug &gt; 2)<br>
-			printk(KERN_INFO "Found %s at PCI address %#lx, IRQ %d.\n",<br>
-				   pci_tbl[chip_idx].name, pciaddr, irq);<br>
+			printk(KERN_INFO "Found %s at PCI %s in range %#lx-%#lx, IRQ %d.\n",<br>
+				   pci_tbl[chip_idx].name, <br>
+				   ((res-&gt;flags &amp; PCI_BASE_ADDRESS_SPACE_IO) ?<br>
+				    "i/o" : "mem"),<br>
+				   pciaddr, res-&gt;end, irq);<br>
 <br>
 		if ((res-&gt;flags &amp; PCI_BASE_ADDRESS_SPACE_IO)) {<br>
 			ioaddr = pciaddr;<br>
<p>
--[snap]--<br>
<p>
Regards,<br>
<p>
Daniel.<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1230.html">Mr. James W. Laferriere: "Re: Probable bug in handling disabled network interfaces (2.2.12)"</a>
<li> <b>Previous message:</b> <a href="1228.html">Mr. James W. Laferriere: "Re: Linux Device Drivers"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
