<!-- received="Sat Sep 18 17:13:04 1999 EET DST" -->
<!-- sent="Sat, 18 Sep 1999 10:09:01 -0400" -->
<!-- name="Simon Kirby" -->
<!-- email="sim@netnation.com" -->
<!-- subject="Re: NONBLOCKing close blocks in named" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.3.95.990918004020.12270A-100000@thingy.localnet" -->
<title>Linux-kernel mailing list archive 1999-37,: Re: NONBLOCKing close blocks in named</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: NONBLOCKing close blocks in named</h1>
<b>Simon Kirby</b> (<a href="mailto:sim@netnation.com"><i>sim@netnation.com</i></a>)<br>
<i>Sat, 18 Sep 1999 10:09:01 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1201">[ date ]</a><a href="index.html#1201">[ thread ]</a><a href="subject.html#1201">[ subject ]</a><a href="author.html#1201">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1202.html">Peter Hanecak: "Re: "ls | less" whith 2.2.12"</a>
<li> <b>Previous message:</b> <a href="1200.html">David Weinehall: "Re: NFS corruption revisited"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sat, Sep 18, 1999 at 01:11:38AM +0100, Steven Clarke wrote:<br>
<p>
<i>&gt; On Fri, 17 Sep 1999, Alan Cox wrote:</i><br>
<i>&gt; </i><br>
<i>&gt; &gt; &gt; If a socket file description has the O_NONBLOCK flag set, a close syscall</i><br>
<i>&gt; &gt; &gt; should return almost straight away, right? </i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; If SO_LINGER is set the close() blocks. If SO_LINGER is not set it doesnt</i><br>
<i>&gt; &gt; block. Ok thats the theory anyway.</i><br>
<i>&gt; &gt; </i><br>
<i>&gt; &gt; Check the SO_LINGER settings</i><br>
<i>&gt; </i><br>
<i>&gt; Should have mentioned that I checked that. According to the strace,</i><br>
<i>&gt; SO_LINGER hasn't been set or unset on that file descriptor (curiously, it</i><br>
<i>&gt; had been set on a previous socket from the same IP and with the same file</i><br>
<i>&gt; descriptor number).</i><br>
<i>&gt; </i><br>
<i>&gt; Even where the LINGER was set (elsewhere in the code) it was set to 120</i><br>
<i>&gt; (units - seconds? - claims to be hundreths of seconds in the setsockopt</i><br>
<i>&gt; man page but I think that's wrong).  In the problem that I demonstrated,</i><br>
<i>&gt; close took 11 minutes to return! </i><br>
<i>&gt; </i><br>
<i>&gt; I'm tempted to comment out the only SO_LINGER entry in BIND (it doesn't</i><br>
<i>&gt; seem to be needed) to see it help - I'm not sure.</i><br>
<p>
We had to do this on our nameservers to stop similar problems.  Removing<br>
SO_LINGER fixed it.<br>
<p>
I created this (cheap) patch that seems to do the trick:<br>
<p>
diff -ru src/bin/named/ns_main.c bind-8.2.1/bin/named/ns_main.c<br>
--- src/bin/named/ns_main.c	Thu Jun 17 19:26:54 1999<br>
+++ bind-8.2.1/bin/named/ns_main.c	Thu Jun 24 13:31:22 1999<br>
@@ -1719,6 +1719,7 @@<br>
  */<br>
 int<br>
 sq_openw(struct qstream *qs, int buflen) {<br>
+#undef SO_LINGER<br>
 #ifdef SO_LINGER	/* XXX */<br>
 	static const struct linger ll = { 1, 120 };<br>
 #endif<br>
<p>
Against 8.2.1 in this case.  Should also apply to 8.1.2.<br>
<p>
Simon-<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1202.html">Peter Hanecak: "Re: "ls | less" whith 2.2.12"</a>
<li> <b>Previous message:</b> <a href="1200.html">David Weinehall: "Re: NFS corruption revisited"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
