<!-- received="Sat Sep 18 12:19:10 1999 EET DST" -->
<!-- sent="Sat, 18 Sep 1999 05:09:12 -0400" -->
<!-- name="Paul Gortmaker" -->
<!-- email="p_gortmaker@yahoo.com" -->
<!-- subject="[patch] SA_INTERRUPT information" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [patch] SA_INTERRUPT information</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] SA_INTERRUPT information</h1>
<b>Paul Gortmaker</b> (<a href="mailto:p_gortmaker@yahoo.com"><i>p_gortmaker@yahoo.com</i></a>)<br>
<i>Sat, 18 Sep 1999 05:09:12 -0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1185">[ date ]</a><a href="index.html#1185">[ thread ]</a><a href="subject.html#1185">[ subject ]</a><a href="author.html#1185">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1186.html">G. Allen Morris III: "[RFC] i_generation numbers."</a>
<li> <b>Previous message:</b> <a href="1184.html">Thomas Molina: "_isofs_bmap: block &gt;= EOF (4, 82) in 2.3.18ac4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I put this together from various posts I'd saved - others might<br>
as well benefit from the information too.<br>
<p>
Paul.<br>
<p>
--- /dev/null	Mon Dec 31 23:00:00 1979<br>
+++ linux-2.3.18ac5/Documentation/SA_INTERRUPT.txt	Sat Sep 18 04:38:53 1999<br>
@@ -0,0 +1,130 @@<br>
+Info regarding SA_INTERRUPT cut from messages by Linus to linux-kernel:<br>
+<br>
+<br>
+Sun, 20 Sep 1998:<br>
+-----------------<br>
+<br>
+A small historical background on the issue..<br>
+<br>
+SA_INTERRUPT _used_ to mean (a _long_ long time ago):<br>
+ - incomplete stack frame, with only the non-preserved registers saved on<br>
+   the frame. This meant, for example, that we couldn't handle signals etc<br>
+   from a fast interrupt handler, because the stack wasn't set up for<br>
+   signal handling.<br>
+ - no PIC masking, and the PIC ACK done after the interrupt handler. This<br>
+   was made possible by guaranteeing that interrupts would not be enabled<br>
+   during SA_INTERRUPT processing, so we didn't need to mask out the<br>
+   interrupt.<br>
+ - no bottom half handling (well, this was originally even before bottom<br>
+   halves existed)<br>
+<br>
+Essentially, the SA_INTERRUPT thing was meant to be a truly lightweight<br>
+interrupt handling system, where it took just a few cycles to get into the<br>
+real handler. It was most useful for serial interrupts that were extremely<br>
+timing-critical (they still are, but CPU speeds have made the overhead<br>
+less of an issue).<br>
+<br>
+These days, SA_INTERRUPT has none of the above meanings. For various<br>
+reasons, not the least of which is just my own sanity, the differences<br>
+between fast and "slow" interrupts have become less and less.<br>
+<br>
+First people wanted bottom half handling as a response to serial<br>
+interrupts, because it made a huge difference to PPP latency. That already<br>
+meant that some of the advantage of a bottom-half interrupt was no longer<br>
+there. Then, with the new SMP code, it just became clear that it made no<br>
+sense at all to have the difference, because the interrupt entry code<br>
+became fairly involved (I definitely didn't want to have two separate<br>
+copies).<br>
+<br>
+These days the _only_ difference that SA_INTERRUPT makes is that a handler<br>
+that has SA_INTERRUPT set will not enable local interrupts on the CPU it<br>
+is running. Or rather, the generic code won't enable the interrupts<br>
+automatically: the low-level drivers can still enable them if they want<br>
+to.<br>
+<br>
+That's a rather arbitrary difference, and not one worth maintaining, I<br>
+think. I should just remove that test.<br>
+<br>
+<br>
+Sat, 11 Jul 1998:<br>
+-----------------<br>
+<br>
+Don't bother with the "fast interrupt". It was never any faster than the<br>
+slow one. It had slightly different semantics wrt the return path, but the<br>
+original meaning of the fast interrupt was that it wouldn't play any games<br>
+with the interrupt controller, because it would never enable interrupts,<br>
+so there were no re-entrancy issues. Not playing any interrupt controller<br>
+games meant avoiding the overhead of several IO instructions, and that<br>
+would have been meaningful. <br>
+<br>
+That was in pre-1.0.x days - even fast interrupts were changed to mask the<br>
+interrupt controller because too many people wanted them. The only<br>
+difference between a fast and a slow interrupt was that the fast one<br>
+didn't do the bottom half handling, and didn't check for signals, and due<br>
+to that a lot of people actually complained about ppp latencies etc. <br>
+<br>
+What you _should_ do, and what the code is actually set up to support<br>
+already, is to instead of having the notion of "fast" vs "slow" (which was<br>
+completely broken), you should look into having the interrupt routines<br>
+return a value. The return path can then check whether it should do bottom<br>
+halves or not depending on that value. <br>
+<br>
+This is because a lot of the things that really want fast interrupts,<br>
+don't actually want the interrupts to be _always_ fast, they want them to<br>
+be fast most of the time. The static "SA_INTERRUPT" flag was too static. <br>
+<br>
+For example, if you have high-speed serial devices, they usually do not<br>
+want to do a bottom half for each interrupt. However, to avoid latency<br>
+problems with packets etc, they _do_ want to be able to say "ok, my<br>
+ping-pong buffer is getting full, please do a bottom half interrupt now",<br>
+or "ok, I got the end-of-packet marker, now it makes sense to get a whole<br>
+packet, so do the bottom half now". <br>
+<br>
+And THEN they want the bottom half handler to be done immediately. <br>
+<br>
+This is actually completely done already, if you look at irq.c. The only<br>
+part that is missing is the return value from the interrupt handlers, so<br>
+right now the code has something like<br>
+<br>
+	if (1) {<br>
+		if (bh_active &amp; bh_mask)<br>
+			do_bottom_half();<br>
+	}<br>
+<br>
+while it instead should look something like<br>
+<br>
+	flags = irq_desc[irq].handler-&gt;handle(irq, cpu, &amp;regs);<br>
+<br>
+	if (flags &amp; INTERRUPT_DO_BH) {<br>
+		if (bh_active &amp; bh_mask)<br>
+			do_bottom_half();<br>
+	}<br>
+<br>
+	if (flags &amp; INTERRUPT_DO_SIGNALS) {<br>
+		return through signal checking code<br>
+	}<br>
+<br>
+but it would mean that every interrupt handler would have to return a<br>
+value (it might not be too painful to just make them all return 0, and<br>
+then one by one the ones that know about their needs could be changed). <br>
+<br>
+[...]<br>
+<br>
+&gt; It would be generally useful to handle nested interrupt of different <br>
+&gt; kinds (higher priority irq A interrupts irq B). <br>
+<br>
+We have always done that (since long before 1.0). The nesting is a<br>
+per-interrupt thing, and is only disallowed for the _same_ interrupt.<br>
+<br>
+Also note that if all interrupt handlers on a given IRQ line have the<br>
+SA_INTERRUPT flag set, then 2.1.x (and all earlier kernels for that<br>
+matter) don't allow any nesting at all, because the irq handler won't<br>
+enable interrupt locally. You can still get "nested" interrupts (of a<br>
+different type) on different CPU's, but they'll also have different<br>
+stacks. <br>
+<br>
+[...] nesting a timer interrupt (or something else) with another interrupt<br>
+has always been allowed, and still is. And that is still disallowed by <br>
+"fast" interrupts (it is in fact the only meaning that the SA_INTERRUPT <br>
+flag still has). <br>
+<br>
<p>
<p>
_________________________________________________________<br>
Do You Yahoo!?<br>
Get your free @yahoo.com address at <a href="http://mail.yahoo.com">http://mail.yahoo.com</a><br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1186.html">G. Allen Morris III: "[RFC] i_generation numbers."</a>
<li> <b>Previous message:</b> <a href="1184.html">Thomas Molina: "_isofs_bmap: block &gt;= EOF (4, 82) in 2.3.18ac4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
