<!-- received="Fri Sep 17 17:48:05 1999 EET DST" -->
<!-- sent="Fri, 17 Sep 1999 16:41:17 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Fri, 17 Sep 1999 16:41:17 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#1040">[ date ]</a><a href="index.html#1040">[ thread ]</a><a href="subject.html#1040">[ subject ]</a><a href="author.html#1040">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1041.html">Stephen C. Tweedie: "Re: &gt; 15K simultaneous connections EXAMPLE program/OS config needed, was:"</a>
<li> <b>Previous message:</b> <a href="1039.html">david: "Re: bz2 compression.. ???"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1235.html">dave madden: "Re: [patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)"</a>
<li> <b>Reply:</b> <a href="1235.html">dave madden: "Re: [patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I reviewed the time-related stuff in 2.2.12 and I found potential SMP<br>
races in the time-related syscalls. Basically the only problem is that the<br>
time-syscalls are not protecting against each other. They are only<br>
protecting themself against the timer irq. And this may lead to SMP races.<br>
<p>
Actually I don't know if these SMP races may be the source of the RTC<br>
screwedup with ntpd enabled (also considering that ntpd seems single<br>
threaded...). Anyway here it is the fix for the races I spotted so far.<br>
It's against 2.2.12 but it applyes cleanly to all 2.2.x 2.3.x kernels out<br>
there as there aren't been NTP/time changes since 2.2.0. You may want to<br>
try to reproduce the RTC SMP race with this fix applyed (I can't reproduce<br>
in any way here, but I am not sure I configured xntp hard enough to<br>
trigger the race).<br>
<p>
--- 2.2.12/kernel/time.c	Wed Mar 24 01:53:19 1999<br>
+++ 2.2.12-ntp-SMP-races/kernel/time.c	Fri Sep 17 16:29:11 1999<br>
@@ -22,6 +22,8 @@<br>
  *	"A Kernel Model for Precision Timekeeping" by Dave Mills<br>
  *	Allow time_constant larger than MAXTC(6) for NTP v4 (MAXTC == 10)<br>
  *	(Even though the technical memorandum forbids it)<br>
+ * 1999-09-17    Andrea Arcangeli &lt;<a href="mailto:andrea@suse.de">andrea@suse.de</a>&gt;<br>
+ *	Fixed adjtimex/settimeofday/stime SMP races.<br>
  */<br>
 <br>
 #include &lt;linux/mm.h&gt;<br>
@@ -76,6 +78,13 @@<br>
 	return i;<br>
 }<br>
 <br>
+/* The xtime_lock is not only serializing the xtime read/writes but it's also<br>
+   serializing all accesses to the global NTP variables.<br>
+   NOTE NOTE: We really need a spinlock here as the global irq locking<br>
+   only protect us against the timer irq and not against other time-related<br>
+   syscall running under us. */<br>
+extern rwlock_t xtime_lock;<br>
+<br>
 /*<br>
  * sys_stime() can be implemented in user-level using<br>
  * sys_settimeofday().  Is this for backwards compatibility?  If so,<br>
@@ -91,14 +100,14 @@<br>
 		return -EPERM;<br>
 	if (get_user(value, tptr))<br>
 		return -EFAULT;<br>
-	cli();<br>
+	write_lock_irq(&amp;xtime_lock);<br>
 	xtime.tv_sec = value;<br>
 	xtime.tv_usec = 0;<br>
 	time_adjust = 0;	/* stop active adjtime() */<br>
 	time_status |= STA_UNSYNC;<br>
 	time_maxerror = NTP_PHASE_LIMIT;<br>
 	time_esterror = NTP_PHASE_LIMIT;<br>
-	sti();<br>
+	write_unlock_irq(&amp;xtime_lock);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -137,9 +146,9 @@<br>
  */<br>
 inline static void warp_clock(void)<br>
 {<br>
-	cli();<br>
+	write_lock_irq(&amp;xtime_lock);<br>
 	xtime.tv_sec += sys_tz.tz_minuteswest * 60;<br>
-	sti();<br>
+	write_unlock_irq(&amp;xtime_lock);<br>
 }<br>
 <br>
 /*<br>
@@ -220,7 +229,7 @@<br>
 int do_adjtimex(struct timex *txc)<br>
 {<br>
         long ltemp, mtemp, save_adjust;<br>
-	int result = time_state;	/* mostly `TIME_OK' */<br>
+	int result;<br>
 <br>
 	/* In order to modify anything, you gotta be super-user! */<br>
 	if (txc-&gt;modes &amp;&amp; !capable(CAP_SYS_TIME))<br>
@@ -238,7 +247,8 @@<br>
 		if (txc-&gt;tick &lt; 900000/HZ || txc-&gt;tick &gt; 1100000/HZ)<br>
 			return -EINVAL;<br>
 <br>
-	cli(); /* SMP: global cli() is enough protection. */<br>
+	write_lock(&amp;xtime_lock);<br>
+	result = time_state;	/* mostly `TIME_OK' */<br>
 <br>
 	/* Save for later - semantics of adjtime is to return old value */<br>
 	save_adjust = time_adjust;<br>
@@ -383,7 +393,6 @@<br>
 	txc-&gt;constant	   = time_constant;<br>
 	txc-&gt;precision	   = time_precision;<br>
 	txc-&gt;tolerance	   = time_tolerance;<br>
-	do_gettimeofday(&amp;txc-&gt;time);<br>
 	txc-&gt;tick	   = tick;<br>
 	txc-&gt;ppsfreq	   = pps_freq;<br>
 	txc-&gt;jitter	   = pps_jitter &gt;&gt; PPS_AVG;<br>
@@ -393,8 +402,8 @@<br>
 	txc-&gt;calcnt	   = pps_calcnt;<br>
 	txc-&gt;errcnt	   = pps_errcnt;<br>
 	txc-&gt;stbcnt	   = pps_stbcnt;<br>
-<br>
-	sti();<br>
+	write_unlock_irq(&amp;xtime_lock);<br>
+	do_gettimeofday(&amp;txc-&gt;time);<br>
 	return(result);<br>
 }<br>
 <br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="1041.html">Stephen C. Tweedie: "Re: &gt; 15K simultaneous connections EXAMPLE program/OS config needed, was:"</a>
<li> <b>Previous message:</b> <a href="1039.html">david: "Re: bz2 compression.. ???"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="1235.html">dave madden: "Re: [patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)"</a>
<li> <b>Reply:</b> <a href="1235.html">dave madden: "Re: [patch] stime/settimeofday/adjtimex SMP races (2.2.12 and 2.3.18ac5)"</a>
<!-- reply="end" -->
</ul>
</font></body>
