<!-- received="Thu Sep 16 20:37:43 1999 EET DST" -->
<!-- sent="Thu, 16 Sep 1999 19:33:04 +0200" -->
<!-- name="Frank van Maarseveen" -->
<!-- email="fvm@tasking.nl" -->
<!-- subject="2.3.18ac5 patch: bypass ngroups limitation (16) in NFS/RPC protocol" -->
<!-- id="19990916193304.H29785@tasking.nl" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: 2.3.18ac5 patch: bypass ngroups limitation (16) in NFS/RPC protocol</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>2.3.18ac5 patch: bypass ngroups limitation (16) in NFS/RPC protocol</h1>
<b>Frank van Maarseveen</b> (<a href="mailto:fvm@tasking.nl"><i>fvm@tasking.nl</i></a>)<br>
<i>Thu, 16 Sep 1999 19:33:04 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#908">[ date ]</a><a href="index.html#908">[ thread ]</a><a href="subject.html#908">[ subject ]</a><a href="author.html#908">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0909.html">Alex: "Ext3 filesystem info?"</a>
<li> <b>Previous message:</b> <a href="0907.html">Andy Henroid: "[PATCH] generic ACPI support"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
--T4sUOijqQbZv57TR<br>
Content-Type: text/plain; charset=us-ascii<br>
<p>
This patch has been in operation on various kernels for<br>
a few months (no bugs found yet). It may be useful for<br>
others and I hope it will make it into the kernel some day.<br>
<p>
Feel free to comment (I read l-k).<br>
<p>
For those who have missed earlier posts:<br>
The RPC layer used by the NFS client restricts the number<br>
of groups to 16. This seems to be a hard protocol limit. The<br>
patch below gets around this limitation by implementing<br>
a group id cache in the RPC layer.<br>
 <br>
Permission checking is still done by the server but now<br>
the secondary group list is truncated in a more intelligent<br>
way. A similar effect could be achieved when the user calls<br>
setgroups() to reorder the secondary group list based on<br>
the exepected UNIX permission checks performed at the server<br>
(AUTH_UNIX). Of course that is not possible unless you're root.<br>
If RPC is going to truncate the secondary group list then we<br>
might just as well choose the groups from the group list.<br>
 <br>
<pre>
-- 
Frank
<p>
--T4sUOijqQbZv57TR
Content-Type: text/plain; charset=us-ascii
Content-Disposition: attachment; filename="nfs-ngroups.patch"
<p>
diff -ru linux-2.3.18ac5.orig/fs/nfs/dir.c linux/fs/nfs/dir.c
--- linux-2.3.18ac5.orig/fs/nfs/dir.c	Thu Sep 16 17:46:18 1999
+++ linux/fs/nfs/dir.c	Thu Sep 16 18:41:01 1999
@@ -728,6 +728,7 @@
 
 	dfprintk(VFS, "NFS: lookup(%s/%s)\n",
 		dentry-&gt;d_parent-&gt;d_name.name, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 	error = -ENAMETOOLONG;
 	if (dentry-&gt;d_name.len &gt; NFS_MAXNAMLEN)
@@ -809,6 +810,7 @@
 
 	dfprintk(VFS, "NFS: create(%x/%ld, %s\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 	sattr.mode = mode;
 	sattr.uid = sattr.gid = sattr.size = (unsigned) -1;
@@ -840,6 +842,7 @@
 
 	dfprintk(VFS, "NFS: mknod(%x/%ld, %s\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 	sattr.mode = mode;
 	sattr.uid = sattr.gid = sattr.size = (unsigned) -1;
@@ -870,6 +873,7 @@
 
 	dfprintk(VFS, "NFS: mkdir(%x/%ld, %s\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 	sattr.mode = mode | S_IFDIR;
 	sattr.uid = sattr.gid = sattr.size = (unsigned) -1;
@@ -897,6 +901,7 @@
 
 	dfprintk(VFS, "NFS: rmdir(%x/%ld, %s\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 #ifdef NFS_PARANOIA
 if (dentry-&gt;d_inode-&gt;i_count &gt; 1)
@@ -1127,6 +1132,8 @@
 
 	dfprintk(VFS, "NFS: unlink(%x/%ld, %s)\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name);
+	rpc_register_group(dentry-&gt;d_inode-&gt;i_gid);
+	rpc_register_group(dir-&gt;i_gid);
 
 	error = nfs_sillyrename(dir, dentry);
 	if (error &amp;&amp; error != -EBUSY) {
@@ -1146,6 +1153,7 @@
 
 	dfprintk(VFS, "NFS: symlink(%x/%ld, %s, %s)\n",
 		dir-&gt;i_dev, dir-&gt;i_ino, dentry-&gt;d_name.name, symname);
+	rpc_register_group(dir-&gt;i_gid);
 
 	error = -ENAMETOOLONG;
 	if (strlen(symname) &gt; NFS_MAXPATHLEN)
@@ -1194,6 +1202,7 @@
 	dfprintk(VFS, "NFS: link(%s/%s -&gt; %s/%s)\n",
 		old_dentry-&gt;d_parent-&gt;d_name.name, old_dentry-&gt;d_name.name,
 		dentry-&gt;d_parent-&gt;d_name.name, dentry-&gt;d_name.name);
+	rpc_register_group(dir-&gt;i_gid);
 
 	/*
 	 * Drop the dentry in advance to force a new lookup.
@@ -1251,6 +1260,9 @@
 		old_dentry-&gt;d_parent-&gt;d_name.name, old_dentry-&gt;d_name.name,
 		new_dentry-&gt;d_parent-&gt;d_name.name, new_dentry-&gt;d_name.name,
 		new_dentry-&gt;d_count);
+	rpc_register_group(old_inode-&gt;i_gid);
+	rpc_register_group(old_dir-&gt;i_gid);
+	rpc_register_group(new_dir-&gt;i_gid);
 
 	/*
 	 * First check whether the target is busy ... we can't
diff -ru linux-2.3.18ac5.orig/fs/nfs/inode.c linux/fs/nfs/inode.c
--- linux-2.3.18ac5.orig/fs/nfs/inode.c	Thu Sep 16 17:47:40 1999
+++ linux/fs/nfs/inode.c	Thu Sep 16 18:41:01 1999
@@ -638,8 +638,10 @@
 		sattr.uid = attr-&gt;ia_uid;
 
 	sattr.gid = (u32) -1;
-	if (attr-&gt;ia_valid &amp; ATTR_GID)
+	if (attr-&gt;ia_valid &amp; ATTR_GID) {
 		sattr.gid = attr-&gt;ia_gid;
+		rpc_register_group(attr-&gt;ia_gid);
+	}
 
 	sattr.size = (u32) -1;
 	if ((attr-&gt;ia_valid &amp; ATTR_SIZE) &amp;&amp; S_ISREG(inode-&gt;i_mode))
@@ -700,6 +702,7 @@
  */
 int nfs_open(struct inode *inode, struct file *filp)
 {
+ 	rpc_register_group(inode-&gt;i_gid);
 	return 0;
 }
 
diff -ru linux-2.3.18ac5.orig/include/linux/sched.h linux/include/linux/sched.h
--- linux-2.3.18ac5.orig/include/linux/sched.h	Thu Sep 16 17:47:41 1999
+++ linux/include/linux/sched.h	Thu Sep 16 18:41:01 1999
@@ -328,6 +328,10 @@
 	gid_t	groups[NGROUPS];
 	kernel_cap_t   cap_effective, cap_inheritable, cap_permitted;
 	struct user_struct *user;
+/* group id cache for sunrpc on client (nfs) */
+	int rpc_ngroups;
+	gid_t rpc_groups[16];		/* 16: hard rpc limit in client credential */
+	unsigned short rpc_giduse[16];	/* for LRU replacement */
 /* limits */
 	struct rlimit rlim[RLIM_NLIMITS];
 	unsigned short used_math;
@@ -410,6 +414,7 @@
 /* suppl grps*/ 0, {0,},					\
 /* caps */      CAP_INIT_EFF_SET,CAP_INIT_INH_SET,CAP_FULL_SET, \
 /* user */	NULL,						\
+/* grp cache */	0, {0,}, {0,}, \
 /* rlimits */   INIT_RLIMITS, \
 /* math */	0, \
 /* comm */	"swapper", \
diff -ru linux-2.3.18ac5.orig/include/linux/sunrpc/clnt.h linux/include/linux/sunrpc/clnt.h
--- linux-2.3.18ac5.orig/include/linux/sunrpc/clnt.h	Tue May 11 22:04:32 1999
+++ linux/include/linux/sunrpc/clnt.h	Thu Sep 16 18:41:01 1999
@@ -123,6 +123,7 @@
 void		rpc_restart_call(struct rpc_task *);
 void		rpc_clnt_sigmask(struct rpc_clnt *clnt, sigset_t *oldset);
 void		rpc_clnt_sigunmask(struct rpc_clnt *clnt, sigset_t *oldset);
+void		rpc_register_group(gid_t gid);
 
 #define rpc_call(clnt, proc, argp, resp, flags)	\
 		rpc_do_call(clnt, proc, argp, resp, flags, NULL, NULL)
diff -ru linux-2.3.18ac5.orig/include/linux/sunrpc/msg_prot.h linux/include/linux/sunrpc/msg_prot.h
--- linux-2.3.18ac5.orig/include/linux/sunrpc/msg_prot.h	Mon Apr  7 20:35:32 1997
+++ linux/include/linux/sunrpc/msg_prot.h	Thu Sep 16 18:41:01 1999
@@ -57,6 +57,7 @@
 #define RPC_PMAP_PORT		111
 
 #define RPC_MAXNETNAMELEN	256
+#define RPC_NGROUPS		16
 
 #endif /* __KERNEL__ */
 #endif /* _LINUX_SUNRPC_MSGPROT_H_ */
diff -ru linux-2.3.18ac5.orig/kernel/sys.c linux/kernel/sys.c
--- linux-2.3.18ac5.orig/kernel/sys.c	Thu Sep 16 17:47:41 1999
+++ linux/kernel/sys.c	Thu Sep 16 18:41:01 1999
@@ -782,6 +782,7 @@
 	if(copy_from_user(current-&gt;groups, grouplist, gidsetsize * sizeof(gid_t)))
 		return -EFAULT;
 	current-&gt;ngroups = gidsetsize;
+	current-&gt;rpc_ngroups = 0;
 	return 0;
 }
 
diff -ru linux-2.3.18ac5.orig/net/sunrpc/auth_unix.c linux/net/sunrpc/auth_unix.c
--- linux-2.3.18ac5.orig/net/sunrpc/auth_unix.c	Thu Aug 26 10:35:27 1999
+++ linux/net/sunrpc/auth_unix.c	Thu Sep 16 18:41:01 1999
@@ -16,12 +16,11 @@
 #include &lt;linux/sunrpc/clnt.h&gt;
 #include &lt;linux/sunrpc/auth.h&gt;
 
-#define NFS_NGROUPS	16
 struct unx_cred {
 	struct rpc_cred		uc_base;
 	uid_t			uc_fsuid;
 	gid_t			uc_gid, uc_fsgid;
-	gid_t			uc_gids[NFS_NGROUPS];
+	gid_t			uc_gids[RPC_NGROUPS];
 };
 #define uc_uid			uc_base.cr_uid
 #define uc_count		uc_base.cr_count
@@ -83,18 +82,23 @@
 		cred-&gt;uc_gid = cred-&gt;uc_fsgid = 0;
 		cred-&gt;uc_gids[0] = NOGROUP;
 	} else {
-		int groups = current-&gt;ngroups;
-		if (groups &gt; NFS_NGROUPS)
-			groups = NFS_NGROUPS;
+		int ngroups = current-&gt;ngroups;
+		gid_t *groups = current-&gt;groups;
 
+		if (ngroups &gt; RPC_NGROUPS) {
+			ngroups = current-&gt;rpc_ngroups;
+			groups = current-&gt;rpc_groups;
+			if (ngroups &gt; RPC_NGROUPS)		/* huh? */
+				ngroups = RPC_NGROUPS;
+		}
 		cred-&gt;uc_uid = current-&gt;uid;
 		cred-&gt;uc_gid = current-&gt;gid;
 		cred-&gt;uc_fsuid = current-&gt;fsuid;
 		cred-&gt;uc_fsgid = current-&gt;fsgid;
-		for (i = 0; i &lt; groups; i++)
-			cred-&gt;uc_gids[i] = (gid_t) current-&gt;groups[i];
-		if (i &lt; NFS_NGROUPS)
-		  cred-&gt;uc_gids[i] = NOGROUP;
+		for (i = 0; i &lt; ngroups; i++)
+			cred-&gt;uc_gids[i] = groups[i];
+		if (i &lt; RPC_NGROUPS)
+			cred-&gt;uc_gids[i] = NOGROUP;
 	}
 
 	return (struct rpc_cred *) cred;
@@ -140,7 +144,8 @@
 	int		i;
 
 	if (!RPC_DO_ROOTOVERRIDE(task)) {
-		int groups;
+		int ngroups;
+		gid_t *groups;
 
 		if (cred-&gt;uc_uid != current-&gt;uid
 		 || cred-&gt;uc_gid != current-&gt;gid
@@ -148,11 +153,16 @@
 		 || cred-&gt;uc_fsgid != current-&gt;fsgid)
 			return 0;
 
-		groups = current-&gt;ngroups;
-		if (groups &gt; NFS_NGROUPS)
-			groups = NFS_NGROUPS;
-		for (i = 0; i &lt; groups ; i++)
-			if (cred-&gt;uc_gids[i] != (gid_t) current-&gt;groups[i])
+		ngroups = current-&gt;ngroups;
+		groups = current-&gt;groups;
+		if (ngroups &gt; RPC_NGROUPS) {
+			ngroups = current-&gt;rpc_ngroups;
+			groups = current-&gt;rpc_groups;
+			if (ngroups &gt; RPC_NGROUPS)		/* huh? */
+				ngroups = RPC_NGROUPS;
+		}
+		for (i = 0; i &lt; ngroups ; i++)
+			if (cred-&gt;uc_gids[i] != groups[i])
 				return 0;
 		return 1;
 	}
@@ -193,7 +203,7 @@
 		*p++ = htonl((u32) cred-&gt;uc_fsgid);
 	}
 	hold = p++;
-	for (i = 0; i &lt; 16 &amp;&amp; cred-&gt;uc_gids[i] != (gid_t) NOGROUP; i++)
+	for (i = 0; i &lt; RPC_NGROUPS &amp;&amp; cred-&gt;uc_gids[i] != (gid_t) NOGROUP; i++)
 		*p++ = htonl((u32) cred-&gt;uc_gids[i]);
 	*hold = htonl(p - hold - 1);		/* gid array length */
 	*base = htonl((p - base - 1) &lt;&lt; 2);	/* cred length */
diff -ru linux-2.3.18ac5.orig/net/sunrpc/clnt.c linux/net/sunrpc/clnt.c
--- linux-2.3.18ac5.orig/net/sunrpc/clnt.c	Thu Aug 26 10:35:09 1999
+++ linux/net/sunrpc/clnt.c	Thu Sep 16 18:41:01 1999
@@ -313,6 +313,85 @@
 }
 
 /*
+ * Update the per-process group id cache.
+ * rpc_groups[n] corresponds with rpc_giduse[n]. All rpc_giduse[] numbers
+ * are unique and identify the order in which the groups have been
+ * registered by this function, numbering from 1 to rpc_ngroups. The
+ * least recently registered group has value 1. The groups in rpc_groups
+ * are sorted to avoid blowing up the credential cache.
+ *
+ * Maintaining a cache of groups ids using LRU replacement could be
+ * optimized by replacing the memmove's by a more appropriate datastructure.
+ * However, the number of RPC groups is fairly small and there are other
+ * things to worry about when current-&gt;ngroups becomes really large. Also,
+ * the cache will only be activated when there is reason to: &gt; 16 groups.
+ */
+void
+rpc_register_group(gid_t gid)
+{
+	int		ngroups, i, j, n;
+	gid_t		*groups;
+	unsigned short	*giduse;
+
+	if (current-&gt;ngroups &lt;= RPC_NGROUPS || gid == current-&gt;fsgid)
+		return;
+
+	ngroups = current-&gt;rpc_ngroups;
+	groups = current-&gt;rpc_groups;
+	giduse = current-&gt;rpc_giduse;
+	for (i = 0; i &lt; ngroups; ++i) {
+		if (groups[i] == gid)
+			break;
+	}
+	if (i &lt; ngroups) {
+		unsigned short use = giduse[i];
+		if (use != (unsigned short)ngroups) {
+			for (j = 0; j &lt; ngroups; ++j) {
+				if (giduse[j] &gt; use)
+					--giduse[j];
+			}
+			giduse[i] = (unsigned short)ngroups;
+		}
+		return;		/* ok: group already cached */
+	}
+	if (!in_group_p(gid))
+		return;		/* not ok: we're not a member */
+
+	/*
+	 * Delete the least recently used group (giduse == 1) when all
+	 * groups are in use. We're conservative about the group cache
+	 * size: it doesn't have to be equal to RPC_NGROUPS.
+	 */
+	if (ngroups == sizeof(current-&gt;rpc_groups)/sizeof(*groups)) {
+		j = 0;
+		for (i = 0; i &lt; ngroups; ++i) {
+			if (!--giduse[i])
+				j = i;
+		}
+		n = ngroups - (j + 1);
+		memmove(&amp;groups[j], &amp;groups[j + 1], n * sizeof(*groups));
+		memmove(&amp;giduse[j], &amp;giduse[j + 1], n * sizeof(*giduse));
+		--ngroups;
+	}
+
+	/*
+	 * Insert the new group. First find the insertion point.
+	 */
+	for (i = 0; i &lt; ngroups; ++i) {
+		if (groups[i] &gt; gid) {
+			break;
+		}
+	}
+	n = ngroups - i;
+	memmove(&amp;groups[i + 1], &amp;groups[i], n * sizeof(*groups));
+	memmove(&amp;giduse[i + 1], &amp;giduse[i], n * sizeof(*giduse));
+	++ngroups;
+	groups[i] = gid;
+	giduse[i] = (unsigned short)ngroups;
+	current-&gt;rpc_ngroups = ngroups;
+}
+
+/*
  * 0.	Get the server port number if not yet set
  */
 static void
diff -ru linux-2.3.18ac5.orig/net/sunrpc/sunrpc_syms.c linux/net/sunrpc/sunrpc_syms.c
--- linux-2.3.18ac5.orig/net/sunrpc/sunrpc_syms.c	Thu Aug 20 01:16:04 1998
+++ linux/net/sunrpc/sunrpc_syms.c	Thu Sep 16 18:41:01 1999
@@ -47,6 +47,7 @@
 EXPORT_SYMBOL(rpc_clnt_sigunmask);
 EXPORT_SYMBOL(rpc_delay);
 EXPORT_SYMBOL(rpc_restart_call);
+EXPORT_SYMBOL(rpc_register_group);
 
 /* Client transport */
 EXPORT_SYMBOL(xprt_create_proto);
diff -ru linux-2.3.18ac5.orig/net/sunrpc/svcauth.c linux/net/sunrpc/svcauth.c
--- linux-2.3.18ac5.orig/net/sunrpc/svcauth.c	Mon Apr  7 20:35:33 1997
+++ linux/net/sunrpc/svcauth.c	Thu Sep 16 18:41:01 1999
@@ -135,7 +135,7 @@
 	cred-&gt;cr_gid = ntohl(*bufp++);		/* gid */
 
 	slen = ntohl(*bufp++);			/* gids length */
-	if (slen &gt; 16 || (len -= slen + 2) &lt; 0)
+	if (slen &gt; RPC_NGROUPS || (len -= slen + 2) &lt; 0)
 		goto badcred;
 	for (i = 0; i &lt; NGROUPS &amp;&amp; i &lt; slen; i++)
 		cred-&gt;cr_groups[i] = ntohl(*bufp++);
<p>
--T4sUOijqQbZv57TR--
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0909.html">Alex: "Ext3 filesystem info?"</a>
<li> <b>Previous message:</b> <a href="0907.html">Andy Henroid: "[PATCH] generic ACPI support"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
