<!-- received="Thu Sep 16 16:21:25 1999 EET DST" -->
<!-- sent="Thu, 16 Sep 1999 15:15:17 +0200 (MET DST)" -->
<!-- name="Jacek Kopecky" -->
<!-- email="kopeckyj@inf.upol.cz" -->
<!-- subject="[PATCH] console alertness - notifying of console activities" -->
<!-- id="Pine.OSF.4.05.9909161502060.24268-100000@alpha.inf.upol.cz" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [PATCH] console alertness - notifying of console activities</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] console alertness - notifying of console activities</h1>
<b>Jacek Kopecky</b> (<a href="mailto:kopeckyj@inf.upol.cz"><i>kopeckyj@inf.upol.cz</i></a>)<br>
<i>Thu, 16 Sep 1999 15:15:17 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#865">[ date ]</a><a href="index.html#865">[ thread ]</a><a href="subject.html#865">[ subject ]</a><a href="author.html#865">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0866.html">afei@jhu.edu: "Email subject line"</a>
<li> <b>Previous message:</b> <a href="0864.html">Mark Buda: "Re: 2.2.12: serial driver swapping characters?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0885.html">Guest section DW: "Re: [PATCH] console alertness - notifying of console activities"</a>
<li> <b>Reply:</b> <a href="0885.html">Guest section DW: "Re: [PATCH] console alertness - notifying of console activities"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hello.<br>
<p>
I always wanted the console to be able to alert me when something happened it<br>
it. So I started writing a patch to allow me to set a virtual console so that<br>
it gets switched to whenever it beeps. I then expanded it so that now you<br>
can:<br>
 - have the vc switched to when it beeps,<br>
 - have the vc switched to when anything is written to it,<br>
 - have the vc beep whenever anything is written to it<br>
 - do nothing of the above. 8-)<br>
<p>
See the documentation file at the end of the patch for details. And tell me<br>
if you feel such functionality is desired.<br>
<p>
The patch applies cleanly with 2.2.12 and 2.3.18, it was originally made for<br>
2.2.10.<br>
<p>
(Is this mail enough for the patch to get into the main kernel or what should<br>
I do if I get positive responses about it?)<br>
<p>
                                       Jacek Kopecky<br>
<p>
E-mail: jacek.kopecky(at)upol.cz   (ISO Latin 2 encoding gladly accepted)<br>
WWW:    <a href="http://www.inf.upol.cz/~kopeckyj">http://www.inf.upol.cz/~kopeckyj</a>	ICQ: 49514837<br>
Finger <a href="mailto:kopeckyj@alpha.inf.upol.cz">kopeckyj@alpha.inf.upol.cz</a> for Geek Code.<br>
<p>
The patch:<br>
----------------------------------------------------------<br>
<p>
diff -u --recursive linux-2.2.12/drivers/char/console.c linux/drivers/char/console.c<br>
--- linux-2.2.12/drivers/char/console.c	Thu Mar 11 01:51:35 1999<br>
+++ linux/drivers/char/console.c	Thu Jul 15 11:55:38 1999<br>
@@ -66,6 +66,8 @@<br>
  *<br>
  * Resurrected character buffers in videoram plus lots of other trickery<br>
  * by Martin Mares &lt;<a href="mailto:mj@atrey.karlin.mff.cuni.cz">mj@atrey.karlin.mff.cuni.cz</a>&gt;, July 1998<br>
+ *<br>
+ * Console alertness by Jacek Kopecky &lt;<a href="mailto:jacek@unforgettable.com">jacek@unforgettable.com</a>&gt;, July 1999<br>
  */<br>
 <br>
 #include &lt;linux/module.h&gt;<br>
@@ -1263,6 +1265,10 @@<br>
 		case 14: /* set vesa powerdown interval */<br>
 			vesa_off_interval = ((par[1] &lt; 60) ? par[1] : 60) * 60 * HZ;<br>
 			break;<br>
+		case 15: /* set console alertness: <br>
+			    1 beep on write, 2 switch on beep , 3 switch on write*/<br>
+			alert = (par[1] &gt; 2) ? 3 : par[1];<br>
+			break;<br>
 	}<br>
 }<br>
 <br>
@@ -1402,6 +1408,8 @@<br>
 	save_cur(currcons);<br>
 	if (do_clear)<br>
 	    csi_J(currcons,2);<br>
+<br>
+	alert = 0;<br>
 }<br>
 <br>
 static void do_con_trol(struct tty_struct *tty, unsigned int currcons, int c)<br>
@@ -1416,6 +1424,9 @@<br>
 	case 7:<br>
 		if (bell_duration)<br>
 			kd_mksound(bell_pitch, bell_duration);<br>
+		/* switch console if alertness on beep */<br>
+		if ((alert == 2) &amp;&amp; (currcons != fg_console))<br>
+			change_console(currcons);<br>
 		return;<br>
 	case 8:<br>
 		bs(currcons);<br>
@@ -1927,6 +1938,16 @@<br>
 	}<br>
 	FLUSH<br>
 	enable_bh(CONSOLE_BH);<br>
+<br>
+	/* Switch to this console if alertness is 3<br>
+	 * or beep if alertness is 1<br>
+	 */<br>
+	if (alert &amp;&amp; (currcons != fg_console)) {<br>
+		if (alert == 3) change_console(currcons);<br>
+		else if ((alert == 1) &amp;&amp; bell_duration)<br>
+			kd_mksound(bell_pitch, bell_duration);<br>
+	}<br>
+<br>
 	return n;<br>
 #undef FLUSH<br>
 }<br>
diff -u --recursive linux-2.2.12/drivers/char/console_macros.h linux/drivers/char/console_macros.h<br>
--- linux-2.2.12/drivers/char/console_macros.h	Thu Sep 17 18:35:03 1998<br>
+++ linux/drivers/char/console_macros.h	Wed Jun 30 20:50:00 1999<br>
@@ -64,6 +64,7 @@<br>
 #define complement_mask (vc_cons[currcons].d-&gt;vc_complement_mask)<br>
 #define s_complement_mask (vc_cons[currcons].d-&gt;vc_s_complement_mask)<br>
 #define hi_font_mask	(vc_cons[currcons].d-&gt;vc_hi_font_mask)<br>
+#define alert		(vc_cons[currcons].d-&gt;vc_alert)<br>
 <br>
 #define vcmode		(vt_cons[currcons]-&gt;vc_mode)<br>
 <br>
diff -u --recursive linux-2.2.12/include/linux/console_struct.h linux/include/linux/console_struct.h<br>
--- linux-2.2.12/include/linux/console_struct.h	Thu Sep 17 18:35:04 1998<br>
+++ linux/include/linux/console_struct.h	Wed Jun 30 22:45:11 1999<br>
@@ -65,6 +65,7 @@<br>
 	unsigned int	vc_can_do_color	: 1;<br>
 	unsigned int	vc_report_mouse : 2;<br>
 	unsigned int	vc_kmalloced	: 1;<br>
+	unsigned int	vc_alert	: 2;    /* Switch to this console on write or beep */<br>
 	unsigned char	vc_utf		: 1;	/* Unicode UTF-8 encoding */<br>
 	unsigned char	vc_utf_count;<br>
 		 int	vc_utf_char;<br>
diff -u --recursive --new-file linux-2.2.12/Documentation/console-alertness linux/Documentation/console-alertness<br>
--- linux-2.2.12/Documentation/console-alertness	Thu Jan  1 01:00:00 1970<br>
+++ linux/Documentation/console-alertness	Fri Aug  6 22:45:45 1999<br>
@@ -0,0 +1,31 @@<br>
+This file describes the console alertness function of linux virtual consoles<br>
+as implemented by Jacek Kopecky (<a href="mailto:jacek@unforgettable.com">jacek@unforgettable.com</a>) in July 1999.<br>
+<br>
+First, what does console alertness mean anyway?<br>
+In cases when you want to be warned when something changes or only beeps on a<br>
+virtual console other than the one that's active at the moment (so that you<br>
+don't see the changes yourself), you can use the following escape sequences<br>
+to set the console-alertness-level to get some warnings:<br>
+<br>
+echo -ne "\033[15;0]" &gt; /dev/ttyX	    alertnes off ("beep on beep")<br>
+echo -ne "\033[15;1]" &gt; /dev/ttyX	    beep on write to the console<br>
+echo -ne "\033[15;2]" &gt; /dev/ttyX	    switch to the console on beep<br>
+echo -ne "\033[15;3]" &gt; /dev/ttyX	    switch to the console on write<br>
+<br>
+At the level 1 the virtual console /dev/ttyX beeps whenever anything is<br>
+written to it but only if the console is not currently the foreground console.<br>
+The level 2 makes the console get switched to whenever it beeps. On the highest<br>
+level the console gets switched to on each write to it.<br>
+<br>
+A side-effect of setting beep-on-write (1) or switch-on-write (3) on another<br>
+console is that the other console beeps or is switched to, this comes handy<br>
+as a test it's working. 8-)<br>
+The sequence for setting the switch-on-beep (2) level can be enhanced to give<br>
+the same kind of test:<br>
+<br>
+echo -ne "\033[15;2]\a" &gt; /dev/ttyX<br>
+<br>
+The setting sequences may seem to be a little too user-unfriendly so I'm<br>
+planning to try to incorporate alertness setting into the setterm package.<br>
+<br>
+Enjoy. 8-)<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0866.html">afei@jhu.edu: "Email subject line"</a>
<li> <b>Previous message:</b> <a href="0864.html">Mark Buda: "Re: 2.2.12: serial driver swapping characters?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0885.html">Guest section DW: "Re: [PATCH] console alertness - notifying of console activities"</a>
<li> <b>Reply:</b> <a href="0885.html">Guest section DW: "Re: [PATCH] console alertness - notifying of console activities"</a>
<!-- reply="end" -->
</ul>
</font></body>
