<!-- received="Thu Sep 16 15:05:14 1999 EET DST" -->
<!-- sent="Thu, 16 Sep 1999 14:01:52 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] __flush_one_page() on i386" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [patch] __flush_one_page() on i386</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] __flush_one_page() on i386</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Thu, 16 Sep 1999 14:01:52 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#859">[ date ]</a><a href="index.html#859">[ thread ]</a><a href="subject.html#859">[ subject ]</a><a href="author.html#859">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0860.html">Alan Cox: "Re: [patch] __flush_one_page() on i386"</a>
<li> <b>Previous message:</b> <a href="0858.html">Andreas Tobler: "strange mounting problem"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On i386 we are doing a flush_tlb_current_task() when a __flush_one_page()<br>
is requested. This is plain wrong as if there isn't the `invlpg` asm<br>
instruction we should revert to the only bit more larger (and CPU local)<br>
operation by moving back and forth the %%cr3 register so doing a full<br>
flush of the local tlb and nothing more.<br>
<p>
This bug is on both 2.2.x and 2.3.x.<br>
<p>
In 2.3.18 __flush_one_page() actually is called by flush_tlb_page() in<br>
smp.c and flush_tlb_page is called by kswapd. kswapd has no current-&gt;mm so<br>
then flush_tlb_current_page() oopses because current-&gt;mm is null and it's<br>
trying to dereference it to flush the mm of the current (kswapd) task.<br>
<p>
Fix against 2.3.18ac4:<br>
<p>
--- 2.3.18ac4-tlb/include/asm-i386/pgtable.h.~1~	Wed Sep 15 14:48:32 1999<br>
+++ 2.3.18ac4-tlb/include/asm-i386/pgtable.h	Wed Sep 15 15:47:41 1999<br>
@@ -44,7 +44,7 @@<br>
 do { unsigned long tmpreg; __asm__ __volatile__("movl %%cr3,%0\n\tmovl %0,%%cr3":"=r" (tmpreg) : :"memory"); } while (0)<br>
 <br>
 #ifndef CONFIG_X86_INVLPG<br>
-#define __flush_tlb_one(addr) flush_tlb()<br>
+#define __flush_tlb_one(addr) __flush_tlb()<br>
 #else<br>
 #define __flush_tlb_one(addr) \<br>
 __asm__ __volatile__("invlpg %0": :"m" (*(char *) addr))<br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0860.html">Alan Cox: "Re: [patch] __flush_one_page() on i386"</a>
<li> <b>Previous message:</b> <a href="0858.html">Andreas Tobler: "strange mounting problem"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
