<!-- received="Thu Sep 16 10:59:51 1999 EET DST" -->
<!-- sent="16 Sep 1999 09:56:15 +0200" -->
<!-- name="Trond Myklebust" -->
<!-- email="trond.myklebust@fys.uio.no" -->
<!-- subject="Re: NFS problem: __nfs_fhget: inode still busy" -->
<!-- id="" -->
<!-- inreplyto="Thu, 16 Sep 1999 01:00:09 +0100 (IST)"" -->
<title>Linux-kernel mailing list archive 1999-37,: Re: NFS problem: __nfs_fhget: inode still busy</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: NFS problem: __nfs_fhget: inode still busy</h1>
<b>Trond Myklebust</b> (<a href="mailto:trond.myklebust@fys.uio.no"><i>trond.myklebust@fys.uio.no</i></a>)<br>
<i>16 Sep 1999 09:56:15 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#826">[ date ]</a><a href="index.html#826">[ thread ]</a><a href="subject.html#826">[ subject ]</a><a href="author.html#826">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0827.html">Garst R. Reese: "2.3.18ac5 PCMCIA"</a>
<li> <b>Previous message:</b> <a href="0825.html">Klaus Kudielka: "Re: problem with system clock"</a>
<li> <b>In reply to:</b> <a href="0787.html">Paul Jakma: "NFS problem: __nfs_fhget: inode still busy"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Paul Jakma &lt;<a href="mailto:paul@clubi.ie">paul@clubi.ie</a>&gt; writes:<br>
<p>
<i>&gt; I have an nfs client which virtually hangs immediately after boot. it</i><br>
<i>&gt; continually prints out the message:</i><br>
<i>&gt; </i><br>
<i>&gt; __nfs_fhget: inode 8227 still busy, i_count=1</i><br>
<i>&gt; </i><br>
<i>&gt; This happens just after finishing executing rc.local. (RH5 boot-up</i><br>
<i>&gt; scripts). It's then supposed to start xdm, but never get's that far.</i><br>
<i>&gt; Inode number is always the same.</i><br>
<p>
This is due to the stale inode code getting activated, and trying to<br>
clean out an inode that is in use. I have a patch which softens the<br>
stale inode code which may (or may not) help.<br>
<p>
Please try it out and see if it helps...<br>
<p>
Cheers,<br>
  Trond<br>
<p>
diff -u --recursive --new-file linux-2.2.12.orig/fs/dcache.c linux-2.2.12/fs/dcache.c<br>
--- linux-2.2.12.orig/fs/dcache.c	Mon Apr 26 08:17:56 1999<br>
+++ linux-2.2.12/fs/dcache.c	Mon Aug 30 16:13:24 1999<br>
@@ -168,6 +168,11 @@<br>
 int d_invalidate(struct dentry * dentry)<br>
 {<br>
 	/*<br>
+	 * If it's already been dropped, return OK.<br>
+	 */<br>
+	if (&amp;list_empty(&amp;dentry-&gt;d_hash))<br>
+		return 0;<br>
+	/*<br>
 	 * Check whether to do a partial shrink_dcache<br>
 	 * to get rid of unused child entries.<br>
 	 */<br>
diff -u --recursive --new-file linux-2.2.12.orig/fs/nfs/dir.c linux-2.2.12/fs/nfs/dir.c<br>
--- linux-2.2.12.orig/fs/nfs/dir.c	Mon Aug  9 21:04:57 1999<br>
+++ linux-2.2.12/fs/nfs/dir.c	Mon Aug 30 16:15:54 1999<br>
@@ -395,13 +395,14 @@<br>
  * If mtime is close to present time, we revalidate<br>
  * more often.<br>
  */<br>
+#define NFS_REVALIDATE_NEGATIVE (1 * HZ)<br>
 static inline int nfs_neg_need_reval(struct dentry *dentry)<br>
 {<br>
-	unsigned long timeout = 30 * HZ;<br>
+	unsigned long timeout = NFS_ATTRTIMEO(dentry-&gt;d_parent-&gt;d_inode);<br>
 	long diff = CURRENT_TIME - dentry-&gt;d_parent-&gt;d_inode-&gt;i_mtime;<br>
 <br>
-	if (diff &lt; 5*60)<br>
-		timeout = 1 * HZ;<br>
+	if (diff &lt; 5*60 &amp;&amp; timeout &gt; NFS_REVALIDATE_NEGATIVE)<br>
+		timeout = NFS_REVALIDATE_NEGATIVE;<br>
 <br>
 	return time_after(jiffies, dentry-&gt;d_time + timeout);<br>
 }<br>
@@ -462,12 +463,8 @@<br>
 		goto out_bad;<br>
 <br>
 	/* Filehandle matches? */<br>
-	if (memcmp(dentry-&gt;d_fsdata, &amp;fhandle, sizeof(struct nfs_fh))) {<br>
-		if (!list_empty(&amp;dentry-&gt;d_subdirs))<br>
-			shrink_dcache_parent(dentry);<br>
-		if (dentry-&gt;d_count &lt; 2)<br>
-			goto out_bad;<br>
-	}<br>
+	if (memcmp(dentry-&gt;d_fsdata, &amp;fhandle, sizeof(struct nfs_fh)))<br>
+		goto out_bad;<br>
 <br>
 	/* Ok, remeber that we successfully checked it.. */<br>
 	nfs_renew_times(dentry);<br>
@@ -476,6 +473,9 @@<br>
 out_valid:<br>
 	return 1;<br>
 out_bad:<br>
+	d_drop(dentry);<br>
+	if (!list_empty(&amp;dentry-&gt;d_subdirs))<br>
+		shrink_dcache_parent(dentry);<br>
 	if (dentry-&gt;d_parent-&gt;d_inode)<br>
 		nfs_invalidate_dircache(dentry-&gt;d_parent-&gt;d_inode);<br>
 	if (inode &amp;&amp; S_ISDIR(inode-&gt;i_mode))<br>
diff -u --recursive --new-file linux-2.2.12.orig/fs/nfs/inode.c linux-2.2.12/fs/nfs/inode.c<br>
--- linux-2.2.12.orig/fs/nfs/inode.c	Mon Aug  9 21:05:05 1999<br>
+++ linux-2.2.12/fs/nfs/inode.c	Mon Aug 30 16:14:37 1999<br>
@@ -492,6 +492,48 @@<br>
 }<br>
 <br>
 /*<br>
+ * The following may seem pretty minimal, but the stateless nature<br>
+ * of NFS means that we can't do too much more. Previous attempts to use<br>
+ * fattr-&gt;nlink to determine how well the cached state matches the<br>
+ * server suffer from races with stale dentries. You also risk killing<br>
+ * off processes by just doing 'mv file newdir' on the server.<br>
+ *<br>
+ * FIXME: Of course, if 2 exported files have the same fileid (but<br>
+ * different fsid which makes it legal) you're still buggered...<br>
+ *                                      Trond, August 1999.<br>
+ */<br>
+static int<br>
+nfs_inode_is_stale(struct inode *inode, struct nfs_fattr *fattr)<br>
+{<br>
+	int unhashed;<br>
+	int is_stale = 0;<br>
+<br>
+	if (inode-&gt;i_mode &amp;&amp;<br>
+	    (fattr-&gt;mode &amp; S_IFMT) != (inode-&gt;i_mode &amp; S_IFMT))<br>
+		is_stale = 1;<br>
+<br>
+	if (is_bad_inode(inode))<br>
+		is_stale = 1;<br>
+<br>
+	/*<br>
+	 * Free up unused cached dentries to see if it's wise to unhash<br>
+	 * the inode (which we can do if all the dentries have been unhashed).<br>
+	 */<br>
+	unhashed = nfs_free_dentries(inode);<br>
+<br>
+	/* Assume we're holding 1 lock on the inode from 'iget'<br>
+	 *<br>
+	 * NB: sockets sometimes have volatile file handles<br>
+	 *     don't invalidate their inodes even if all dentries are<br>
+	 *     unhashed. */<br>
+	if (unhashed &amp;&amp; inode-&gt;i_count == unhashed + 1<br>
+	    &amp;&amp; !S_ISSOCK(inode-&gt;i_mode) &amp;&amp; !S_ISFIFO(inode-&gt;i_mode))<br>
+		is_stale = 1;<br>
+<br>
+	return is_stale;<br>
+}<br>
+<br>
+/*<br>
  * This is our own version of iget that looks up inodes by file handle<br>
  * instead of inode number.  We use this technique instead of using<br>
  * the vfs read_inode function because there is no way to pass the<br>
@@ -550,53 +592,26 @@<br>
 static struct inode *<br>
 __nfs_fhget(struct super_block *sb, struct nfs_fattr *fattr)<br>
 {<br>
-	struct inode *inode;<br>
-	int max_count, stale_inode, unhashed = 0;<br>
+	struct inode *inode = NULL;<br>
 <br>
-retry:<br>
-	inode = iget(sb, fattr-&gt;fileid);<br>
-	if (!inode)<br>
+	if (!fattr)<br>
 		goto out_no_inode;<br>
-	/* N.B. This should be impossible ... */<br>
-	if (inode-&gt;i_ino != fattr-&gt;fileid)<br>
-		goto out_bad_id;<br>
 <br>
-	/*<br>
-	 * Check for busy inodes, and attempt to get rid of any<br>
-	 * unused local references. If successful, we release the<br>
-	 * inode and try again.<br>
-	 *<br>
-	 * Note that the busy test uses the values in the fattr,<br>
-	 * as the inode may have become a different object.<br>
-	 * (We can probably handle modes changes here, too.)<br>
-	 */<br>
-	stale_inode = inode-&gt;i_mode &amp;&amp;<br>
-		      ((fattr-&gt;mode ^ inode-&gt;i_mode) &amp; S_IFMT);<br>
-	stale_inode |= inode-&gt;i_count &amp;&amp; inode-&gt;i_count == unhashed;<br>
-	max_count = S_ISDIR(fattr-&gt;mode) ? 1 : fattr-&gt;nlink;<br>
-	if (stale_inode || inode-&gt;i_count &gt; max_count + unhashed) {<br>
-		dprintk("__nfs_fhget: inode %ld busy, i_count=%d, i_nlink=%d\n",<br>
-			inode-&gt;i_ino, inode-&gt;i_count, inode-&gt;i_nlink);<br>
-		unhashed = nfs_free_dentries(inode);<br>
-		if (stale_inode || inode-&gt;i_count &gt; max_count + unhashed) {<br>
-			printk("__nfs_fhget: inode %ld still busy, i_count=%d\n",<br>
-				inode-&gt;i_ino, inode-&gt;i_count);<br>
-			if (!list_empty(&amp;inode-&gt;i_dentry)) {<br>
-				struct dentry *dentry;<br>
-				dentry = list_entry(inode-&gt;i_dentry.next,<br>
-						 struct dentry, d_alias);<br>
-				printk("__nfs_fhget: killing %s/%s filehandle\n",<br>
-					dentry-&gt;d_parent-&gt;d_name.name,<br>
-					dentry-&gt;d_name.name);<br>
-				memset(dentry-&gt;d_fsdata, 0,<br>
-					sizeof(struct nfs_fh));<br>
-			}<br>
-			remove_inode_hash(inode);<br>
-			nfs_invalidate_inode(inode);<br>
-			unhashed = 0;<br>
-		}<br>
+	while (!inode) {<br>
+		inode = iget(sb, fattr-&gt;fileid);<br>
+		if (!inode)<br>
+			goto out_no_inode;<br>
+		/* N.B. This should be impossible ... */<br>
+		if (inode-&gt;i_ino != fattr-&gt;fileid)<br>
+			goto out_bad_id;<br>
+<br>
+		if (!nfs_inode_is_stale(inode,fattr))<br>
+			break;<br>
+<br>
+		remove_inode_hash(inode);<br>
+		nfs_invalidate_inode(inode);<br>
 		iput(inode);<br>
-		goto retry;<br>
+		inode = NULL;<br>
 	}<br>
 	nfs_fill_inode(inode, fattr);<br>
 	dprintk("NFS: __nfs_fhget(%x/%ld ct=%d)\n",<br>
@@ -751,6 +766,8 @@<br>
 		fh = (u32 *) &amp;fhandle;<br>
 		dfprintk(PAGECACHE, "            %08x%08x%08x%08x%08x%08x%08x%08x\n",<br>
 			fh[0],fh[1],fh[2],fh[3],fh[4],fh[5],fh[6],fh[7]);<br>
+		if (!IS_ROOT(dentry))<br>
+			d_drop(dentry);<br>
 		goto out;<br>
 	}<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0827.html">Garst R. Reese: "2.3.18ac5 PCMCIA"</a>
<li> <b>Previous message:</b> <a href="0825.html">Klaus Kudielka: "Re: problem with system clock"</a>
<li> <b>In reply to:</b> <a href="0787.html">Paul Jakma: "NFS problem: __nfs_fhget: inode still busy"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
