<!-- received="Wed Sep 15 05:17:02 1999 EET DST" -->
<!-- sent="Tue, 14 Sep 1999 19:43:17 -0500 (CDT)" -->
<!-- name="jamesm@gtwn.net" -->
<!-- email="jamesm@gtwn.net" -->
<!-- subject="2.3.18 patch to get alphas to boot" -->
<!-- id="199909150033.TAA26222@gtwn.net" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: 2.3.18 patch to get alphas to boot</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>2.3.18 patch to get alphas to boot</h1>
<a href="mailto:jamesm@gtwn.net"><i>jamesm@gtwn.net</i></a><br>
<i>Tue, 14 Sep 1999 19:43:17 -0500 (CDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#581">[ date ]</a><a href="index.html#581">[ thread ]</a><a href="subject.html#581">[ subject ]</a><a href="author.html#581">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0582.html">Jeff Garzik: "Re: MTRR setting and framebuffer driver"</a>
<li> <b>Previous message:</b> <a href="0580.html">Alan Cox: "Linux 2.3.18ac4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
The following patch against 2.3.18 allows the kernel to compile on<br>
alphas (I have only tested it on my ruffian).  It boots fine, but the<br>
sym53C8xx driver fails to initialize correctly on my machine.  This is<br>
my first patch, so be gentle.  I am not aware of a patch that fixes<br>
these problems, but I apologize if one already exists.<br>
<p>
-James McCollough<br>
<p>
diff -u --recursive linux/drivers/char/pc_keyb.c linux-2.3.18ac2/drivers/char/pc_keyb.c<br>
--- linux/drivers/char/pc_keyb.c        Tue Sep 14 17:53:42 1999<br>
+++ linux-2.3.18ac2/drivers/char/pc_keyb.c      Tue Sep 14 17:51:24 1999<br>
@@ -37,6 +37,8 @@<br>
 #include &lt;asm/irq.h&gt;<br>
 #include &lt;asm/system.h&gt;<br>
 <br>
+#include &lt;asm/io.h&gt;<br>
+<br>
 /* Some configuration switches are present in the include file... */<br>
 <br>
 #include &lt;linux/pc_keyb.h&gt;<br>
diff -u --recursive linux/include/asm-alpha/keyboard.h linux-2.3.18ac2/include/asm-alpha/keyboard.h<br>
--- linux/include/asm-alpha/keyboard.h  Mon Apr 26 12:54:25 1999<br>
+++ linux-2.3.18ac2/include/asm-alpha/keyboard.h        Tue Sep 14 17:49:17 1999<br>
@@ -37,6 +37,31 @@<br>
 <br>
 #define SYSRQ_KEY 0x54<br>
 <br>
+/* resource allocation */<br>
+#define kbd_request_region()<br>
+#define kbd_request_irq(handler) request_irq(KEYBOARD_IRQ, handler, 0, \<br>
+                                             "keyboard", NULL)<br>
+<br>
+/* How to access the keyboard macros on this platform.  */<br>
+#define kbd_read_input() inb(KBD_DATA_REG)<br>
+#define kbd_read_status() inb(KBD_STATUS_REG)<br>
+#define kbd_write_output(val) outb(val, KBD_DATA_REG)<br>
+#define kbd_write_command(val) outb(val, KBD_CNTL_REG)<br>
+<br>
+/* Some stoneage hardware needs delays after some operations.  */<br>
+#define kbd_pause() do { } while(0)<br>
+<br>
+/*<br>
+ * Machine specific bits for the PS/2 driver<br>
+ */<br>
+<br>
+#define AUX_IRQ 12<br>
+<br>
+#define aux_request_irq(hand, dev_id)                                  \<br>
+       request_irq(AUX_IRQ, hand, SA_SHIRQ, "PS/2 Mouse", dev_id)<br>
+<br>
+#define aux_free_irq(dev_id) free_irq(AUX_IRQ, dev_id)<br>
+<br>
 #endif /* __KERNEL__ */<br>
 <br>
 #endif /* __ASMalpha_KEYBOARD_H */<br>
diff -u --recursive linux/include/asm-alpha/pgtable.h linux-2.3.18ac2/include/asm-alpha/pgtable.h<br>
--- linux/include/asm-alpha/pgtable.h   Wed Sep  8 13:54:14 1999<br>
+++ linux-2.3.18ac2/include/asm-alpha/pgtable.h Tue Sep 14 17:49:46 1999<br>
@@ -622,6 +622,6 @@<br>
 #define kern_addr_valid(addr)  (1)<br>
 <br>
 #define io_remap_page_range(start, busaddr, size, prot) \<br>
-       remap_page_range(start, virt_to_phys(ioremap(busaddr)), size, prot)<br>
+       remap_page_range(start, virt_to_phys(__ioremap(busaddr)), size, prot)<br>
 <br>
 #endif /* _ALPHA_PGTABLE_H */<br>
diff -u --recursive linux/include/asm-alpha/processor.h linux-2.3.18ac2/include/asm-alpha/processor.h<br>
--- linux/include/asm-alpha/processor.h Wed Aug  4 17:48:00 1999<br>
+++ linux-2.3.18ac2/include/asm-alpha/processor.h       Tue Sep 14 17:50:03 1999<br>
@@ -114,6 +114,8 @@<br>
 /* Do necessary setup to start up a newly executed thread.  */<br>
 extern void start_thread(struct pt_regs *, unsigned long, unsigned long);<br>
 <br>
+struct task_struct;<br>
+<br>
 /* Free all resources held by a thread. */<br>
 extern void release_thread(struct task_struct *);<br>
<p>
diff -u --recursive linux/include/asm-alpha/socket.h linux-2.3.18ac2/include/asm-alpha/socket.h<br>
--- linux/include/asm-alpha/socket.h    Sun Dec 21 19:41:24 1997<br>
+++ linux-2.3.18ac2/include/asm-alpha/socket.h  Tue Sep 14 17:50:28 1999<br>
@@ -48,4 +48,18 @@<br>
 #define SO_SECURITY_ENCRYPTION_TRANSPORT       20<br>
 #define SO_SECURITY_ENCRYPTION_NETWORK         21<br>
 <br>
+#ifdef __KERNEL__<br>
+/* Socket types. */<br>
+#define SOCK_STREAM    1               /* stream (connection) socket   */<br>
+#define SOCK_DGRAM     2               /* datagram (conn.less) socket  */<br>
+#define SOCK_RAW       3               /* raw socket                   */<br>
+#define SOCK_RDM       4               /* reliably-delivered message   */<br>
+#define SOCK_SEQPACKET 5               /* sequential packet socket     */<br>
+#define SOCK_PACKET    10              /* linux specific way of        */<br>
+                                       /* getting packets at the dev   */<br>
+                                       /* level.  For writing rarp and */<br>
+                                       /* other similar things on the  */<br>
+                                       /* user level.                  */<br>
+#endif                                 <br>
+<br>
 #endif /* _ASM_SOCKET_H */<br>
diff -u --recursive linux/net/core/datagram.c linux-2.3.18ac2/net/core/datagram.c<br>
--- linux/net/core/datagram.c   Fri Sep  3 16:17:43 1999<br>
+++ linux-2.3.18ac2/net/core/datagram.c Tue Sep 14 18:06:49 1999<br>
@@ -27,6 +27,7 @@<br>
 #include &lt;linux/kernel.h&gt;<br>
 #include &lt;asm/uaccess.h&gt;<br>
 #include &lt;asm/system.h&gt;<br>
+#include &lt;asm/socket.h&gt;<br>
 #include &lt;linux/mm.h&gt;<br>
 #include &lt;linux/interrupt.h&gt;<br>
 #include &lt;linux/in.h&gt;<br>
<p>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0582.html">Jeff Garzik: "Re: MTRR setting and framebuffer driver"</a>
<li> <b>Previous message:</b> <a href="0580.html">Alan Cox: "Linux 2.3.18ac4"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
