<!-- received="Wed Sep 15 03:44:25 1999 EET DST" -->
<!-- sent="Wed, 15 Sep 1999 00:02:02 +0200" -->
<!-- name="Henner Eisen" -->
<!-- email="eis@baty.hanse.de" -->
<!-- subject="patch: isdn ppp performace problems" -->
<!-- id="199909142202.AAA06331@baty.hanse.de" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: patch: isdn ppp performace problems</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>patch: isdn ppp performace problems</h1>
<b>Henner Eisen</b> (<a href="mailto:eis@baty.hanse.de"><i>eis@baty.hanse.de</i></a>)<br>
<i>Wed, 15 Sep 1999 00:02:02 +0200</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#563">[ date ]</a><a href="index.html#563">[ thread ]</a><a href="subject.html#563">[ subject ]</a><a href="author.html#563">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0564.html">Mike A. Harris: "Re: Accountability"</a>
<li> <b>Previous message:</b> <a href="0562.html">Jamie Lokier: "Re: MTRR setting and framebuffer driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi,<br>
<p>
as regards the occasionnally observed spurious isdn ppp peformance decrease<br>
(e.g. the "ping delayed by multiples of a second" and "mppp slow down"<br>
stuff), I detected a possible problem with isdn_ppp tx timeout recovery that<br>
might be the reason for this.<br>
<p>
Could people who can reproduce those problems please try the follong patch<br>
and report whether it helps, does not help, or breaks something else? <br>
(please add info about HL driver, ISDN_CONFIG options and ppp options<br>
in affect to such a report). (I myself have tested with single link ppp<br>
only). Please also report if you observe "isdn_ppp_xmit: sav_skb timeout"<br>
warning messages in the syslog.<br>
<p>
The same patch applies against 2.2.12 as well as 2.3.18.<br>
<p>
<p>
Short description for those interested in the internals:<br>
<p>
isdn_ppp maintains an internal queue of length 1 (stored in lp-&gt;sav_skb)<br>
which is needed because skbuffs are copied for compression reasons.<br>
Due to this, network device flow control cannot be done like for<br>
usual network devices. I now detected a possible problem that a lost<br>
BSENT statcallback could disturb the standard linux network device<br>
tx timeout recovery. In therory, a lost BSENT statcallback could disturb<br>
single link ppp partially and cause whole channels to die with multilink ppp.<br>
Anyway, the follwing patch adds a timeout recovery to isdn_ppp's<br>
xmit paths and also prints a warning message if such a timeout condition<br>
is detected.<br>
<p>
It's currently unclear under which circumstances this error (missed/lost BSENT<br>
statcallback) could be actually triggered at all. (In therory, it<br>
should not be possible with the HiSax driver). Thus, I'm very interested<br>
in reports about the observed warning message.<br>
<p>
Henner<br>
<p>
diff -ur linux/drivers/isdn/isdn_net.c linux-2.3.18-timeout/drivers/isdn/isdn_net.c<br>
--- linux/drivers/isdn/isdn_net.c	Sun Sep  5 20:28:59 1999<br>
+++ linux-2.3.18-timeout/drivers/isdn/isdn_net.c	Tue Sep 14 22:14:51 1999<br>
@@ -607,4 +607,11 @@<br>
 				    (!lp-&gt;dialstate)) {<br>
 					lp-&gt;stats.tx_packets++;<br>
 					lp-&gt;stats.tx_bytes += c-&gt;parm.length;<br>
+					/* some HL drivers deliver <br>
+					   ISDN_STAT_BSENT from hw interrupt.<br>
+					   Output routines in isdn_ppp are now<br>
+					   called with irq disabled such that<br>
+					   dequeueing the sav_skb while another<br>
+					   frame is sent will not occur.<br>
+					*/<br>
 					if (lp-&gt;p_encap == ISDN_NET_ENCAP_SYNCPPP &amp;&amp; lp-&gt;sav_skb) {<br>
diff -ur linux/drivers/isdn/isdn_ppp.c linux-2.3.18-timeout/drivers/isdn/isdn_ppp.c<br>
--- linux/drivers/isdn/isdn_ppp.c	Sun Sep  5 20:28:59 1999<br>
+++ linux-2.3.18-timeout/drivers/isdn/isdn_ppp.c	Tue Sep 14 22:32:16 1999<br>
@@ -1004,6 +1004,7 @@<br>
 			lp-&gt;dialstate == 0 &amp;&amp;<br>
 		    (lp-&gt;flags &amp; ISDN_NET_CONNECTED)) {<br>
 			unsigned short hl;<br>
+			unsigned long flags;<br>
 			int cnt;<br>
 			struct sk_buff *skb;<br>
 			/*<br>
@@ -1027,6 +1028,8 @@<br>
 <br>
 			isdn_ppp_send_ccp(lp-&gt;netdev,lp,skb); /* keeps CCP/compression states in sync */<br>
 <br>
+			save_flags(flags);<br>
+			cli();<br>
 			if ((cnt = isdn_writebuf_skb_stub(lp-&gt;isdn_device, lp-&gt;isdn_channel, 1, skb)) != count) {<br>
 				if (lp-&gt;sav_skb) {<br>
 					dev_kfree_skb(lp-&gt;sav_skb);<br>
@@ -1034,7 +1037,9 @@<br>
 				} else<br>
 					printk(KERN_INFO "isdn_ppp_write: Can't write PPP frame to LL (%d,%d)!\n", cnt, count);<br>
 				lp-&gt;sav_skb = skb;<br>
+				lp-&gt;sav_time = jiffies;<br>
 			}<br>
+			restore_flags(flags);<br>
 		}<br>
 	}<br>
 	return count;<br>
@@ -1459,6 +1464,7 @@<br>
 	isdn_net_dev *nd;<br>
 	unsigned int proto = PPP_IP;     /* 0x21 */<br>
 	struct ippp_struct *ipt,*ipts;<br>
+	unsigned long flags;<br>
 <br>
 	if (mdev)<br>
 		mlp = (isdn_net_local *) (mdev-&gt;priv);<br>
@@ -1511,12 +1517,24 @@<br>
 <br>
 	lp = nd-&gt;queue;         /* get lp on top of queue */<br>
 <br>
-	if (lp-&gt;sav_skb) {      /* find a non-busy device */<br>
-		isdn_net_local *nlp = lp-&gt;next;<br>
-		while (lp-&gt;sav_skb) {<br>
+	{      /* find a non-busy device */<br>
+		isdn_net_local *nlp = lp;<br>
+		while (nlp-&gt;sav_skb) {<br>
+			/* recover from a missing BSENT statcallback */<br>
+			if( time_after(jiffies,nlp-&gt;sav_time+HZ) ){<br>
+				unsigned long flags;<br>
+				printk(KERN_WARNING "isdn_ppp_xmit: sav_skb timeout on %s\n", nlp-&gt;name);<br>
+				save_flags(flags);<br>
+				cli();<br>
+				if(nlp-&gt;sav_skb){<br>
+					kfree_skb(nlp-&gt;sav_skb);<br>
+					nlp-&gt;sav_skb = NULL;<br>
+				}<br>
+				restore_flags(flags);<br>
+			}<br>
+			nlp = nd-&gt;queue = nd-&gt;queue-&gt;next;<br>
 			if (lp == nlp)<br>
 				return 1;<br>
-			nlp = nd-&gt;queue = nd-&gt;queue-&gt;next;<br>
 		}<br>
 		lp = nlp;<br>
 	}<br>
@@ -1654,13 +1672,18 @@<br>
 		printk(KERN_DEBUG "skb xmit: len: %d\n", (int) skb-&gt;len);<br>
 		isdn_ppp_frame_log("xmit", skb-&gt;data, skb-&gt;len, 32,ipt-&gt;unit,lp-&gt;ppp_slot);<br>
 	}<br>
+	save_flags(flags);<br>
+	cli();<br>
 	if (isdn_net_send_skb(netdev, lp, skb)) {<br>
-		if (lp-&gt;sav_skb) {	/* whole sav_skb processing with disabled IRQs ?? */<br>
+		if (lp-&gt;sav_skb) {	/* should never happen as sav_skb are sent with disabled IRQs) */<br>
 			printk(KERN_ERR "%s: whoops .. there is another stored skb!\n", netdev-&gt;name);<br>
 			dev_kfree_skb(skb);<br>
-		} else<br>
+		} else {<br>
 			lp-&gt;sav_skb = skb;<br>
+			lp-&gt;sav_time = jiffies;<br>
+		}<br>
 	}<br>
+	restore_flags(flags);<br>
 	return 0;<br>
 }<br>
 <br>
@@ -2242,6 +2265,7 @@<br>
 	struct sk_buff *skb;<br>
 	unsigned char *p;<br>
 	int count;<br>
+	unsigned long flags;<br>
 	int cnt = 0;<br>
 	isdn_net_local *lp = is-&gt;lp;<br>
 <br>
@@ -2284,6 +2308,8 @@<br>
 	   especially dunno what the sav_skb stuff is good for. */<br>
 <br>
 	count = skb-&gt;len;<br>
+	save_flags(flags);<br>
+	cli();<br>
 	if ((cnt = isdn_writebuf_skb_stub(lp-&gt;isdn_device, lp-&gt;isdn_channel,<br>
 					  1, skb)) != count) {<br>
 		if (lp-&gt;sav_skb) {<br>
@@ -2296,7 +2322,10 @@<br>
 			       "isdn_ppp_write: Can't write PPP frame to LL (%d,%d)!\n",<br>
 			       cnt, count);<br>
 		lp-&gt;sav_skb = skb;<br>
+		lp-&gt;sav_time = jiffies;<br>
+<br>
 	}<br>
+	restore_flags(flags);<br>
 }<br>
 <br>
 /* Allocate the reset state vector */<br>
@@ -3000,5 +3029,3 @@<br>
 	}<br>
 	return -EINVAL;<br>
 }<br>
-<br>
-<br>
diff -ur linux/include/linux/isdn.h linux-2.3.18-timeout/include/linux/isdn.h<br>
--- linux/include/linux/isdn.h	Sun Sep  5 20:29:01 1999<br>
+++ linux-2.3.18-timeout/include/linux/isdn.h	Tue Sep 14 21:34:21 1999<br>
@@ -591,7 +591,8 @@<br>
   struct isdn_net_local_s *last;       /* Ptr to last link in bundle       */<br>
   struct isdn_net_dev_s  *netdev;      /* Ptr to netdev                    */<br>
   struct sk_buff         *first_skb;   /* Ptr to skb that triggers dialing */<br>
-  struct sk_buff         *sav_skb;     /* Ptr to skb, rejected by LL-driver*/<br>
+  struct sk_buff *volatile sav_skb;    /* Ptr to skb, rejected by LL-driver*/<br>
+  unsigned long 	  sav_time;    /* time when last sav_skb was set */<br>
                                        /* Ptr to orig. hard_header_cache   */<br>
   int                    (*org_hhc)(<br>
 				    struct neighbour *neigh,<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0564.html">Mike A. Harris: "Re: Accountability"</a>
<li> <b>Previous message:</b> <a href="0562.html">Jamie Lokier: "Re: MTRR setting and framebuffer driver"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
