<!-- received="Wed Sep 15 03:23:07 1999 EET DST" -->
<!-- sent="Thu, 09 Sep 1999 14:24:08 +0930" -->
<!-- name="Paul Rusty Russell" -->
<!-- email="Paul.Russell@rustcorp.com.au" -->
<!-- subject="[PATCH] spinlock.h cleanup: linux/spinlock.h v2.3.16" -->
<!-- id="m11OwDp-000CCzC@localhost" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [PATCH] spinlock.h cleanup: linux/spinlock.h v2.3.16</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] spinlock.h cleanup: linux/spinlock.h v2.3.16</h1>
<b>Paul Rusty Russell</b> (<a href="mailto:Paul.Russell@rustcorp.com.au"><i>Paul.Russell@rustcorp.com.au</i></a>)<br>
<i>Thu, 09 Sep 1999 14:24:08 +0930</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#560">[ date ]</a><a href="index.html#560">[ thread ]</a><a href="subject.html#560">[ subject ]</a><a href="author.html#560">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0561.html">Mike A. Harris: "Re: Accountability"</a>
<li> <b>Previous message:</b> <a href="0559.html">Matthew Bader: "kernel Oopsen in 2.2.12 SMP"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This introduces linux/spinlock.h, and moves all the arch-independent<br>
spinlock code there.  It includes asm/spinlock.h if SMP, and each<br>
asm/spinlock.h includes linux/spinlock.h, so including either one<br>
works.<br>
<p>
Rusty.<br>
--- linux-2.3-raw/include/linux/spinlock.h.~1~	Thu Sep  9 14:10:16 1999<br>
+++ linux-2.3-raw/include/linux/spinlock.h	Thu Sep  9 09:18:33 1999<br>
@@ -0,0 +1,120 @@<br>
+#ifndef __LINUX_SPINLOCK_H<br>
+#define __LINUX_SPINLOCK_H<br>
+<br>
+/*<br>
+ * These are the generic versions of the spinlocks and read-write<br>
+ * locks..<br>
+ */<br>
+#define spin_lock_irqsave(lock, flags)		do { local_irq_save(flags);       spin_lock(lock); } while (0)<br>
+#define spin_lock_irq(lock)			do { local_irq_disable();         spin_lock(lock); } while (0)<br>
+#define spin_lock_bh(lock)			do { local_bh_disable();          spin_lock(lock); } while (0)<br>
+<br>
+#define read_lock_irqsave(lock, flags)		do { local_irq_save(flags);       read_lock(lock); } while (0)<br>
+#define read_lock_irq(lock)			do { local_irq_disable();         read_lock(lock); } while (0)<br>
+#define read_lock_bh(lock)			do { local_bh_disable();          read_lock(lock); } while (0)<br>
+<br>
+#define write_lock_irqsave(lock, flags)		do { local_irq_save(flags);      write_lock(lock); } while (0)<br>
+#define write_lock_irq(lock)			do { local_irq_disable();        write_lock(lock); } while (0)<br>
+#define write_lock_bh(lock)			do { local_bh_disable();         write_lock(lock); } while (0)<br>
+<br>
+#define spin_unlock_irqrestore(lock, flags)	do { spin_unlock(lock);  local_irq_restore(flags); } while (0)<br>
+#define spin_unlock_irq(lock)			do { spin_unlock(lock);  local_irq_enable();       } while (0)<br>
+#define spin_unlock_bh(lock)			do { spin_unlock(lock);  local_bh_enable();        } while (0)<br>
+<br>
+#define read_unlock_irqrestore(lock, flags)	do { read_unlock(lock);  local_irq_restore(flags); } while (0)<br>
+#define read_unlock_irq(lock)			do { read_unlock(lock);  local_irq_enable();       } while (0)<br>
+#define read_unlock_bh(lock)			do { read_unlock(lock);  local_bh_enable();        } while (0)<br>
+<br>
+#define write_unlock_irqrestore(lock, flags)	do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
+#define write_unlock_irq(lock)			do { write_unlock(lock); local_irq_enable();       } while (0)<br>
+#define write_unlock_bh(lock)			do { write_unlock(lock); local_bh_enable();        } while (0)<br>
+<br>
+#ifdef CONFIG_SMP<br>
+#include &lt;asm/spinlock.h&gt;<br>
+<br>
+#else /* !SMP */<br>
+<br>
+#define DEBUG_SPINLOCKS	0	/* 0 == no debugging, 1 == maintain lock state, 2 == full debug */<br>
+<br>
+#if (DEBUG_SPINLOCKS &lt; 1)<br>
+<br>
+/*<br>
+ * Your basic spinlocks, allowing only a single CPU anywhere<br>
+ *<br>
+ * Gcc-2.7.x has a nasty bug with empty initializers.<br>
+ */<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
+  typedef struct { } spinlock_t;<br>
+  #define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
+#else<br>
+  typedef struct { int gcc_is_buggy; } spinlock_t;<br>
+  #define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
+#endif<br>
+<br>
+#define spin_lock_init(lock)	do { } while(0)<br>
+#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
+#define spin_trylock(lock)	(1)<br>
+#define spin_unlock_wait(lock)	do { } while(0)<br>
+#define spin_unlock(lock)	do { } while(0)<br>
+<br>
+#elif (DEBUG_SPINLOCKS &lt; 2)<br>
+<br>
+typedef struct {<br>
+	volatile unsigned int lock;<br>
+} spinlock_t;<br>
+#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
+<br>
+#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
+#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
+<br>
+#define spin_lock(x)		do { (x)-&gt;lock = 1; } while (0)<br>
+#define spin_unlock_wait(x)	do { } while (0)<br>
+#define spin_unlock(x)		do { (x)-&gt;lock = 0; } while (0)<br>
+<br>
+#else /* (DEBUG_SPINLOCKS &gt;= 2) */<br>
+<br>
+typedef struct {<br>
+	volatile unsigned int lock;<br>
+	volatile unsigned int babble;<br>
+	const char *module;<br>
+} spinlock_t;<br>
+#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0, 25, __BASE_FILE__ }<br>
+<br>
+#include &lt;linux/kernel.h&gt;<br>
+<br>
+#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
+#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
+<br>
+#define spin_lock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_lock(%s:%p) already locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 1; restore_flags(__spinflags);} while (0)<br>
+#define spin_unlock_wait(x)	do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock_wait(%s:%p) deadlock\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} restore_flags(__spinflags);} while (0)<br>
+#define spin_unlock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if (!(x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock(%s:%p) not locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 0; restore_flags(__spinflags);} while (0)<br>
+<br>
+#endif	/* DEBUG_SPINLOCKS */<br>
+<br>
+/*<br>
+ * Read-write spinlocks, allowing multiple readers<br>
+ * but only one writer.<br>
+ *<br>
+ * NOTE! it is quite common to have readers in interrupts<br>
+ * but no interrupt writers. For those circumstances we<br>
+ * can "mix" irq-safe locks - any writer needs to get a<br>
+ * irq-safe write-lock, but readers can get non-irqsafe<br>
+ * read-locks.<br>
+ *<br>
+ * Gcc-2.7.x has a nasty bug with empty initializers.<br>
+ */<br>
+#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
+  typedef struct { } rwlock_t;<br>
+  #define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
+#else<br>
+  typedef struct { int gcc_is_buggy; } rwlock_t;<br>
+  #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
+#endif<br>
+<br>
+#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
+#define read_unlock(lock)	do { } while(0)<br>
+#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
+#define write_unlock(lock)	do { } while(0)<br>
+<br>
+#endif /* !SMP */<br>
+#endif /* __LINUX_SPINLOCK_H */<br>
--- linux-2.3-raw/include/asm-alpha/spinlock.h.~1~	Tue Jul 20 05:42:47 1999<br>
+++ linux-2.3-raw/include/asm-alpha/spinlock.h	Thu Sep  9 09:24:52 1999<br>
@@ -1,104 +1,10 @@<br>
 #ifndef _ALPHA_SPINLOCK_H<br>
 #define _ALPHA_SPINLOCK_H<br>
 <br>
-#include &lt;asm/system.h&gt;<br>
-<br>
-/*<br>
- * These are the generic versions of the spinlocks<br>
- * and read-write locks.. We should actually do a<br>
- * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
- */<br>
-#define spin_lock_irqsave(lock, flags) \<br>
-  do { local_irq_save(flags); spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock) \<br>
-  do { local_irq_disable(); spin_lock(lock); } while (0)<br>
-#define spin_lock_bh(lock) \<br>
-  do { local_bh_disable(); spin_lock(lock); } while (0)<br>
-<br>
-#define read_lock_irqsave(lock, flags) \<br>
-  do { local_irq_save(flags); read_lock(lock); } while (0)<br>
-#define read_lock_irq(lock) \<br>
-  do { local_irq_disable(); read_lock(lock); } while (0)<br>
-#define read_lock_bh(lock) \<br>
-  do { local_bh_disable(); read_lock(lock); } while (0)<br>
-<br>
-#define write_lock_irqsave(lock, flags) \<br>
-  do { local_irq_save(flags); write_lock(lock); } while (0)<br>
-#define write_lock_irq(lock) \<br>
-  do { local_irq_disable(); write_lock(lock); } while (0)<br>
-#define write_lock_bh(lock) \<br>
-  do { local_bh_disable(); write_lock(lock); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags) \<br>
-  do { spin_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define spin_unlock_irq(lock) \<br>
-  do { spin_unlock(lock); local_irq_enable(); } while (0)<br>
-#define spin_unlock_bh(lock) \<br>
-  do { spin_unlock(lock); local_bh_enable(); } while (0)<br>
-<br>
-#define read_unlock_irqrestore(lock, flags) \<br>
-  do { read_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define read_unlock_irq(lock) \<br>
-  do { read_unlock(lock); local_irq_enable(); } while (0)<br>
-#define read_unlock_bh(lock) \<br>
-  do { read_unlock(lock); local_bh_enable(); } while (0)<br>
-<br>
-#define write_unlock_irqrestore(lock, flags) \<br>
-  do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define write_unlock_irq(lock) \<br>
-  do { write_unlock(lock); local_irq_enable(); } while (0)<br>
-#define write_unlock_bh(lock) \<br>
-  do { write_unlock(lock); local_bh_enable(); } while (0)<br>
-<br>
-#ifndef __SMP__<br>
-<br>
-/*<br>
- * Your basic spinlocks, allowing only a single CPU anywhere<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)			((void)(lock))<br>
-#define spin_lock(lock)				((void)(lock))<br>
-#define spin_trylock(lock)			((void)(lock), 1)<br>
-#define spin_unlock_wait(lock)			((void)(lock))<br>
-#define spin_unlock(lock)			((void)(lock))<br>
-#define spin_is_locked(lock)			((void)(lock), 0)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define read_lock(lock)				((void)(lock))<br>
-#define read_unlock(lock)			((void)(lock))<br>
-#define write_lock(lock)			((void)(lock))<br>
-#define write_unlock(lock)			((void)(lock))<br>
-<br>
-#else /* __SMP__ */<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
+#ifdef CONFIG_SMP<br>
+#include &lt;asm/system.h&gt;<br>
 #include &lt;linux/kernel.h&gt;<br>
 #include &lt;asm/current.h&gt;<br>
 <br>
--- linux-2.3-raw/include/asm-arm/spinlock.h.~1~	Tue Jul 20 05:42:47 1999<br>
+++ linux-2.3-raw/include/asm-arm/spinlock.h	Thu Sep  9 13:02:48 1999<br>
@@ -1,116 +1,9 @@<br>
 #ifndef __ASM_SPINLOCK_H<br>
 #define __ASM_SPINLOCK_H<br>
 <br>
-/*<br>
- * To be safe, we assume the only compiler that can cope with<br>
- * empty initialisers is EGCS.<br>
- */<br>
-#if (__GNUC__ &gt; 2 || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 90))<br>
-#define EMPTY_STRUCT		struct { }<br>
-#define EMPTY_STRUCT_INIT(t)	(t) { }<br>
-#else<br>
-#define EMPTY_STRUCT		unsigned char<br>
-#define EMPTY_STRUCT_INIT(t)	(t) 0<br>
-#endif<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
-/*<br>
- * These are the generic versions of the spinlocks<br>
- * and read-write locks.. We should actually do a<br>
- * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
- */<br>
-#define spin_lock_irqsave(lock, flags)		do { local_irq_save(flags);       spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock)			do { local_irq_disable();         spin_lock(lock); } while (0)<br>
-#define spin_lock_bh(lock)			do { local_bh_disable();          spin_lock(lock); } while (0)<br>
-<br>
-#define read_lock_irqsave(lock, flags)		do { local_irq_save(flags);       read_lock(lock); } while (0)<br>
-#define read_lock_irq(lock)			do { local_irq_disable();         read_lock(lock); } while (0)<br>
-#define read_lock_bh(lock)			do { local_bh_disable();          read_lock(lock); } while (0)<br>
-<br>
-#define write_lock_irqsave(lock, flags)		do { local_irq_save(flags);      write_lock(lock); } while (0)<br>
-#define write_lock_irq(lock)			do { local_irq_disable();        write_lock(lock); } while (0)<br>
-#define write_lock_bh(lock)			do { local_bh_disable();         write_lock(lock); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags)	do { spin_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define spin_unlock_irq(lock)			do { spin_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define spin_unlock_bh(lock)			do { spin_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define read_unlock_irqrestore(lock, flags)	do { read_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define read_unlock_irq(lock)			do { read_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define read_unlock_bh(lock)			do { read_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define write_unlock_irqrestore(lock, flags)	do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define write_unlock_irq(lock)			do { write_unlock(lock); local_irq_enable();       } while (0)<br>
-#define write_unlock_bh(lock)			do { write_unlock(lock); local_bh_enable();        } while (0)<br>
-<br>
-#ifndef __SMP__<br>
-<br>
-#define DEBUG_SPINLOCKS 0	/* 0 == no debugging, 1 == maintain lock state, 2 == full debugging */<br>
-<br>
-#if (DEBUG_SPINLOCKS &lt; 1)<br>
-/*<br>
- * Your basic spinlocks, allowing only a single CPU anywhere<br>
- */<br>
-typedef EMPTY_STRUCT spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED EMPTY_STRUCT_INIT(spinlock_t)<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-<br>
-#elif (DEBUG_SPINLOCKS &lt; 2)<br>
-<br>
-typedef struct {<br>
-	volatile unsigned int lock;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (pinlock_t) { 0 }<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_lock(x)		do { (x)-&gt;lock = 1; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-#define spin_unlock_wait(x)	do { } while (0)<br>
-#define spin_unlock(x)		do { (x)-&gt;lock = 0; } while (0)<br>
-<br>
-#else /* (DEBUG_SPINLOCKS &gt;= 2) */<br>
-<br>
-typedef struct {<br>
-	volatule unsigned int lock;<br>
-	volatile unsigned int babble;<br>
-	const char *module;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0, 25, __BASE_FILE__ }<br>
-<br>
-#include &lt;linux/kernel.h&gt;<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-<br>
-#define spin_lock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_lock(%s:%p) already locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 1; restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock_wait(x)	do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock_wait(%s:%p) deadlock\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if (!(x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock(%s:%p) not locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 0; restore_flags(__spinflags);} while (0)<br>
-<br>
-#endif<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- */<br>
-typedef EMPTY_STRUCT rwlock_t;<br>
-#define RW_LOCK_UNLOCKED EMPTY_STRUCT_INIT(rwlock_t)<br>
-<br>
-#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-<br>
-#else<br>
+#ifdef CONFIG_SMP<br>
 #error ARM architecture does not support spin locks<br>
 #endif /* SMP */<br>
 #endif /* __ASM_SPINLOCK_H */<br>
--- linux-2.3-raw/include/asm-i386/spinlock.h.~1~	Sun Sep  5 05:08:28 1999<br>
+++ linux-2.3-raw/include/asm-i386/spinlock.h	Thu Sep  9 09:22:54 1999<br>
@@ -1,121 +1,9 @@<br>
 #ifndef __ASM_SPINLOCK_H<br>
 #define __ASM_SPINLOCK_H<br>
 <br>
-/*<br>
- * These are the generic versions of the spinlocks<br>
- * and read-write locks.. We should actually do a<br>
- * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
- */<br>
-#define spin_lock_irqsave(lock, flags)		do { local_irq_save(flags);       spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock)			do { local_irq_disable();         spin_lock(lock); } while (0)<br>
-#define spin_lock_bh(lock)			do { local_bh_disable();          spin_lock(lock); } while (0)<br>
-<br>
-#define read_lock_irqsave(lock, flags)		do { local_irq_save(flags);       read_lock(lock); } while (0)<br>
-#define read_lock_irq(lock)			do { local_irq_disable();         read_lock(lock); } while (0)<br>
-#define read_lock_bh(lock)			do { local_bh_disable();          read_lock(lock); } while (0)<br>
-<br>
-#define write_lock_irqsave(lock, flags)		do { local_irq_save(flags);      write_lock(lock); } while (0)<br>
-#define write_lock_irq(lock)			do { local_irq_disable();        write_lock(lock); } while (0)<br>
-#define write_lock_bh(lock)			do { local_bh_disable();         write_lock(lock); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags)	do { spin_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define spin_unlock_irq(lock)			do { spin_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define spin_unlock_bh(lock)			do { spin_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define read_unlock_irqrestore(lock, flags)	do { read_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define read_unlock_irq(lock)			do { read_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define read_unlock_bh(lock)			do { read_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define write_unlock_irqrestore(lock, flags)	do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define write_unlock_irq(lock)			do { write_unlock(lock); local_irq_enable();       } while (0)<br>
-#define write_unlock_bh(lock)			do { write_unlock(lock); local_bh_enable();        } while (0)<br>
-<br>
-#ifndef __SMP__<br>
-<br>
-#define DEBUG_SPINLOCKS	0	/* 0 == no debugging, 1 == maintain lock state, 2 == full debug */<br>
-<br>
-#if (DEBUG_SPINLOCKS &lt; 1)<br>
-<br>
-/*<br>
- * Your basic spinlocks, allowing only a single CPU anywhere<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-<br>
-#elif (DEBUG_SPINLOCKS &lt; 2)<br>
-<br>
-typedef struct {<br>
-	volatile unsigned int lock;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-<br>
-#define spin_lock(x)		do { (x)-&gt;lock = 1; } while (0)<br>
-#define spin_unlock_wait(x)	do { } while (0)<br>
-#define spin_unlock(x)		do { (x)-&gt;lock = 0; } while (0)<br>
-<br>
-#else /* (DEBUG_SPINLOCKS &gt;= 2) */<br>
-<br>
-typedef struct {<br>
-	volatile unsigned int lock;<br>
-	volatile unsigned int babble;<br>
-	const char *module;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0, 25, __BASE_FILE__ }<br>
-<br>
-#include &lt;linux/kernel.h&gt;<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-<br>
-#define spin_lock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_lock(%s:%p) already locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 1; restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock_wait(x)	do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock_wait(%s:%p) deadlock\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if (!(x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock(%s:%p) not locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 0; restore_flags(__spinflags);} while (0)<br>
-<br>
-#endif	/* DEBUG_SPINLOCKS */<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-<br>
-#else	/* __SMP__ */<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
+#ifdef CONFIG_SMP<br>
 /*<br>
  * Your basic spinlocks, allowing only a single CPU anywhere<br>
  */<br>
--- linux-2.3-raw/include/asm-m68k/spinlock.h.~1~	Tue Aug 10 04:57:31 1999<br>
+++ linux-2.3-raw/include/asm-m68k/spinlock.h	Thu Sep  9 13:03:31 1999<br>
@@ -1,72 +1,8 @@<br>
 #ifndef __M68K_SPINLOCK_H<br>
 #define __M68K_SPINLOCK_H<br>
 <br>
+#include &lt;linux/spinlock.h&gt;<br>
 /*<br>
  * We don't do SMP on the m68k .... at least not yet.<br>
  */<br>
-<br>
-/*<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-typedef struct { } spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-typedef struct { int gcc_is_buggy; } spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-#define spin_lock_irq(lock)	cli()<br>
-#define spin_unlock_irq(lock)	sti()<br>
-#define spin_lock_bh(lock)	local_bh_disable()<br>
-#define spin_unlock_bh(lock)	local_bh_enable()<br>
-<br>
-#define spin_lock_irqsave(lock, flags) \<br>
-	do { save_flags(flags); cli(); } while (0)<br>
-#define spin_unlock_irqrestore(lock, flags) \<br>
-	restore_flags(flags)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-typedef struct { } rwlock_t;<br>
-#define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-#else<br>
-typedef struct { int gcc_is_buggy; } rwlock_t;<br>
-#define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-#define read_lock_irq(lock)	cli()<br>
-#define read_unlock_irq(lock)	sti()<br>
-#define write_lock_irq(lock)	cli()<br>
-#define write_unlock_irq(lock)	sti()<br>
-#define read_lock_bh(lock)	local_bh_disable()<br>
-#define read_unlock_bh(lock)	local_bh_enable()<br>
-#define write_lock_bh(lock)	local_bh_disable()<br>
-#define write_unlock_bh(lock)	local_bh_enable()<br>
-<br>
-#define read_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define read_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-#define write_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define write_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-<br>
 #endif<br>
--- linux-2.3-raw/include/asm-mips/spinlock.h.~1~	Tue Jul 20 05:42:47 1999<br>
+++ linux-2.3-raw/include/asm-mips/spinlock.h	Thu Sep  9 14:14:15 1999<br>
@@ -3,75 +3,9 @@<br>
 #ifndef __ASM_MIPS_SPINLOCK_H<br>
 #define __ASM_MIPS_SPINLOCK_H<br>
 <br>
-/*<br>
- * These are the generic versions of the spinlocks<br>
- * and read-write locks.. We should actually do a<br>
- * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
- */<br>
-#define spin_lock_irqsave(lock, flags)		do { local_irq_save(flags);       spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock)			do { local_irq_disable();         spin_lock(lock); } while (0)<br>
-#define spin_lock_bh(lock)			do { local_bh_disable();          spin_lock(lock); } while (0)<br>
-<br>
-#define read_lock_irqsave(lock, flags)		do { local_irq_save(flags);       read_lock(lock); } while (0)<br>
-#define read_lock_irq(lock)			do { local_irq_disable();         read_lock(lock); } while (0)<br>
-#define read_lock_bh(lock)			do { local_bh_disable();          read_lock(lock); } while (0)<br>
-<br>
-#define write_lock_irqsave(lock, flags)		do { local_irq_save(flags);      write_lock(lock); } while (0)<br>
-#define write_lock_irq(lock)			do { local_irq_disable();        write_lock(lock); } while (0)<br>
-#define write_lock_bh(lock)			do { local_bh_disable();         write_lock(lock); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags)	do { spin_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define spin_unlock_irq(lock)			do { spin_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define spin_unlock_bh(lock)			do { spin_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define read_unlock_irqrestore(lock, flags)	do { read_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define read_unlock_irq(lock)			do { read_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define read_unlock_bh(lock)			do { read_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define write_unlock_irqrestore(lock, flags)	do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define write_unlock_irq(lock)			do { write_unlock(lock); local_irq_enable();       } while (0)<br>
-#define write_unlock_bh(lock)			do { write_unlock(lock); local_bh_enable();        } while (0)<br>
-<br>
-#ifndef __SMP__<br>
-<br>
-/*<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		do { } while(0)<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- */<br>
-typedef struct { } rwlock_t;<br>
-#define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-<br>
-#define read_lock(lock)		do { } while(0)<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	do { } while(0)<br>
-#define write_unlock(lock)	do { } while(0)<br>
-<br>
-#else<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
+#ifdef CONFIG_SMP<br>
 #error "Nix SMP on MIPS"<br>
-<br>
 #endif /* SMP */<br>
 #endif /* __ASM_MIPS_SPINLOCK_H */<br>
--- linux-2.3-raw/include/asm-ppc/spinlock.h.~1~	Sat Sep  4 15:29:36 1999<br>
+++ linux-2.3-raw/include/asm-ppc/spinlock.h	Thu Sep  9 13:04:29 1999<br>
@@ -1,79 +1,9 @@<br>
 #ifndef __ASM_SPINLOCK_H<br>
 #define __ASM_SPINLOCK_H<br>
 <br>
-#ifndef __SMP__<br>
-/*<br>
- * Your basic spinlocks, allowing only a single CPU anywhere<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } spinlock_t;<br>
-  #define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock)	/* Avoid warnings about unused variable */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-#define spin_lock_irq(lock)	cli()<br>
-#define spin_unlock_irq(lock)	sti()<br>
-#define spin_lock_bh(lock)	local_bh_disable()<br>
-#define spin_unlock_bh(lock)	local_bh_enable()<br>
-#define spin_lock_irqsave(lock, flags) \<br>
-	do { save_flags(flags); cli(); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags) \<br>
-	restore_flags(flags)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- *<br>
- * Gcc-2.7.x has a nasty bug with empty initializers.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-#else<br>
-  typedef struct { int gcc_is_buggy; } rwlock_t;<br>
-  #define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define read_lock(lock)		(void)(lock)	/* Avoid warnings about unused variable */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock)	/* Likewise */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-#define read_lock_irq(lock)	cli()<br>
-#define read_unlock_irq(lock)	sti()<br>
-#define write_lock_irq(lock)	cli()<br>
-#define write_unlock_irq(lock)	sti()<br>
-#define read_lock_bh(lock)	local_bh_disable()<br>
-#define read_unlock_bh(lock)	local_bh_enable()<br>
-#define write_lock_bh(lock)	local_bh_disable()<br>
-#define write_unlock_bh(lock)	local_bh_enable()<br>
-<br>
-#define read_lock_irqsave(lock, flags)	\<br>
-	do { save_flags(flags); cli(); } while (0)<br>
-#define read_unlock_irqrestore(lock, flags) \<br>
-	restore_flags(flags)<br>
-#define write_lock_irqsave(lock, flags)	\<br>
-	do { save_flags(flags); cli(); } while (0)<br>
-#define write_unlock_irqrestore(lock, flags) \<br>
-	restore_flags(flags)<br>
-<br>
-#else /* __SMP__ */<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
+#ifdef CONFIG_SMP<br>
 /* Simple spin lock operations.  There are two variants, one clears IRQ's<br>
  * on the local processor, one does not.<br>
  *<br>
--- linux-2.3-raw/include/asm-sh/spinlock.h.~1~	Sat Sep  4 15:29:36 1999<br>
+++ linux-2.3-raw/include/asm-sh/spinlock.h	Thu Sep  9 14:13:54 1999<br>
@@ -1,108 +1,9 @@<br>
 #ifndef __ASM_SH_SPINLOCK_H<br>
 #define __ASM_SH_SPINLOCK_H<br>
 <br>
-/*<br>
- * These are the generic versions of the spinlocks<br>
- * and read-write locks.. We should actually do a<br>
- * &lt;linux/spinlock.h&gt; with all of this. Oh, well.<br>
- */<br>
-#define spin_lock_irqsave(lock, flags)		do { local_irq_save(flags);       spin_lock(lock); } while (0)<br>
-#define spin_lock_irq(lock)			do { local_irq_disable();         spin_lock(lock); } while (0)<br>
-#define spin_lock_bh(lock)			do { local_bh_disable();          spin_lock(lock); } while (0)<br>
-<br>
-#define read_lock_irqsave(lock, flags)		do { local_irq_save(flags);       read_lock(lock); } while (0)<br>
-#define read_lock_irq(lock)			do { local_irq_disable();         read_lock(lock); } while (0)<br>
-#define read_lock_bh(lock)			do { local_bh_disable();          read_lock(lock); } while (0)<br>
-<br>
-#define write_lock_irqsave(lock, flags)		do { local_irq_save(flags);      write_lock(lock); } while (0)<br>
-#define write_lock_irq(lock)			do { local_irq_disable();        write_lock(lock); } while (0)<br>
-#define write_lock_bh(lock)			do { local_bh_disable();         write_lock(lock); } while (0)<br>
-<br>
-#define spin_unlock_irqrestore(lock, flags)	do { spin_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define spin_unlock_irq(lock)			do { spin_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define spin_unlock_bh(lock)			do { spin_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define read_unlock_irqrestore(lock, flags)	do { read_unlock(lock);  local_irq_restore(flags); } while (0)<br>
-#define read_unlock_irq(lock)			do { read_unlock(lock);  local_irq_enable();       } while (0)<br>
-#define read_unlock_bh(lock)			do { read_unlock(lock);  local_bh_enable();        } while (0)<br>
-<br>
-#define write_unlock_irqrestore(lock, flags)	do { write_unlock(lock); local_irq_restore(flags); } while (0)<br>
-#define write_unlock_irq(lock)			do { write_unlock(lock); local_irq_enable();       } while (0)<br>
-#define write_unlock_bh(lock)			do { write_unlock(lock); local_bh_enable();        } while (0)<br>
-<br>
-#ifndef __SMP__<br>
-<br>
-#define DEBUG_SPINLOCKS	0	/* 0 == no debugging, 1 == maintain lock state, 2 == full debug */<br>
-<br>
-#if (DEBUG_SPINLOCKS &lt; 1)<br>
-<br>
-/*<br>
- * Your basic spinlocks, allowing only a single CPU anywhere<br>
- */<br>
-typedef struct { } spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-<br>
-#elif (DEBUG_SPINLOCKS &lt; 2)<br>
-<br>
-typedef struct {<br>
-	volatile unsigned int lock;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0 }<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-<br>
-#define spin_lock(x)		do { (x)-&gt;lock = 1; } while (0)<br>
-#define spin_unlock_wait(x)	do { } while (0)<br>
-#define spin_unlock(x)		do { (x)-&gt;lock = 0; } while (0)<br>
-<br>
-#else /* (DEBUG_SPINLOCKS &gt;= 2) */<br>
-<br>
-typedef struct {<br>
-	volatile unsigned int lock;<br>
-	volatile unsigned int babble;<br>
-	const char *module;<br>
-} spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED (spinlock_t) { 0, 25, __BASE_FILE__ }<br>
-<br>
-#include &lt;linux/kernel.h&gt;<br>
-<br>
-#define spin_lock_init(x)	do { (x)-&gt;lock = 0; } while (0)<br>
-#define spin_trylock(lock)	(!test_and_set_bit(0,(lock)))<br>
-<br>
-#define spin_lock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_lock(%s:%p) already locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 1; restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock_wait(x)	do {unsigned long __spinflags; save_flags(__spinflags); cli(); if ((x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock_wait(%s:%p) deadlock\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} restore_flags(__spinflags);} while (0)<br>
-#define spin_unlock(x)		do {unsigned long __spinflags; save_flags(__spinflags); cli(); if (!(x)-&gt;lock&amp;&amp;(x)-&gt;babble) {printk("%s:%d: spin_unlock(%s:%p) not locked\n", __BASE_FILE__,__LINE__, (x)-&gt;module, (x));(x)-&gt;babble--;} (x)-&gt;lock = 0; restore_flags(__spinflags);} while (0)<br>
-<br>
-#endif	/* DEBUG_SPINLOCKS */<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- */<br>
-typedef struct { } rwlock_t;<br>
-#define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-<br>
-#define read_lock(lock)		(void)(lock) /* Not "unused variable". */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock) /* Not "unused variable". */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-<br>
-#else<br>
+#include &lt;linux/spinlock.h&gt;<br>
 <br>
+#ifdef CONFIG_SMP<br>
 #error "No SMP on SH"<br>
-<br>
 #endif /* SMP */<br>
 #endif /* __ASM_SH_SPINLOCK_H */<br>
--- linux-2.3-raw/include/asm-sparc/spinlock.h.~1~	Sat Sep  4 15:29:38 1999<br>
+++ linux-2.3-raw/include/asm-sparc/spinlock.h	Thu Sep  9 13:24:04 1999<br>
@@ -10,57 +10,7 @@<br>
 <br>
 #ifndef __ASSEMBLY__<br>
 <br>
-#ifndef __SMP__<br>
-<br>
-typedef unsigned char spinlock_t;<br>
-#define SPIN_LOCK_UNLOCKED 0<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		do { } while(0)<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-#define spin_lock_irq(lock)	cli()<br>
-#define spin_unlock_irq(lock)	sti()<br>
-#define spin_lock_bh(lock)	local_bh_disable()<br>
-#define spin_unlock_bh(lock)	local_bh_enable()<br>
-<br>
-#define spin_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define spin_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- */<br>
-typedef struct { volatile unsigned int lock; } rwlock_t;<br>
-#define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-<br>
-#define read_lock(lock)		do { } while(0)<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	do { } while(0)<br>
-#define write_unlock(lock)	do { } while(0)<br>
-#define read_lock_irq(lock)	cli()<br>
-#define read_unlock_irq(lock)	sti()<br>
-#define write_lock_irq(lock)	cli()<br>
-#define write_unlock_irq(lock)	sti()<br>
-#define read_lock_bh(lock)	local_bh_disable()<br>
-#define read_unlock_bh(lock)	local_bh_enable()<br>
-#define write_lock_bh(lock)	local_bh_disable()<br>
-#define write_unlock_bh(lock)	local_bh_enable()<br>
-<br>
-#define read_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define read_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-#define write_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define write_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-<br>
-#else /* !(__SMP__) */<br>
-<br>
+#ifdef CONFIG_SMP<br>
 #include &lt;asm/psr.h&gt;<br>
 <br>
 /* Define this to use the verbose/debugging versions in arch/sparc/lib/debuglocks.c */<br>
--- linux-2.3-raw/include/asm-sparc64/spinlock.h.~1~	Sat Sep  4 15:29:39 1999<br>
+++ linux-2.3-raw/include/asm-sparc64/spinlock.h	Thu Sep  9 14:07:22 1999<br>
@@ -8,88 +8,7 @@<br>
 <br>
 #ifndef __ASSEMBLY__<br>
 <br>
-#ifndef __SMP__<br>
-<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } spinlock_t;<br>
-# define SPIN_LOCK_UNLOCKED (spinlock_t) { }<br>
-#else<br>
-  typedef unsigned char spinlock_t;<br>
-# define SPIN_LOCK_UNLOCKED 0<br>
-#endif<br>
-<br>
-#define spin_lock_init(lock)	do { } while(0)<br>
-#define spin_lock(lock)		(void)(lock)	/* Avoid warnings about unused variable */<br>
-#define spin_trylock(lock)	(1)<br>
-#define spin_unlock_wait(lock)	do { } while(0)<br>
-#define spin_unlock(lock)	do { } while(0)<br>
-#define spin_lock_irq(lock)	cli()<br>
-#define spin_unlock_irq(lock)	sti()<br>
-#define spin_lock_bh(lock) \<br>
-do {	local_bh_count++; \<br>
-	barrier(); \<br>
-} while(0)<br>
-#define spin_unlock_bh(lock) \<br>
-do {	barrier(); \<br>
-	local_bh_count--; \<br>
-} while(0)<br>
-<br>
-#define spin_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define spin_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-<br>
-/*<br>
- * Read-write spinlocks, allowing multiple readers<br>
- * but only one writer.<br>
- *<br>
- * NOTE! it is quite common to have readers in interrupts<br>
- * but no interrupt writers. For those circumstances we<br>
- * can "mix" irq-safe locks - any writer needs to get a<br>
- * irq-safe write-lock, but readers can get non-irqsafe<br>
- * read-locks.<br>
- */<br>
-#if (__GNUC__ &gt; 2) || (__GNUC__ == 2 &amp;&amp; __GNUC_MINOR__ &gt;= 8)<br>
-  typedef struct { } rwlock_t;<br>
-# define RW_LOCK_UNLOCKED (rwlock_t) { }<br>
-#else<br>
-  typedef unsigned int rwlock_t;<br>
-# define RW_LOCK_UNLOCKED (rwlock_t) { 0 }<br>
-#endif<br>
-<br>
-#define read_lock(lock)		(void)(lock)	/* Avoid warnings about unused variable */<br>
-#define read_unlock(lock)	do { } while(0)<br>
-#define write_lock(lock)	(void)(lock)	/* Likewise */<br>
-#define write_unlock(lock)	do { } while(0)<br>
-#define read_lock_irq(lock)	cli()<br>
-#define read_unlock_irq(lock)	sti()<br>
-#define read_lock_bh(lock) \<br>
-do {	local_bh_count++; \<br>
-	barrier(); \<br>
-} while(0)<br>
-#define read_unlock_bh(lock) \<br>
-do {	barrier(); \<br>
-	local_bh_count--; \<br>
-} while(0)<br>
-<br>
-#define write_lock_irq(lock)	cli()<br>
-#define write_unlock_irq(lock)	sti()<br>
-<br>
-#define write_lock_bh(lock) \<br>
-do {	local_bh_count++; \<br>
-	barrier(); \<br>
-} while(0)<br>
- <br>
-#define write_unlock_bh(lock) \<br>
-do {	barrier(); \<br>
-	local_bh_count--; \<br>
-} while(0)<br>
-<br>
-#define read_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define read_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-#define write_lock_irqsave(lock, flags)		save_and_cli(flags)<br>
-#define write_unlock_irqrestore(lock, flags)	restore_flags(flags)<br>
-<br>
-#else /* !(__SMP__) */<br>
-<br>
+#ifdef CONFIG_SMP<br>
 /* To get debugging spinlocks which detect and catch<br>
  * deadlock situations, set DEBUG_SPINLOCKS in the sparc64<br>
  * specific makefile and rebuild your kernel.<br>
<p>
<pre>
--
Hacking time.
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0561.html">Mike A. Harris: "Re: Accountability"</a>
<li> <b>Previous message:</b> <a href="0559.html">Matthew Bader: "kernel Oopsen in 2.2.12 SMP"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
