<!-- received="Tue Sep 14 09:11:55 1999 EET DST" -->
<!-- sent="Mon, 13 Sep 1999 23:09:00 -0700 (PDT)" -->
<!-- name="Pete Zaitcev" -->
<!-- email="zaitcev@metabyte.com" -->
<!-- subject="mm/swapfile.c problem" -->
<!-- id="199909140609.XAA07432@ns1.metabyte.com" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: mm/swapfile.c problem</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>mm/swapfile.c problem</h1>
<b>Pete Zaitcev</b> (<a href="mailto:zaitcev@metabyte.com"><i>zaitcev@metabyte.com</i></a>)<br>
<i>Mon, 13 Sep 1999 23:09:00 -0700 (PDT)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#381">[ date ]</a><a href="index.html#381">[ thread ]</a><a href="subject.html#381">[ subject ]</a><a href="author.html#381">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0382.html">Rogier Wolff: "Re: only root has acces to /dev/mem ?"</a>
<li> <b>Previous message:</b> <a href="0380.html">=?ISO-8859-1?Q?=BE=E7=BB=F3=C8=C: "=?ISO-8859-1?Q?=C0=D0=BE=EE?= =?ISO-8859-1?Q?=C1=D6=BC=C5=BC=AD?= =?ISO-8859-1?Q?=B0=ED=B8=BF=BD=C0=B4=CF=B4=D9...-=C3=DF=BC=AE=BC=B1=B9=B0-?="</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0425.html">Andrea Arcangeli: "Re: mm/swapfile.c problem"</a>
<li> <b>Reply:</b> <a href="0425.html">Andrea Arcangeli: "Re: mm/swapfile.c problem"</a>
<li> <b>Reply:</b> <a href="0532.html">Stephen C. Tweedie: "Re: mm/swapfile.c problem"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi, I have a small problem with 2.3.18.<br>
<p>
If a swap device does not come online on reboot, sys_swapon() does<br>
lock_page(), then rw_swap_page_nolock (unsuccessful) and goes to<br>
bad_swap, where it calls free_page(swap_header). This causes the<br>
following diagnostic: "kernel BUG in page_alloc.c:161", and a NULL<br>
pointer dereference somewhere down the line. I would like to see<br>
something along these lines:<br>
<p>
--- mm/swapfile.c       1999/08/31 06:50:36     1.59<br>
+++ mm/swapfile.c       1999/09/14 05:48:49<br>
@@ -771,8 +771,11 @@<br>
        if (!(swap_flags &amp; SWAP_FLAG_PREFER))<br>
                ++least_priority;<br>
 out:<br>
-       if (swap_header)<br>
+       if (swap_header) {<br>
+               mem_map_t *page = mem_map + MAP_NR(swap_header);<br>
+               UnlockPage(page);<br>
                free_page((long) swap_header);<br>
+       }<br>
        unlock_kernel();<br>
        return error;<br>
 }<br>
<p>
Thanks,<br>
--Pete<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0382.html">Rogier Wolff: "Re: only root has acces to /dev/mem ?"</a>
<li> <b>Previous message:</b> <a href="0380.html">=?ISO-8859-1?Q?=BE=E7=BB=F3=C8=C: "=?ISO-8859-1?Q?=C0=D0=BE=EE?= =?ISO-8859-1?Q?=C1=D6=BC=C5=BC=AD?= =?ISO-8859-1?Q?=B0=ED=B8=BF=BD=C0=B4=CF=B4=D9...-=C3=DF=BC=AE=BC=B1=B9=B0-?="</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0425.html">Andrea Arcangeli: "Re: mm/swapfile.c problem"</a>
<li> <b>Reply:</b> <a href="0425.html">Andrea Arcangeli: "Re: mm/swapfile.c problem"</a>
<li> <b>Reply:</b> <a href="0532.html">Stephen C. Tweedie: "Re: mm/swapfile.c problem"</a>
<!-- reply="end" -->
</ul>
</font></body>
