<!-- received="Tue Sep 14 08:27:27 1999 EET DST" -->
<!-- sent="Tue, 14 Sep 1999 15:19:39 +1000" -->
<!-- name="Paul Mackerras" -->
<!-- email="paulus@cs.anu.edu.au" -->
<!-- subject="Re: 2.2.13pre5/6/7 strnlen for PPC" -->
<!-- id="199909140519.PAA07932@tango.anu.edu.au" -->
<!-- inreplyto="2.2.13pre5/6/7 strnlen for PPC" -->
<title>Linux-kernel mailing list archive 1999-37,: Re: 2.2.13pre5/6/7 strnlen for PPC</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.2.13pre5/6/7 strnlen for PPC</h1>
<b>Paul Mackerras</b> (<a href="mailto:paulus@cs.anu.edu.au"><i>paulus@cs.anu.edu.au</i></a>)<br>
<i>Tue, 14 Sep 1999 15:19:39 +1000</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#377">[ date ]</a><a href="index.html#377">[ thread ]</a><a href="subject.html#377">[ subject ]</a><a href="author.html#377">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0378.html">Stuart Midgley: "Re: em86 broken with 2.2.12 and above"</a>
<li> <b>Previous message:</b> <a href="0376.html">Marty Leisner: "SEMMSL (from older code...)"</a>
<li> <b>Maybe in reply to:</b> <a href="0277.html">Andreas Tobler: "2.2.13pre5/6/7 strnlen for PPC"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Andreas Tobler &lt;<a href="mailto:toa@pop.agri.ch">toa@pop.agri.ch</a>&gt; wrote:<br>
<p>
<i>&gt; A little exploration showed me, that in alpha, i386 and sparc some</i><br>
<i>&gt; updates concerning the strnlen_user were done. </i><br>
<i>&gt; Is the PPC part already done? I got some problems when I saw the</i><br>
<p>
I have done a strnlen_user and sent the patch to Alan.  In the<br>
meantime, here's the patch to implement strnlen_user.<br>
<p>
Paul.<br>
<p>
diff -urN official/arch/ppc/kernel/ppc_ksyms.c linux/arch/ppc/kernel/ppc_ksyms.c<br>
--- official/arch/ppc/kernel/ppc_ksyms.c	Mon Sep 13 10:56:11 1999<br>
+++ linux/arch/ppc/kernel/ppc_ksyms.c	Mon Sep 13 10:54:48 1999<br>
@@ -121,7 +121,7 @@<br>
 EXPORT_SYMBOL(__copy_tofrom_user);<br>
 EXPORT_SYMBOL(__clear_user);<br>
 EXPORT_SYMBOL(__strncpy_from_user);<br>
-EXPORT_SYMBOL(strlen_user);<br>
+EXPORT_SYMBOL(__strnlen_user);<br>
 <br>
 /*<br>
 EXPORT_SYMBOL(inb);<br>
diff -urN official/arch/ppc/lib/string.S linux/arch/ppc/lib/string.S<br>
--- official/arch/ppc/lib/string.S	Thu Apr 29 16:43:58 1999<br>
+++ linux/arch/ppc/lib/string.S	Mon Sep 13 10:56:54 1999<br>
@@ -380,16 +380,26 @@<br>
 	.long	1b,99b<br>
 .text<br>
 <br>
-	.globl	strlen_user<br>
-strlen_user:<br>
-	addi	r4,r3,-1<br>
-1:	lbzu	r0,1(r4)<br>
+/* r3 = str, r4 = len (&gt; 0), r5 = top (highest addr + 1) */<br>
+	.globl	__strnlen_user<br>
+__strnlen_user:<br>
+	subf	r6,r3,r5	/* top - str */<br>
+	addi	r7,r3,-1<br>
+	cmplw	0,r4,r6<br>
+	bge	0f<br>
+	mr	r6,r4<br>
+0:	mtctr	r6		/* ctr = min(len, top - str) */<br>
+1:	lbzu	r0,1(r7)	/* get next byte */<br>
 	cmpwi	0,r0,0<br>
-	bne	1b<br>
-	subf	r3,r3,r4<br>
-	addi	r3,r3,1<br>
+	bdnzf	2,1b		/* loop if --ctr != 0 &amp;&amp; byte != 0 */<br>
+	addi	r7,r7,1<br>
+	subf	r3,r3,r7	/* number of bytes we have looked at */<br>
+	beqlr			/* return if we found a 0 byte */<br>
+	cmpw	0,r3,r4		/* did we look at all len bytes? */<br>
+	blt	99f		/* if not, must have hit top */<br>
+	addi	r3,r4,1		/* return len + 1 to indicate no null found */<br>
 	blr<br>
-99:	li	r3,0<br>
+99:	li	r3,0		/* bad address, return 0 */<br>
 	blr<br>
 .section __ex_table,"a"<br>
 	.align	2<br>
diff -urN official/include/asm-ppc/uaccess.h linux/include/asm-ppc/uaccess.h<br>
--- official/include/asm-ppc/uaccess.h	Wed Mar 24 10:20:25 1999<br>
+++ linux/include/asm-ppc/uaccess.h	Mon Sep 13 11:09:23 1999<br>
@@ -259,7 +259,24 @@<br>
  * Return 0 for error<br>
  */<br>
 <br>
-extern long strlen_user(const char *);<br>
+extern int __strnlen_user(const char *str, long len, unsigned long top);<br>
+<br>
+/*<br>
+ * Returns the length of the string at str (including the null byte),<br>
+ * or 0 if we hit a page we can't access,<br>
+ * or something &gt; len if we didn't find a null byte.<br>
+ *<br>
+ * The `top' parameter to __strnlen_user is to make sure that<br>
+ * we can never overflow from the user area into kernel space.<br>
+ * It is 1 + the highest address the task can access.<br>
+ */<br>
+extern __inline__ int strnlen_user(const char *str, long len)<br>
+{<br>
+	unsigned long top = __kernel_ok? 0: TASK_SIZE;<br>
+	return __strnlen_user(str, len, top);<br>
+}<br>
+<br>
+#define strlen_user(str)	strnlen_user((str), 0x7ffffffe)<br>
 <br>
 #endif  /* __ASSEMBLY__ */<br>
 <br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0378.html">Stuart Midgley: "Re: em86 broken with 2.2.12 and above"</a>
<li> <b>Previous message:</b> <a href="0376.html">Marty Leisner: "SEMMSL (from older code...)"</a>
<li> <b>Maybe in reply to:</b> <a href="0277.html">Andreas Tobler: "2.2.13pre5/6/7 strnlen for PPC"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
