<!-- received="Mon Sep 13 22:20:40 1999 EET DST" -->
<!-- sent="Mon, 13 Sep 1999 21:01:00 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] inode dynamic allocation" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [patch] inode dynamic allocation</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] inode dynamic allocation</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Mon, 13 Sep 1999 21:01:00 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#284">[ date ]</a><a href="index.html#284">[ thread ]</a><a href="subject.html#284">[ subject ]</a><a href="author.html#284">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0285.html">Jens Benecke: "Re: New Idea?  Capture video settings details in Win98/etc. for XFree86 config"</a>
<li> <b>Previous message:</b> <a href="0283.html">Avenger: "Re: S3 Trio FB"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
I rewrote the inode memory management to make it dynamic. The inode<br>
memory managmenet is very similar to the dcache memory management. Only<br>
valid/useful inodes lives in memory. The inodes with i_count zero (so the<br>
inodes that we may shrink) are queued in a separate list so at shrink-time<br>
we'll try to free only the caching-inodes and not the in-use inodes.<br>
<p>
The icache is shrink after the dcache in do_try_to_free_pages.<br>
<p>
The thing seems to works fine and I believe it's the right design. It<br>
completly avoids any kind of DoS since as we are low on memory the cache<br>
is automatically shrunk and it allow us to cache really lots of inodes (so<br>
the dcache can safely grow a lot).<br>
<p>
Here it is the patch against 2.3.18ac2:<br>
<p>
diff -urN 2.3.18ac2/fs/dcache.c 2.3.18ac2-inode/fs/dcache.c<br>
--- 2.3.18ac2/fs/dcache.c	Wed Sep  8 00:26:01 1999<br>
+++ 2.3.18ac2-inode/fs/dcache.c	Mon Sep 13 19:15:48 1999<br>
@@ -284,8 +284,10 @@<br>
  * something (at which point we need to unuse<br>
  * all dentries).<br>
  */<br>
-void prune_dcache(int count)<br>
+int prune_dcache(int goal)<br>
 {<br>
+	int count = 0;<br>
+<br>
 	for (;;) {<br>
 		struct dentry *dentry;<br>
 		struct list_head *tmp = dentry_unused.prev;<br>
@@ -298,10 +300,13 @@<br>
 		dentry = list_entry(tmp, struct dentry, d_lru);<br>
 		if (!dentry-&gt;d_count) {<br>
 			prune_one_dentry(dentry);<br>
-			if (!--count)<br>
+			count++;<br>
+			if (!--goal)<br>
 				break;<br>
 		}<br>
 	}<br>
+<br>
+	return count;<br>
 }<br>
 <br>
 /*<br>
@@ -470,16 +475,20 @@<br>
  *  ...<br>
  *   6 - base-level: try to shrink a bit.<br>
  */<br>
-void shrink_dcache_memory(int priority, unsigned int gfp_mask)<br>
+int shrink_dcache_memory(int priority, unsigned int gfp_mask)<br>
 {<br>
+	int ret = 0;<br>
+<br>
 	if (gfp_mask &amp; __GFP_IO) {<br>
 		int count = 0;<br>
 		lock_kernel();<br>
 		if (priority)<br>
 			count = dentry_stat.nr_unused / priority;<br>
-		prune_dcache(count);<br>
+		ret = prune_dcache(count);<br>
 		unlock_kernel();<br>
 	}<br>
+<br>
+	return ret;<br>
 }<br>
 <br>
 #define NAME_ALLOC_LEN(len)	((len+16) &amp; ~15)<br>
diff -urN 2.3.18ac2/fs/dquot.c 2.3.18ac2-inode/fs/dquot.c<br>
--- 2.3.18ac2/fs/dquot.c	Wed Sep  8 00:26:01 1999<br>
+++ 2.3.18ac2-inode/fs/dquot.c	Mon Sep 13 19:15:48 1999<br>
@@ -520,7 +520,7 @@<br>
 	if (count) {<br>
 		printk(KERN_DEBUG "get_empty_dquot: pruning %d\n", count);<br>
 		prune_dcache(count);<br>
-		free_inode_memory(count);<br>
+		prune_icache(count);<br>
 		goto repeat;<br>
 	}<br>
 <br>
diff -urN 2.3.18ac2/fs/inode.c 2.3.18ac2-inode/fs/inode.c<br>
--- 2.3.18ac2/fs/inode.c	Wed Sep  8 00:26:02 1999<br>
+++ 2.3.18ac2-inode/fs/inode.c	Mon Sep 13 19:15:48 1999<br>
@@ -10,6 +10,7 @@<br>
 #include &lt;linux/dcache.h&gt;<br>
 #include &lt;linux/init.h&gt;<br>
 #include &lt;linux/quotaops.h&gt;<br>
+#include &lt;linux/slab.h&gt;<br>
 <br>
 /*<br>
  * New inode.c implementation.<br>
@@ -21,6 +22,8 @@<br>
  * Famous last words.<br>
  */<br>
 <br>
+/* inode dynamic allocation 1999, Andrea Arcangeli &lt;<a href="mailto:andrea@suse.de">andrea@suse.de</a>&gt; */<br>
+<br>
 #define INODE_PARANOIA 1<br>
 /* #define INODE_DEBUG 1 */<br>
 <br>
@@ -36,9 +39,9 @@<br>
  * Each inode can be on two separate lists. One is<br>
  * the hash list of the inode, used for lookups. The<br>
  * other linked list is the "type" list:<br>
- *  "in_use" - valid inode, hashed if i_nlink &gt; 0<br>
- *  "dirty"  - valid inode, hashed if i_nlink &gt; 0, dirty.<br>
- *  "unused" - ready to be re-used. Not hashed.<br>
+ *  "in_use" - valid inode, i_count &gt; 0, i_nlink &gt; 0<br>
+ *  "dirty"  - as "in_use" but also dirty<br>
+ *  "unused" - valid inode, i_count = 0<br>
  *<br>
  * A "dirty" list is maintained for each super block,<br>
  * allowing for low-overhead inode sync() operations.<br>
@@ -61,11 +64,36 @@<br>
  */<br>
 struct {<br>
 	int nr_inodes;<br>
-	int nr_free_inodes;<br>
+	int nr_unused;<br>
 	int dummy[5];<br>
 } inodes_stat = {0, 0,};<br>
 <br>
-int max_inodes;<br>
+static kmem_cache_t * inode_cachep;<br>
+<br>
+#define alloc_inode() \<br>
+	 ((struct inode *) kmem_cache_alloc(inode_cachep, SLAB_KERNEL))<br>
+#define destroy_inode(inode) kmem_cache_free(inode_cachep, (inode))<br>
+<br>
+/*<br>
+ * These are initializations that only need to be done<br>
+ * once, because the fields are idempotent across use<br>
+ * of the inode, so let the slab aware of that.<br>
+ */<br>
+static void init_once(void * foo, kmem_cache_t * cachep, unsigned long flags)<br>
+{<br>
+	struct inode * inode = (struct inode *) foo;<br>
+<br>
+	if ((flags &amp; (SLAB_CTOR_VERIFY|SLAB_CTOR_CONSTRUCTOR)) ==<br>
+	    SLAB_CTOR_CONSTRUCTOR)<br>
+	{<br>
+		memset(inode, 0, sizeof(*inode));<br>
+		init_waitqueue_head(&amp;inode-&gt;i_wait);<br>
+		INIT_LIST_HEAD(&amp;inode-&gt;i_hash);<br>
+		INIT_LIST_HEAD(&amp;inode-&gt;i_dentry);<br>
+		sema_init(&amp;inode-&gt;i_sem, 1);<br>
+		spin_lock_init(&amp;inode-&gt;i_shared_lock);<br>
+	}<br>
+}<br>
 <br>
 /*<br>
  * Put the inode on the super block's dirty list.<br>
@@ -118,20 +146,6 @@<br>
 		__wait_on_inode(inode);<br>
 }<br>
 <br>
-/*<br>
- * These are initializations that only need to be done<br>
- * once, because the fields are idempotent across use<br>
- * of the inode..<br>
- */<br>
-static inline void init_once(struct inode * inode)<br>
-{<br>
-	memset(inode, 0, sizeof(*inode));<br>
-	init_waitqueue_head(&amp;inode-&gt;i_wait);<br>
-	INIT_LIST_HEAD(&amp;inode-&gt;i_hash);<br>
-	INIT_LIST_HEAD(&amp;inode-&gt;i_dentry);<br>
-	sema_init(&amp;inode-&gt;i_sem, 1);<br>
-	spin_lock_init(&amp;inode-&gt;i_shared_lock);<br>
-}<br>
 <br>
 static inline void write_inode(struct inode *inode)<br>
 {<br>
@@ -147,7 +161,8 @@<br>
 		spin_lock(&amp;inode_lock);<br>
 	} else {<br>
 		list_del(&amp;inode-&gt;i_list);<br>
-		list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
+		list_add(&amp;inode-&gt;i_list,<br>
+			 inode-&gt;i_count ? &amp;inode_in_use : &amp;inode_unused);<br>
 		/* Set I_LOCK, reset I_DIRTY */<br>
 		inode-&gt;i_state ^= I_DIRTY | I_LOCK;<br>
 		spin_unlock(&amp;inode_lock);<br>
@@ -233,6 +248,8 @@<br>
 {<br>
 	if (inode-&gt;i_nrpages)<br>
 		BUG();<br>
+	if (!(inode-&gt;i_state &amp; I_FREEING))<br>
+		BUG();<br>
 	wait_on_inode(inode);<br>
 	if (IS_QUOTAINIT(inode))<br>
 		DQUOT_DROP(inode);<br>
@@ -243,35 +260,24 @@<br>
 }<br>
 <br>
 /*<br>
- * Dispose-list gets a local list, so it doesn't need to<br>
- * worry about list corruption. It releases the inode lock<br>
- * while clearing the inodes.<br>
+ * Dispose-list gets a local list with local inodes in it, so it doesn't<br>
+ * need to worry about list corruption and SMP locks.<br>
  */<br>
 static void dispose_list(struct list_head * head)<br>
 {<br>
-	struct list_head *next;<br>
-	int count = 0;<br>
+	struct list_head * inode_entry;<br>
+	struct inode * inode;<br>
 <br>
-	spin_unlock(&amp;inode_lock);<br>
-	next = head-&gt;next;<br>
-	for (;;) {<br>
-		struct list_head * tmp = next;<br>
-		struct inode * inode;<br>
+	while ((inode_entry = head-&gt;next) != head)<br>
+	{<br>
+		list_del(inode_entry);<br>
 <br>
-		next = next-&gt;next;<br>
-		if (tmp == head)<br>
-			break;<br>
-		inode = list_entry(tmp, struct inode, i_list);<br>
+		inode = list_entry(inode_entry, struct inode, i_list);<br>
 		if (inode-&gt;i_nrpages)<br>
 			truncate_inode_pages(inode, 0);<br>
 		clear_inode(inode);<br>
-		count++;<br>
+		destroy_inode(inode);<br>
 	}<br>
-<br>
-	/* Add them all to the unused list in one fell swoop */<br>
-	spin_lock(&amp;inode_lock);<br>
-	list_splice(head, &amp;inode_unused);<br>
-	inodes_stat.nr_free_inodes += count;<br>
 }<br>
 <br>
 /*<br>
@@ -280,7 +286,7 @@<br>
 static int invalidate_list(struct list_head *head, struct super_block * sb, struct list_head * dispose)<br>
 {<br>
 	struct list_head *next;<br>
-	int busy = 0;<br>
+	int busy = 0, count = 0;<br>
 <br>
 	next = head-&gt;next;<br>
 	for (;;) {<br>
@@ -299,10 +305,13 @@<br>
 			list_del(&amp;inode-&gt;i_list);<br>
 			list_add(&amp;inode-&gt;i_list, dispose);<br>
 			inode-&gt;i_state |= I_FREEING;<br>
+			count++;<br>
 			continue;<br>
 		}<br>
 		busy = 1;<br>
 	}<br>
+	/* only unused inodes may be cached with i_count zero */<br>
+	inodes_stat.nr_unused -= count;<br>
 	return busy;<br>
 }<br>
 <br>
@@ -320,10 +329,12 @@<br>
 <br>
 	spin_lock(&amp;inode_lock);<br>
 	busy = invalidate_list(&amp;inode_in_use, sb, &amp;throw_away);<br>
+	busy |= invalidate_list(&amp;inode_unused, sb, &amp;throw_away);<br>
 	busy |= invalidate_list(&amp;sb-&gt;s_dirty, sb, &amp;throw_away);<br>
-	dispose_list(&amp;throw_away);<br>
 	spin_unlock(&amp;inode_lock);<br>
 <br>
+	dispose_list(&amp;throw_away);<br>
+<br>
 	return busy;<br>
 }<br>
 <br>
@@ -339,155 +350,79 @@<br>
  *      dispose_list.<br>
  */<br>
 #define CAN_UNUSE(inode) \<br>
-	(((inode)-&gt;i_count | (inode)-&gt;i_state | (inode)-&gt;i_nrpages) == 0)<br>
+	(((inode)-&gt;i_state | (inode)-&gt;i_nrpages) == 0)<br>
 #define INODE(entry)	(list_entry(entry, struct inode, i_list))<br>
 <br>
-static int free_inodes(void)<br>
+int prune_icache(int goal)<br>
 {<br>
-	struct list_head list, *entry, *freeable = &amp;list;<br>
-	int found = 0;<br>
+	LIST_HEAD(list);<br>
+	struct list_head *entry, *freeable = &amp;list;<br>
+	int count = 0;<br>
+	struct inode * inode;<br>
 <br>
-	INIT_LIST_HEAD(freeable);<br>
-	entry = inode_in_use.next;<br>
-	while (entry != &amp;inode_in_use) {<br>
+	spin_lock(&amp;inode_lock);<br>
+	/* go simple and safe syncing everything before starting */<br>
+	sync_all_inodes();<br>
+<br>
+	entry = inode_unused.prev;<br>
+	while (entry != &amp;inode_unused)<br>
+	{<br>
 		struct list_head *tmp = entry;<br>
 <br>
-		entry = entry-&gt;next;<br>
-		if (!CAN_UNUSE(INODE(tmp)))<br>
+		entry = entry-&gt;prev;<br>
+		inode = INODE(tmp);<br>
+		if (!CAN_UNUSE(inode))<br>
 			continue;<br>
+		if (inode-&gt;i_count)<br>
+			BUG();<br>
 		list_del(tmp);<br>
-		list_del(&amp;INODE(tmp)-&gt;i_hash);<br>
-		INIT_LIST_HEAD(&amp;INODE(tmp)-&gt;i_hash);<br>
+		list_del(&amp;inode-&gt;i_hash);<br>
+		INIT_LIST_HEAD(&amp;inode-&gt;i_hash);<br>
 		list_add(tmp, freeable);<br>
-		list_entry(tmp, struct inode, i_list)-&gt;i_state = I_FREEING;<br>
-		found = 1;<br>
+		inode-&gt;i_state |= I_FREEING;<br>
+		count++;<br>
+		if (!--goal)<br>
+			break;<br>
 	}<br>
+	inodes_stat.nr_unused -= count;<br>
+	spin_unlock(&amp;inode_lock);<br>
 <br>
-	if (found)<br>
-		dispose_list(freeable);<br>
+	dispose_list(freeable);<br>
 <br>
-	return found;<br>
+	return count;<br>
 }<br>
 <br>
-/*<br>
- * Searches the inodes list for freeable inodes,<br>
- * shrinking the dcache before (and possible after,<br>
- * if we're low)<br>
- */<br>
-static void try_to_free_inodes(int goal)<br>
+int shrink_icache_memory(int priority, int gfp_mask)<br>
 {<br>
-	/*<br>
-	 * First stry to just get rid of unused inodes.<br>
-	 *<br>
-	 * If we can't reach our goal that way, we'll have<br>
-	 * to try to shrink the dcache and sync existing<br>
-	 * inodes..<br>
-	 */<br>
-	free_inodes();<br>
-	goal -= inodes_stat.nr_free_inodes;<br>
-	if (goal &gt; 0) {<br>
-		spin_unlock(&amp;inode_lock);<br>
-		select_dcache(goal, 0);<br>
-		prune_dcache(goal);<br>
-		spin_lock(&amp;inode_lock);<br>
-		sync_all_inodes();<br>
-		free_inodes();<br>
+	if (gfp_mask &amp; __GFP_IO)<br>
+	{<br>
+		int count = 0;<br>
+		if (priority)<br>
+			count = inodes_stat.nr_unused / priority;<br>
+		return prune_icache(count);<br>
 	}<br>
-}<br>
 <br>
-/*<br>
- * This is the externally visible routine for<br>
- * inode memory management.<br>
- */<br>
-void free_inode_memory(int goal)<br>
-{<br>
-	spin_lock(&amp;inode_lock);<br>
-	free_inodes();<br>
-	spin_unlock(&amp;inode_lock);<br>
+	return 0;<br>
 }<br>
 <br>
-<br>
-/*<br>
- * This is called with the spinlock held, but releases<br>
- * the lock when freeing or allocating inodes.<br>
- * Look out! This returns with the inode lock held if<br>
- * it got an inode..<br>
- *<br>
- * We do inode allocations two pages at a time to reduce<br>
- * fragmentation.<br>
- */<br>
-#define INODE_PAGE_ORDER	1<br>
-#define INODE_ALLOCATION_SIZE	(PAGE_SIZE &lt;&lt; INODE_PAGE_ORDER)<br>
-#define INODES_PER_ALLOCATION	(INODE_ALLOCATION_SIZE/sizeof(struct inode))<br>
-<br>
-static struct inode * grow_inodes(void)<br>
+static inline void __iget(struct inode * inode)<br>
 {<br>
-	struct inode * inode;<br>
-<br>
-	/*<br>
-	 * Check whether to restock the unused list.<br>
-	 */<br>
-	if (inodes_stat.nr_inodes &gt; max_inodes) {<br>
-		struct list_head *tmp;<br>
-		try_to_free_inodes(inodes_stat.nr_inodes &gt;&gt; 2);<br>
-		tmp = inode_unused.next;<br>
-		if (tmp != &amp;inode_unused) {<br>
-			inodes_stat.nr_free_inodes--;<br>
-			list_del(tmp);<br>
-			inode = list_entry(tmp, struct inode, i_list);<br>
-			return inode;<br>
-		}<br>
-	}<br>
-		<br>
-	spin_unlock(&amp;inode_lock);<br>
-	inode = (struct inode *)__get_free_pages(GFP_KERNEL,INODE_PAGE_ORDER);<br>
-	if (inode) {<br>
-		int size;<br>
-		struct inode * tmp;<br>
-<br>
-		size = INODE_ALLOCATION_SIZE - 2*sizeof(struct inode);<br>
-		tmp = inode;<br>
-		spin_lock(&amp;inode_lock);<br>
-		do {<br>
-			tmp++;<br>
-			init_once(tmp);<br>
-			list_add(&amp;tmp-&gt;i_list, &amp;inode_unused);<br>
-			size -= sizeof(struct inode);<br>
-		} while (size &gt;= 0);<br>
-		init_once(inode);<br>
-		/*<br>
-		 * Update the inode statistics<br>
-		 */<br>
-		inodes_stat.nr_inodes += INODES_PER_ALLOCATION;<br>
-		inodes_stat.nr_free_inodes += INODES_PER_ALLOCATION - 1;<br>
-		return inode;<br>
-	}<br>
-<br>
-	/*<br>
-	 * If the allocation failed, do an extensive pruning of <br>
-	 * the dcache and then try again to free some inodes.<br>
-	 */<br>
-	prune_dcache(inodes_stat.nr_inodes &gt;&gt; 2);<br>
-<br>
-	spin_lock(&amp;inode_lock);<br>
-	free_inodes();<br>
+	if (!inode-&gt;i_count++)<br>
 	{<br>
-		struct list_head *tmp = inode_unused.next;<br>
-		if (tmp != &amp;inode_unused) {<br>
-			inodes_stat.nr_free_inodes--;<br>
-			list_del(tmp);<br>
-			inode = list_entry(tmp, struct inode, i_list);<br>
-			return inode;<br>
+		if (!(inode-&gt;i_state &amp; I_DIRTY))<br>
+		{<br>
+			list_del(&amp;inode-&gt;i_list);<br>
+			list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
 		}<br>
+		inodes_stat.nr_unused--;<br>
 	}<br>
-	spin_unlock(&amp;inode_lock);<br>
-<br>
-	printk("grow_inodes: allocation failed\n");<br>
-	return NULL;<br>
 }<br>
 <br>
 /*<br>
  * Called with the inode lock held.<br>
+ * NOTE: we are not increasing the inode-refcount, you must call __iget()<br>
+ * by hand after calling find_inode now! This simplify iunique and won't<br>
+ * add any additional branch in the common code.<br>
  */<br>
 static struct inode * find_inode(struct super_block * sb, unsigned long ino, struct list_head *head)<br>
 {<br>
@@ -505,7 +440,6 @@<br>
 			continue;<br>
 		if (inode-&gt;i_ino != ino)<br>
 			continue;<br>
-		inode-&gt;i_count++;<br>
 		break;<br>
 	}<br>
 	return inode;<br>
@@ -518,7 +452,7 @@<br>
  * i_sb, i_ino, i_count, i_state and the lists have<br>
  * been initialized elsewhere..<br>
  */<br>
-void clean_inode(struct inode *inode)<br>
+static void clean_inode(struct inode *inode)<br>
 {<br>
 	memset(&amp;inode-&gt;u, 0, sizeof(inode-&gt;u));<br>
 	inode-&gt;i_sock = 0;<br>
@@ -528,7 +462,6 @@<br>
 	inode-&gt;i_size = 0;<br>
 	inode-&gt;i_generation = 0;<br>
 	memset(&amp;inode-&gt;i_dquot, 0, sizeof(inode-&gt;i_dquot));<br>
-	sema_init(&amp;inode-&gt;i_sem, 1);<br>
 	inode-&gt;i_pipe = NULL;<br>
 }<br>
 <br>
@@ -542,15 +475,11 @@<br>
 {<br>
 	static unsigned long last_ino = 0;<br>
 	struct inode * inode;<br>
-	struct list_head * tmp;<br>
 <br>
-	spin_lock(&amp;inode_lock);<br>
-	tmp = inode_unused.next;<br>
-	if (tmp != &amp;inode_unused) {<br>
-		list_del(tmp);<br>
-		inodes_stat.nr_free_inodes--;<br>
-		inode = list_entry(tmp, struct inode, i_list);<br>
-add_new_inode:<br>
+	inode = alloc_inode();<br>
+	if (inode)<br>
+	{<br>
+		spin_lock(&amp;inode_lock);<br>
 		list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
 		inode-&gt;i_sb = NULL;<br>
 		inode-&gt;i_dev = 0;<br>
@@ -560,22 +489,12 @@<br>
 		inode-&gt;i_state = 0;<br>
 		spin_unlock(&amp;inode_lock);<br>
 		clean_inode(inode);<br>
-		return inode;<br>
 	}<br>
-<br>
-	/*<br>
-	 * Warning: if this succeeded, we will now<br>
-	 * return with the inode lock.<br>
-	 */<br>
-	inode = grow_inodes();<br>
-	if (inode)<br>
-		goto add_new_inode;<br>
-<br>
 	return inode;<br>
 }<br>
 <br>
 /*<br>
- * This is called with the inode lock held.. Be careful.<br>
+ * This is called without the inode lock held.. Be careful.<br>
  *<br>
  * We no longer cache the sb_flags in i_flags - see fs.h<br>
  *	-- <a href="mailto:rmk@arm.uk.linux.org">rmk@arm.uk.linux.org</a><br>
@@ -583,56 +502,47 @@<br>
 static struct inode * get_new_inode(struct super_block *sb, unsigned long ino, struct list_head *head)<br>
 {<br>
 	struct inode * inode;<br>
-	struct list_head * tmp = inode_unused.next;<br>
 <br>
-	if (tmp != &amp;inode_unused) {<br>
-		list_del(tmp);<br>
-		inodes_stat.nr_free_inodes--;<br>
-		inode = list_entry(tmp, struct inode, i_list);<br>
-add_new_inode:<br>
-		list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
-		list_add(&amp;inode-&gt;i_hash, head);<br>
-		inode-&gt;i_sb = sb;<br>
-		inode-&gt;i_dev = sb-&gt;s_dev;<br>
-		inode-&gt;i_ino = ino;<br>
-		inode-&gt;i_flags = 0;<br>
-		inode-&gt;i_count = 1;<br>
-		inode-&gt;i_state = I_LOCK;<br>
-		spin_unlock(&amp;inode_lock);<br>
+	inode = alloc_inode();<br>
+	if (inode) {<br>
+		struct inode * old;<br>
 <br>
-		clean_inode(inode);<br>
-		sb-&gt;s_op-&gt;read_inode(inode);<br>
+		spin_lock(&amp;inode_lock);<br>
+		/* We released the lock, so.. */<br>
+		old = find_inode(sb, ino, head);<br>
+		if (!old)<br>
+		{<br>
+			list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
+			list_add(&amp;inode-&gt;i_hash, head);<br>
+			inode-&gt;i_sb = sb;<br>
+			inode-&gt;i_dev = sb-&gt;s_dev;<br>
+			inode-&gt;i_ino = ino;<br>
+			inode-&gt;i_flags = 0;<br>
+			inode-&gt;i_count = 1;<br>
+			inode-&gt;i_state = I_LOCK;<br>
+			spin_unlock(&amp;inode_lock);<br>
 <br>
-		/*<br>
-		 * This is special!  We do not need the spinlock<br>
-		 * when clearing I_LOCK, because we're guaranteed<br>
-		 * that nobody else tries to do anything about the<br>
-		 * state of the inode when it is locked, as we<br>
-		 * just created it (so there can be no old holders<br>
-		 * that haven't tested I_LOCK).<br>
-		 */<br>
-		inode-&gt;i_state &amp;= ~I_LOCK;<br>
-		wake_up(&amp;inode-&gt;i_wait);<br>
+			clean_inode(inode);<br>
+			sb-&gt;s_op-&gt;read_inode(inode);<br>
 <br>
-		return inode;<br>
-	}<br>
+			/*<br>
+			 * This is special!  We do not need the spinlock<br>
+			 * when clearing I_LOCK, because we're guaranteed<br>
+			 * that nobody else tries to do anything about the<br>
+			 * state of the inode when it is locked, as we<br>
+			 * just created it (so there can be no old holders<br>
+			 * that haven't tested I_LOCK).<br>
+			 */<br>
+			inode-&gt;i_state &amp;= ~I_LOCK;<br>
+			wake_up(&amp;inode-&gt;i_wait);<br>
 <br>
-	/*<br>
-	 * We need to expand. Note that "grow_inodes()" will<br>
-	 * release the spinlock, but will return with the lock <br>
-	 * held again if the allocation succeeded.<br>
-	 */<br>
-	inode = grow_inodes();<br>
-	if (inode) {<br>
-		/* We released the lock, so.. */<br>
-		struct inode * old = find_inode(sb, ino, head);<br>
-		if (!old)<br>
-			goto add_new_inode;<br>
-		list_add(&amp;inode-&gt;i_list, &amp;inode_unused);<br>
-		inodes_stat.nr_free_inodes++;<br>
+			return inode;<br>
+		}<br>
+		__iget(inode);<br>
 		spin_unlock(&amp;inode_lock);<br>
-		wait_on_inode(old);<br>
-		return old;<br>
+		destroy_inode(inode);<br>
+		inode = old;<br>
+		wait_on_inode(inode);<br>
 	}<br>
 	return inode;<br>
 }<br>
@@ -660,7 +570,6 @@<br>
 			spin_unlock(&amp;inode_lock);<br>
 			return res;<br>
 		}<br>
-		inode-&gt;i_count--; /* compensate find_inode() */<br>
 	} else {<br>
 		counter = max_reserved + 1;<br>
 	}<br>
@@ -671,10 +580,10 @@<br>
 struct inode *igrab(struct inode *inode)<br>
 {<br>
 	spin_lock(&amp;inode_lock);<br>
-	if (inode-&gt;i_state &amp; I_FREEING)<br>
-		inode = NULL;<br>
+	if (!(inode-&gt;i_state &amp; I_FREEING))<br>
+		__iget(inode);<br>
 	else<br>
-		inode-&gt;i_count++;<br>
+		inode = NULL;<br>
 	spin_unlock(&amp;inode_lock);<br>
 	if (inode)<br>
 		wait_on_inode(inode);<br>
@@ -689,14 +598,16 @@<br>
 	spin_lock(&amp;inode_lock);<br>
 	inode = find_inode(sb, ino, head);<br>
 	if (inode) {<br>
+		__iget(inode);<br>
 		spin_unlock(&amp;inode_lock);<br>
 		wait_on_inode(inode);<br>
 		return inode;<br>
 	}<br>
+	spin_unlock(&amp;inode_lock);<br>
+<br>
 	/*<br>
-	 * get_new_inode() will do the right thing, releasing<br>
-	 * the inode lock and re-trying the search in case it<br>
-	 * had to block at any point.<br>
+	 * get_new_inode() will do the right thing, re-trying the search<br>
+	 * in case it had to block at any point.<br>
 	 */<br>
 	return get_new_inode(sb, ino, head);<br>
 }<br>
@@ -721,6 +632,7 @@<br>
 {<br>
 	if (inode) {<br>
 		struct super_operations *op = NULL;<br>
+		int destroy = 0;<br>
 <br>
 		if (inode-&gt;i_sb &amp;&amp; inode-&gt;i_sb-&gt;s_op)<br>
 			op = inode-&gt;i_sb-&gt;s_op;<br>
@@ -750,13 +662,17 @@<br>
 				inode-&gt;i_state|=I_FREEING;<br>
 				spin_unlock(&amp;inode_lock);<br>
 				clear_inode(inode);<br>
+				destroy = 1;<br>
 				spin_lock(&amp;inode_lock);<br>
-				list_add(&amp;inode-&gt;i_list, &amp;inode_unused);<br>
-				inodes_stat.nr_free_inodes++;<br>
 			}<br>
-			else if (!(inode-&gt;i_state &amp; I_DIRTY)) {<br>
-				list_del(&amp;inode-&gt;i_list);<br>
-				list_add(&amp;inode-&gt;i_list, &amp;inode_in_use);<br>
+			else<br>
+			{<br>
+				if (!(inode-&gt;i_state &amp; I_DIRTY)) {<br>
+					list_del(&amp;inode-&gt;i_list);<br>
+					list_add(&amp;inode-&gt;i_list,<br>
+						 &amp;inode_unused);<br>
+				}<br>
+				inodes_stat.nr_unused++;<br>
 			}<br>
 #ifdef INODE_PARANOIA<br>
 if (inode-&gt;i_flock)<br>
@@ -778,6 +694,8 @@<br>
 				kdevname(inode-&gt;i_dev), inode-&gt;i_ino);<br>
 		}<br>
 		spin_unlock(&amp;inode_lock);<br>
+		if (destroy)<br>
+			destroy_inode(inode);<br>
 	}<br>
 }<br>
 <br>
@@ -795,14 +713,11 @@<br>
 }<br>
 <br>
 /*<br>
- * Initialize the hash tables and default<br>
- * value for max inodes<br>
+ * Initialize the hash tables.<br>
  */<br>
-#define MAX_INODE (16384)<br>
-<br>
 void __init inode_init(void)<br>
 {<br>
-	int i, max;<br>
+	int i;<br>
 	struct list_head *head = inode_hashtable;<br>
 <br>
 	i = HASH_SIZE;<br>
@@ -812,11 +727,12 @@<br>
 		i--;<br>
 	} while (i);<br>
 <br>
-	/* Initial guess at reasonable inode number */<br>
-	max = num_physpages &gt;&gt; 1;<br>
-	if (max &gt; MAX_INODE)<br>
-		max = MAX_INODE;<br>
-	max_inodes = max;<br>
+	/* inode slab cache */<br>
+	inode_cachep = kmem_cache_create("inode_cache", sizeof(struct inode),<br>
+					 0, SLAB_HWCACHE_ALIGN, init_once,<br>
+					 NULL);<br>
+	if (!inode_cachep)<br>
+		panic("cannot create inode slab cache");<br>
 }<br>
 <br>
 void update_atime (struct inode *inode)<br>
diff -urN 2.3.18ac2/include/linux/dcache.h 2.3.18ac2-inode/include/linux/dcache.h<br>
--- 2.3.18ac2/include/linux/dcache.h	Tue Jul 13 02:01:39 1999<br>
+++ 2.3.18ac2-inode/include/linux/dcache.h	Mon Sep 13 19:15:48 1999<br>
@@ -131,7 +131,7 @@<br>
 <br>
 /* allocate/de-allocate */<br>
 extern struct dentry * d_alloc(struct dentry *, const struct qstr *);<br>
-extern void prune_dcache(int);<br>
+extern int prune_dcache(int);<br>
 extern void shrink_dcache_sb(struct super_block *);<br>
 extern void shrink_dcache_parent(struct dentry *);<br>
 extern int d_invalidate(struct dentry *);<br>
@@ -140,9 +140,12 @@<br>
 <br>
 /* dcache memory management */<br>
 extern int  select_dcache(int, int);<br>
-extern void shrink_dcache_memory(int, unsigned int);<br>
+extern int shrink_dcache_memory(int, unsigned int);<br>
 extern void check_dcache_memory(void);<br>
-extern void free_inode_memory(int);	/* defined in fs/inode.c */<br>
+<br>
+/* icache memory management (defined in linux/fs/inode.c) */<br>
+extern int shrink_icache_memory(int, int);<br>
+extern int prune_icache(int);<br>
 <br>
 /* only used at mount-time */<br>
 extern struct dentry * d_alloc_root(struct inode *);<br>
diff -urN 2.3.18ac2/include/linux/fs.h 2.3.18ac2-inode/include/linux/fs.h<br>
--- 2.3.18ac2/include/linux/fs.h	Mon Sep 13 03:38:46 1999<br>
+++ 2.3.18ac2-inode/include/linux/fs.h	Mon Sep 13 19:15:48 1999<br>
@@ -45,7 +45,6 @@<br>
 #define BLOCK_SIZE (1&lt;&lt;BLOCK_SIZE_BITS)<br>
 <br>
 /* And dynamically-tunable limits and defaults: */<br>
-extern int max_inodes;<br>
 extern int max_files, nr_files, nr_free_files;<br>
 extern int max_super_blocks, nr_super_blocks;<br>
 <br>
diff -urN 2.3.18ac2/kernel/sysctl.c 2.3.18ac2-inode/kernel/sysctl.c<br>
--- 2.3.18ac2/kernel/sysctl.c	Wed Sep  8 00:26:08 1999<br>
+++ 2.3.18ac2-inode/kernel/sysctl.c	Mon Sep 13 19:15:48 1999<br>
@@ -256,8 +256,6 @@<br>
 	 0444, NULL, &amp;proc_dointvec},<br>
 	{FS_STATINODE, "inode-state", &amp;inodes_stat, 7*sizeof(int),<br>
 	 0444, NULL, &amp;proc_dointvec},<br>
-	{FS_MAXINODE, "inode-max", &amp;max_inodes, sizeof(int),<br>
-	 0644, NULL, &amp;proc_dointvec},<br>
 	{FS_NRFILE, "file-nr", &amp;nr_files, 3*sizeof(int),<br>
 	 0444, NULL, &amp;proc_dointvec},<br>
 	{FS_MAXFILE, "file-max", &amp;max_files, sizeof(int),<br>
diff -urN 2.3.18ac2/mm/vmscan.c 2.3.18ac2-inode/mm/vmscan.c<br>
--- 2.3.18ac2/mm/vmscan.c	Wed Sep  8 00:26:08 1999<br>
+++ 2.3.18ac2-inode/mm/vmscan.c	Mon Sep 13 19:18:27 1999<br>
@@ -424,6 +424,19 @@<br>
 				goto done;<br>
 		}<br>
 <br>
+		/* don't be too light against the d/i cache since<br>
+		   shrink_mmap() almost never fail when there's<br>
+		   really plenty of memory free and swap_out()<br>
+		   rarely fail even if we are low on memory. */<br>
+		{<br>
+			int progress;<br>
+<br>
+			progress = shrink_dcache_memory(priority, gfp_mask);<br>
+			progress |= shrink_icache_memory(priority, gfp_mask);<br>
+			if (progress)<br>
+				kmem_cache_reap(gfp_mask);<br>
+		}<br>
+<br>
 		/* Try to get rid of some shared memory pages.. */<br>
 		if (gfp_mask &amp; __GFP_IO) {<br>
 			while (shm_swap(priority, gfp_mask)) {<br>
@@ -437,8 +450,6 @@<br>
 			if (!--count)<br>
 				goto done;<br>
 		}<br>
-<br>
-		shrink_dcache_memory(priority, gfp_mask);<br>
 	} while (--priority &gt;= 0);<br>
 done:<br>
 <br>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0285.html">Jens Benecke: "Re: New Idea?  Capture video settings details in Win98/etc. for XFree86 config"</a>
<li> <b>Previous message:</b> <a href="0283.html">Avenger: "Re: S3 Trio FB"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
