<!-- received="Mon Sep 13 13:33:14 1999 EET DST" -->
<!-- sent="Mon, 13 Sep 1999 14:26:02 +0400" -->
<!-- name="Ivan Kokshaysky" -->
<!-- email="ink@jurassic.park.msu.ru" -->
<!-- subject="Re: 2.2.13-pre6 build failed (gcc-2.95.1)" -->
<!-- id="" -->
<!-- inreplyto="199909130016.UAA01445@sleipnir.valparaiso.cl" -->
<title>Linux-kernel mailing list archive 1999-37,: Re: 2.2.13-pre6 build failed (gcc-2.95.1)</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: 2.2.13-pre6 build failed (gcc-2.95.1)</h1>
<b>Ivan Kokshaysky</b> (<a href="mailto:ink@jurassic.park.msu.ru"><i>ink@jurassic.park.msu.ru</i></a>)<br>
<i>Mon, 13 Sep 1999 14:26:02 +0400</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#196">[ date ]</a><a href="index.html#196">[ thread ]</a><a href="subject.html#196">[ subject ]</a><a href="author.html#196">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0197.html">Peter Samuelson: "2.3.18: phantom hdb, oops in IDE init, boot hang"</a>
<li> <b>Previous message:</b> <a href="0195.html">Daniel J Blueman: "kflushd rewrite..."</a>
<li> <b>In reply to:</b> <a href="0146.html">Horst von Brand: "Re: 2.2.13-pre6 build failed (gcc-2.95.1)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Sun, Sep 12, 1999 at 08:16:29PM -0400, Horst von Brand wrote:<br>
<i>&gt; BTW, the function definition itself bothers me a lot: it is called</i><br>
<i>&gt; strnlen_user; but doesn't return the string's length, but its size; or some</i><br>
<i>&gt; weird values that signal various errors. I'd clean it up to return a string</i><br>
<i>&gt; length (I can see the unending patches "fixing" the uses assuming it</i><br>
<i>&gt; returns a proper length...), -EFAULT for bad addresses, or -E2BIG (?) for</i><br>
<i>&gt; strings that are too long.</i><br>
<p>
Meanwhile, this patch would make all versions of gcc happy.<br>
<p>
Ivan.<br>
<p>
--- linux-2.2.13ac7/arch/i386/lib/usercopy.c	Mon Sep 13 14:10:43 1999<br>
+++ linux/arch/i386/lib/usercopy.c	Mon Sep 13 14:12:13 1999<br>
@@ -123,7 +123,7 @@<br>
 long strnlen_user(const char *s, long n)<br>
 {<br>
 	unsigned long mask = -__addr_ok(s);<br>
-	unsigned long res;<br>
+	unsigned long res, tmp;<br>
 <br>
 	__asm__ __volatile__(<br>
 		"	andl %0,%%ecx\n"<br>
@@ -140,8 +140,8 @@<br>
 		"	.align 4\n"<br>
 		"	.long 0b,2b\n"<br>
 		".previous"<br>
-		:"=r" (n), "=D" (s), "=a" (res)<br>
+		:"=r" (n), "=D" (s), "=a" (res), "=c" (tmp)<br>
 		:"0" (n), "1" (s), "2" (0), "c" (mask)<br>
-		:"cx", "cc");<br>
+		:"cc");<br>
 	return res &amp; mask;<br>
 }<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0197.html">Peter Samuelson: "2.3.18: phantom hdb, oops in IDE init, boot hang"</a>
<li> <b>Previous message:</b> <a href="0195.html">Daniel J Blueman: "kflushd rewrite..."</a>
<li> <b>In reply to:</b> <a href="0146.html">Horst von Brand: "Re: 2.2.13-pre6 build failed (gcc-2.95.1)"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
