<!-- received="Sun Sep 12 20:28:42 1999 EET DST" -->
<!-- sent="Sun, 12 Sep 1999 19:24:58 +0200 (MET DST)" -->
<!-- name="Mikael Pettersson" -->
<!-- email="mikpe@csd.uu.se" -->
<!-- subject="Re: Linux 2.3.18ac1" -->
<!-- id="199909121724.TAA04109@harpo.csd.uu.se" -->
<!-- inreplyto="Linux 2.3.18ac1" -->
<title>Linux-kernel mailing list archive 1999-37,: Re: Linux 2.3.18ac1</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: Linux 2.3.18ac1</h1>
<b>Mikael Pettersson</b> (<a href="mailto:mikpe@csd.uu.se"><i>mikpe@csd.uu.se</i></a>)<br>
<i>Sun, 12 Sep 1999 19:24:58 +0200 (MET DST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#97">[ date ]</a><a href="index.html#97">[ thread ]</a><a href="subject.html#97">[ subject ]</a><a href="author.html#97">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0098.html">Fred Reimer: "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0096.html">Pete Clements: "[Q] ide probe and 2.3.18"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0128.html">Tim Waugh: "Re: Linux 2.3.18ac1"</a>
<li> <b>Reply:</b> <a href="0128.html">Tim Waugh: "Re: Linux 2.3.18ac1"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Here are two small fixes for Linux kernel 2.3.18:<br>
<p>
* The patch 2.3.10-&gt;2.3.11 added a return statement to the F0 0F<br>
  bug workaround code which disabled the workaround. (I assume<br>
  this was intended as a temporary fix while ironing out other<br>
  changes.) The patch below re-enables the F0 0F workaround.<br>
<p>
* parport_pc has one "virtual" bug and one real one:<br>
  * After placing the ECP port in configuration mode, the config<br>
    status should be read from I/O port CONFIGA(pb), not FIFO(pb).<br>
    [They denote the same I/O address, but that address changes<br>
    meaning depending on the mode of the parallel port.]<br>
  * The ISA-Level/Pulses bit (0x80) should be read from CONFIGA(pb),<br>
    not CONFIGB(pb). (0x80 in CONFIGB is the "compress" flag.)<br>
<p>
  While I'm at it: the check for IRQ conflict further down fails<br>
  on my Dell Latitude notebook: On the Latitude, CONFIGB always<br>
  reads as zero, which makes parport_pc believe there's an IRQ<br>
  conflict (there isn't). parport_pc then turns off IRQ capability,<br>
  which leaves the parport in a next to useless state (printing<br>
  is excruciatingly slow, if it works at all). I know some documents<br>
  recommend this check; I'm just not sure whether they're wrong<br>
  or whether the Dell Latitude has a crap parallel port controller.<br>
  Printing works in polling mode and IRQ-mode without FIFO/DMA.<br>
<p>
/Mikael<br>
<p>
--- linux-2.3.18/arch/i386/kernel/traps.c.~1~	Sun Sep 12 02:51:52 1999<br>
+++ linux-2.3.18/arch/i386/kernel/traps.c	Sun Sep 12 13:42:43 1999<br>
@@ -489,7 +489,6 @@<br>
 	pmd_t * pmd;<br>
 	pte_t * pte;<br>
 <br>
-return;<br>
 	/*<br>
 	 * Allocate a new page in virtual address space, <br>
 	 * move the IDT into it and write protect this page.<br>
--- linux-2.3.18/drivers/parport/parport_pc.c.orig	Thu Aug 19 18:41:54 1999<br>
+++ linux-2.3.18/drivers/parport/parport_pc.c	Sun Sep 12 13:42:20 1999<br>
@@ -1202,7 +1202,7 @@<br>
 <br>
 	outb (ECR_SPP &lt;&lt; 5, ECONTROL (pb)); /* Reset FIFO */<br>
 	outb (0xf4, ECONTROL (pb)); /* Configuration mode */<br>
-	config = inb (FIFO (pb));<br>
+	config = inb (CONFIGA (pb));<br>
 	pword = (config &gt;&gt; 4) &amp; 0x7;<br>
 	switch (pword) {<br>
 	case 0:<br>
@@ -1225,10 +1225,10 @@<br>
 	priv-&gt;pword = pword;<br>
 	printk (KERN_DEBUG "0x%lx: PWord is %d bits\n", pb-&gt;base, 8 * pword);<br>
 <br>
-	config = inb (CONFIGB (pb));<br>
 	printk (KERN_DEBUG "0x%lx: Interrupts are ISA-%s\n", pb-&gt;base,<br>
 		config &amp; 0x80 ? "Level" : "Pulses");<br>
 <br>
+	config = inb (CONFIGB (pb));<br>
 	if (!(config &amp; 0x40)) {<br>
 		printk (KERN_WARNING "0x%lx: IRQ conflict!\n", pb-&gt;base);<br>
 		pb-&gt;irq = PARPORT_IRQ_NONE;<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0098.html">Fred Reimer: "Re: I vote for updated RAID and KNFSD"</a>
<li> <b>Previous message:</b> <a href="0096.html">Pete Clements: "[Q] ide probe and 2.3.18"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0128.html">Tim Waugh: "Re: Linux 2.3.18ac1"</a>
<li> <b>Reply:</b> <a href="0128.html">Tim Waugh: "Re: Linux 2.3.18ac1"</a>
<!-- reply="end" -->
</ul>
</font></body>
