<!-- received="Sun Sep 12 13:05:50 1999 EET DST" -->
<!-- sent="Sun, 12 Sep 1999 12:02:53 +0200 (METDST)" -->
<!-- name="Richard Guenther" -->
<!-- email="zxmpm11@student.uni-tuebingen.de" -->
<!-- subject="[PATCH] final support for MODULE_PARAM as kernel commandline" -->
<!-- id="" -->
<!-- inreplyto="Pine.HPP.3.96.990911164401.25635A-100000@fphp16.tphys.physik.uni-tuebingen.de" -->
<title>Linux-kernel mailing list archive 1999-37,: [PATCH] final support for MODULE_PARAM as kernel commandline</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] final support for MODULE_PARAM as kernel commandline</h1>
<b>Richard Guenther</b> (<a href="mailto:zxmpm11@student.uni-tuebingen.de"><i>zxmpm11@student.uni-tuebingen.de</i></a>)<br>
<i>Sun, 12 Sep 1999 12:02:53 +0200 (METDST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#57">[ date ]</a><a href="index.html#57">[ thread ]</a><a href="subject.html#57">[ subject ]</a><a href="author.html#57">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0058.html">Tim Waugh: "Lava PCI parallel card"</a>
<li> <b>Previous message:</b> <a href="0056.html">Richard Guenther: "Re: [PATCH] support for ISAPnP code with ne2000 network driver"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0356.html">David Hinds: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0356.html">David Hinds: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0441.html">David Woodhouse: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0605.html">Keith Owens: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
Hi!<br>
<p>
This is the final version of the patch that allows compiled<br>
in modules which use MODULE_PARAM get their parameters from<br>
the kernel command line. The code has been cleaned up wrt.<br>
formatting and 's' support is there (as far as the kernel<br>
command line allows).<br>
<p>
Please apply (well its sent to Alan, as Linus is not here...).<br>
<p>
Richard.<br>
<p>
<pre>
--
Richard Guenther &lt;<a href="mailto:richard.guenther@student.uni-tuebingen.de">richard.guenther@student.uni-tuebingen.de</a>&gt;
PGP: 2E829319 - 2F 83 FC 93 E9 E4 19 E2 93 7A 32 42 45 37 23 57
WWW: <a href="http://www.anatom.uni-tuebingen.de/~richi/">http://www.anatom.uni-tuebingen.de/~richi/</a>
<p>
<p>
--- linux-2.3.16/lib/Makefile.original	Sat Sep 11 15:45:57 1999
+++ linux-2.3.16/lib/Makefile	Sat Sep 11 16:29:13 1999
@@ -7,6 +7,6 @@
 #
 
 L_TARGET := lib.a
-L_OBJS   := errno.o ctype.o string.o vsprintf.o
+L_OBJS   := errno.o ctype.o string.o vsprintf.o parse.o
 
 include $(TOPDIR)/Rules.make
--- linux-2.3.16/lib/parse.c.original	Sat Sep 11 16:28:05 1999
+++ linux-2.3.16/lib/parse.c	Sat Sep 11 20:07:59 1999
@@ -0,0 +1,97 @@
+/*
+ *  linux/lib/parse.c
+ *
+ *  (C) Richard Guenther &lt;<a href="mailto:richard.guenther@student.uni-tuebingen.de">richard.guenther@student.uni-tuebingen.de</a>&gt;
+ *
+ *  Heavily based on parts of modutil's insmod.c which is
+ *
+ *  Copyright 1996, 1997 Linux International.
+ *
+ *  New implementation contributed by Richard Henderson &lt;<a href="mailto:rth@tamu.edu">rth@tamu.edu</a>&gt;
+ *  Based on original work by Bjorn Eckwall &lt;<a href="mailto:bj0rn@blox.se">bj0rn@blox.se</a>&gt;
+ *
+ *  This file is part of the Linux modutils.
+ *
+ *  This program is free software; you can redistribute it and/or modify it
+ *  under the terms of the GNU General Public License as published by the
+ *  Free Software Foundation; either version 2 of the License, or (at your
+ *  option) any later version.
+ *
+ *  This program is distributed in the hope that it will be useful, but
+ *  WITHOUT ANY WARRANTY; without even the implied warranty of
+ *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
+ *  General Public License for more details.
+ *
+ *  You should have received a copy of the GNU General Public License
+ *  along with this program; if not, write to the Free Software Foundation,
+ *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
+ */
+
+#include &lt;linux/kernel.h&gt;
+#include &lt;linux/ctype.h&gt;
+#include &lt;linux/string.h&gt;
+
+/* parse module parameters like insmod */
+int parse_parameters(void *var, char *type, char *str)
+{
+	char *p, t;
+	long min, max, val, cnt;
+
+	p = type;
+	if (isdigit(*p)) {
+		min = simple_strtoul(p, &amp;p, 0);
+		if (*p == '-')
+			max = simple_strtoul(p+1, &amp;p, 0);
+		else
+			max = min;
+	} else
+		min = max = 1;
+	t = *p;
+
+	p = str;
+	cnt = 0;
+	do {
+		if (*p == ',') {
+			p++;
+			cnt++;
+			continue;
+		}
+		switch (t) {
+		case 'b':
+			val = simple_strtol(p, &amp;p, 0);
+			((char *)var)[cnt] = (char)val;
+			break;
+		case 'h':
+			val = simple_strtol(p, &amp;p, 0);
+			((short *)var)[cnt] = (short)val;
+			break;
+		case 'i':
+			val = simple_strtol(p, &amp;p, 0);
+			((int *)var)[cnt] = (int)val;
+			break;
+		case 'l':
+			val = simple_strtol(p, &amp;p, 0);
+			((long *)var)[cnt] = (long)val;
+			break;
+		case 's':
+			/* complex quoting is not possible, as parse_options()
+			 * just searches for ' ', so we can safely just leech
+			 * the whole string (multiple strings are impossible, too)
+			 * - where do we check for overflows?? */
+			strcpy((char *)var, p);
+			break;
+		default:
+			printk(KERN_INFO "error in parsing arguments \"%s\" using format %s\n", str, type);
+			return 0;
+		}
+		if (*p == ',')
+			p++;
+		cnt++;
+	} while (*p &amp;&amp; cnt &lt; max);
+
+	return 1;
+}
+
+
+
+
--- linux-2.3.16/include/linux/module.h.original	Sat Sep 11 15:04:03 1999
+++ linux-2.3.16/include/linux/module.h	Sat Sep 11 16:08:09 1999
@@ -8,6 +8,7 @@
 #define _LINUX_MODULE_H
 
 #include &lt;linux/config.h&gt;
+#include &lt;linux/init.h&gt;
 
 #ifdef __GENKSYMS__
 #  define _set_ver(sym) sym
@@ -207,11 +208,17 @@
 #endif
 
 #else /* MODULE */
-
+extern int parse_parameters(void *var, char *type, char *str);
 #define MODULE_AUTHOR(name)
 #define MODULE_DESCRIPTION(desc)
 #define MODULE_SUPPORTED_DEVICE(name)
-#define MODULE_PARM(var,type)
+#define MODULE_PARM(var,type) \
+static char *modparm##var##_setup_type __initdata = type;\
+static int __init modparm##var##_setup(char *str)\
+{\
+  return parse_parameters(var, modparm##var##_setup_type, str);\
+}\
+__setup(#var "=", modparm##var##_setup);
 #define MODULE_PARM_DESC(var,desc)
 
 #ifndef __GENKSYMS__
<p>
<p>
-
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in
the body of a message to majordomo@vger.rutgers.edu
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a>
</pre>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0058.html">Tim Waugh: "Lava PCI parallel card"</a>
<li> <b>Previous message:</b> <a href="0056.html">Richard Guenther: "Re: [PATCH] support for ISAPnP code with ne2000 network driver"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0356.html">David Hinds: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0356.html">David Hinds: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0441.html">David Woodhouse: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<li> <b>Reply:</b> <a href="0605.html">Keith Owens: "Re: [PATCH] final support for MODULE_PARAM as kernel commandline"</a>
<!-- reply="end" -->
</ul>
</font></body>
