<!-- received="Sun Sep 12 04:00:46 1999 EET DST" -->
<!-- sent="Sun, 12 Sep 1999 02:50:32 +0200 (CEST)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@suse.de" -->
<!-- subject="[patch] show_buffers() resurrection" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1999-37,: [patch] show_buffers() resurrection</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[patch] show_buffers() resurrection</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@suse.de"><i>andrea@suse.de</i></a>)<br>
<i>Sun, 12 Sep 1999 02:50:32 +0200 (CEST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#26">[ date ]</a><a href="index.html#26">[ thread ]</a><a href="subject.html#26">[ subject ]</a><a href="author.html#26">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0027.html">Andrea Arcangeli: "Re: Lockups - lost interrupt"</a>
<li> <b>Previous message:</b> <a href="0025.html">Mikael Pettersson: "Re: ftape: update to version 4.xx sometime?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0030.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<li> <b>Reply:</b> <a href="0030.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<li> <b>Reply:</b> <a href="0063.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
With the buffer SMP threading show_buffers() is been removed from the<br>
kernel. This patch will reinsert it. It's safe as it uses the trylock<br>
type of spinlocks. I find it extremely useful to know what's going on in<br>
the buffer layer.<br>
<p>
Patch against 2.3.18ac1:<br>
<p>
diff -urN 2.3.18ac1/arch/alpha/mm/init.c 2.3.18ac1-buffers/arch/alpha/mm/init.c<br>
--- 2.3.18ac1/arch/alpha/mm/init.c	Thu Aug 12 02:53:17 1999<br>
+++ 2.3.18ac1-buffers/arch/alpha/mm/init.c	Sun Sep 12 00:44:13 1999<br>
@@ -166,6 +166,7 @@<br>
 	printk("%ld pages shared\n",shared);<br>
 	printk("%ld pages swap cached\n",cached);<br>
 	printk("%ld pages in page table cache\n",pgtable_cache_size);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/arm/mm/init.c 2.3.18ac1-buffers/arch/arm/mm/init.c<br>
--- 2.3.18ac1/arch/arm/mm/init.c	Wed Sep  8 00:25:39 1999<br>
+++ 2.3.18ac1-buffers/arch/arm/mm/init.c	Sun Sep 12 00:43:49 1999<br>
@@ -115,6 +115,7 @@<br>
 	printk("%d free pages\n",free);<br>
 	printk("%d reserved pages\n",reserved);<br>
 	printk("%d pages shared\n",shared);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/i386/mm/init.c 2.3.18ac1-buffers/arch/i386/mm/init.c<br>
--- 2.3.18ac1/arch/i386/mm/init.c	Wed Sep  8 18:18:45 1999<br>
+++ 2.3.18ac1-buffers/arch/i386/mm/init.c	Sun Sep 12 00:43:26 1999<br>
@@ -180,6 +180,7 @@<br>
 	printk("%d pages shared\n",shared);<br>
 	printk("%d pages swap cached\n",cached);<br>
 	printk("%ld pages in page table cache\n",pgtable_cache_size);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/m68k/mm/init.c 2.3.18ac1-buffers/arch/m68k/mm/init.c<br>
--- 2.3.18ac1/arch/m68k/mm/init.c	Wed Sep  8 18:18:46 1999<br>
+++ 2.3.18ac1-buffers/arch/m68k/mm/init.c	Sun Sep 12 00:43:11 1999<br>
@@ -112,6 +112,7 @@<br>
     printk("%d pages shared\n",shared);<br>
     printk("%d pages swap cached\n",cached);<br>
     printk("%ld pages in page table cache\n",pgtable_cache_size);<br>
+    show_buffers();<br>
 #ifdef CONFIG_NET<br>
     show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/mips/mm/init.c 2.3.18ac1-buffers/arch/mips/mm/init.c<br>
--- 2.3.18ac1/arch/mips/mm/init.c	Wed Sep  8 00:25:41 1999<br>
+++ 2.3.18ac1-buffers/arch/mips/mm/init.c	Sun Sep 12 00:42:53 1999<br>
@@ -265,6 +265,7 @@<br>
 	printk("%d pages swap cached\n",cached);<br>
 	printk("%ld pages in page table cache\n",pgtable_cache_size);<br>
 	printk("%d free pages\n", free);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/ppc/mm/init.c 2.3.18ac1-buffers/arch/ppc/mm/init.c<br>
--- 2.3.18ac1/arch/ppc/mm/init.c	Sat Sep 11 02:47:53 1999<br>
+++ 2.3.18ac1-buffers/arch/ppc/mm/init.c	Sun Sep 12 00:42:25 1999<br>
@@ -285,6 +285,7 @@<br>
 	printk("%d pages shared\n",shared);<br>
 	printk("%d pages swap cached\n",cached);<br>
 	printk("%d pages in page table cache\n",(int)pgtable_cache_size);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/sparc/mm/init.c 2.3.18ac1-buffers/arch/sparc/mm/init.c<br>
--- 2.3.18ac1/arch/sparc/mm/init.c	Sat Sep 11 02:47:53 1999<br>
+++ 2.3.18ac1-buffers/arch/sparc/mm/init.c	Sun Sep 12 00:42:09 1999<br>
@@ -106,6 +106,7 @@<br>
 	printk("%ld page tables cached\n",pgtable_cache_size);<br>
 	if (sparc_cpu_model == sun4m || sparc_cpu_model == sun4d)<br>
 		printk("%ld page dirs cached\n", pgd_cache_size);<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/arch/sparc64/mm/init.c 2.3.18ac1-buffers/arch/sparc64/mm/init.c<br>
--- 2.3.18ac1/arch/sparc64/mm/init.c	Sat Sep 11 02:47:53 1999<br>
+++ 2.3.18ac1-buffers/arch/sparc64/mm/init.c	Sun Sep 12 00:41:53 1999<br>
@@ -150,6 +150,7 @@<br>
 #ifndef __SMP__<br>
 	printk("%d entries in page dir cache\n",pgd_cache_size);<br>
 #endif	<br>
+	show_buffers();<br>
 #ifdef CONFIG_NET<br>
 	show_net_buffers();<br>
 #endif<br>
diff -urN 2.3.18ac1/drivers/sgi/char/sgiserial.c 2.3.18ac1-buffers/drivers/sgi/char/sgiserial.c<br>
--- 2.3.18ac1/drivers/sgi/char/sgiserial.c	Wed Sep  8 00:26:00 1999<br>
+++ 2.3.18ac1-buffers/drivers/sgi/char/sgiserial.c	Sun Sep 12 00:41:26 1999<br>
@@ -408,6 +408,7 @@<br>
 			show_state();<br>
 			return;<br>
 		} else if (ch == 2) {<br>
+			show_buffers();<br>
 			return;<br>
 		}<br>
 		/* It is a 'keyboard interrupt' ;-) */<br>
diff -urN 2.3.18ac1/fs/buffer.c 2.3.18ac1-buffers/fs/buffer.c<br>
--- 2.3.18ac1/fs/buffer.c	Sat Sep 11 16:33:32 1999<br>
+++ 2.3.18ac1-buffers/fs/buffer.c	Sun Sep 12 00:54:30 1999<br>
@@ -2160,6 +2160,45 @@<br>
 	goto out;<br>
 }<br>
 <br>
+/* ================== Debugging =================== */<br>
+<br>
+void show_buffers(void)<br>
+{<br>
+	struct buffer_head * bh;<br>
+	int found = 0, locked = 0, dirty = 0, used = 0, lastused = 0;<br>
+	int protected = 0;<br>
+	int nlist;<br>
+	static char *buf_types[NR_LIST] = { "CLEAN", "LOCKED", "DIRTY" };<br>
+<br>
+	printk("Buffer memory:   %6dkB\n", atomic_read(&amp;buffermem) &gt;&gt; 10);<br>
+<br>
+	if (!spin_trylock(&amp;lru_list_lock))<br>
+		return;<br>
+	for(nlist = 0; nlist &lt; NR_LIST; nlist++) {<br>
+		found = locked = dirty = used = lastused = protected = 0;<br>
+		bh = lru_list[nlist];<br>
+		if(!bh) continue;<br>
+<br>
+		do {<br>
+			found++;<br>
+			if (buffer_locked(bh))<br>
+				locked++;<br>
+			if (buffer_protected(bh))<br>
+				protected++;<br>
+			if (buffer_dirty(bh))<br>
+				dirty++;<br>
+			if (atomic_read(&amp;bh-&gt;b_count))<br>
+				used++, lastused = found;<br>
+			bh = bh-&gt;b_next_free;<br>
+		} while (bh != lru_list[nlist]);<br>
+		printk("%8s: %d buffers, %d used (last=%d), "<br>
+		       "%d locked, %d protected, %d dirty\n",<br>
+		       buf_types[nlist], found, used, lastused,<br>
+		       locked, protected, dirty);<br>
+	}<br>
+	spin_unlock(&amp;lru_list_lock);<br>
+}<br>
+<br>
 /* ===================== Init ======================= */<br>
 <br>
 /*<br>
diff -urN 2.3.18ac1/include/linux/fs.h 2.3.18ac1-buffers/include/linux/fs.h<br>
--- 2.3.18ac1/include/linux/fs.h	Sun Sep 12 01:03:03 1999<br>
+++ 2.3.18ac1-buffers/include/linux/fs.h	Sun Sep 12 00:51:46 1999<br>
@@ -937,6 +937,7 @@<br>
 unsigned long generate_cluster_swab32(kdev_t, int b[], int);<br>
 extern kdev_t ROOT_DEV;<br>
 <br>
+extern void show_buffers(void);<br>
 extern void mount_root(void);<br>
 <br>
 #ifdef CONFIG_BLK_DEV_INITRD<br>
<p>
<p>
Andrea<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0027.html">Andrea Arcangeli: "Re: Lockups - lost interrupt"</a>
<li> <b>Previous message:</b> <a href="0025.html">Mikael Pettersson: "Re: ftape: update to version 4.xx sometime?"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0030.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<li> <b>Reply:</b> <a href="0030.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<li> <b>Reply:</b> <a href="0063.html">David S. Miller: "Re: [patch] show_buffers() resurrection"</a>
<!-- reply="end" -->
</ul>
</font></body>
