<!-- received="Sat Nov  7 19:10:58 1998 EET" -->
<!-- sent="Sat, 7 Nov 1998 16:29:12 +0000 (/etc/localtime)" -->
<!-- name="Matthew G. Marsh" -->
<!-- email="mgm@paktronix.com" -->
<!-- subject="Re: compilation problems with ncpfs" -->
<!-- id="" -->
<!-- inreplyto="Pine.LNX.4.05.9811062249580.3902-100000@mousehole.sandwich.net" -->
<title>Linux-kernel mailing list archive 1998-44,: Re: compilation problems with ncpfs</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>Re: compilation problems with ncpfs</h1>
<b>Matthew G. Marsh</b> (<a href="mailto:mgm@paktronix.com"><i>mgm@paktronix.com</i></a>)<br>
<i>Sat, 7 Nov 1998 16:29:12 +0000 (/etc/localtime)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#966">[ date ]</a><a href="index.html#966">[ thread ]</a><a href="subject.html#966">[ subject ]</a><a href="author.html#966">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0967.html">Stefan Monnier: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0965.html">Meelis Roos: "Re: swapfile security weakeness"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
On Fri, 6 Nov 1998, James Curbo wrote:<br>
<p>
<i>&gt; This seems related to the whole schedule_timeout/jiffies thing. Anyone</i><br>
<i>&gt; else noticed this? This is 2.1.127pre7 with arca-10 applied.</i><br>
<p>
Yes - I posted a patch to the list (enclosed).<br>
 <br>
<p>
<i>&gt; This is with ncpfs being built in.</i><br>
<i>&gt; Rest of config available upon request.</i><br>
<i>&gt; -- </i><br>
<i>&gt; James Curbo            computer science/math undergradute</i><br>
<i>&gt; Henderson State University Department of Computer Science</i><br>
<i>&gt; <a href="mailto:jc108788@cyprus.hsu.edu">jc108788@cyprus.hsu.edu</a>      james@mousehole.sandwich.net</i><br>
<i>&gt; <a href="http://users.ipa.net/~jcurbo/index.html">http://users.ipa.net/~jcurbo/index.html</a></i><br>
<p>
Patch:<br>
<p>
--- linux/fs/ncpfs/sock.127-7	Fri Nov  6 11:13:08 1998<br>
+++ linux/fs/ncpfs/sock.c	Fri Nov  6 11:16:42 1998<br>
@@ -182,17 +182,16 @@<br>
 				}<br>
 				timeout = max_timeout;<br>
 			}<br>
-			current-&gt;timeout = jiffies + timeout;<br>
-			schedule();<br>
+			schedule_timeout(timeout);<br>
 			remove_wait_queue(entry.wait_address, &amp;entry.wait);<br>
 			fput(file);<br>
 			current-&gt;state = TASK_RUNNING;<br>
 			if (signal_pending(current)) {<br>
-				current-&gt;timeout = 0;<br>
+				schedule_timeout(0);<br>
 				result = -ERESTARTSYS;<br>
 				break;<br>
 			}<br>
-			if (!current-&gt;timeout) {<br>
+			if (!schedule_timeout(timeout)) {<br>
 				if (n &lt; retrans)<br>
 					continue;<br>
 				if (server-&gt;m.flags &amp; NCP_MOUNT_SOFT) {<br>
@@ -209,7 +208,7 @@<br>
 				major_timeout_seen = 1;<br>
 				continue;<br>
 			} else<br>
-				current-&gt;timeout = 0;<br>
+				schedule_timeout(0);<br>
 		} else if (wait_table.nr) {<br>
 			remove_wait_queue(entry.wait_address, &amp;entry.wait);<br>
 			fput(file);<br>
<p>
<p>
--------------------------------------------------<br>
Matthew G. Marsh,  President<br>
Paktronix Systems LLC<br>
1506 North 59th Street<br>
Omaha  NE  68104<br>
Phone: (402) 932-7250<br>
Email: <a href="mailto:mgm@paktronix.com">mgm@paktronix.com</a><br>
WWW:  <a href="http://www.paktronix.com">http://www.paktronix.com</a><br>
--------------------------------------------------<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0967.html">Stefan Monnier: "Re: Volume Managers in Linux"</a>
<li> <b>Previous message:</b> <a href="0965.html">Meelis Roos: "Re: swapfile security weakeness"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
