<!-- received="Sat Nov  7 05:32:43 1998 EET" -->
<!-- sent="Fri, 6 Nov 1998 20:09:52 -0700 (MST)" -->
<!-- name="Ely Wilson" -->
<!-- email="plexus@ionet.net" -->
<!-- subject="[PATCH] getsockname() always fails with EFAULT in 2.1.127pre7" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[PATCH] getsockname() always fails with EFAULT in 2.1.127pre7</h1>
<b>Ely Wilson</b> (<a href="mailto:plexus@ionet.net"><i>plexus@ionet.net</i></a>)<br>
<i>Fri, 6 Nov 1998 20:09:52 -0700 (MST)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#901">[ date ]</a><a href="index.html#901">[ thread ]</a><a href="subject.html#901">[ subject ]</a><a href="author.html#901">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0902.html">John Daley: "dump device, reboot on kernel panic"</a>
<li> <b>Previous message:</b> <a href="0900.html">Aaron J. Grier: "Re: linux &amp;&amp; ultrix"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0913.html">David S. Miller: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<li> <b>Reply:</b> <a href="0913.html">David S. Miller: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<li> <b>Reply:</b> <a href="0928.html">Philip Blundell: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
  This message is in MIME format.  The first part should be readable text,<br>
  while the remaining parts are likely unreadable without MIME-aware tools.<br>
  Send mail to <a href="mailto:mime@docserver.cac.washington.edu">mime@docserver.cac.washington.edu</a> for more info.<br>
<p>
--8323328-1707146190-910408192=:12744<br>
Content-Type: TEXT/PLAIN; charset=US-ASCII<br>
<p>
<p>
A call to getsockname() will always return EFAULT but will in fact succeed<br>
(given it *really* succeeds, it might actually EFAULT you know). included is<br>
a server.c and client.c used to test the patch I've included.<br>
<p>
Here it is, real quick like.  From sys_getsockname() -&gt; move_addr_to_user()<br>
you will find that the following call to get_user will always result in an<br>
-EFAULT return value.<br>
<p>
-------snip-------<br>
int move_addr_to_user(void *kaddr, int klen, void *uaddr, int *ulen)<br>
{<br>
        int err;<br>
        int len;<br>
<p>
        if((err=get_user(len, ulen)))<br>
                return err;<br>
-------snip-------<br>
<p>
with get_user() you should be passing the address of the data you wish to<br>
get the length of, where here you are passing the length of the data that<br>
you want to get the length of.<br>
<p>
Am I wrong on this?  I checked the source as well as the man 9 get_user<br>
documentation and this is what I've concluded.   If you look at the order in<br>
which sys_getsockname() does it's work this would fit very well with the<br>
fact that sockgetname() will always succeed but always return EFAULT.<br>
<p>
Here is a stupid little patch, this is against 2.1.127pre7, I don't know if<br>
it applies to anything sooner.  I know nothing pre 2.1.x works like this<br>
though. <br>
<p>
-------snip-------<br>
--- socket.c.old        Thu Aug 27 19:33:09 1998<br>
+++ socket.c    Fri Nov  6 19:32:35 1998<br>
@@ -170,7 +170,7 @@<br>
        int err;<br>
        int len;<br>
<p>
-       if((err=get_user(len, ulen)))<br>
+       if((err=get_user(len, uaddr)))<br>
                return err;<br>
        if(len&gt;klen)<br>
                len=klen;<br>
-------snip-------<br>
<p>
And just a purely stupid question here.  Why would a kernel function set a<br>
return value to something like -EFAULT or -EBADF when a user program would<br>
check against that value with EFAULT or EBADF?   Does the - not negate the<br>
value?  I'm not saying it's wrong LOL, because it works.  But what does it<br>
do why is it done that way?<br>
<p>
:)	Yeah, I should get a few interesting emails about that eh?<br>
<p>
	----------------------------------------------------<br>
	  ely				&lt;plexus@ionet.net&gt;<br>
<p>
*********** quickie before I send this off **********<br>
Here's a few instances where move_addr_to_user() is used and in all but one<br>
case (sys_recvmsg it *seems*) that the calls should always return EFAULT<br>
but they will otherwise succeed in their task.  Kind of makes you wonder.<br>
<p>
in socket.c -&gt; sys_accept() :<br>
<p>
-------<br>
                }<br>
                /* N.B. Should check for errors here */<br>
                move_addr_to_user(address, len, upeer_sockaddr,<br>
upeer_addrlen);<br>
        }<br>
-------<br>
<p>
in socket.c -&gt; sys_getpeername() :<br>
<p>
-------<br>
                if (!err)<br>
                        err=move_addr_to_user(address,len, usockaddr,<br>
usockaddr_len);<br>
                sockfd_put(sock);<br>
        }<br>
        unlock_kernel();<br>
        return err;<br>
}<br>
-------<br>
<p>
in socket.c -&gt; sys_recvfrom() :<br>
<p>
-------<br>
        if(err &gt;= 0 &amp;&amp; addr != NULL)<br>
        {<br>
                err2=move_addr_to_user(address, msg.msg_namelen, addr,<br>
addr_len);<br>
                if(err2&lt;0)<br>
                        err=err2;<br>
        }<br>
        sockfd_put(sock);<br>
out:<br>
        unlock_kernel();<br>
        return err;<br>
}<br>
-------<br>
<p>
in socket.c -&gt; sys_recvmsg() :<br>
 <br>
-------<br>
        if (uaddr != NULL) {<br>
                err = move_addr_to_user(addr, msg_sys.msg_namelen, uaddr,<br>
uaddr_len);<br>
                if (err &lt; 0)<br>
                        goto out_freeiov;<br>
        }<br>
-------<br>
<p>
	     "awaiting the wave of kernel hacker flames"<br>
<p>
<p>
<p>
--8323328-1707146190-910408192=:12744<br>
Content-Type: TEXT/PLAIN; charset=US-ASCII; name="client.c"<br>
Content-Transfer-Encoding: BASE64<br>
Content-ID: &lt;<a href="mailto:Pine.LNX.4.05.9811062009520.12744@localhost.localdomain">Pine.LNX.4.05.9811062009520.12744@localhost.localdomain</a>&gt;<br>
Content-Description: <br>
Content-Disposition: attachment; filename="client.c"<br>
<p>
LyogY2xpZW50LmMgKi8NCg0KI2luY2x1ZGUgPHN0ZGlvLmg+DQojaW5jbHVk<br>
ZSA8c3RkbGliLmg+DQojaW5jbHVkZSA8c3lzL3NvY2tldC5oPg0KI2luY2x1<br>
ZGUgPG5ldGluZXQvaW4uaD4NCiNpbmNsdWRlIDxhcnBhL2luZXQuaD4NCiNp<br>
bmNsdWRlIDxlcnJuby5oPg0KDQppbnQgc29ja19kZXNjcmlwdG9yOw0Kc3Ry<br>
dWN0IHNvY2thZGRyX2luCXNvY2tfYWRkcmVzcywgY29ubmVjdF9hZGRyZXNz<br>
Ow0KY2hhciAqcmVzcG9uc2U7DQoNCmludCBtYWluKHZvaWQpIA0Kew0KCS8q<br>
IG9wZW4gc29ja2V0ICovDQoJc29ja19kZXNjcmlwdG9yID0gc29ja2V0KEFG<br>
X0lORVQsU09DS19TVFJFQU0sMCk7DQoJaWYgKHNvY2tfZGVzY3JpcHRvcj09<br>
LTEpDQoJew0KCQlwcmludGYoInNvY2tldDogRmFpbGVkIHRvIG9wZW4gc29j<br>
a2V0LlxuIik7DQoJCXJldHVybiAtMTsNCgl9DQoNCgkvKiBiaW5kIHNvY2tl<br>
dCAqLw0KCXNvY2tfYWRkcmVzcy5zaW5fZmFtaWx5ID0gQUZfSU5FVDsNCglz<br>
b2NrX2FkZHJlc3Muc2luX3BvcnQgPSBodG9ucygyMDA5Nik7DQoJaWYgKGlu<br>
ZXRfYXRvbigiMTI3LjAuMC4xIiwgJnNvY2tfYWRkcmVzcy5zaW5fYWRkcik9<br>
PTApIA0KCXsNCgkJcHJpbnRmKCJiaW5kIHNvY2tldDogaW52YWxpZCBpcC9o<br>
b3N0IG51bWJlclxuIik7DQoJCWNsb3NlKHNvY2tfZGVzY3JpcHRvcik7DQoJ<br>
CXJldHVybiAtMTsNCgl9DQoJaWYgKGJpbmQoc29ja19kZXNjcmlwdG9yLCAo<br>
c3RydWN0IHNvY2thZGRyICopICZzb2NrX2FkZHJlc3MsIHNpemVvZihzdHJ1<br>
Y3Qgc29ja2FkZHJfaW4pKT09LTEpDQoJew0KCQlwcmludGYoImJpbmQ6IGZh<br>
aWxlZCB0byBiaW5kIGFkZHJlc3MgdG8gc29ja2V0LlxuIik7DQoJCWNsb3Nl<br>
KHNvY2tfZGVzY3JpcHRvcik7DQoJCXJldHVybiAtMTsNCgl9DQoNCgkvKiBl<br>
c3RhYmxpc2ggY29ubmVjdGlvbiAqLw0KCWNvbm5lY3RfYWRkcmVzcy5zaW5f<br>
ZmFtaWx5ID0gQUZfSU5FVDsNCgljb25uZWN0X2FkZHJlc3Muc2luX3BvcnQg<br>
PSBodG9ucygyMDA2OSk7DQoJaWYgKGluZXRfYXRvbigiMTI3LjAuMC4xIiwg<br>
JmNvbm5lY3RfYWRkcmVzcy5zaW5fYWRkcik9PTApIA0KCXsNCgkJcHJpbnRm<br>
KCJjb25uZWN0OiBpbnZhbGlkIGlwL2hvc3QgbnVtYmVyXG4iKTsNCgkJY2xv<br>
c2Uoc29ja19kZXNjcmlwdG9yKTsNCgkJcmV0dXJuIC0xOw0KCX0NCgkNCglp<br>
ZiAoZ2V0c29ja25hbWUoc29ja19kZXNjcmlwdG9yLCAoc3RydWN0IHNvY2th<br>
ZGRyICopJnNvY2tfYWRkcmVzcywgKHNvY2tsZW5fdCopc2l6ZW9mKHN0cnVj<br>
dCBzb2NrYWRkcl9pbikpPT0tMSkNCgl7DQoJCXByaW50ZigiZ2V0c29ja25h<br>
bWU6IGFkZHJlc3MgcmVzb2x1dGlvbiBmYWlsdXJlICAgICBSZWFzb246ICIp<br>
Ow0KCQlzd2l0Y2ggKGVycm5vKSB7DQoJCQljYXNlIEVCQURGOg0KCQkJCXBy<br>
aW50ZigiRUJBREZcblxuIik7DQoJCQkJYnJlYWs7DQoJCQljYXNlIEVOT1RT<br>
T0NLOg0KCQkJCXByaW50ZigiRU5PVFNPQ0tcblxuIik7DQoJCQkJYnJlYWs7<br>
DQoJCQljYXNlIEVOT0JVRlM6DQoJCQkJcHJpbnRmKCJFTk9CVUZTXG5cbiIp<br>
Ow0KCQkJCWJyZWFrOw0KCQkJY2FzZSBFRkFVTFQ6DQoJCQkJcHJpbnRmKCJF<br>
RkFVTFRcblxuIik7DQoJCQkJYnJlYWs7DQoJCQlkZWZhdWx0Og0KCQkJCXBy<br>
aW50ZigiVU5LTk9XTiBFUlJPUlxuXG4iKTsNCgkJCQlicmVhazsNCgkJCX0N<br>
Ci8qCQljbG9zZShzb2NrX2Rlc2NyaXB0b3IpOw0KCQlyZXR1cm4gLTE7DQoq<br>
Lwl9DQoNCglwcmludGYoImNsaWVudDogc3VjY2Vzc1xuIFNvY2tldCBpbmZv<br>
OlxuTG9jYWw6IEFkZHJlc3MgJXMgUG9ydCAlaVxuUmVtb3RlOiBBZGRyZXNz<br>
ICVzIFBvcnQgJWlcbiIsIGluZXRfbnRvYShzb2NrX2FkZHJlc3Muc2luX2Fk<br>
ZHIpLCBudG9ocyhzb2NrX2FkZHJlc3Muc2luX3BvcnQpLCBpbmV0X250b2Eo<br>
Y29ubmVjdF9hZGRyZXNzLnNpbl9hZGRyKSwgbnRvaHMoY29ubmVjdF9hZGRy<br>
ZXNzLnNpbl9wb3J0KSk7DQoJDQoJaWYgKGNvbm5lY3Qoc29ja19kZXNjcmlw<br>
dG9yLCAoc3RydWN0IHNvY2thZGRyICopICZjb25uZWN0X2FkZHJlc3MsIHNp<br>
emVvZihzdHJ1Y3Qgc29ja2FkZHJfaW4pKT09LTEpDQoJew0KCQlwcmludGYo<br>
ImNvbm5lY3Q6IHVuYWJsZSB0byBlc3RhYmxpc2ggY29ubmVjdGlvblxuIik7<br>
DQoJCWNsb3NlKHNvY2tfZGVzY3JpcHRvcik7DQoJCXJldHVybiAtMTsNCgl9<br>
DQoJDQoJc2xlZXAoMSk7DQoJcmVzcG9uc2U9KGNoYXIqKWNhbGxvYygxLDEw<br>
MjQpOw0KCWlmIChyZWN2KHNvY2tfZGVzY3JpcHRvcixyZXNwb25zZSwxMDIz<br>
LDApPT0tMSkNCgl7DQoJCXByaW50ZigicmVjdjogc29ja2V0IGlvIGZhaWx1<br>
cmVcbiIpOw0KCQljbG9zZShzb2NrX2Rlc2NyaXB0b3IpOw0KCQlyZXR1cm4g<br>
LTE7DQoJfQ0KCXNsZWVwKDEpOw0KCXByaW50ZigiXG5cbiVzXG4iLHJlc3Bv<br>
bnNlKTsNCgkJDQoJLyogY2xlYW4gYW5kIGNsb3NlICovCQ0KCWNsb3NlKHNv<br>
Y2tfZGVzY3JpcHRvcik7DQoJcmV0dXJuIDA7DQp9DQo=<br>
--8323328-1707146190-910408192=:12744<br>
Content-Type: TEXT/PLAIN; charset=US-ASCII; name="server.c"<br>
Content-Transfer-Encoding: BASE64<br>
Content-ID: &lt;<a href="mailto:Pine.LNX.4.05.9811062009521.12744@localhost.localdomain">Pine.LNX.4.05.9811062009521.12744@localhost.localdomain</a>&gt;<br>
Content-Description: <br>
Content-Disposition: attachment; filename="server.c"<br>
<p>
Lyogc2VydmVyLmMgKi8NCg0KI2luY2x1ZGUgPHN0ZGlvLmg+DQojaW5jbHVk<br>
ZSA8c3RkbGliLmg+DQojaW5jbHVkZSA8c3lzL3NvY2tldC5oPg0KI2luY2x1<br>
ZGUgPG5ldGluZXQvaW4uaD4NCiNpbmNsdWRlIDxhcnBhL2luZXQuaD4NCiNp<br>
bmNsdWRlIDxzeXMvdHlwZXMuaD4NCiNpbmNsdWRlIDxzdHJpbmcuaD4NCg0K<br>
I2RlZmluZSBUSEVfTVNHICJzdWNjZXNzZnVsbCBjb25uZWN0aW9uIHRvIHNl<br>
cnZlciINCg0KaW50IHNvY2tfZGVzY3JpcHRvciwgY29ubmVjdF9kZXNjcmlw<br>
dG9yOw0Kc3RydWN0IHNvY2thZGRyX2luCXNvY2tfYWRkcmVzcywgY29ubmVj<br>
dF9hZGRyZXNzOw0KDQoNCmludCBtYWluKHZvaWQpIA0Kew0KCS8qIG9wZW4g<br>
c29ja2V0ICovDQoJc29ja19kZXNjcmlwdG9yID0gc29ja2V0KEFGX0lORVQs<br>
U09DS19TVFJFQU0sMCk7DQoJaWYgKHNvY2tfZGVzY3JpcHRvcj09LTEpDQoJ<br>
ew0KCQlwcmludGYoInNvY2tldDogRmFpbGVkIHRvIG9wZW4gc29ja2V0Llxu<br>
Iik7DQoJCXJldHVybiAtMTsNCgl9DQoNCgkvKiBiaW5kIHNvY2tldCAqLw0K<br>
CXNvY2tfYWRkcmVzcy5zaW5fZmFtaWx5ID0gQUZfSU5FVDsNCglzb2NrX2Fk<br>
ZHJlc3Muc2luX3BvcnQgPSBodG9ucygyMDA2OSk7DQoJaWYgKGluZXRfYXRv<br>
bigiMTI3LjAuMC4xIiwgJnNvY2tfYWRkcmVzcy5zaW5fYWRkcik9PTApIA0K<br>
CXsNCgkJcHJpbnRmKCJiaW5kOiBpbnZhbGlkIGlwL2hvc3QgbnVtYmVyXG4i<br>
KTsNCgkJY2xvc2Uoc29ja19kZXNjcmlwdG9yKTsNCgkJcmV0dXJuIC0xOw0K<br>
CX0NCglpZiAoYmluZChzb2NrX2Rlc2NyaXB0b3IsIChzdHJ1Y3Qgc29ja2Fk<br>
ZHIgKikgJnNvY2tfYWRkcmVzcywgc2l6ZW9mKHN0cnVjdCBzb2NrYWRkcl9p<br>
bikpPT0tMSkNCgl7DQoJCXByaW50ZigiYmluZDogZmFpbGVkIHRvIGJpbmQg<br>
YWRkcmVzcyB0byBzb2NrZXQuXG4iKTsNCgkJY2xvc2Uoc29ja19kZXNjcmlw<br>
dG9yKTsNCgkJcmV0dXJuIC0xOw0KCX0NCg0KCXByaW50Zigic2VydmVyOiBz<br>
dWNjZXNzXG5zdGFydGluZyBzZXJ2ZXIuLlxuIik7DQoJDQoJLyogc2V0IGxp<br>
c3RlbiBvbiBzb2NrZXQgKi8NCglpZiAobGlzdGVuKHNvY2tfZGVzY3JpcHRv<br>
ciwgNSk9PS0xKQ0KCXsNCgkJcHJpbnRmKCJsaXN0ZW46IGZhaWxlZCB0byBz<br>
ZXQgc2VydmVyIHNvY2tldC5cbiIpOw0KCQljbG9zZShzb2NrX2Rlc2NyaXB0<br>
b3IpOw0KCQlyZXR1cm4gLTE7DQoJfQ0KCQ0KCXByaW50Zigic2VydmVyOiB3<br>
aWF0aW5nIGZvciBjbGllbnQgY29ubmVjdFxuIik7DQoJDQoJaWYgKChjb25u<br>
ZWN0X2Rlc2NyaXB0b3I9YWNjZXB0KHNvY2tfZGVzY3JpcHRvciwgKHN0cnVj<br>
dCBzb2NrYWRkciopJmNvbm5lY3RfYWRkcmVzcywgKHZvaWQqKSgoaW50KShz<br>
aXplb2Yoc3RydWN0IHNvY2thZGRyX2luKSkpICkpPT0tMSkNCgl7DQoJCXBy<br>
aW50ZigiYWNjZXB0OiBzZXJ2ZXIvc29ja2V0IGZhaWx1cmUuXG4iKTsNCgkJ<br>
Y2xvc2Uoc29ja19kZXNjcmlwdG9yKTsNCgkJcmV0dXJuIC0xOw0KCX0NCgkN<br>
CglwcmludGYoInNlcnZlcjogY29ubmVjdGlvbiBlc3RhYmxpc2hlZCAoJXMg<br>
JWkpXG4iLCBpbmV0X250b2EoY29ubmVjdF9hZGRyZXNzLnNpbl9hZGRyKSwg<br>
bnRvaHMoY29ubmVjdF9hZGRyZXNzLnNpbl9wb3J0KSk7DQoNCglpZiAoc2Vu<br>
ZChjb25uZWN0X2Rlc2NyaXB0b3IsVEhFX01TRyxzdHJsZW4oVEhFX01TRyks<br>
MCk9PS0xKQ0KCXsNCgkJcHJpbnRmKCJzZW5kOiBjb21tdW5pY2F0aW9uIGZh<br>
aWx1cmVcbiIpOw0KCQljbG9zZShzb2NrX2Rlc2NyaXB0b3IpOw0KCQljbG9z<br>
ZShjb25uZWN0X2Rlc2NyaXB0b3IpOw0KCQlyZXR1cm4gLTE7DQoJfQ0KCQ0K<br>
CXByaW50Zigic2VydmVyOiBkYXRhIHNlbnQsIGtpbGxpbmcgY29ubmVjdGlv<br>
blxuIik7DQoNCgkvKiBjbGVhbiBhbmQgY2xvc2UgKi8JDQoJY2xvc2UoY29u<br>
bmVjdF9kZXNjcmlwdG9yKTsNCglzbGVlcCg0KTsNCgljbG9zZShzb2NrX2Rl<br>
c2NyaXB0b3IpOw0KCXJldHVybiAwOw0KfQ0K<br>
--8323328-1707146190-910408192=:12744--<br>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0902.html">John Daley: "dump device, reboot on kernel panic"</a>
<li> <b>Previous message:</b> <a href="0900.html">Aaron J. Grier: "Re: linux &amp;&amp; ultrix"</a>
<!-- nextthread="start" -->
<li> <b>Next in thread:</b> <a href="0913.html">David S. Miller: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<li> <b>Reply:</b> <a href="0913.html">David S. Miller: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<li> <b>Reply:</b> <a href="0928.html">Philip Blundell: "Re: [PATCH] getsockname() always fails with EFAULT in 2.1.127pre7"</a>
<!-- reply="end" -->
</ul>
</font></body>
