<!-- received="Sat Nov  7 01:20:00 1998 EET" -->
<!-- sent="Fri, 6 Nov 1998 22:38:07 +0100 (CET)" -->
<!-- name="Andrea Arcangeli" -->
<!-- email="andrea@e-mind.com" -->
<!-- subject="[proc] sysctl/proc compile fix" -->
<!-- id="" -->
<!-- inreplyto="" -->
<title>Linux-kernel mailing list archive 1998-44,: [proc] sysctl/proc compile fix</title>
<body bgcolor="#FFFFFF"><font face="Arial,Helvetica">
<h1>[proc] sysctl/proc compile fix</h1>
<b>Andrea Arcangeli</b> (<a href="mailto:andrea@e-mind.com"><i>andrea@e-mind.com</i></a>)<br>
<i>Fri, 6 Nov 1998 22:38:07 +0100 (CET)</i>
<p>
<ul>
<li> <b>Messages sorted by:</b> <a href="date.html#864">[ date ]</a><a href="index.html#864">[ thread ]</a><a href="subject.html#864">[ subject ]</a><a href="author.html#864">[ author ]</a>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0865.html">Pavel Machek: "Re: swapfile security weakeness"</a>
<li> <b>Previous message:</b> <a href="0863.html">Andrea Arcangeli: "[patch] arca-10"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
<hr>
<!-- body="start" -->
This patch extracted by my arca-10 allow a clean compile if CONFIG_PROC_FS<br>
and/or CONFIG_SYSCTL are not set.<br>
<p>
Patch against pre-2.1.127-7:<br>
<p>
Index: linux/drivers/misc/parport_arc.c<br>
diff -u linux/drivers/misc/parport_arc.c:1.1.1.2 linux/drivers/misc/parport_arc.c:1.1.1.1.12.2<br>
--- linux/drivers/misc/parport_arc.c:1.1.1.2	Sat Oct 24 15:40:02 1998<br>
+++ linux/drivers/misc/parport_arc.c	Tue Oct 20 01:13:28 1998<br>
@@ -141,7 +141,9 @@<br>
 <br>
 	printk(KERN_INFO "%s: Archimedes on-board port, using irq %d\n",<br>
 	       p-&gt;irq);<br>
+#ifdef	CONFIG_PROC_FS<br>
 	parport_proc_register(p);<br>
+#endif<br>
 	p-&gt;flags |= PARPORT_FLAG_COMA;<br>
 <br>
 	if (parport_probe_hook)<br>
Index: linux/drivers/misc/parport_ax.c<br>
diff -u linux/drivers/misc/parport_ax.c:1.1.1.2 linux/drivers/misc/parport_ax.c:1.1.1.1.12.2<br>
--- linux/drivers/misc/parport_ax.c:1.1.1.2	Sat Oct 24 15:40:02 1998<br>
+++ linux/drivers/misc/parport_ax.c	Tue Oct 20 01:13:28 1998<br>
@@ -585,7 +585,9 @@<br>
 		printmode(ECPPS2);<br>
 	}<br>
 	printk("]\n");<br>
+#ifdef	CONFIG_PROC_FS<br>
 	parport_proc_register(p);<br>
+#endif<br>
 	p-&gt;flags |= PARPORT_FLAG_COMA;<br>
 <br>
 	p-&gt;ops-&gt;write_control(p, 0x0c);<br>
@@ -628,7 +630,9 @@<br>
 		if (p-&gt;modes &amp; PARPORT_MODE_PCSPP) { <br>
 			if (!(p-&gt;flags &amp; PARPORT_FLAG_COMA)) <br>
 				parport_quiesce(p);<br>
+#ifdef	CONFIG_PROC_FS<br>
 			parport_proc_unregister(p);<br>
+#endif<br>
 			parport_unregister_port(p);<br>
 		}<br>
 		p = tmp;<br>
Index: linux/drivers/misc/parport_init.c<br>
diff -u linux/drivers/misc/parport_init.c:1.1.1.1 linux/drivers/misc/parport_init.c:1.1.1.1.14.1<br>
--- linux/drivers/misc/parport_init.c:1.1.1.1	Fri Oct  2 19:23:33 1998<br>
+++ linux/drivers/misc/parport_init.c	Tue Oct 20 01:13:28 1998<br>
@@ -98,13 +98,17 @@<br>
 #ifdef MODULE<br>
 int init_module(void)<br>
 {<br>
+#ifdef	CONFIG_PROC_FS<br>
 	(void)parport_proc_init();	/* We can go on without it. */<br>
+#endif<br>
 	return 0;<br>
 }<br>
 <br>
 void cleanup_module(void)<br>
 {<br>
+#ifdef	CONFIG_PROC_FS<br>
 	parport_proc_cleanup();<br>
+#endif<br>
 }<br>
 #else<br>
 __initfunc(int parport_init(void))<br>
@@ -115,7 +119,9 @@<br>
 #ifdef CONFIG_PNP_PARPORT<br>
 	parport_probe_hook = &amp;parport_probe_one;<br>
 #endif<br>
+#ifdef	CONFIG_PROC_FS<br>
 	parport_proc_init();<br>
+#endif<br>
 #ifdef CONFIG_PARPORT_PC<br>
 	parport_pc_init(io, irq, dma);<br>
 #endif<br>
@@ -139,8 +145,10 @@<br>
 EXPORT_SYMBOL(parport_enumerate);<br>
 EXPORT_SYMBOL(parport_ieee1284_nibble_mode_ok);<br>
 EXPORT_SYMBOL(parport_wait_peripheral);<br>
+#ifdef	CONFIG_PROC_FS<br>
 EXPORT_SYMBOL(parport_proc_register);<br>
 EXPORT_SYMBOL(parport_proc_unregister);<br>
+#endif<br>
 EXPORT_SYMBOL(parport_probe_hook);<br>
 EXPORT_SYMBOL(parport_parse_irqs);<br>
 <br>
Index: linux/drivers/misc/parport_pc.c<br>
diff -u linux/drivers/misc/parport_pc.c:1.1.1.3 linux/drivers/misc/parport_pc.c:1.1.1.1.12.3<br>
--- linux/drivers/misc/parport_pc.c:1.1.1.3	Tue Oct 27 08:40:16 1998<br>
+++ linux/drivers/misc/parport_pc.c	Tue Oct 27 15:15:11 1998<br>
@@ -755,9 +755,11 @@<br>
 	}<br>
 #undef printmode<br>
 	printk("]\n");<br>
+#ifdef	CONFIG_PROC_FS<br>
 	if (probedirq != PARPORT_IRQ_NONE) <br>
 		printk("%s: detected irq %d; use procfs to enable interrupt-driven operation.\n", p-&gt;name, probedirq);<br>
 	parport_proc_register(p);<br>
+#endif<br>
 	p-&gt;flags |= PARPORT_FLAG_COMA;<br>
 <br>
 	/* Done probing.  Now put the port into a sensible start-up state. */<br>
@@ -821,7 +823,9 @@<br>
 		if (p-&gt;modes &amp; PARPORT_MODE_PCSPP) { <br>
 			if (!(p-&gt;flags &amp; PARPORT_FLAG_COMA)) <br>
 				parport_quiesce(p);<br>
+#ifdef	CONFIG_PROC_FS<br>
 			parport_proc_unregister(p);<br>
+#endif<br>
 			parport_unregister_port(p);<br>
 		}<br>
 		p = tmp;<br>
Index: linux/drivers/pci/pcisyms.c<br>
diff -u linux/drivers/pci/pcisyms.c:1.1.1.1 linux/drivers/pci/pcisyms.c:1.1.1.1.14.1<br>
--- linux/drivers/pci/pcisyms.c:1.1.1.1	Fri Oct  2 19:23:27 1998<br>
+++ linux/drivers/pci/pcisyms.c	Tue Oct 20 01:13:31 1998<br>
@@ -28,8 +28,10 @@<br>
 EXPORT_SYMBOL(pci_find_device);<br>
 EXPORT_SYMBOL(pci_find_slot);<br>
 EXPORT_SYMBOL(pci_set_master);<br>
+#ifdef	CONFIG_PROC_FS<br>
 EXPORT_SYMBOL(pci_proc_attach_device);<br>
 EXPORT_SYMBOL(pci_proc_detach_device);<br>
+#endif<br>
 <br>
 /* Backward compatibility */<br>
 <br>
Index: linux/kernel/sysctl.c<br>
diff -u linux/kernel/sysctl.c:1.1.1.2 linux/kernel/sysctl.c:1.1.1.2.4.2<br>
--- linux/kernel/sysctl.c:1.1.1.2	Fri Oct  9 17:44:10 1998<br>
+++ linux/kernel/sysctl.c	Fri Oct 30 19:11:17 1998<br>
@@ -34,11 +34,11 @@<br>
 #include &lt;linux/nfs_fs.h&gt;<br>
 #endif<br>
 <br>
-#if defined(CONFIG_SYSCTL) &amp;&amp; defined(CONFIG_PROC_FS)<br>
+#if defined(CONFIG_SYSCTL)<br>
 <br>
 /* External variables not in a header file. */<br>
 extern int panic_timeout;<br>
-extern int console_loglevel, C_A_D, swapout_interval;<br>
+extern int console_loglevel, C_A_D;<br>
 extern int bdf_prm[], bdflush_min[], bdflush_max[];<br>
 extern char binfmt_java_interpreter[], binfmt_java_appletviewer[];<br>
 extern int sysctl_overcommit_memory;<br>
@@ -125,11 +125,11 @@<br>
 <br>
 extern struct proc_dir_entry proc_sys_root;<br>
 <br>
-extern int inodes_stat[];<br>
-extern int dentry_stat[];<br>
 static void register_proc_table(ctl_table *, struct proc_dir_entry *);<br>
 static void unregister_proc_table(ctl_table *, struct proc_dir_entry *);<br>
 #endif<br>
+extern int inodes_stat[];<br>
+extern int dentry_stat[];<br>
 <br>
 /* The default sysctl tables: */<br>
 <br>
@@ -199,8 +199,6 @@<br>
 static ctl_table vm_table[] = {<br>
 	{VM_SWAPCTL, "swapctl", <br>
 	 &amp;swap_control, sizeof(swap_control_t), 0644, NULL, &amp;proc_dointvec},<br>
-	{VM_SWAPOUT, "swapout_interval",<br>
-	 &amp;swapout_interval, sizeof(int), 0644, NULL, &amp;proc_dointvec},<br>
 	{VM_FREEPG, "freepages", <br>
 	 &amp;freepages, sizeof(freepages_t), 0644, NULL, &amp;proc_dointvec},<br>
 	{VM_BDFLUSH, "bdflush", &amp;bdf_prm, 9*sizeof(int), 0600, NULL,<br>
@@ -866,14 +864,14 @@<br>
 <br>
 #else /* CONFIG_PROC_FS */<br>
 <br>
-int proc_dointvec_jiffies(ctl_table *table, int write, struct file *filp,<br>
-			  void *buffer, size_t *lenp)<br>
+int proc_dostring(ctl_table *table, int write, struct file *filp,<br>
+		  void *buffer, size_t *lenp)<br>
 {<br>
-  return -ENOSYS; <br>
+	return -ENOSYS;<br>
 }<br>
 <br>
-int proc_dostring(ctl_table *table, int write, struct file *filp,<br>
-		  void *buffer, size_t *lenp)<br>
+static int proc_doutsstring(ctl_table *table, int write, struct file *filp,<br>
+			    void *buffer, size_t *lenp)<br>
 {<br>
 	return -ENOSYS;<br>
 }<br>
@@ -1053,7 +1051,7 @@<br>
 }<br>
 <br>
 <br>
-#else /* CONFIG_PROC_FS &amp;&amp; CONFIG_SYSCTL */<br>
+#else /* CONFIG_SYSCTL */<br>
 <br>
 <br>
 extern asmlinkage int sys_sysctl(struct __sysctl_args *args)<br>
@@ -1108,8 +1106,5 @@<br>
 void unregister_sysctl_table(struct ctl_table_header * table)<br>
 {<br>
 }<br>
-<br>
-#endif /* CONFIG_PROC_FS &amp;&amp; CONFIG_SYSCTL */<br>
-<br>
-<br>
 <br>
+#endif /* CONFIG_SYSCTL */<br>
Index: linux/net/ipv4/ip_masq.c<br>
diff -u linux/net/ipv4/ip_masq.c:1.1.1.2 linux/net/ipv4/ip_masq.c:1.1.1.2.4.1<br>
--- linux/net/ipv4/ip_masq.c:1.1.1.2	Fri Oct  9 17:44:21 1998<br>
+++ linux/net/ipv4/ip_masq.c	Tue Oct 20 01:13:32 1998<br>
@@ -2149,6 +2149,14 @@<br>
 	return ret;<br>
 }<br>
 <br>
+/*<br>
+ *	Wrapper over inet_select_addr()<br>
+ */<br>
+u32 ip_masq_select_addr(struct device *dev, u32 dst, int scope)<br>
+{<br>
+	return inet_select_addr(dev, dst, scope);<br>
+}<br>
+<br>
 #ifdef CONFIG_PROC_FS<br>
 static struct proc_dir_entry	*proc_net_ip_masq = NULL;<br>
 <br>
@@ -2175,14 +2183,6 @@<br>
 	IP_MASQ_DEBUG(1, "unregistering \"/proc/net/ip_masq/%s\" entry\n",<br>
 			ent-&gt;name);<br>
 	proc_unregister(proc_net_ip_masq, ent-&gt;low_ino);<br>
-}<br>
-<br>
-/*<br>
- *	Wrapper over inet_select_addr()<br>
- */<br>
-u32 ip_masq_select_addr(struct device *dev, u32 dst, int scope)<br>
-{<br>
-	return inet_select_addr(dev, dst, scope);<br>
 }<br>
 <br>
 __initfunc(static void masq_proc_init(void))<br>
<p>
<p>
Andrea Arcangeli<br>
<p>
<p>
-<br>
To unsubscribe from this list: send the line "unsubscribe linux-kernel" in<br>
the body of a message to majordomo@vger.rutgers.edu<br>
Please read the FAQ at <a href="http://www.tux.org/lkml/">http://www.tux.org/lkml/</a><br>
<!-- body="end" -->
<hr>
<p>
<ul>
<!-- next="start" -->
<li> <b>Next message:</b> <a href="0865.html">Pavel Machek: "Re: swapfile security weakeness"</a>
<li> <b>Previous message:</b> <a href="0863.html">Andrea Arcangeli: "[patch] arca-10"</a>
<!-- nextthread="start" -->
<!-- reply="end" -->
</ul>
</font></body>
